/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ConditionCategory;

public class ConditionCategoryEnumFactory
implements EnumFactory<ConditionCategory> {
    @Override
    public ConditionCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complaint".equals(codeString)) {
            return ConditionCategory.COMPLAINT;
        }
        if ("symptom".equals(codeString)) {
            return ConditionCategory.SYMPTOM;
        }
        if ("finding".equals(codeString)) {
            return ConditionCategory.FINDING;
        }
        if ("diagnosis".equals(codeString)) {
            return ConditionCategory.DIAGNOSIS;
        }
        throw new IllegalArgumentException("Unknown ConditionCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ConditionCategory code) {
        if (code == ConditionCategory.COMPLAINT) {
            return "complaint";
        }
        if (code == ConditionCategory.SYMPTOM) {
            return "symptom";
        }
        if (code == ConditionCategory.FINDING) {
            return "finding";
        }
        if (code == ConditionCategory.DIAGNOSIS) {
            return "diagnosis";
        }
        return "?";
    }

    @Override
    public String toSystem(ConditionCategory code) {
        return code.getSystem();
    }
}

