/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ActionDefinition")
public class ActionDefinition
extends Type
implements ICompositeType {
    @Child(name="actionIdentifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="A unique identifier for the action. The identifier SHALL be unique within the container in which it appears, and MAY be universally unique.")
    protected Identifier actionIdentifier;
    @Child(name="label", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="User-visible label for the action (e.g. 1. or A.)", formalDefinition="A user-visible label for the action.")
    protected StringType label;
    @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="User-visible title", formalDefinition="The title of the action displayed to a user.")
    protected StringType title;
    @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Short description of the action", formalDefinition="A short description of the action used to provide a summary to display to the user.")
    protected StringType description;
    @Child(name="textEquivalent", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.")
    protected StringType textEquivalent;
    @Child(name="concept", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The meaning of the action or its sub-actions", formalDefinition="The concept represented by this action or its sub-actions.")
    protected List<CodeableConcept> concept;
    @Child(name="supportingEvidence", type={Attachment.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Evidence that supports taking the action", formalDefinition="The evidence grade and the sources of evidence for this action.")
    protected List<Attachment> supportingEvidence;
    @Child(name="documentation", type={Attachment.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
    protected List<Attachment> documentation;
    @Child(name="relatedAction", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
    protected ActionDefinitionRelatedActionComponent relatedAction;
    @Child(name="participantType", type={CodeType.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="patient | practitioner | related-person", formalDefinition="The type of participant in the action.")
    protected List<Enumeration<ParticipantType>> participantType;
    @Child(name="type", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
    protected Enumeration<ActionType> type;
    @Child(name="behavior", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Defines behaviors such as selection and grouping", formalDefinition="A behavior associated with the action. Behaviors define how the action is to be presented and/or executed within the receiving environment.")
    protected List<ActionDefinitionBehaviorComponent> behavior;
    @Child(name="resource", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Static portion of the action definition", formalDefinition="The resource that is the target of the action (e.g. CommunicationRequest). The resource described here defines any aspects of the action that can be specified statically (i.e. are known at the time of definition).")
    protected Reference resource;
    protected Resource resourceTarget;
    @Child(name="customization", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Dynamic aspects of the definition", formalDefinition="Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.")
    protected List<ActionDefinitionCustomizationComponent> customization;
    @Child(name="action", type={ActionDefinition.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A sub-action", formalDefinition="Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.")
    protected List<ActionDefinition> action;
    private static final long serialVersionUID = -1659761573L;

    public Identifier getActionIdentifier() {
        if (this.actionIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.actionIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.actionIdentifier = new Identifier();
            }
        }
        return this.actionIdentifier;
    }

    public boolean hasActionIdentifier() {
        return this.actionIdentifier != null && !this.actionIdentifier.isEmpty();
    }

    public ActionDefinition setActionIdentifier(Identifier value) {
        this.actionIdentifier = value;
        return this;
    }

    public StringType getLabelElement() {
        if (this.label == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.label");
            }
            if (Configuration.doAutoCreate()) {
                this.label = new StringType();
            }
        }
        return this.label;
    }

    public boolean hasLabelElement() {
        return this.label != null && !this.label.isEmpty();
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    public ActionDefinition setLabelElement(StringType value) {
        this.label = value;
        return this;
    }

    public String getLabel() {
        return this.label == null ? null : (String)this.label.getValue();
    }

    public ActionDefinition setLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ActionDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ActionDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ActionDefinition setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ActionDefinition setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public StringType getTextEquivalentElement() {
        if (this.textEquivalent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.textEquivalent");
            }
            if (Configuration.doAutoCreate()) {
                this.textEquivalent = new StringType();
            }
        }
        return this.textEquivalent;
    }

    public boolean hasTextEquivalentElement() {
        return this.textEquivalent != null && !this.textEquivalent.isEmpty();
    }

    public boolean hasTextEquivalent() {
        return this.textEquivalent != null && !this.textEquivalent.isEmpty();
    }

    public ActionDefinition setTextEquivalentElement(StringType value) {
        this.textEquivalent = value;
        return this;
    }

    public String getTextEquivalent() {
        return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
    }

    public ActionDefinition setTextEquivalent(String value) {
        if (Utilities.noString((String)value)) {
            this.textEquivalent = null;
        } else {
            if (this.textEquivalent == null) {
                this.textEquivalent = new StringType();
            }
            this.textEquivalent.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<CodeableConcept>();
        }
        return this.concept;
    }

    public boolean hasConcept() {
        if (this.concept == null) {
            return false;
        }
        for (CodeableConcept item : this.concept) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addConcept() {
        CodeableConcept t = new CodeableConcept();
        if (this.concept == null) {
            this.concept = new ArrayList<CodeableConcept>();
        }
        this.concept.add(t);
        return t;
    }

    public ActionDefinition addConcept(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.concept == null) {
            this.concept = new ArrayList<CodeableConcept>();
        }
        this.concept.add(t);
        return this;
    }

    public List<Attachment> getSupportingEvidence() {
        if (this.supportingEvidence == null) {
            this.supportingEvidence = new ArrayList<Attachment>();
        }
        return this.supportingEvidence;
    }

    public boolean hasSupportingEvidence() {
        if (this.supportingEvidence == null) {
            return false;
        }
        for (Attachment item : this.supportingEvidence) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addSupportingEvidence() {
        Attachment t = new Attachment();
        if (this.supportingEvidence == null) {
            this.supportingEvidence = new ArrayList<Attachment>();
        }
        this.supportingEvidence.add(t);
        return t;
    }

    public ActionDefinition addSupportingEvidence(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.supportingEvidence == null) {
            this.supportingEvidence = new ArrayList<Attachment>();
        }
        this.supportingEvidence.add(t);
        return this;
    }

    public List<Attachment> getDocumentation() {
        if (this.documentation == null) {
            this.documentation = new ArrayList<Attachment>();
        }
        return this.documentation;
    }

    public boolean hasDocumentation() {
        if (this.documentation == null) {
            return false;
        }
        for (Attachment item : this.documentation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addDocumentation() {
        Attachment t = new Attachment();
        if (this.documentation == null) {
            this.documentation = new ArrayList<Attachment>();
        }
        this.documentation.add(t);
        return t;
    }

    public ActionDefinition addDocumentation(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.documentation == null) {
            this.documentation = new ArrayList<Attachment>();
        }
        this.documentation.add(t);
        return this;
    }

    public ActionDefinitionRelatedActionComponent getRelatedAction() {
        if (this.relatedAction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.relatedAction");
            }
            if (Configuration.doAutoCreate()) {
                this.relatedAction = new ActionDefinitionRelatedActionComponent();
            }
        }
        return this.relatedAction;
    }

    public boolean hasRelatedAction() {
        return this.relatedAction != null && !this.relatedAction.isEmpty();
    }

    public ActionDefinition setRelatedAction(ActionDefinitionRelatedActionComponent value) {
        this.relatedAction = value;
        return this;
    }

    public List<Enumeration<ParticipantType>> getParticipantType() {
        if (this.participantType == null) {
            this.participantType = new ArrayList<Enumeration<ParticipantType>>();
        }
        return this.participantType;
    }

    public boolean hasParticipantType() {
        if (this.participantType == null) {
            return false;
        }
        for (Enumeration<ParticipantType> item : this.participantType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ParticipantType> addParticipantTypeElement() {
        Enumeration<ParticipantType> t = new Enumeration<ParticipantType>(new ParticipantTypeEnumFactory());
        if (this.participantType == null) {
            this.participantType = new ArrayList<Enumeration<ParticipantType>>();
        }
        this.participantType.add(t);
        return t;
    }

    public ActionDefinition addParticipantType(ParticipantType value) {
        Enumeration<ParticipantType> t = new Enumeration<ParticipantType>(new ParticipantTypeEnumFactory());
        t.setValue((Object)value);
        if (this.participantType == null) {
            this.participantType = new ArrayList<Enumeration<ParticipantType>>();
        }
        this.participantType.add(t);
        return this;
    }

    public boolean hasParticipantType(ParticipantType value) {
        if (this.participantType == null) {
            return false;
        }
        for (Enumeration<ParticipantType> v : this.participantType) {
            if (!((ParticipantType)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ActionType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ActionType>(new ActionTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ActionDefinition setTypeElement(Enumeration<ActionType> value) {
        this.type = value;
        return this;
    }

    public ActionType getType() {
        return this.type == null ? null : (ActionType)((Object)this.type.getValue());
    }

    public ActionDefinition setType(ActionType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<ActionType>(new ActionTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public List<ActionDefinitionBehaviorComponent> getBehavior() {
        if (this.behavior == null) {
            this.behavior = new ArrayList<ActionDefinitionBehaviorComponent>();
        }
        return this.behavior;
    }

    public boolean hasBehavior() {
        if (this.behavior == null) {
            return false;
        }
        for (ActionDefinitionBehaviorComponent item : this.behavior) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActionDefinitionBehaviorComponent addBehavior() {
        ActionDefinitionBehaviorComponent t = new ActionDefinitionBehaviorComponent();
        if (this.behavior == null) {
            this.behavior = new ArrayList<ActionDefinitionBehaviorComponent>();
        }
        this.behavior.add(t);
        return t;
    }

    public ActionDefinition addBehavior(ActionDefinitionBehaviorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.behavior == null) {
            this.behavior = new ArrayList<ActionDefinitionBehaviorComponent>();
        }
        this.behavior.add(t);
        return this;
    }

    public Reference getResource() {
        if (this.resource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActionDefinition.resource");
            }
            if (Configuration.doAutoCreate()) {
                this.resource = new Reference();
            }
        }
        return this.resource;
    }

    public boolean hasResource() {
        return this.resource != null && !this.resource.isEmpty();
    }

    public ActionDefinition setResource(Reference value) {
        this.resource = value;
        return this;
    }

    public Resource getResourceTarget() {
        return this.resourceTarget;
    }

    public ActionDefinition setResourceTarget(Resource value) {
        this.resourceTarget = value;
        return this;
    }

    public List<ActionDefinitionCustomizationComponent> getCustomization() {
        if (this.customization == null) {
            this.customization = new ArrayList<ActionDefinitionCustomizationComponent>();
        }
        return this.customization;
    }

    public boolean hasCustomization() {
        if (this.customization == null) {
            return false;
        }
        for (ActionDefinitionCustomizationComponent item : this.customization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActionDefinitionCustomizationComponent addCustomization() {
        ActionDefinitionCustomizationComponent t = new ActionDefinitionCustomizationComponent();
        if (this.customization == null) {
            this.customization = new ArrayList<ActionDefinitionCustomizationComponent>();
        }
        this.customization.add(t);
        return t;
    }

    public ActionDefinition addCustomization(ActionDefinitionCustomizationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.customization == null) {
            this.customization = new ArrayList<ActionDefinitionCustomizationComponent>();
        }
        this.customization.add(t);
        return this;
    }

    public List<ActionDefinition> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        return this.action;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (ActionDefinition item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActionDefinition addAction() {
        ActionDefinition t = new ActionDefinition();
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        this.action.add(t);
        return t;
    }

    public ActionDefinition addAction(ActionDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        this.action.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("actionIdentifier", "Identifier", "A unique identifier for the action. The identifier SHALL be unique within the container in which it appears, and MAY be universally unique.", 0, Integer.MAX_VALUE, this.actionIdentifier));
        childrenList.add(new Property("label", "string", "A user-visible label for the action.", 0, Integer.MAX_VALUE, this.label));
        childrenList.add(new Property("title", "string", "The title of the action displayed to a user.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("description", "string", "A short description of the action used to provide a summary to display to the user.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.", 0, Integer.MAX_VALUE, this.textEquivalent));
        childrenList.add(new Property("concept", "CodeableConcept", "The concept represented by this action or its sub-actions.", 0, Integer.MAX_VALUE, this.concept));
        childrenList.add(new Property("supportingEvidence", "Attachment", "The evidence grade and the sources of evidence for this action.", 0, Integer.MAX_VALUE, this.supportingEvidence));
        childrenList.add(new Property("documentation", "Attachment", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
        childrenList.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
        childrenList.add(new Property("participantType", "code", "The type of participant in the action.", 0, Integer.MAX_VALUE, this.participantType));
        childrenList.add(new Property("type", "code", "The type of action to perform (create, update, remove).", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("behavior", "", "A behavior associated with the action. Behaviors define how the action is to be presented and/or executed within the receiving environment.", 0, Integer.MAX_VALUE, this.behavior));
        childrenList.add(new Property("resource", "Reference(Any)", "The resource that is the target of the action (e.g. CommunicationRequest). The resource described here defines any aspects of the action that can be specified statically (i.e. are known at the time of definition).", 0, Integer.MAX_VALUE, this.resource));
        childrenList.add(new Property("customization", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.customization));
        childrenList.add(new Property("action", "ActionDefinition", "Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -889046145: {
                Base[] baseArray;
                if (this.actionIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.actionIdentifier;
                }
                return baseArray;
            }
            case 102727412: {
                Base[] baseArray;
                if (this.label == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.label;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -900391049: {
                Base[] baseArray;
                if (this.textEquivalent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.textEquivalent;
                }
                return baseArray;
            }
            case 951024232: {
                return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
            }
            case -1735429846: {
                return this.supportingEvidence == null ? new Base[]{} : this.supportingEvidence.toArray(new Base[this.supportingEvidence.size()]);
            }
            case 1587405498: {
                return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
            }
            case -384107967: {
                Base[] baseArray;
                if (this.relatedAction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.relatedAction;
                }
                return baseArray;
            }
            case 841294093: {
                return this.participantType == null ? new Base[]{} : this.participantType.toArray(new Base[this.participantType.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.type;
                }
                return baseArray;
            }
            case 1510912594: {
                return this.behavior == null ? new Base[]{} : this.behavior.toArray(new Base[this.behavior.size()]);
            }
            case -341064690: {
                Base[] baseArray;
                if (this.resource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.resource;
                }
                return baseArray;
            }
            case 1637263315: {
                return this.customization == null ? new Base[]{} : this.customization.toArray(new Base[this.customization.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -889046145: {
                this.actionIdentifier = this.castToIdentifier(value);
                break;
            }
            case 102727412: {
                this.label = this.castToString(value);
                break;
            }
            case 110371416: {
                this.title = this.castToString(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -900391049: {
                this.textEquivalent = this.castToString(value);
                break;
            }
            case 951024232: {
                this.getConcept().add(this.castToCodeableConcept(value));
                break;
            }
            case -1735429846: {
                this.getSupportingEvidence().add(this.castToAttachment(value));
                break;
            }
            case 1587405498: {
                this.getDocumentation().add(this.castToAttachment(value));
                break;
            }
            case -384107967: {
                this.relatedAction = (ActionDefinitionRelatedActionComponent)value;
                break;
            }
            case 841294093: {
                this.getParticipantType().add(new ParticipantTypeEnumFactory().fromType(value));
                break;
            }
            case 3575610: {
                this.type = new ActionTypeEnumFactory().fromType(value);
                break;
            }
            case 1510912594: {
                this.getBehavior().add((ActionDefinitionBehaviorComponent)value);
                break;
            }
            case -341064690: {
                this.resource = this.castToReference(value);
                break;
            }
            case 1637263315: {
                this.getCustomization().add((ActionDefinitionCustomizationComponent)value);
                break;
            }
            case -1422950858: {
                this.getAction().add(this.castToActionDefinition(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("actionIdentifier")) {
            this.actionIdentifier = this.castToIdentifier(value);
        } else if (name.equals("label")) {
            this.label = this.castToString(value);
        } else if (name.equals("title")) {
            this.title = this.castToString(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("textEquivalent")) {
            this.textEquivalent = this.castToString(value);
        } else if (name.equals("concept")) {
            this.getConcept().add(this.castToCodeableConcept(value));
        } else if (name.equals("supportingEvidence")) {
            this.getSupportingEvidence().add(this.castToAttachment(value));
        } else if (name.equals("documentation")) {
            this.getDocumentation().add(this.castToAttachment(value));
        } else if (name.equals("relatedAction")) {
            this.relatedAction = (ActionDefinitionRelatedActionComponent)value;
        } else if (name.equals("participantType")) {
            this.getParticipantType().add(new ParticipantTypeEnumFactory().fromType(value));
        } else if (name.equals("type")) {
            this.type = new ActionTypeEnumFactory().fromType(value);
        } else if (name.equals("behavior")) {
            this.getBehavior().add((ActionDefinitionBehaviorComponent)value);
        } else if (name.equals("resource")) {
            this.resource = this.castToReference(value);
        } else if (name.equals("customization")) {
            this.getCustomization().add((ActionDefinitionCustomizationComponent)value);
        } else if (name.equals("action")) {
            this.getAction().add(this.castToActionDefinition(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -889046145: {
                return this.getActionIdentifier();
            }
            case 102727412: {
                throw new FHIRException("Cannot make property label as it is not a complex type");
            }
            case 110371416: {
                throw new FHIRException("Cannot make property title as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -900391049: {
                throw new FHIRException("Cannot make property textEquivalent as it is not a complex type");
            }
            case 951024232: {
                return this.addConcept();
            }
            case -1735429846: {
                return this.addSupportingEvidence();
            }
            case 1587405498: {
                return this.addDocumentation();
            }
            case -384107967: {
                return this.getRelatedAction();
            }
            case 841294093: {
                throw new FHIRException("Cannot make property participantType as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case 1510912594: {
                return this.addBehavior();
            }
            case -341064690: {
                return this.getResource();
            }
            case 1637263315: {
                return this.addCustomization();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("actionIdentifier")) {
            this.actionIdentifier = new Identifier();
            return this.actionIdentifier;
        }
        if (name.equals("label")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.label");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.title");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.description");
        }
        if (name.equals("textEquivalent")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.textEquivalent");
        }
        if (name.equals("concept")) {
            return this.addConcept();
        }
        if (name.equals("supportingEvidence")) {
            return this.addSupportingEvidence();
        }
        if (name.equals("documentation")) {
            return this.addDocumentation();
        }
        if (name.equals("relatedAction")) {
            this.relatedAction = new ActionDefinitionRelatedActionComponent();
            return this.relatedAction;
        }
        if (name.equals("participantType")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.participantType");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.type");
        }
        if (name.equals("behavior")) {
            return this.addBehavior();
        }
        if (name.equals("resource")) {
            this.resource = new Reference();
            return this.resource;
        }
        if (name.equals("customization")) {
            return this.addCustomization();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ActionDefinition";
    }

    @Override
    public ActionDefinition copy() {
        ActionDefinition dst = new ActionDefinition();
        this.copyValues(dst);
        dst.actionIdentifier = this.actionIdentifier == null ? null : this.actionIdentifier.copy();
        dst.label = this.label == null ? null : this.label.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.description = this.description == null ? null : this.description.copy();
        StringType stringType = dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
        if (this.concept != null) {
            dst.concept = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.concept) {
                dst.concept.add(codeableConcept.copy());
            }
        }
        if (this.supportingEvidence != null) {
            dst.supportingEvidence = new ArrayList<Attachment>();
            for (Attachment attachment : this.supportingEvidence) {
                dst.supportingEvidence.add(attachment.copy());
            }
        }
        if (this.documentation != null) {
            dst.documentation = new ArrayList<Attachment>();
            for (Attachment attachment : this.documentation) {
                dst.documentation.add(attachment.copy());
            }
        }
        ActionDefinitionRelatedActionComponent actionDefinitionRelatedActionComponent = dst.relatedAction = this.relatedAction == null ? null : this.relatedAction.copy();
        if (this.participantType != null) {
            dst.participantType = new ArrayList<Enumeration<ParticipantType>>();
            for (Enumeration enumeration : this.participantType) {
                dst.participantType.add((Enumeration<ParticipantType>)enumeration.copy());
            }
        }
        Enumeration<ActionType> enumeration = dst.type = this.type == null ? null : this.type.copy();
        if (this.behavior != null) {
            dst.behavior = new ArrayList<ActionDefinitionBehaviorComponent>();
            for (ActionDefinitionBehaviorComponent actionDefinitionBehaviorComponent : this.behavior) {
                dst.behavior.add(actionDefinitionBehaviorComponent.copy());
            }
        }
        Reference reference = dst.resource = this.resource == null ? null : this.resource.copy();
        if (this.customization != null) {
            dst.customization = new ArrayList<ActionDefinitionCustomizationComponent>();
            for (ActionDefinitionCustomizationComponent actionDefinitionCustomizationComponent : this.customization) {
                dst.customization.add(actionDefinitionCustomizationComponent.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<ActionDefinition>();
            for (ActionDefinition actionDefinition : this.action) {
                dst.action.add(actionDefinition.copy());
            }
        }
        return dst;
    }

    @Override
    protected ActionDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ActionDefinition)) {
            return false;
        }
        ActionDefinition o = (ActionDefinition)other;
        return ActionDefinition.compareDeep(this.actionIdentifier, o.actionIdentifier, true) && ActionDefinition.compareDeep(this.label, o.label, true) && ActionDefinition.compareDeep(this.title, o.title, true) && ActionDefinition.compareDeep(this.description, o.description, true) && ActionDefinition.compareDeep(this.textEquivalent, o.textEquivalent, true) && ActionDefinition.compareDeep(this.concept, o.concept, true) && ActionDefinition.compareDeep(this.supportingEvidence, o.supportingEvidence, true) && ActionDefinition.compareDeep(this.documentation, o.documentation, true) && ActionDefinition.compareDeep(this.relatedAction, o.relatedAction, true) && ActionDefinition.compareDeep(this.participantType, o.participantType, true) && ActionDefinition.compareDeep(this.type, o.type, true) && ActionDefinition.compareDeep(this.behavior, o.behavior, true) && ActionDefinition.compareDeep(this.resource, o.resource, true) && ActionDefinition.compareDeep(this.customization, o.customization, true) && ActionDefinition.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ActionDefinition)) {
            return false;
        }
        ActionDefinition o = (ActionDefinition)other;
        return ActionDefinition.compareValues(this.label, o.label, true) && ActionDefinition.compareValues(this.title, o.title, true) && ActionDefinition.compareValues(this.description, o.description, true) && ActionDefinition.compareValues(this.textEquivalent, o.textEquivalent, true) && ActionDefinition.compareValues(this.participantType, o.participantType, true) && ActionDefinition.compareValues(this.type, o.type, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.actionIdentifier != null && !this.actionIdentifier.isEmpty() || this.label != null && !this.label.isEmpty() || this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.textEquivalent != null && !this.textEquivalent.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.supportingEvidence != null && !this.supportingEvidence.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.relatedAction != null && !this.relatedAction.isEmpty() || this.participantType != null && !this.participantType.isEmpty() || this.type != null && !this.type.isEmpty() || this.behavior != null && !this.behavior.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.customization != null && !this.customization.isEmpty() || this.action != null && !this.action.isEmpty());
    }

    @Block
    public static class ActionDefinitionCustomizationComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The path to the element to be set dynamically", formalDefinition="The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.")
        protected StringType path;
        @Child(name="expression", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An expression that provides the dynamic value for the customization", formalDefinition="An expression specifying the value of the customized element.")
        protected StringType expression;
        private static final long serialVersionUID = -252690483L;

        public ActionDefinitionCustomizationComponent() {
        }

        public ActionDefinitionCustomizationComponent(StringType path, StringType expression) {
            this.path = path;
            this.expression = expression;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionCustomizationComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ActionDefinitionCustomizationComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ActionDefinitionCustomizationComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionCustomizationComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public ActionDefinitionCustomizationComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public ActionDefinitionCustomizationComponent setExpression(String value) {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("expression", "string", "An expression specifying the value of the customized element.", 0, Integer.MAX_VALUE, this.expression));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case -1795452264: {
                    throw new FHIRException("Cannot make property expression as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.path");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.expression");
            }
            return super.addChild(name);
        }

        @Override
        public ActionDefinitionCustomizationComponent copy() {
            ActionDefinitionCustomizationComponent dst = new ActionDefinitionCustomizationComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ActionDefinitionCustomizationComponent)) {
                return false;
            }
            ActionDefinitionCustomizationComponent o = (ActionDefinitionCustomizationComponent)other;
            return ActionDefinitionCustomizationComponent.compareDeep(this.path, o.path, true) && ActionDefinitionCustomizationComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ActionDefinitionCustomizationComponent)) {
                return false;
            }
            ActionDefinitionCustomizationComponent o = (ActionDefinitionCustomizationComponent)other;
            return ActionDefinitionCustomizationComponent.compareValues(this.path, o.path, true) && ActionDefinitionCustomizationComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.expression != null && !this.expression.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ActionDefinition.customization";
        }
    }

    @Block
    public static class ActionDefinitionBehaviorComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of behavior (grouping, precheck, selection, cardinality, etc)", formalDefinition="The type of the behavior to be described, such as grouping, visual, or selection behaviors.")
        protected Coding type;
        @Child(name="value", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific behavior (e.g. required, at-most-one, single, etc)", formalDefinition="The specific behavior. The code used here is determined by the type of behavior being described. For example, the grouping behavior uses the grouping-behavior-type valueset.")
        protected Coding value;
        private static final long serialVersionUID = -1054119695L;

        public ActionDefinitionBehaviorComponent() {
        }

        public ActionDefinitionBehaviorComponent(Coding type, Coding value) {
            this.type = type;
            this.value = value;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionBehaviorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ActionDefinitionBehaviorComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionBehaviorComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Coding();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ActionDefinitionBehaviorComponent setValue(Coding value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "The type of the behavior to be described, such as grouping, visual, or selection behaviors.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("value", "Coding", "The specific behavior. The code used here is determined by the type of behavior being described. For example, the grouping behavior uses the grouping-behavior-type valueset.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("value")) {
                this.value = new Coding();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ActionDefinitionBehaviorComponent copy() {
            ActionDefinitionBehaviorComponent dst = new ActionDefinitionBehaviorComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ActionDefinitionBehaviorComponent)) {
                return false;
            }
            ActionDefinitionBehaviorComponent o = (ActionDefinitionBehaviorComponent)other;
            return ActionDefinitionBehaviorComponent.compareDeep(this.type, o.type, true) && ActionDefinitionBehaviorComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ActionDefinitionBehaviorComponent)) {
                return false;
            }
            ActionDefinitionBehaviorComponent o = (ActionDefinitionBehaviorComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ActionDefinition.behavior";
        }
    }

    @Block
    public static class ActionDefinitionRelatedActionComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="actionIdentifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the related action", formalDefinition="The unique identifier of the related action.")
        protected Identifier actionIdentifier;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="before | after", formalDefinition="The relationship of this action to the related action.")
        protected Enumeration<ActionRelationshipType> relationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected Type offset;
        @Child(name="anchor", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="start | end", formalDefinition="An optional indicator for how the relationship is anchored to the related action. For example \"before the start\" or \"before the end\" of the related action.")
        protected Enumeration<ActionRelationshipAnchor> anchor;
        private static final long serialVersionUID = 451097227L;

        public ActionDefinitionRelatedActionComponent() {
        }

        public ActionDefinitionRelatedActionComponent(Identifier actionIdentifier, Enumeration<ActionRelationshipType> relationship) {
            this.actionIdentifier = actionIdentifier;
            this.relationship = relationship;
        }

        public Identifier getActionIdentifier() {
            if (this.actionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionRelatedActionComponent.actionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.actionIdentifier = new Identifier();
                }
            }
            return this.actionIdentifier;
        }

        public boolean hasActionIdentifier() {
            return this.actionIdentifier != null && !this.actionIdentifier.isEmpty();
        }

        public ActionDefinitionRelatedActionComponent setActionIdentifier(Identifier value) {
            this.actionIdentifier = value;
            return this;
        }

        public Enumeration<ActionRelationshipType> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<ActionRelationshipType>(new ActionRelationshipTypeEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public ActionDefinitionRelatedActionComponent setRelationshipElement(Enumeration<ActionRelationshipType> value) {
            this.relationship = value;
            return this;
        }

        public ActionRelationshipType getRelationship() {
            return this.relationship == null ? null : (ActionRelationshipType)((Object)this.relationship.getValue());
        }

        public ActionDefinitionRelatedActionComponent setRelationship(ActionRelationshipType value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<ActionRelationshipType>(new ActionRelationshipTypeEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public Type getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public ActionDefinitionRelatedActionComponent setOffset(Type value) {
            this.offset = value;
            return this;
        }

        public Enumeration<ActionRelationshipAnchor> getAnchorElement() {
            if (this.anchor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActionDefinitionRelatedActionComponent.anchor");
                }
                if (Configuration.doAutoCreate()) {
                    this.anchor = new Enumeration<ActionRelationshipAnchor>(new ActionRelationshipAnchorEnumFactory());
                }
            }
            return this.anchor;
        }

        public boolean hasAnchorElement() {
            return this.anchor != null && !this.anchor.isEmpty();
        }

        public boolean hasAnchor() {
            return this.anchor != null && !this.anchor.isEmpty();
        }

        public ActionDefinitionRelatedActionComponent setAnchorElement(Enumeration<ActionRelationshipAnchor> value) {
            this.anchor = value;
            return this;
        }

        public ActionRelationshipAnchor getAnchor() {
            return this.anchor == null ? null : (ActionRelationshipAnchor)((Object)this.anchor.getValue());
        }

        public ActionDefinitionRelatedActionComponent setAnchor(ActionRelationshipAnchor value) {
            if (value == null) {
                this.anchor = null;
            } else {
                if (this.anchor == null) {
                    this.anchor = new Enumeration<ActionRelationshipAnchor>(new ActionRelationshipAnchorEnumFactory());
                }
                this.anchor.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("actionIdentifier", "Identifier", "The unique identifier of the related action.", 0, Integer.MAX_VALUE, this.actionIdentifier));
            childrenList.add(new Property("relationship", "code", "The relationship of this action to the related action.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, Integer.MAX_VALUE, this.offset));
            childrenList.add(new Property("anchor", "code", "An optional indicator for how the relationship is anchored to the related action. For example \"before the start\" or \"before the end\" of the related action.", 0, Integer.MAX_VALUE, this.anchor));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    Base[] baseArray;
                    if (this.actionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actionIdentifier;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.offset;
                    }
                    return baseArray;
                }
                case -1413299531: {
                    Base[] baseArray;
                    if (this.anchor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.anchor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    this.actionIdentifier = this.castToIdentifier(value);
                    break;
                }
                case -261851592: {
                    this.relationship = new ActionRelationshipTypeEnumFactory().fromType(value);
                    break;
                }
                case -1019779949: {
                    this.offset = (Type)value;
                    break;
                }
                case -1413299531: {
                    this.anchor = new ActionRelationshipAnchorEnumFactory().fromType(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actionIdentifier")) {
                this.actionIdentifier = this.castToIdentifier(value);
            } else if (name.equals("relationship")) {
                this.relationship = new ActionRelationshipTypeEnumFactory().fromType(value);
            } else if (name.equals("offset[x]")) {
                this.offset = (Type)value;
            } else if (name.equals("anchor")) {
                this.anchor = new ActionRelationshipAnchorEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -889046145: {
                    return this.getActionIdentifier();
                }
                case -261851592: {
                    throw new FHIRException("Cannot make property relationship as it is not a complex type");
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1413299531: {
                    throw new FHIRException("Cannot make property anchor as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actionIdentifier")) {
                this.actionIdentifier = new Identifier();
                return this.actionIdentifier;
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.relationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            if (name.equals("anchor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ActionDefinition.anchor");
            }
            return super.addChild(name);
        }

        @Override
        public ActionDefinitionRelatedActionComponent copy() {
            ActionDefinitionRelatedActionComponent dst = new ActionDefinitionRelatedActionComponent();
            this.copyValues(dst);
            dst.actionIdentifier = this.actionIdentifier == null ? null : this.actionIdentifier.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
            dst.anchor = this.anchor == null ? null : this.anchor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ActionDefinitionRelatedActionComponent)) {
                return false;
            }
            ActionDefinitionRelatedActionComponent o = (ActionDefinitionRelatedActionComponent)other;
            return ActionDefinitionRelatedActionComponent.compareDeep(this.actionIdentifier, o.actionIdentifier, true) && ActionDefinitionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && ActionDefinitionRelatedActionComponent.compareDeep(this.offset, o.offset, true) && ActionDefinitionRelatedActionComponent.compareDeep(this.anchor, o.anchor, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ActionDefinitionRelatedActionComponent)) {
                return false;
            }
            ActionDefinitionRelatedActionComponent o = (ActionDefinitionRelatedActionComponent)other;
            return ActionDefinitionRelatedActionComponent.compareValues(this.relationship, o.relationship, true) && ActionDefinitionRelatedActionComponent.compareValues(this.anchor, o.anchor, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.actionIdentifier != null && !this.actionIdentifier.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.offset != null && !this.offset.isEmpty() || this.anchor != null && !this.anchor.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ActionDefinition.relatedAction";
        }
    }

    public static class ActionTypeEnumFactory
    implements EnumFactory<ActionType> {
        @Override
        public ActionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return ActionType.CREATE;
            }
            if ("update".equals(codeString)) {
                return ActionType.UPDATE;
            }
            if ("remove".equals(codeString)) {
                return ActionType.REMOVE;
            }
            if ("fire-event".equals(codeString)) {
                return ActionType.FIREEVENT;
            }
            throw new IllegalArgumentException("Unknown ActionType code '" + codeString + "'");
        }

        public Enumeration<ActionType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return new Enumeration<ActionType>(this, ActionType.CREATE);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<ActionType>(this, ActionType.UPDATE);
            }
            if ("remove".equals(codeString)) {
                return new Enumeration<ActionType>(this, ActionType.REMOVE);
            }
            if ("fire-event".equals(codeString)) {
                return new Enumeration<ActionType>(this, ActionType.FIREEVENT);
            }
            throw new FHIRException("Unknown ActionType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionType code) {
            if (code == ActionType.CREATE) {
                return "create";
            }
            if (code == ActionType.UPDATE) {
                return "update";
            }
            if (code == ActionType.REMOVE) {
                return "remove";
            }
            if (code == ActionType.FIREEVENT) {
                return "fire-event";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionType code) {
            return code.getSystem();
        }
    }

    public static enum ActionType {
        CREATE,
        UPDATE,
        REMOVE,
        FIREEVENT,
        NULL;


        public static ActionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("remove".equals(codeString)) {
                return REMOVE;
            }
            if ("fire-event".equals(codeString)) {
                return FIREEVENT;
            }
            throw new FHIRException("Unknown ActionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case REMOVE: {
                    return "remove";
                }
                case FIREEVENT: {
                    return "fire-event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/action-type";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/action-type";
                }
                case REMOVE: {
                    return "http://hl7.org/fhir/action-type";
                }
                case FIREEVENT: {
                    return "http://hl7.org/fhir/action-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "The action is to create a new resource";
                }
                case UPDATE: {
                    return "The action is to update an existing resource";
                }
                case REMOVE: {
                    return "The action is to remove an existing resource";
                }
                case FIREEVENT: {
                    return "The action is to fire a specific event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "Create";
                }
                case UPDATE: {
                    return "Update";
                }
                case REMOVE: {
                    return "Remove";
                }
                case FIREEVENT: {
                    return "Fire Event";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ParticipantTypeEnumFactory
    implements EnumFactory<ParticipantType> {
        @Override
        public ParticipantType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return ParticipantType.PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return ParticipantType.PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return ParticipantType.RELATEDPERSON;
            }
            throw new IllegalArgumentException("Unknown ParticipantType code '" + codeString + "'");
        }

        public Enumeration<ParticipantType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return new Enumeration<ParticipantType>(this, ParticipantType.PATIENT);
            }
            if ("practitioner".equals(codeString)) {
                return new Enumeration<ParticipantType>(this, ParticipantType.PRACTITIONER);
            }
            if ("related-person".equals(codeString)) {
                return new Enumeration<ParticipantType>(this, ParticipantType.RELATEDPERSON);
            }
            throw new FHIRException("Unknown ParticipantType code '" + codeString + "'");
        }

        @Override
        public String toCode(ParticipantType code) {
            if (code == ParticipantType.PATIENT) {
                return "patient";
            }
            if (code == ParticipantType.PRACTITIONER) {
                return "practitioner";
            }
            if (code == ParticipantType.RELATEDPERSON) {
                return "related-person";
            }
            return "?";
        }

        @Override
        public String toSystem(ParticipantType code) {
            return code.getSystem();
        }
    }

    public static enum ParticipantType {
        PATIENT,
        PRACTITIONER,
        RELATEDPERSON,
        NULL;


        public static ParticipantType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return RELATEDPERSON;
            }
            throw new FHIRException("Unknown ParticipantType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PATIENT: {
                    return "patient";
                }
                case PRACTITIONER: {
                    return "practitioner";
                }
                case RELATEDPERSON: {
                    return "related-person";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PATIENT: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PATIENT: {
                    return "The participant is the patient under evaluation";
                }
                case PRACTITIONER: {
                    return "The participant is a practitioner involved in the patient's care";
                }
                case RELATEDPERSON: {
                    return "The participant is a person related to the patient";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case RELATEDPERSON: {
                    return "Related Person";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionRelationshipAnchorEnumFactory
    implements EnumFactory<ActionRelationshipAnchor> {
        @Override
        public ActionRelationshipAnchor fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("start".equals(codeString)) {
                return ActionRelationshipAnchor.START;
            }
            if ("end".equals(codeString)) {
                return ActionRelationshipAnchor.END;
            }
            throw new IllegalArgumentException("Unknown ActionRelationshipAnchor code '" + codeString + "'");
        }

        public Enumeration<ActionRelationshipAnchor> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("start".equals(codeString)) {
                return new Enumeration<ActionRelationshipAnchor>(this, ActionRelationshipAnchor.START);
            }
            if ("end".equals(codeString)) {
                return new Enumeration<ActionRelationshipAnchor>(this, ActionRelationshipAnchor.END);
            }
            throw new FHIRException("Unknown ActionRelationshipAnchor code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionRelationshipAnchor code) {
            if (code == ActionRelationshipAnchor.START) {
                return "start";
            }
            if (code == ActionRelationshipAnchor.END) {
                return "end";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionRelationshipAnchor code) {
            return code.getSystem();
        }
    }

    public static enum ActionRelationshipAnchor {
        START,
        END,
        NULL;


        public static ActionRelationshipAnchor fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("start".equals(codeString)) {
                return START;
            }
            if ("end".equals(codeString)) {
                return END;
            }
            throw new FHIRException("Unknown ActionRelationshipAnchor code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case START: {
                    return "start";
                }
                case END: {
                    return "end";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case START: {
                    return "http://hl7.org/fhir/action-relationship-anchor";
                }
                case END: {
                    return "http://hl7.org/fhir/action-relationship-anchor";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case START: {
                    return "The action relationship is anchored to the start of the related action";
                }
                case END: {
                    return "The action relationship is anchored to the end of the related action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case START: {
                    return "Start";
                }
                case END: {
                    return "End";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionRelationshipTypeEnumFactory
    implements EnumFactory<ActionRelationshipType> {
        @Override
        public ActionRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("before".equals(codeString)) {
                return ActionRelationshipType.BEFORE;
            }
            if ("after".equals(codeString)) {
                return ActionRelationshipType.AFTER;
            }
            throw new IllegalArgumentException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        public Enumeration<ActionRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("before".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFORE);
            }
            if ("after".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTER);
            }
            throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionRelationshipType code) {
            if (code == ActionRelationshipType.BEFORE) {
                return "before";
            }
            if (code == ActionRelationshipType.AFTER) {
                return "after";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum ActionRelationshipType {
        BEFORE,
        AFTER,
        NULL;


        public static ActionRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("before".equals(codeString)) {
                return BEFORE;
            }
            if ("after".equals(codeString)) {
                return AFTER;
            }
            throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BEFORE: {
                    return "before";
                }
                case AFTER: {
                    return "after";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BEFORE: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTER: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BEFORE: {
                    return "The action must be performed before the related action";
                }
                case AFTER: {
                    return "The action must be performed after the related action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BEFORE: {
                    return "Before";
                }
                case AFTER: {
                    return "After";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

