/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.Adjudication;

public class AdjudicationEnumFactory
implements EnumFactory<Adjudication> {
    @Override
    public Adjudication fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("total".equals(codeString)) {
            return Adjudication.TOTAL;
        }
        if ("copay".equals(codeString)) {
            return Adjudication.COPAY;
        }
        if ("eligible".equals(codeString)) {
            return Adjudication.ELIGIBLE;
        }
        if ("deductible".equals(codeString)) {
            return Adjudication.DEDUCTIBLE;
        }
        if ("eligpercent".equals(codeString)) {
            return Adjudication.ELIGPERCENT;
        }
        if ("tax".equals(codeString)) {
            return Adjudication.TAX;
        }
        if ("benefit".equals(codeString)) {
            return Adjudication.BENEFIT;
        }
        throw new IllegalArgumentException("Unknown Adjudication code '" + codeString + "'");
    }

    @Override
    public String toCode(Adjudication code) {
        if (code == Adjudication.TOTAL) {
            return "total";
        }
        if (code == Adjudication.COPAY) {
            return "copay";
        }
        if (code == Adjudication.ELIGIBLE) {
            return "eligible";
        }
        if (code == Adjudication.DEDUCTIBLE) {
            return "deductible";
        }
        if (code == Adjudication.ELIGPERCENT) {
            return "eligpercent";
        }
        if (code == Adjudication.TAX) {
            return "tax";
        }
        if (code == Adjudication.BENEFIT) {
            return "benefit";
        }
        return "?";
    }

    @Override
    public String toSystem(Adjudication code) {
        return code.getSystem();
    }
}

