/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="TestScript", profile="http://hl7.org/fhir/Profile/TestScript")
public class TestScript
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Absolute URL used to reference this TestScript", formalDefinition="An absolute URL that is used to identify this Test Script. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Test Script is (or will be) published.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the TestScript", formalDefinition="The identifier that is used to identify this version of the TestScript. This is an arbitrary value managed by the TestScript author manually.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this TestScript", formalDefinition="A free text natural language name identifying the TestScript.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the TestScript.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="identifier", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier for the TestScript assigned for external purposes outside the context of FHIR.")
    protected Identifier identifier;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This TestScript was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the Test Script.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<TestScriptContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for this version of the TestScript", formalDefinition="The date this version of the test tcript was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the test cases change.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the TestScript", formalDefinition="A free text natural language description of the TestScript and its use.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of Test Scripts.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Scope and Usage this Test Script is for", formalDefinition="Explains why this Test Script is needed and why it's been constrained as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the Test Script and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.")
    protected StringType copyright;
    @Child(name="origin", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An abstract server representing a client or sender in a message exchange", formalDefinition="An abstract server used in operations within this test script in the origin element.")
    protected List<TestScriptOriginComponent> origin;
    @Child(name="destination", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An abstract server representing a destination or receiver in a message exchange", formalDefinition="An abstract server used in operations within this test script in the destination element.")
    protected List<TestScriptDestinationComponent> destination;
    @Child(name="metadata", type={}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Required capability that is assumed to function correctly on the FHIR server being tested", formalDefinition="The required capability must exist and are assumed to function correctly on the FHIR server being tested.")
    protected TestScriptMetadataComponent metadata;
    @Child(name="fixture", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Fixture in the test script - by reference (uri)", formalDefinition="Fixture in the test script - by reference (uri). All fixtures are required for the test script to execute.")
    protected List<TestScriptFixtureComponent> fixture;
    @Child(name="profile", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference of the validation profile", formalDefinition="Reference to the profile to be used for validation.")
    protected List<Reference> profile;
    protected List<Resource> profileTarget;
    @Child(name="variable", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Placeholder for evaluated elements", formalDefinition="Variable is set based either on element value in response body or on header field value in the response headers.")
    protected List<TestScriptVariableComponent> variable;
    @Child(name="rule", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Assert rule used within the test script", formalDefinition="Assert rule to be used in one or more asserts within the test script.")
    protected List<TestScriptRuleComponent> rule;
    @Child(name="ruleset", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Assert ruleset used within the test script", formalDefinition="Contains one or more rules.  Offers a way to group rules so assertions could reference the group of rules and have them all applied.")
    protected List<TestScriptRulesetComponent> ruleset;
    @Child(name="setup", type={}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A series of required setup operations before tests are executed", formalDefinition="A series of required setup operations before tests are executed.")
    protected TestScriptSetupComponent setup;
    @Child(name="test", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A test in this script", formalDefinition="A test in this script.")
    protected List<TestScriptTestComponent> test;
    @Child(name="teardown", type={}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A series of required clean up steps", formalDefinition="A series of operations required to clean up after the all the tests are executed (successfully or otherwise).")
    protected TestScriptTeardownComponent teardown;
    private static final long serialVersionUID = -468958725L;
    @SearchParamDefinition(name="testscript-test-capability", path="TestScript.test.metadata.capability.description", description="TestScript test required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_TEST_CAPABILITY = "testscript-test-capability";
    public static final StringClientParam TESTSCRIPT_TEST_CAPABILITY = new StringClientParam("testscript-test-capability");
    @SearchParamDefinition(name="testscript-setup-capability", path="TestScript.setup.metadata.capability.description", description="TestScript setup required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_SETUP_CAPABILITY = "testscript-setup-capability";
    public static final StringClientParam TESTSCRIPT_SETUP_CAPABILITY = new StringClientParam("testscript-setup-capability");
    @SearchParamDefinition(name="description", path="TestScript.description", description="Natural language description of the TestScript", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="TestScript.name", description="Informal name for this TestScript", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="testscript-capability", path="TestScript.metadata.capability.description", description="TestScript required and validated capability", type="string")
    public static final String SP_TESTSCRIPT_CAPABILITY = "testscript-capability";
    public static final StringClientParam TESTSCRIPT_CAPABILITY = new StringClientParam("testscript-capability");
    @SearchParamDefinition(name="identifier", path="TestScript.identifier", description="External identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="url", path="TestScript.url", description="Absolute URL used to reference this TestScript", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public TestScript() {
    }

    public TestScript(UriType url, StringType name, Enumeration<Enumerations.ConformanceResourceStatus> status) {
        this.url = url;
        this.name = name;
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public TestScript setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public TestScript setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public TestScript setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public TestScript setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public TestScript setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public TestScript setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public TestScript setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public TestScript setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public TestScript setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public TestScript setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public TestScript setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public TestScript setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public TestScript setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<TestScriptContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<TestScriptContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (TestScriptContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptContactComponent addContact() {
        TestScriptContactComponent t = new TestScriptContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<TestScriptContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public TestScript addContact(TestScriptContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<TestScriptContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public TestScript setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public TestScript setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public TestScript setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public TestScript setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public TestScript addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public TestScript setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public TestScript setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public TestScript setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public TestScript setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<TestScriptOriginComponent> getOrigin() {
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOriginComponent>();
        }
        return this.origin;
    }

    public boolean hasOrigin() {
        if (this.origin == null) {
            return false;
        }
        for (TestScriptOriginComponent item : this.origin) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptOriginComponent addOrigin() {
        TestScriptOriginComponent t = new TestScriptOriginComponent();
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOriginComponent>();
        }
        this.origin.add(t);
        return t;
    }

    public TestScript addOrigin(TestScriptOriginComponent t) {
        if (t == null) {
            return this;
        }
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOriginComponent>();
        }
        this.origin.add(t);
        return this;
    }

    public List<TestScriptDestinationComponent> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestinationComponent>();
        }
        return this.destination;
    }

    public boolean hasDestination() {
        if (this.destination == null) {
            return false;
        }
        for (TestScriptDestinationComponent item : this.destination) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptDestinationComponent addDestination() {
        TestScriptDestinationComponent t = new TestScriptDestinationComponent();
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestinationComponent>();
        }
        this.destination.add(t);
        return t;
    }

    public TestScript addDestination(TestScriptDestinationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestinationComponent>();
        }
        this.destination.add(t);
        return this;
    }

    public TestScriptMetadataComponent getMetadata() {
        if (this.metadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.metadata");
            }
            if (Configuration.doAutoCreate()) {
                this.metadata = new TestScriptMetadataComponent();
            }
        }
        return this.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    public TestScript setMetadata(TestScriptMetadataComponent value) {
        this.metadata = value;
        return this;
    }

    public List<TestScriptFixtureComponent> getFixture() {
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixtureComponent>();
        }
        return this.fixture;
    }

    public boolean hasFixture() {
        if (this.fixture == null) {
            return false;
        }
        for (TestScriptFixtureComponent item : this.fixture) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptFixtureComponent addFixture() {
        TestScriptFixtureComponent t = new TestScriptFixtureComponent();
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixtureComponent>();
        }
        this.fixture.add(t);
        return t;
    }

    public TestScript addFixture(TestScriptFixtureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixtureComponent>();
        }
        this.fixture.add(t);
        return this;
    }

    public List<Reference> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        return this.profile;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (Reference item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProfile() {
        Reference t = new Reference();
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        this.profile.add(t);
        return t;
    }

    public TestScript addProfile(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        this.profile.add(t);
        return this;
    }

    public List<Resource> getProfileTarget() {
        if (this.profileTarget == null) {
            this.profileTarget = new ArrayList<Resource>();
        }
        return this.profileTarget;
    }

    public List<TestScriptVariableComponent> getVariable() {
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariableComponent>();
        }
        return this.variable;
    }

    public boolean hasVariable() {
        if (this.variable == null) {
            return false;
        }
        for (TestScriptVariableComponent item : this.variable) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptVariableComponent addVariable() {
        TestScriptVariableComponent t = new TestScriptVariableComponent();
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariableComponent>();
        }
        this.variable.add(t);
        return t;
    }

    public TestScript addVariable(TestScriptVariableComponent t) {
        if (t == null) {
            return this;
        }
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariableComponent>();
        }
        this.variable.add(t);
        return this;
    }

    public List<TestScriptRuleComponent> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<TestScriptRuleComponent>();
        }
        return this.rule;
    }

    public boolean hasRule() {
        if (this.rule == null) {
            return false;
        }
        for (TestScriptRuleComponent item : this.rule) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptRuleComponent addRule() {
        TestScriptRuleComponent t = new TestScriptRuleComponent();
        if (this.rule == null) {
            this.rule = new ArrayList<TestScriptRuleComponent>();
        }
        this.rule.add(t);
        return t;
    }

    public TestScript addRule(TestScriptRuleComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rule == null) {
            this.rule = new ArrayList<TestScriptRuleComponent>();
        }
        this.rule.add(t);
        return this;
    }

    public List<TestScriptRulesetComponent> getRuleset() {
        if (this.ruleset == null) {
            this.ruleset = new ArrayList<TestScriptRulesetComponent>();
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        if (this.ruleset == null) {
            return false;
        }
        for (TestScriptRulesetComponent item : this.ruleset) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptRulesetComponent addRuleset() {
        TestScriptRulesetComponent t = new TestScriptRulesetComponent();
        if (this.ruleset == null) {
            this.ruleset = new ArrayList<TestScriptRulesetComponent>();
        }
        this.ruleset.add(t);
        return t;
    }

    public TestScript addRuleset(TestScriptRulesetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ruleset == null) {
            this.ruleset = new ArrayList<TestScriptRulesetComponent>();
        }
        this.ruleset.add(t);
        return this;
    }

    public TestScriptSetupComponent getSetup() {
        if (this.setup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.setup");
            }
            if (Configuration.doAutoCreate()) {
                this.setup = new TestScriptSetupComponent();
            }
        }
        return this.setup;
    }

    public boolean hasSetup() {
        return this.setup != null && !this.setup.isEmpty();
    }

    public TestScript setSetup(TestScriptSetupComponent value) {
        this.setup = value;
        return this;
    }

    public List<TestScriptTestComponent> getTest() {
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTestComponent>();
        }
        return this.test;
    }

    public boolean hasTest() {
        if (this.test == null) {
            return false;
        }
        for (TestScriptTestComponent item : this.test) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestScriptTestComponent addTest() {
        TestScriptTestComponent t = new TestScriptTestComponent();
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTestComponent>();
        }
        this.test.add(t);
        return t;
    }

    public TestScript addTest(TestScriptTestComponent t) {
        if (t == null) {
            return this;
        }
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTestComponent>();
        }
        this.test.add(t);
        return this;
    }

    public TestScriptTeardownComponent getTeardown() {
        if (this.teardown == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestScript.teardown");
            }
            if (Configuration.doAutoCreate()) {
                this.teardown = new TestScriptTeardownComponent();
            }
        }
        return this.teardown;
    }

    public boolean hasTeardown() {
        return this.teardown != null && !this.teardown.isEmpty();
    }

    public TestScript setTeardown(TestScriptTeardownComponent value) {
        this.teardown = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this Test Script. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Test Script is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property("version", "string", "The identifier that is used to identify this version of the TestScript. This is an arbitrary value managed by the TestScript author manually.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the TestScript.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("status", "code", "The status of the TestScript.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the TestScript assigned for external purposes outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("experimental", "boolean", "This TestScript was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property("publisher", "string", "The name of the individual or organization that published the Test Script.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("date", "dateTime", "The date this version of the test tcript was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the test cases change.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the TestScript and its use.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of Test Scripts.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "Explains why this Test Script is needed and why it's been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the Test Script and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("origin", "", "An abstract server used in operations within this test script in the origin element.", 0, Integer.MAX_VALUE, this.origin));
        childrenList.add(new Property("destination", "", "An abstract server used in operations within this test script in the destination element.", 0, Integer.MAX_VALUE, this.destination));
        childrenList.add(new Property("metadata", "", "The required capability must exist and are assumed to function correctly on the FHIR server being tested.", 0, Integer.MAX_VALUE, this.metadata));
        childrenList.add(new Property("fixture", "", "Fixture in the test script - by reference (uri). All fixtures are required for the test script to execute.", 0, Integer.MAX_VALUE, this.fixture));
        childrenList.add(new Property("profile", "Reference(Any)", "Reference to the profile to be used for validation.", 0, Integer.MAX_VALUE, this.profile));
        childrenList.add(new Property("variable", "", "Variable is set based either on element value in response body or on header field value in the response headers.", 0, Integer.MAX_VALUE, this.variable));
        childrenList.add(new Property("rule", "", "Assert rule to be used in one or more asserts within the test script.", 0, Integer.MAX_VALUE, this.rule));
        childrenList.add(new Property("ruleset", "", "Contains one or more rules.  Offers a way to group rules so assertions could reference the group of rules and have them all applied.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("setup", "", "A series of required setup operations before tests are executed.", 0, Integer.MAX_VALUE, this.setup));
        childrenList.add(new Property("test", "", "A test in this script.", 0, Integer.MAX_VALUE, this.test));
        childrenList.add(new Property("teardown", "", "A series of operations required to clean up after the all the tests are executed (successfully or otherwise).", 0, Integer.MAX_VALUE, this.teardown));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.identifier;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requirements;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case -1008619738: {
                return this.origin == null ? new Base[]{} : this.origin.toArray(new Base[this.origin.size()]);
            }
            case -1429847026: {
                return this.destination == null ? new Base[]{} : this.destination.toArray(new Base[this.destination.size()]);
            }
            case -450004177: {
                Base[] baseArray;
                if (this.metadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.metadata;
                }
                return baseArray;
            }
            case -843449847: {
                return this.fixture == null ? new Base[]{} : this.fixture.toArray(new Base[this.fixture.size()]);
            }
            case -309425751: {
                return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
            }
            case -1249586564: {
                return this.variable == null ? new Base[]{} : this.variable.toArray(new Base[this.variable.size()]);
            }
            case 3512060: {
                return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
            }
            case 1548678118: {
                return this.ruleset == null ? new Base[]{} : this.ruleset.toArray(new Base[this.ruleset.size()]);
            }
            case 109329021: {
                Base[] baseArray;
                if (this.setup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.setup;
                }
                return baseArray;
            }
            case 3556498: {
                return this.test == null ? new Base[]{} : this.test.toArray(new Base[this.test.size()]);
            }
            case -1663474172: {
                Base[] baseArray;
                if (this.teardown == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.teardown;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((TestScriptContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case -1008619738: {
                this.getOrigin().add((TestScriptOriginComponent)value);
                break;
            }
            case -1429847026: {
                this.getDestination().add((TestScriptDestinationComponent)value);
                break;
            }
            case -450004177: {
                this.metadata = (TestScriptMetadataComponent)value;
                break;
            }
            case -843449847: {
                this.getFixture().add((TestScriptFixtureComponent)value);
                break;
            }
            case -309425751: {
                this.getProfile().add(this.castToReference(value));
                break;
            }
            case -1249586564: {
                this.getVariable().add((TestScriptVariableComponent)value);
                break;
            }
            case 3512060: {
                this.getRule().add((TestScriptRuleComponent)value);
                break;
            }
            case 1548678118: {
                this.getRuleset().add((TestScriptRulesetComponent)value);
                break;
            }
            case 109329021: {
                this.setup = (TestScriptSetupComponent)value;
                break;
            }
            case 3556498: {
                this.getTest().add((TestScriptTestComponent)value);
                break;
            }
            case -1663474172: {
                this.teardown = (TestScriptTeardownComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("status")) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals("publisher")) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((TestScriptContactComponent)value);
        } else if (name.equals("date")) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("origin")) {
            this.getOrigin().add((TestScriptOriginComponent)value);
        } else if (name.equals("destination")) {
            this.getDestination().add((TestScriptDestinationComponent)value);
        } else if (name.equals("metadata")) {
            this.metadata = (TestScriptMetadataComponent)value;
        } else if (name.equals("fixture")) {
            this.getFixture().add((TestScriptFixtureComponent)value);
        } else if (name.equals("profile")) {
            this.getProfile().add(this.castToReference(value));
        } else if (name.equals("variable")) {
            this.getVariable().add((TestScriptVariableComponent)value);
        } else if (name.equals("rule")) {
            this.getRule().add((TestScriptRuleComponent)value);
        } else if (name.equals("ruleset")) {
            this.getRuleset().add((TestScriptRulesetComponent)value);
        } else if (name.equals("setup")) {
            this.setup = (TestScriptSetupComponent)value;
        } else if (name.equals("test")) {
            this.getTest().add((TestScriptTestComponent)value);
        } else if (name.equals("teardown")) {
            this.teardown = (TestScriptTeardownComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case -1008619738: {
                return this.addOrigin();
            }
            case -1429847026: {
                return this.addDestination();
            }
            case -450004177: {
                return this.getMetadata();
            }
            case -843449847: {
                return this.addFixture();
            }
            case -309425751: {
                return this.addProfile();
            }
            case -1249586564: {
                return this.addVariable();
            }
            case 3512060: {
                return this.addRule();
            }
            case 1548678118: {
                return this.addRuleset();
            }
            case 109329021: {
                return this.getSetup();
            }
            case 3556498: {
                return this.addTest();
            }
            case -1663474172: {
                return this.getTeardown();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.url");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.status");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.experimental");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestScript.copyright");
        }
        if (name.equals("origin")) {
            return this.addOrigin();
        }
        if (name.equals("destination")) {
            return this.addDestination();
        }
        if (name.equals("metadata")) {
            this.metadata = new TestScriptMetadataComponent();
            return this.metadata;
        }
        if (name.equals("fixture")) {
            return this.addFixture();
        }
        if (name.equals("profile")) {
            return this.addProfile();
        }
        if (name.equals("variable")) {
            return this.addVariable();
        }
        if (name.equals("rule")) {
            return this.addRule();
        }
        if (name.equals("ruleset")) {
            return this.addRuleset();
        }
        if (name.equals("setup")) {
            this.setup = new TestScriptSetupComponent();
            return this.setup;
        }
        if (name.equals("test")) {
            return this.addTest();
        }
        if (name.equals("teardown")) {
            this.teardown = new TestScriptTeardownComponent();
            return this.teardown;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TestScript";
    }

    @Override
    public TestScript copy() {
        TestScript dst = new TestScript();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<TestScriptContactComponent>();
            for (TestScriptContactComponent testScriptContactComponent : this.contact) {
                dst.contact.add(testScriptContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        StringType stringType3 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.origin != null) {
            dst.origin = new ArrayList<TestScriptOriginComponent>();
            for (TestScriptOriginComponent testScriptOriginComponent : this.origin) {
                dst.origin.add(testScriptOriginComponent.copy());
            }
        }
        if (this.destination != null) {
            dst.destination = new ArrayList<TestScriptDestinationComponent>();
            for (TestScriptDestinationComponent testScriptDestinationComponent : this.destination) {
                dst.destination.add(testScriptDestinationComponent.copy());
            }
        }
        TestScriptMetadataComponent testScriptMetadataComponent = dst.metadata = this.metadata == null ? null : this.metadata.copy();
        if (this.fixture != null) {
            dst.fixture = new ArrayList<TestScriptFixtureComponent>();
            for (TestScriptFixtureComponent testScriptFixtureComponent : this.fixture) {
                dst.fixture.add(testScriptFixtureComponent.copy());
            }
        }
        if (this.profile != null) {
            dst.profile = new ArrayList<Reference>();
            for (Reference reference : this.profile) {
                dst.profile.add(reference.copy());
            }
        }
        if (this.variable != null) {
            dst.variable = new ArrayList<TestScriptVariableComponent>();
            for (TestScriptVariableComponent testScriptVariableComponent : this.variable) {
                dst.variable.add(testScriptVariableComponent.copy());
            }
        }
        if (this.rule != null) {
            dst.rule = new ArrayList<TestScriptRuleComponent>();
            for (TestScriptRuleComponent testScriptRuleComponent : this.rule) {
                dst.rule.add(testScriptRuleComponent.copy());
            }
        }
        if (this.ruleset != null) {
            dst.ruleset = new ArrayList<TestScriptRulesetComponent>();
            for (TestScriptRulesetComponent testScriptRulesetComponent : this.ruleset) {
                dst.ruleset.add(testScriptRulesetComponent.copy());
            }
        }
        TestScriptSetupComponent testScriptSetupComponent = dst.setup = this.setup == null ? null : this.setup.copy();
        if (this.test != null) {
            dst.test = new ArrayList<TestScriptTestComponent>();
            for (TestScriptTestComponent testScriptTestComponent : this.test) {
                dst.test.add(testScriptTestComponent.copy());
            }
        }
        dst.teardown = this.teardown == null ? null : this.teardown.copy();
        return dst;
    }

    protected TestScript typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof TestScript)) {
            return false;
        }
        TestScript o = (TestScript)other;
        return TestScript.compareDeep(this.url, o.url, true) && TestScript.compareDeep(this.version, o.version, true) && TestScript.compareDeep(this.name, o.name, true) && TestScript.compareDeep(this.status, o.status, true) && TestScript.compareDeep(this.identifier, o.identifier, true) && TestScript.compareDeep(this.experimental, o.experimental, true) && TestScript.compareDeep(this.publisher, o.publisher, true) && TestScript.compareDeep(this.contact, o.contact, true) && TestScript.compareDeep(this.date, o.date, true) && TestScript.compareDeep(this.description, o.description, true) && TestScript.compareDeep(this.useContext, o.useContext, true) && TestScript.compareDeep(this.requirements, o.requirements, true) && TestScript.compareDeep(this.copyright, o.copyright, true) && TestScript.compareDeep(this.origin, o.origin, true) && TestScript.compareDeep(this.destination, o.destination, true) && TestScript.compareDeep(this.metadata, o.metadata, true) && TestScript.compareDeep(this.fixture, o.fixture, true) && TestScript.compareDeep(this.profile, o.profile, true) && TestScript.compareDeep(this.variable, o.variable, true) && TestScript.compareDeep(this.rule, o.rule, true) && TestScript.compareDeep(this.ruleset, o.ruleset, true) && TestScript.compareDeep(this.setup, o.setup, true) && TestScript.compareDeep(this.test, o.test, true) && TestScript.compareDeep(this.teardown, o.teardown, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof TestScript)) {
            return false;
        }
        TestScript o = (TestScript)other;
        return TestScript.compareValues(this.url, o.url, true) && TestScript.compareValues(this.version, o.version, true) && TestScript.compareValues(this.name, o.name, true) && TestScript.compareValues(this.status, o.status, true) && TestScript.compareValues(this.experimental, o.experimental, true) && TestScript.compareValues(this.publisher, o.publisher, true) && TestScript.compareValues(this.date, o.date, true) && TestScript.compareValues(this.description, o.description, true) && TestScript.compareValues(this.requirements, o.requirements, true) && TestScript.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.origin != null && !this.origin.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.metadata != null && !this.metadata.isEmpty() || this.fixture != null && !this.fixture.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.variable != null && !this.variable.isEmpty() || this.rule != null && !this.rule.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.setup != null && !this.setup.isEmpty() || this.test != null && !this.test.isEmpty() || this.teardown != null && !this.teardown.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TestScript;
    }

    @Block
    public static class TeardownActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={SetupActionOperationComponent.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The teardown operation to perform", formalDefinition="An operation would involve a REST request to a server.")
        protected SetupActionOperationComponent operation;
        private static final long serialVersionUID = -1099598054L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TeardownActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TeardownActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("operation", "@TestScript.setup.action.operation", "An operation would involve a REST request to a server.", 0, Integer.MAX_VALUE, this.operation));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            return super.addChild(name);
        }

        @Override
        public TeardownActionComponent copy() {
            TeardownActionComponent dst = new TeardownActionComponent();
            this.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TeardownActionComponent)) {
                return false;
            }
            TeardownActionComponent o = (TeardownActionComponent)other;
            return TeardownActionComponent.compareDeep(this.operation, o.operation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TeardownActionComponent)) {
                return false;
            }
            TeardownActionComponent o = (TeardownActionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.operation == null || this.operation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.teardown.action";
        }
    }

    @Block
    public static class TestScriptTeardownComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="One or more teardown operations to perform", formalDefinition="The teardown action will only contain an operation.")
        protected List<TeardownActionComponent> action;
        private static final long serialVersionUID = 1168638089L;

        public List<TeardownActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            return this.action;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (TeardownActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TeardownActionComponent addAction() {
            TeardownActionComponent t = new TeardownActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestScriptTeardownComponent addAction(TeardownActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<TeardownActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("action", "", "The teardown action will only contain an operation.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.getAction().add((TeardownActionComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.getAction().add((TeardownActionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptTeardownComponent copy() {
            TestScriptTeardownComponent dst = new TestScriptTeardownComponent();
            this.copyValues(dst);
            if (this.action != null) {
                dst.action = new ArrayList<TeardownActionComponent>();
                for (TeardownActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptTeardownComponent)) {
                return false;
            }
            TestScriptTeardownComponent o = (TestScriptTeardownComponent)other;
            return TestScriptTeardownComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptTeardownComponent)) {
                return false;
            }
            TestScriptTeardownComponent o = (TestScriptTeardownComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.action == null || this.action.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.teardown";
        }
    }

    @Block
    public static class TestActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={SetupActionOperationComponent.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The setup operation to perform", formalDefinition="An operation would involve a REST request to a server.")
        protected SetupActionOperationComponent operation;
        @Child(name="assert", type={SetupActionAssertComponent.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The setup assertion to perform", formalDefinition="Evaluates the results of previous operations to determine if the server under test behaves appropriately.")
        protected SetupActionAssertComponent assert_;
        private static final long serialVersionUID = -252088305L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TestActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        public SetupActionAssertComponent getAssert() {
            if (this.assert_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestActionComponent.assert_");
                }
                if (Configuration.doAutoCreate()) {
                    this.assert_ = new SetupActionAssertComponent();
                }
            }
            return this.assert_;
        }

        public boolean hasAssert() {
            return this.assert_ != null && !this.assert_.isEmpty();
        }

        public TestActionComponent setAssert(SetupActionAssertComponent value) {
            this.assert_ = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("operation", "@TestScript.setup.action.operation", "An operation would involve a REST request to a server.", 0, Integer.MAX_VALUE, this.operation));
            childrenList.add(new Property("assert", "@TestScript.setup.action.assert", "Evaluates the results of previous operations to determine if the server under test behaves appropriately.", 0, Integer.MAX_VALUE, this.assert_));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
                case -1408208058: {
                    Base[] baseArray;
                    if (this.assert_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.assert_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    break;
                }
                case -1408208058: {
                    this.assert_ = (SetupActionAssertComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else if (name.equals("assert")) {
                this.assert_ = (SetupActionAssertComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
                case -1408208058: {
                    return this.getAssert();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            if (name.equals("assert")) {
                this.assert_ = new SetupActionAssertComponent();
                return this.assert_;
            }
            return super.addChild(name);
        }

        @Override
        public TestActionComponent copy() {
            TestActionComponent dst = new TestActionComponent();
            this.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            dst.assert_ = this.assert_ == null ? null : this.assert_.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestActionComponent)) {
                return false;
            }
            TestActionComponent o = (TestActionComponent)other;
            return TestActionComponent.compareDeep(this.operation, o.operation, true) && TestActionComponent.compareDeep(this.assert_, o.assert_, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestActionComponent)) {
                return false;
            }
            TestActionComponent o = (TestActionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.operation != null && !this.operation.isEmpty() || this.assert_ != null && !this.assert_.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.test.action";
        }
    }

    @Block
    public static class TestScriptTestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging name of this test", formalDefinition="The name of this test used for tracking/logging purposes by test engines.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting short description of the test", formalDefinition="A short description of the test used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="metadata", type={TestScriptMetadataComponent.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Capabilities  that are expected to function correctly on the FHIR server being tested", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        protected TestScriptMetadataComponent metadata;
        @Child(name="action", type={}, order=4, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A test operation or assert to perform", formalDefinition="Action would contain either an operation or an assertion.")
        protected List<TestActionComponent> action;
        private static final long serialVersionUID = -1607790780L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptTestComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptTestComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptTestComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptTestComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptTestComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptTestComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public TestScriptMetadataComponent getMetadata() {
            if (this.metadata == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptTestComponent.metadata");
                }
                if (Configuration.doAutoCreate()) {
                    this.metadata = new TestScriptMetadataComponent();
                }
            }
            return this.metadata;
        }

        public boolean hasMetadata() {
            return this.metadata != null && !this.metadata.isEmpty();
        }

        public TestScriptTestComponent setMetadata(TestScriptMetadataComponent value) {
            this.metadata = value;
            return this;
        }

        public List<TestActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            return this.action;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (TestActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestActionComponent addAction() {
            TestActionComponent t = new TestActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestScriptTestComponent addAction(TestActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<TestActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "The name of this test used for tracking/logging purposes by test engines.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(TestScript.SP_DESCRIPTION, "string", "A short description of the test used by test engines for tracking and reporting purposes.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("metadata", "@TestScript.metadata", "Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.", 0, Integer.MAX_VALUE, this.metadata));
            childrenList.add(new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -450004177: {
                    Base[] baseArray;
                    if (this.metadata == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.metadata;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -450004177: {
                    this.metadata = (TestScriptMetadataComponent)value;
                    break;
                }
                case -1422950858: {
                    this.getAction().add((TestActionComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("metadata")) {
                this.metadata = (TestScriptMetadataComponent)value;
            } else if (name.equals("action")) {
                this.getAction().add((TestActionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -450004177: {
                    return this.getMetadata();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
            }
            if (name.equals("metadata")) {
                this.metadata = new TestScriptMetadataComponent();
                return this.metadata;
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptTestComponent copy() {
            TestScriptTestComponent dst = new TestScriptTestComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            TestScriptMetadataComponent testScriptMetadataComponent = dst.metadata = this.metadata == null ? null : this.metadata.copy();
            if (this.action != null) {
                dst.action = new ArrayList<TestActionComponent>();
                for (TestActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptTestComponent)) {
                return false;
            }
            TestScriptTestComponent o = (TestScriptTestComponent)other;
            return TestScriptTestComponent.compareDeep(this.name, o.name, true) && TestScriptTestComponent.compareDeep(this.description, o.description, true) && TestScriptTestComponent.compareDeep(this.metadata, o.metadata, true) && TestScriptTestComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptTestComponent)) {
                return false;
            }
            TestScriptTestComponent o = (TestScriptTestComponent)other;
            return TestScriptTestComponent.compareValues(this.name, o.name, true) && TestScriptTestComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.metadata != null && !this.metadata.isEmpty() || this.action != null && !this.action.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.test";
        }
    }

    @Block
    public static class SetupActionAssertRulesetRuleParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter name matching external assert ruleset rule parameter", formalDefinition="Descriptive name for this parameter that matches the external assert ruleset rule parameter name.")
        protected StringType name;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter value defined either explicitly or dynamically", formalDefinition="The value for the parameter that will be passed on to the external ruleset rule template.")
        protected StringType value;
        private static final long serialVersionUID = 395259392L;

        public SetupActionAssertRulesetRuleParamComponent() {
        }

        public SetupActionAssertRulesetRuleParamComponent(StringType name, StringType value) {
            this.name = name;
            this.value = value;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRulesetRuleParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SetupActionAssertRulesetRuleParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SetupActionAssertRulesetRuleParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRulesetRuleParamComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SetupActionAssertRulesetRuleParamComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SetupActionAssertRulesetRuleParamComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "Descriptive name for this parameter that matches the external assert ruleset rule parameter name.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value", "string", "The value for the parameter that will be passed on to the external ruleset rule template.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.value");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertRulesetRuleParamComponent copy() {
            SetupActionAssertRulesetRuleParamComponent dst = new SetupActionAssertRulesetRuleParamComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRulesetRuleParamComponent)) {
                return false;
            }
            SetupActionAssertRulesetRuleParamComponent o = (SetupActionAssertRulesetRuleParamComponent)other;
            return SetupActionAssertRulesetRuleParamComponent.compareDeep(this.name, o.name, true) && SetupActionAssertRulesetRuleParamComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRulesetRuleParamComponent)) {
                return false;
            }
            SetupActionAssertRulesetRuleParamComponent o = (SetupActionAssertRulesetRuleParamComponent)other;
            return SetupActionAssertRulesetRuleParamComponent.compareValues(this.name, o.name, true) && SetupActionAssertRulesetRuleParamComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert.ruleset.rule.param";
        }
    }

    @Block
    public static class SetupActionAssertRulesetRuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="ruleId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of referenced rule within the ruleset", formalDefinition="Id of the referenced rule within the external ruleset template.")
        protected IdType ruleId;
        @Child(name="param", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rule parameter template", formalDefinition="Each rule template can take one or more parameters for rule evaluation.")
        protected List<SetupActionAssertRulesetRuleParamComponent> param;
        private static final long serialVersionUID = 52246314L;

        public SetupActionAssertRulesetRuleComponent() {
        }

        public SetupActionAssertRulesetRuleComponent(IdType ruleId) {
            this.ruleId = ruleId;
        }

        public IdType getRuleIdElement() {
            if (this.ruleId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRulesetRuleComponent.ruleId");
                }
                if (Configuration.doAutoCreate()) {
                    this.ruleId = new IdType();
                }
            }
            return this.ruleId;
        }

        public boolean hasRuleIdElement() {
            return this.ruleId != null && !this.ruleId.isEmpty();
        }

        public boolean hasRuleId() {
            return this.ruleId != null && !this.ruleId.isEmpty();
        }

        public SetupActionAssertRulesetRuleComponent setRuleIdElement(IdType value) {
            this.ruleId = value;
            return this;
        }

        public String getRuleId() {
            return this.ruleId == null ? null : this.ruleId.getValue();
        }

        public SetupActionAssertRulesetRuleComponent setRuleId(String value) {
            if (this.ruleId == null) {
                this.ruleId = new IdType();
            }
            this.ruleId.setValue(value);
            return this;
        }

        public List<SetupActionAssertRulesetRuleParamComponent> getParam() {
            if (this.param == null) {
                this.param = new ArrayList<SetupActionAssertRulesetRuleParamComponent>();
            }
            return this.param;
        }

        public boolean hasParam() {
            if (this.param == null) {
                return false;
            }
            for (SetupActionAssertRulesetRuleParamComponent item : this.param) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionAssertRulesetRuleParamComponent addParam() {
            SetupActionAssertRulesetRuleParamComponent t = new SetupActionAssertRulesetRuleParamComponent();
            if (this.param == null) {
                this.param = new ArrayList<SetupActionAssertRulesetRuleParamComponent>();
            }
            this.param.add(t);
            return t;
        }

        public SetupActionAssertRulesetRuleComponent addParam(SetupActionAssertRulesetRuleParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.param == null) {
                this.param = new ArrayList<SetupActionAssertRulesetRuleParamComponent>();
            }
            this.param.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("ruleId", "id", "Id of the referenced rule within the external ruleset template.", 0, Integer.MAX_VALUE, this.ruleId));
            childrenList.add(new Property("param", "", "Each rule template can take one or more parameters for rule evaluation.", 0, Integer.MAX_VALUE, this.param));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    Base[] baseArray;
                    if (this.ruleId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.ruleId;
                    }
                    return baseArray;
                }
                case 106436749: {
                    return this.param == null ? new Base[]{} : this.param.toArray(new Base[this.param.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    this.ruleId = this.castToId(value);
                    break;
                }
                case 106436749: {
                    this.getParam().add((SetupActionAssertRulesetRuleParamComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("ruleId")) {
                this.ruleId = this.castToId(value);
            } else if (name.equals("param")) {
                this.getParam().add((SetupActionAssertRulesetRuleParamComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    throw new FHIRException("Cannot make property ruleId as it is not a complex type");
                }
                case 106436749: {
                    return this.addParam();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("ruleId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.ruleId");
            }
            if (name.equals("param")) {
                return this.addParam();
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertRulesetRuleComponent copy() {
            SetupActionAssertRulesetRuleComponent dst = new SetupActionAssertRulesetRuleComponent();
            this.copyValues(dst);
            IdType idType = dst.ruleId = this.ruleId == null ? null : this.ruleId.copy();
            if (this.param != null) {
                dst.param = new ArrayList<SetupActionAssertRulesetRuleParamComponent>();
                for (SetupActionAssertRulesetRuleParamComponent i : this.param) {
                    dst.param.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRulesetRuleComponent)) {
                return false;
            }
            SetupActionAssertRulesetRuleComponent o = (SetupActionAssertRulesetRuleComponent)other;
            return SetupActionAssertRulesetRuleComponent.compareDeep(this.ruleId, o.ruleId, true) && SetupActionAssertRulesetRuleComponent.compareDeep(this.param, o.param, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRulesetRuleComponent)) {
                return false;
            }
            SetupActionAssertRulesetRuleComponent o = (SetupActionAssertRulesetRuleComponent)other;
            return SetupActionAssertRulesetRuleComponent.compareValues(this.ruleId, o.ruleId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.ruleId != null && !this.ruleId.isEmpty() || this.param != null && !this.param.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert.ruleset.rule";
        }
    }

    @Block
    public static class SetupActionAssertRulesetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="rulesetId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of the TestScript.ruleset", formalDefinition="The TestScript.ruleset id value this assert will evaluate.")
        protected IdType rulesetId;
        @Child(name="rule", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The referenced rule within the ruleset", formalDefinition="The referenced rule within the external ruleset template.")
        protected List<SetupActionAssertRulesetRuleComponent> rule;
        private static final long serialVersionUID = 2070600738L;

        public SetupActionAssertRulesetComponent() {
        }

        public SetupActionAssertRulesetComponent(IdType rulesetId) {
            this.rulesetId = rulesetId;
        }

        public IdType getRulesetIdElement() {
            if (this.rulesetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRulesetComponent.rulesetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.rulesetId = new IdType();
                }
            }
            return this.rulesetId;
        }

        public boolean hasRulesetIdElement() {
            return this.rulesetId != null && !this.rulesetId.isEmpty();
        }

        public boolean hasRulesetId() {
            return this.rulesetId != null && !this.rulesetId.isEmpty();
        }

        public SetupActionAssertRulesetComponent setRulesetIdElement(IdType value) {
            this.rulesetId = value;
            return this;
        }

        public String getRulesetId() {
            return this.rulesetId == null ? null : this.rulesetId.getValue();
        }

        public SetupActionAssertRulesetComponent setRulesetId(String value) {
            if (this.rulesetId == null) {
                this.rulesetId = new IdType();
            }
            this.rulesetId.setValue(value);
            return this;
        }

        public List<SetupActionAssertRulesetRuleComponent> getRule() {
            if (this.rule == null) {
                this.rule = new ArrayList<SetupActionAssertRulesetRuleComponent>();
            }
            return this.rule;
        }

        public boolean hasRule() {
            if (this.rule == null) {
                return false;
            }
            for (SetupActionAssertRulesetRuleComponent item : this.rule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionAssertRulesetRuleComponent addRule() {
            SetupActionAssertRulesetRuleComponent t = new SetupActionAssertRulesetRuleComponent();
            if (this.rule == null) {
                this.rule = new ArrayList<SetupActionAssertRulesetRuleComponent>();
            }
            this.rule.add(t);
            return t;
        }

        public SetupActionAssertRulesetComponent addRule(SetupActionAssertRulesetRuleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.rule == null) {
                this.rule = new ArrayList<SetupActionAssertRulesetRuleComponent>();
            }
            this.rule.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("rulesetId", "id", "The TestScript.ruleset id value this assert will evaluate.", 0, Integer.MAX_VALUE, this.rulesetId));
            childrenList.add(new Property("rule", "", "The referenced rule within the external ruleset template.", 0, Integer.MAX_VALUE, this.rule));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -2073977951: {
                    Base[] baseArray;
                    if (this.rulesetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.rulesetId;
                    }
                    return baseArray;
                }
                case 3512060: {
                    return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -2073977951: {
                    this.rulesetId = this.castToId(value);
                    break;
                }
                case 3512060: {
                    this.getRule().add((SetupActionAssertRulesetRuleComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("rulesetId")) {
                this.rulesetId = this.castToId(value);
            } else if (name.equals("rule")) {
                this.getRule().add((SetupActionAssertRulesetRuleComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2073977951: {
                    throw new FHIRException("Cannot make property rulesetId as it is not a complex type");
                }
                case 3512060: {
                    return this.addRule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("rulesetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.rulesetId");
            }
            if (name.equals("rule")) {
                return this.addRule();
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertRulesetComponent copy() {
            SetupActionAssertRulesetComponent dst = new SetupActionAssertRulesetComponent();
            this.copyValues(dst);
            IdType idType = dst.rulesetId = this.rulesetId == null ? null : this.rulesetId.copy();
            if (this.rule != null) {
                dst.rule = new ArrayList<SetupActionAssertRulesetRuleComponent>();
                for (SetupActionAssertRulesetRuleComponent i : this.rule) {
                    dst.rule.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRulesetComponent)) {
                return false;
            }
            SetupActionAssertRulesetComponent o = (SetupActionAssertRulesetComponent)other;
            return SetupActionAssertRulesetComponent.compareDeep(this.rulesetId, o.rulesetId, true) && SetupActionAssertRulesetComponent.compareDeep(this.rule, o.rule, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRulesetComponent)) {
                return false;
            }
            SetupActionAssertRulesetComponent o = (SetupActionAssertRulesetComponent)other;
            return SetupActionAssertRulesetComponent.compareValues(this.rulesetId, o.rulesetId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.rulesetId != null && !this.rulesetId.isEmpty() || this.rule != null && !this.rule.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert.ruleset";
        }
    }

    @Block
    public static class SetupActionAssertRuleParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter name matching external assert rule parameter", formalDefinition="Descriptive name for this parameter that matches the external assert rule parameter name.")
        protected StringType name;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter value defined either explicitly or dynamically", formalDefinition="The value for the parameter that will be passed on to the external rule template.")
        protected StringType value;
        private static final long serialVersionUID = 395259392L;

        public SetupActionAssertRuleParamComponent() {
        }

        public SetupActionAssertRuleParamComponent(StringType name, StringType value) {
            this.name = name;
            this.value = value;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRuleParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SetupActionAssertRuleParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SetupActionAssertRuleParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRuleParamComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SetupActionAssertRuleParamComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SetupActionAssertRuleParamComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "Descriptive name for this parameter that matches the external assert rule parameter name.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value", "string", "The value for the parameter that will be passed on to the external rule template.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.value");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertRuleParamComponent copy() {
            SetupActionAssertRuleParamComponent dst = new SetupActionAssertRuleParamComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRuleParamComponent)) {
                return false;
            }
            SetupActionAssertRuleParamComponent o = (SetupActionAssertRuleParamComponent)other;
            return SetupActionAssertRuleParamComponent.compareDeep(this.name, o.name, true) && SetupActionAssertRuleParamComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRuleParamComponent)) {
                return false;
            }
            SetupActionAssertRuleParamComponent o = (SetupActionAssertRuleParamComponent)other;
            return SetupActionAssertRuleParamComponent.compareValues(this.name, o.name, true) && SetupActionAssertRuleParamComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert.rule.param";
        }
    }

    @Block
    public static class SetupActionAssertRuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="ruleId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of the TestScript.rule", formalDefinition="The TestScript.rule id value this assert will evaluate.")
        protected IdType ruleId;
        @Child(name="param", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rule parameter template", formalDefinition="Each rule template can take one or more parameters for rule evaluation.")
        protected List<SetupActionAssertRuleParamComponent> param;
        private static final long serialVersionUID = -319928210L;

        public SetupActionAssertRuleComponent() {
        }

        public SetupActionAssertRuleComponent(IdType ruleId) {
            this.ruleId = ruleId;
        }

        public IdType getRuleIdElement() {
            if (this.ruleId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertRuleComponent.ruleId");
                }
                if (Configuration.doAutoCreate()) {
                    this.ruleId = new IdType();
                }
            }
            return this.ruleId;
        }

        public boolean hasRuleIdElement() {
            return this.ruleId != null && !this.ruleId.isEmpty();
        }

        public boolean hasRuleId() {
            return this.ruleId != null && !this.ruleId.isEmpty();
        }

        public SetupActionAssertRuleComponent setRuleIdElement(IdType value) {
            this.ruleId = value;
            return this;
        }

        public String getRuleId() {
            return this.ruleId == null ? null : this.ruleId.getValue();
        }

        public SetupActionAssertRuleComponent setRuleId(String value) {
            if (this.ruleId == null) {
                this.ruleId = new IdType();
            }
            this.ruleId.setValue(value);
            return this;
        }

        public List<SetupActionAssertRuleParamComponent> getParam() {
            if (this.param == null) {
                this.param = new ArrayList<SetupActionAssertRuleParamComponent>();
            }
            return this.param;
        }

        public boolean hasParam() {
            if (this.param == null) {
                return false;
            }
            for (SetupActionAssertRuleParamComponent item : this.param) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionAssertRuleParamComponent addParam() {
            SetupActionAssertRuleParamComponent t = new SetupActionAssertRuleParamComponent();
            if (this.param == null) {
                this.param = new ArrayList<SetupActionAssertRuleParamComponent>();
            }
            this.param.add(t);
            return t;
        }

        public SetupActionAssertRuleComponent addParam(SetupActionAssertRuleParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.param == null) {
                this.param = new ArrayList<SetupActionAssertRuleParamComponent>();
            }
            this.param.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("ruleId", "id", "The TestScript.rule id value this assert will evaluate.", 0, Integer.MAX_VALUE, this.ruleId));
            childrenList.add(new Property("param", "", "Each rule template can take one or more parameters for rule evaluation.", 0, Integer.MAX_VALUE, this.param));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    Base[] baseArray;
                    if (this.ruleId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.ruleId;
                    }
                    return baseArray;
                }
                case 106436749: {
                    return this.param == null ? new Base[]{} : this.param.toArray(new Base[this.param.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    this.ruleId = this.castToId(value);
                    break;
                }
                case 106436749: {
                    this.getParam().add((SetupActionAssertRuleParamComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("ruleId")) {
                this.ruleId = this.castToId(value);
            } else if (name.equals("param")) {
                this.getParam().add((SetupActionAssertRuleParamComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    throw new FHIRException("Cannot make property ruleId as it is not a complex type");
                }
                case 106436749: {
                    return this.addParam();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("ruleId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.ruleId");
            }
            if (name.equals("param")) {
                return this.addParam();
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertRuleComponent copy() {
            SetupActionAssertRuleComponent dst = new SetupActionAssertRuleComponent();
            this.copyValues(dst);
            IdType idType = dst.ruleId = this.ruleId == null ? null : this.ruleId.copy();
            if (this.param != null) {
                dst.param = new ArrayList<SetupActionAssertRuleParamComponent>();
                for (SetupActionAssertRuleParamComponent i : this.param) {
                    dst.param.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRuleComponent)) {
                return false;
            }
            SetupActionAssertRuleComponent o = (SetupActionAssertRuleComponent)other;
            return SetupActionAssertRuleComponent.compareDeep(this.ruleId, o.ruleId, true) && SetupActionAssertRuleComponent.compareDeep(this.param, o.param, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertRuleComponent)) {
                return false;
            }
            SetupActionAssertRuleComponent o = (SetupActionAssertRuleComponent)other;
            return SetupActionAssertRuleComponent.compareValues(this.ruleId, o.ruleId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.ruleId != null && !this.ruleId.isEmpty() || this.param != null && !this.param.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert.rule";
        }
    }

    @Block
    public static class SetupActionAssertComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="label", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging assertion label", formalDefinition="The label would be used for tracking/logging purposes by test engines.")
        protected StringType label;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting assertion description", formalDefinition="The description would be used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="direction", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="response | request", formalDefinition="The direction to use for the assertion.")
        protected Enumeration<AssertionDirectionType> direction;
        @Child(name="compareToSourceId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of fixture used to compare the \"sourceId/path\" evaluations to", formalDefinition="Id of fixture used to compare the \"sourceId/path\" evaluations to.")
        protected StringType compareToSourceId;
        @Child(name="compareToSourcePath", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="XPath or JSONPath expression against fixture used to compare the \"sourceId/path\" evaluations to", formalDefinition="XPath or JSONPath expression against fixture used to compare the \"sourceId/path\" evaluations to.")
        protected StringType compareToSourcePath;
        @Child(name="contentType", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="xml | json", formalDefinition="The content-type or mime-type to use for RESTful operation in the 'Content-Type' header.")
        protected Enumeration<ContentType> contentType;
        @Child(name="headerField", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP header field name", formalDefinition="The HTTP header field name e.g. 'Location'.")
        protected StringType headerField;
        @Child(name="minimumId", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of minimum content resource", formalDefinition="The ID of a fixture.  Asserts that the response contains at a minimum the fixture specified by minimumId.")
        protected StringType minimumId;
        @Child(name="navigationLinks", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Perform validation on navigation links?", formalDefinition="Whether or not the test execution performs validation on the bundle navigation links.")
        protected BooleanType navigationLinks;
        @Child(name="operator", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="equals | notEquals | in | notIn | greaterThan | lessThan | empty | notEmpty | contains | notContains", formalDefinition="The operator type.")
        protected Enumeration<AssertionOperatorType> operator;
        @Child(name="path", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="XPath or JSONPath expression", formalDefinition="The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.")
        protected StringType path;
        @Child(name="resource", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource type", formalDefinition="The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.")
        protected CodeType resource;
        @Child(name="response", type={CodeType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable", formalDefinition="okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.")
        protected Enumeration<AssertionResponseTypes> response;
        @Child(name="responseCode", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP response code to test", formalDefinition="The value of the HTTP response code to be tested.")
        protected StringType responseCode;
        @Child(name="rule", type={}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The reference to a TestScript.rule", formalDefinition="The TestScript.rule this assert will evaluate.")
        protected SetupActionAssertRuleComponent rule;
        @Child(name="ruleset", type={}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The reference to a TestScript.ruleset", formalDefinition="The TestScript.ruleset this assert will evaluate.")
        protected SetupActionAssertRulesetComponent ruleset;
        @Child(name="sourceId", type={IdType.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of source expression or headerField", formalDefinition="Fixture to evaluate the XPath/JSONPath expression or the headerField  against.")
        protected IdType sourceId;
        @Child(name="validateProfileId", type={IdType.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile Id of validation profile reference", formalDefinition="The ID of the Profile to validate against.")
        protected IdType validateProfileId;
        @Child(name="value", type={StringType.class}, order=19, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The value to compare to", formalDefinition="The value to compare to.")
        protected StringType value;
        @Child(name="warningOnly", type={BooleanType.class}, order=20, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Will this assert produce a warning only on error?", formalDefinition="Whether or not the test execution will produce a warning only on error for this assert.")
        protected BooleanType warningOnly;
        private static final long serialVersionUID = -561290310L;

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public SetupActionAssertComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public SetupActionAssertComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SetupActionAssertComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SetupActionAssertComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<AssertionDirectionType> getDirectionElement() {
            if (this.direction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.direction");
                }
                if (Configuration.doAutoCreate()) {
                    this.direction = new Enumeration<AssertionDirectionType>(new AssertionDirectionTypeEnumFactory());
                }
            }
            return this.direction;
        }

        public boolean hasDirectionElement() {
            return this.direction != null && !this.direction.isEmpty();
        }

        public boolean hasDirection() {
            return this.direction != null && !this.direction.isEmpty();
        }

        public SetupActionAssertComponent setDirectionElement(Enumeration<AssertionDirectionType> value) {
            this.direction = value;
            return this;
        }

        public AssertionDirectionType getDirection() {
            return this.direction == null ? null : (AssertionDirectionType)((Object)this.direction.getValue());
        }

        public SetupActionAssertComponent setDirection(AssertionDirectionType value) {
            if (value == null) {
                this.direction = null;
            } else {
                if (this.direction == null) {
                    this.direction = new Enumeration<AssertionDirectionType>(new AssertionDirectionTypeEnumFactory());
                }
                this.direction.setValue((Object)value);
            }
            return this;
        }

        public StringType getCompareToSourceIdElement() {
            if (this.compareToSourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.compareToSourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.compareToSourceId = new StringType();
                }
            }
            return this.compareToSourceId;
        }

        public boolean hasCompareToSourceIdElement() {
            return this.compareToSourceId != null && !this.compareToSourceId.isEmpty();
        }

        public boolean hasCompareToSourceId() {
            return this.compareToSourceId != null && !this.compareToSourceId.isEmpty();
        }

        public SetupActionAssertComponent setCompareToSourceIdElement(StringType value) {
            this.compareToSourceId = value;
            return this;
        }

        public String getCompareToSourceId() {
            return this.compareToSourceId == null ? null : (String)this.compareToSourceId.getValue();
        }

        public SetupActionAssertComponent setCompareToSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.compareToSourceId = null;
            } else {
                if (this.compareToSourceId == null) {
                    this.compareToSourceId = new StringType();
                }
                this.compareToSourceId.setValue(value);
            }
            return this;
        }

        public StringType getCompareToSourcePathElement() {
            if (this.compareToSourcePath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.compareToSourcePath");
                }
                if (Configuration.doAutoCreate()) {
                    this.compareToSourcePath = new StringType();
                }
            }
            return this.compareToSourcePath;
        }

        public boolean hasCompareToSourcePathElement() {
            return this.compareToSourcePath != null && !this.compareToSourcePath.isEmpty();
        }

        public boolean hasCompareToSourcePath() {
            return this.compareToSourcePath != null && !this.compareToSourcePath.isEmpty();
        }

        public SetupActionAssertComponent setCompareToSourcePathElement(StringType value) {
            this.compareToSourcePath = value;
            return this;
        }

        public String getCompareToSourcePath() {
            return this.compareToSourcePath == null ? null : (String)this.compareToSourcePath.getValue();
        }

        public SetupActionAssertComponent setCompareToSourcePath(String value) {
            if (Utilities.noString((String)value)) {
                this.compareToSourcePath = null;
            } else {
                if (this.compareToSourcePath == null) {
                    this.compareToSourcePath = new StringType();
                }
                this.compareToSourcePath.setValue(value);
            }
            return this;
        }

        public Enumeration<ContentType> getContentTypeElement() {
            if (this.contentType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.contentType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contentType = new Enumeration<ContentType>(new ContentTypeEnumFactory());
                }
            }
            return this.contentType;
        }

        public boolean hasContentTypeElement() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public boolean hasContentType() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public SetupActionAssertComponent setContentTypeElement(Enumeration<ContentType> value) {
            this.contentType = value;
            return this;
        }

        public ContentType getContentType() {
            return this.contentType == null ? null : (ContentType)((Object)this.contentType.getValue());
        }

        public SetupActionAssertComponent setContentType(ContentType value) {
            if (value == null) {
                this.contentType = null;
            } else {
                if (this.contentType == null) {
                    this.contentType = new Enumeration<ContentType>(new ContentTypeEnumFactory());
                }
                this.contentType.setValue((Object)value);
            }
            return this;
        }

        public StringType getHeaderFieldElement() {
            if (this.headerField == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.headerField");
                }
                if (Configuration.doAutoCreate()) {
                    this.headerField = new StringType();
                }
            }
            return this.headerField;
        }

        public boolean hasHeaderFieldElement() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public boolean hasHeaderField() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public SetupActionAssertComponent setHeaderFieldElement(StringType value) {
            this.headerField = value;
            return this;
        }

        public String getHeaderField() {
            return this.headerField == null ? null : (String)this.headerField.getValue();
        }

        public SetupActionAssertComponent setHeaderField(String value) {
            if (Utilities.noString((String)value)) {
                this.headerField = null;
            } else {
                if (this.headerField == null) {
                    this.headerField = new StringType();
                }
                this.headerField.setValue(value);
            }
            return this;
        }

        public StringType getMinimumIdElement() {
            if (this.minimumId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.minimumId");
                }
                if (Configuration.doAutoCreate()) {
                    this.minimumId = new StringType();
                }
            }
            return this.minimumId;
        }

        public boolean hasMinimumIdElement() {
            return this.minimumId != null && !this.minimumId.isEmpty();
        }

        public boolean hasMinimumId() {
            return this.minimumId != null && !this.minimumId.isEmpty();
        }

        public SetupActionAssertComponent setMinimumIdElement(StringType value) {
            this.minimumId = value;
            return this;
        }

        public String getMinimumId() {
            return this.minimumId == null ? null : (String)this.minimumId.getValue();
        }

        public SetupActionAssertComponent setMinimumId(String value) {
            if (Utilities.noString((String)value)) {
                this.minimumId = null;
            } else {
                if (this.minimumId == null) {
                    this.minimumId = new StringType();
                }
                this.minimumId.setValue(value);
            }
            return this;
        }

        public BooleanType getNavigationLinksElement() {
            if (this.navigationLinks == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.navigationLinks");
                }
                if (Configuration.doAutoCreate()) {
                    this.navigationLinks = new BooleanType();
                }
            }
            return this.navigationLinks;
        }

        public boolean hasNavigationLinksElement() {
            return this.navigationLinks != null && !this.navigationLinks.isEmpty();
        }

        public boolean hasNavigationLinks() {
            return this.navigationLinks != null && !this.navigationLinks.isEmpty();
        }

        public SetupActionAssertComponent setNavigationLinksElement(BooleanType value) {
            this.navigationLinks = value;
            return this;
        }

        public boolean getNavigationLinks() {
            return this.navigationLinks == null || this.navigationLinks.isEmpty() ? false : (Boolean)this.navigationLinks.getValue();
        }

        public SetupActionAssertComponent setNavigationLinks(boolean value) {
            if (this.navigationLinks == null) {
                this.navigationLinks = new BooleanType();
            }
            this.navigationLinks.setValue((Object)value);
            return this;
        }

        public Enumeration<AssertionOperatorType> getOperatorElement() {
            if (this.operator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.operator");
                }
                if (Configuration.doAutoCreate()) {
                    this.operator = new Enumeration<AssertionOperatorType>(new AssertionOperatorTypeEnumFactory());
                }
            }
            return this.operator;
        }

        public boolean hasOperatorElement() {
            return this.operator != null && !this.operator.isEmpty();
        }

        public boolean hasOperator() {
            return this.operator != null && !this.operator.isEmpty();
        }

        public SetupActionAssertComponent setOperatorElement(Enumeration<AssertionOperatorType> value) {
            this.operator = value;
            return this;
        }

        public AssertionOperatorType getOperator() {
            return this.operator == null ? null : (AssertionOperatorType)((Object)this.operator.getValue());
        }

        public SetupActionAssertComponent setOperator(AssertionOperatorType value) {
            if (value == null) {
                this.operator = null;
            } else {
                if (this.operator == null) {
                    this.operator = new Enumeration<AssertionOperatorType>(new AssertionOperatorTypeEnumFactory());
                }
                this.operator.setValue((Object)value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public SetupActionAssertComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public SetupActionAssertComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public CodeType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new CodeType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SetupActionAssertComponent setResourceElement(CodeType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SetupActionAssertComponent setResource(String value) {
            if (Utilities.noString((String)value)) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new CodeType();
                }
                this.resource.setValue(value);
            }
            return this;
        }

        public Enumeration<AssertionResponseTypes> getResponseElement() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new Enumeration<AssertionResponseTypes>(new AssertionResponseTypesEnumFactory());
                }
            }
            return this.response;
        }

        public boolean hasResponseElement() {
            return this.response != null && !this.response.isEmpty();
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public SetupActionAssertComponent setResponseElement(Enumeration<AssertionResponseTypes> value) {
            this.response = value;
            return this;
        }

        public AssertionResponseTypes getResponse() {
            return this.response == null ? null : (AssertionResponseTypes)((Object)this.response.getValue());
        }

        public SetupActionAssertComponent setResponse(AssertionResponseTypes value) {
            if (value == null) {
                this.response = null;
            } else {
                if (this.response == null) {
                    this.response = new Enumeration<AssertionResponseTypes>(new AssertionResponseTypesEnumFactory());
                }
                this.response.setValue((Object)value);
            }
            return this;
        }

        public StringType getResponseCodeElement() {
            if (this.responseCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.responseCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.responseCode = new StringType();
                }
            }
            return this.responseCode;
        }

        public boolean hasResponseCodeElement() {
            return this.responseCode != null && !this.responseCode.isEmpty();
        }

        public boolean hasResponseCode() {
            return this.responseCode != null && !this.responseCode.isEmpty();
        }

        public SetupActionAssertComponent setResponseCodeElement(StringType value) {
            this.responseCode = value;
            return this;
        }

        public String getResponseCode() {
            return this.responseCode == null ? null : (String)this.responseCode.getValue();
        }

        public SetupActionAssertComponent setResponseCode(String value) {
            if (Utilities.noString((String)value)) {
                this.responseCode = null;
            } else {
                if (this.responseCode == null) {
                    this.responseCode = new StringType();
                }
                this.responseCode.setValue(value);
            }
            return this;
        }

        public SetupActionAssertRuleComponent getRule() {
            if (this.rule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.rule");
                }
                if (Configuration.doAutoCreate()) {
                    this.rule = new SetupActionAssertRuleComponent();
                }
            }
            return this.rule;
        }

        public boolean hasRule() {
            return this.rule != null && !this.rule.isEmpty();
        }

        public SetupActionAssertComponent setRule(SetupActionAssertRuleComponent value) {
            this.rule = value;
            return this;
        }

        public SetupActionAssertRulesetComponent getRuleset() {
            if (this.ruleset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.ruleset");
                }
                if (Configuration.doAutoCreate()) {
                    this.ruleset = new SetupActionAssertRulesetComponent();
                }
            }
            return this.ruleset;
        }

        public boolean hasRuleset() {
            return this.ruleset != null && !this.ruleset.isEmpty();
        }

        public SetupActionAssertComponent setRuleset(SetupActionAssertRulesetComponent value) {
            this.ruleset = value;
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public SetupActionAssertComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public SetupActionAssertComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new IdType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        public IdType getValidateProfileIdElement() {
            if (this.validateProfileId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.validateProfileId");
                }
                if (Configuration.doAutoCreate()) {
                    this.validateProfileId = new IdType();
                }
            }
            return this.validateProfileId;
        }

        public boolean hasValidateProfileIdElement() {
            return this.validateProfileId != null && !this.validateProfileId.isEmpty();
        }

        public boolean hasValidateProfileId() {
            return this.validateProfileId != null && !this.validateProfileId.isEmpty();
        }

        public SetupActionAssertComponent setValidateProfileIdElement(IdType value) {
            this.validateProfileId = value;
            return this;
        }

        public String getValidateProfileId() {
            return this.validateProfileId == null ? null : this.validateProfileId.getValue();
        }

        public SetupActionAssertComponent setValidateProfileId(String value) {
            if (Utilities.noString((String)value)) {
                this.validateProfileId = null;
            } else {
                if (this.validateProfileId == null) {
                    this.validateProfileId = new IdType();
                }
                this.validateProfileId.setValue(value);
            }
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SetupActionAssertComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SetupActionAssertComponent setValue(String value) {
            if (Utilities.noString((String)value)) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public BooleanType getWarningOnlyElement() {
            if (this.warningOnly == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionAssertComponent.warningOnly");
                }
                if (Configuration.doAutoCreate()) {
                    this.warningOnly = new BooleanType();
                }
            }
            return this.warningOnly;
        }

        public boolean hasWarningOnlyElement() {
            return this.warningOnly != null && !this.warningOnly.isEmpty();
        }

        public boolean hasWarningOnly() {
            return this.warningOnly != null && !this.warningOnly.isEmpty();
        }

        public SetupActionAssertComponent setWarningOnlyElement(BooleanType value) {
            this.warningOnly = value;
            return this;
        }

        public boolean getWarningOnly() {
            return this.warningOnly == null || this.warningOnly.isEmpty() ? false : (Boolean)this.warningOnly.getValue();
        }

        public SetupActionAssertComponent setWarningOnly(boolean value) {
            if (this.warningOnly == null) {
                this.warningOnly = new BooleanType();
            }
            this.warningOnly.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("label", "string", "The label would be used for tracking/logging purposes by test engines.", 0, Integer.MAX_VALUE, this.label));
            childrenList.add(new Property(TestScript.SP_DESCRIPTION, "string", "The description would be used by test engines for tracking and reporting purposes.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("direction", "code", "The direction to use for the assertion.", 0, Integer.MAX_VALUE, this.direction));
            childrenList.add(new Property("compareToSourceId", "string", "Id of fixture used to compare the \"sourceId/path\" evaluations to.", 0, Integer.MAX_VALUE, this.compareToSourceId));
            childrenList.add(new Property("compareToSourcePath", "string", "XPath or JSONPath expression against fixture used to compare the \"sourceId/path\" evaluations to.", 0, Integer.MAX_VALUE, this.compareToSourcePath));
            childrenList.add(new Property("contentType", "code", "The content-type or mime-type to use for RESTful operation in the 'Content-Type' header.", 0, Integer.MAX_VALUE, this.contentType));
            childrenList.add(new Property("headerField", "string", "The HTTP header field name e.g. 'Location'.", 0, Integer.MAX_VALUE, this.headerField));
            childrenList.add(new Property("minimumId", "string", "The ID of a fixture.  Asserts that the response contains at a minimum the fixture specified by minimumId.", 0, Integer.MAX_VALUE, this.minimumId));
            childrenList.add(new Property("navigationLinks", "boolean", "Whether or not the test execution performs validation on the bundle navigation links.", 0, Integer.MAX_VALUE, this.navigationLinks));
            childrenList.add(new Property("operator", "code", "The operator type.", 0, Integer.MAX_VALUE, this.operator));
            childrenList.add(new Property("path", "string", "The XPath or JSONPath expression to be evaluated against the fixture representing the response received from server.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("resource", "code", "The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("response", "code", "okay | created | noContent | notModified | bad | forbidden | notFound | methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.", 0, Integer.MAX_VALUE, this.response));
            childrenList.add(new Property("responseCode", "string", "The value of the HTTP response code to be tested.", 0, Integer.MAX_VALUE, this.responseCode));
            childrenList.add(new Property("rule", "", "The TestScript.rule this assert will evaluate.", 0, Integer.MAX_VALUE, this.rule));
            childrenList.add(new Property("ruleset", "", "The TestScript.ruleset this assert will evaluate.", 0, Integer.MAX_VALUE, this.ruleset));
            childrenList.add(new Property("sourceId", "id", "Fixture to evaluate the XPath/JSONPath expression or the headerField  against.", 0, Integer.MAX_VALUE, this.sourceId));
            childrenList.add(new Property("validateProfileId", "id", "The ID of the Profile to validate against.", 0, Integer.MAX_VALUE, this.validateProfileId));
            childrenList.add(new Property("value", "string", "The value to compare to.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("warningOnly", "boolean", "Whether or not the test execution will produce a warning only on error for this assert.", 0, Integer.MAX_VALUE, this.warningOnly));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -962590849: {
                    Base[] baseArray;
                    if (this.direction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.direction;
                    }
                    return baseArray;
                }
                case 2081856758: {
                    Base[] baseArray;
                    if (this.compareToSourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.compareToSourceId;
                    }
                    return baseArray;
                }
                case -790206144: {
                    Base[] baseArray;
                    if (this.compareToSourcePath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.compareToSourcePath;
                    }
                    return baseArray;
                }
                case -389131437: {
                    Base[] baseArray;
                    if (this.contentType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.contentType;
                    }
                    return baseArray;
                }
                case 1160732269: {
                    Base[] baseArray;
                    if (this.headerField == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.headerField;
                    }
                    return baseArray;
                }
                case 818925001: {
                    Base[] baseArray;
                    if (this.minimumId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.minimumId;
                    }
                    return baseArray;
                }
                case 1001488901: {
                    Base[] baseArray;
                    if (this.navigationLinks == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.navigationLinks;
                    }
                    return baseArray;
                }
                case -500553564: {
                    Base[] baseArray;
                    if (this.operator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.operator;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.path;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.resource;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.response;
                    }
                    return baseArray;
                }
                case 1438723534: {
                    Base[] baseArray;
                    if (this.responseCode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.responseCode;
                    }
                    return baseArray;
                }
                case 3512060: {
                    Base[] baseArray;
                    if (this.rule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.rule;
                    }
                    return baseArray;
                }
                case 1548678118: {
                    Base[] baseArray;
                    if (this.ruleset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray17 = new Base[1];
                        baseArray = baseArray17;
                        baseArray17[0] = this.ruleset;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray18 = new Base[1];
                        baseArray = baseArray18;
                        baseArray18[0] = this.sourceId;
                    }
                    return baseArray;
                }
                case 1555541038: {
                    Base[] baseArray;
                    if (this.validateProfileId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray19 = new Base[1];
                        baseArray = baseArray19;
                        baseArray19[0] = this.validateProfileId;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray20 = new Base[1];
                        baseArray = baseArray20;
                        baseArray20[0] = this.value;
                    }
                    return baseArray;
                }
                case -481159832: {
                    Base[] baseArray;
                    if (this.warningOnly == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray21 = new Base[1];
                        baseArray = baseArray21;
                        baseArray21[0] = this.warningOnly;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -962590849: {
                    this.direction = new AssertionDirectionTypeEnumFactory().fromType(value);
                    break;
                }
                case 2081856758: {
                    this.compareToSourceId = this.castToString(value);
                    break;
                }
                case -790206144: {
                    this.compareToSourcePath = this.castToString(value);
                    break;
                }
                case -389131437: {
                    this.contentType = new ContentTypeEnumFactory().fromType(value);
                    break;
                }
                case 1160732269: {
                    this.headerField = this.castToString(value);
                    break;
                }
                case 818925001: {
                    this.minimumId = this.castToString(value);
                    break;
                }
                case 1001488901: {
                    this.navigationLinks = this.castToBoolean(value);
                    break;
                }
                case -500553564: {
                    this.operator = new AssertionOperatorTypeEnumFactory().fromType(value);
                    break;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToCode(value);
                    break;
                }
                case -340323263: {
                    this.response = new AssertionResponseTypesEnumFactory().fromType(value);
                    break;
                }
                case 1438723534: {
                    this.responseCode = this.castToString(value);
                    break;
                }
                case 3512060: {
                    this.rule = (SetupActionAssertRuleComponent)value;
                    break;
                }
                case 1548678118: {
                    this.ruleset = (SetupActionAssertRulesetComponent)value;
                    break;
                }
                case 1746327190: {
                    this.sourceId = this.castToId(value);
                    break;
                }
                case 1555541038: {
                    this.validateProfileId = this.castToId(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                case -481159832: {
                    this.warningOnly = this.castToBoolean(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = this.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("direction")) {
                this.direction = new AssertionDirectionTypeEnumFactory().fromType(value);
            } else if (name.equals("compareToSourceId")) {
                this.compareToSourceId = this.castToString(value);
            } else if (name.equals("compareToSourcePath")) {
                this.compareToSourcePath = this.castToString(value);
            } else if (name.equals("contentType")) {
                this.contentType = new ContentTypeEnumFactory().fromType(value);
            } else if (name.equals("headerField")) {
                this.headerField = this.castToString(value);
            } else if (name.equals("minimumId")) {
                this.minimumId = this.castToString(value);
            } else if (name.equals("navigationLinks")) {
                this.navigationLinks = this.castToBoolean(value);
            } else if (name.equals("operator")) {
                this.operator = new AssertionOperatorTypeEnumFactory().fromType(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToCode(value);
            } else if (name.equals("response")) {
                this.response = new AssertionResponseTypesEnumFactory().fromType(value);
            } else if (name.equals("responseCode")) {
                this.responseCode = this.castToString(value);
            } else if (name.equals("rule")) {
                this.rule = (SetupActionAssertRuleComponent)value;
            } else if (name.equals("ruleset")) {
                this.ruleset = (SetupActionAssertRulesetComponent)value;
            } else if (name.equals("sourceId")) {
                this.sourceId = this.castToId(value);
            } else if (name.equals("validateProfileId")) {
                this.validateProfileId = this.castToId(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else if (name.equals("warningOnly")) {
                this.warningOnly = this.castToBoolean(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    throw new FHIRException("Cannot make property label as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -962590849: {
                    throw new FHIRException("Cannot make property direction as it is not a complex type");
                }
                case 2081856758: {
                    throw new FHIRException("Cannot make property compareToSourceId as it is not a complex type");
                }
                case -790206144: {
                    throw new FHIRException("Cannot make property compareToSourcePath as it is not a complex type");
                }
                case -389131437: {
                    throw new FHIRException("Cannot make property contentType as it is not a complex type");
                }
                case 1160732269: {
                    throw new FHIRException("Cannot make property headerField as it is not a complex type");
                }
                case 818925001: {
                    throw new FHIRException("Cannot make property minimumId as it is not a complex type");
                }
                case 1001488901: {
                    throw new FHIRException("Cannot make property navigationLinks as it is not a complex type");
                }
                case -500553564: {
                    throw new FHIRException("Cannot make property operator as it is not a complex type");
                }
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case -340323263: {
                    throw new FHIRException("Cannot make property response as it is not a complex type");
                }
                case 1438723534: {
                    throw new FHIRException("Cannot make property responseCode as it is not a complex type");
                }
                case 3512060: {
                    return this.getRule();
                }
                case 1548678118: {
                    return this.getRuleset();
                }
                case 1746327190: {
                    throw new FHIRException("Cannot make property sourceId as it is not a complex type");
                }
                case 1555541038: {
                    throw new FHIRException("Cannot make property validateProfileId as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
                case -481159832: {
                    throw new FHIRException("Cannot make property warningOnly as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.label");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
            }
            if (name.equals("direction")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.direction");
            }
            if (name.equals("compareToSourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.compareToSourceId");
            }
            if (name.equals("compareToSourcePath")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.compareToSourcePath");
            }
            if (name.equals("contentType")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.contentType");
            }
            if (name.equals("headerField")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.headerField");
            }
            if (name.equals("minimumId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.minimumId");
            }
            if (name.equals("navigationLinks")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.navigationLinks");
            }
            if (name.equals("operator")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.operator");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.path");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.resource");
            }
            if (name.equals("response")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.response");
            }
            if (name.equals("responseCode")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.responseCode");
            }
            if (name.equals("rule")) {
                this.rule = new SetupActionAssertRuleComponent();
                return this.rule;
            }
            if (name.equals("ruleset")) {
                this.ruleset = new SetupActionAssertRulesetComponent();
                return this.ruleset;
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.sourceId");
            }
            if (name.equals("validateProfileId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.validateProfileId");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.value");
            }
            if (name.equals("warningOnly")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.warningOnly");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionAssertComponent copy() {
            SetupActionAssertComponent dst = new SetupActionAssertComponent();
            this.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.direction = this.direction == null ? null : this.direction.copy();
            dst.compareToSourceId = this.compareToSourceId == null ? null : this.compareToSourceId.copy();
            dst.compareToSourcePath = this.compareToSourcePath == null ? null : this.compareToSourcePath.copy();
            dst.contentType = this.contentType == null ? null : this.contentType.copy();
            dst.headerField = this.headerField == null ? null : this.headerField.copy();
            dst.minimumId = this.minimumId == null ? null : this.minimumId.copy();
            dst.navigationLinks = this.navigationLinks == null ? null : this.navigationLinks.copy();
            dst.operator = this.operator == null ? null : this.operator.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.response = this.response == null ? null : this.response.copy();
            dst.responseCode = this.responseCode == null ? null : this.responseCode.copy();
            dst.rule = this.rule == null ? null : this.rule.copy();
            dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
            dst.validateProfileId = this.validateProfileId == null ? null : this.validateProfileId.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.warningOnly = this.warningOnly == null ? null : this.warningOnly.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertComponent)) {
                return false;
            }
            SetupActionAssertComponent o = (SetupActionAssertComponent)other;
            return SetupActionAssertComponent.compareDeep(this.label, o.label, true) && SetupActionAssertComponent.compareDeep(this.description, o.description, true) && SetupActionAssertComponent.compareDeep(this.direction, o.direction, true) && SetupActionAssertComponent.compareDeep(this.compareToSourceId, o.compareToSourceId, true) && SetupActionAssertComponent.compareDeep(this.compareToSourcePath, o.compareToSourcePath, true) && SetupActionAssertComponent.compareDeep(this.contentType, o.contentType, true) && SetupActionAssertComponent.compareDeep(this.headerField, o.headerField, true) && SetupActionAssertComponent.compareDeep(this.minimumId, o.minimumId, true) && SetupActionAssertComponent.compareDeep(this.navigationLinks, o.navigationLinks, true) && SetupActionAssertComponent.compareDeep(this.operator, o.operator, true) && SetupActionAssertComponent.compareDeep(this.path, o.path, true) && SetupActionAssertComponent.compareDeep(this.resource, o.resource, true) && SetupActionAssertComponent.compareDeep(this.response, o.response, true) && SetupActionAssertComponent.compareDeep(this.responseCode, o.responseCode, true) && SetupActionAssertComponent.compareDeep(this.rule, o.rule, true) && SetupActionAssertComponent.compareDeep(this.ruleset, o.ruleset, true) && SetupActionAssertComponent.compareDeep(this.sourceId, o.sourceId, true) && SetupActionAssertComponent.compareDeep(this.validateProfileId, o.validateProfileId, true) && SetupActionAssertComponent.compareDeep(this.value, o.value, true) && SetupActionAssertComponent.compareDeep(this.warningOnly, o.warningOnly, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionAssertComponent)) {
                return false;
            }
            SetupActionAssertComponent o = (SetupActionAssertComponent)other;
            return SetupActionAssertComponent.compareValues(this.label, o.label, true) && SetupActionAssertComponent.compareValues(this.description, o.description, true) && SetupActionAssertComponent.compareValues(this.direction, o.direction, true) && SetupActionAssertComponent.compareValues(this.compareToSourceId, o.compareToSourceId, true) && SetupActionAssertComponent.compareValues(this.compareToSourcePath, o.compareToSourcePath, true) && SetupActionAssertComponent.compareValues(this.contentType, o.contentType, true) && SetupActionAssertComponent.compareValues(this.headerField, o.headerField, true) && SetupActionAssertComponent.compareValues(this.minimumId, o.minimumId, true) && SetupActionAssertComponent.compareValues(this.navigationLinks, o.navigationLinks, true) && SetupActionAssertComponent.compareValues(this.operator, o.operator, true) && SetupActionAssertComponent.compareValues(this.path, o.path, true) && SetupActionAssertComponent.compareValues(this.resource, o.resource, true) && SetupActionAssertComponent.compareValues(this.response, o.response, true) && SetupActionAssertComponent.compareValues(this.responseCode, o.responseCode, true) && SetupActionAssertComponent.compareValues(this.sourceId, o.sourceId, true) && SetupActionAssertComponent.compareValues(this.validateProfileId, o.validateProfileId, true) && SetupActionAssertComponent.compareValues(this.value, o.value, true) && SetupActionAssertComponent.compareValues(this.warningOnly, o.warningOnly, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.label != null && !this.label.isEmpty() || this.description != null && !this.description.isEmpty() || this.direction != null && !this.direction.isEmpty() || this.compareToSourceId != null && !this.compareToSourceId.isEmpty() || this.compareToSourcePath != null && !this.compareToSourcePath.isEmpty() || this.contentType != null && !this.contentType.isEmpty() || this.headerField != null && !this.headerField.isEmpty() || this.minimumId != null && !this.minimumId.isEmpty() || this.navigationLinks != null && !this.navigationLinks.isEmpty() || this.operator != null && !this.operator.isEmpty() || this.path != null && !this.path.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.response != null && !this.response.isEmpty() || this.responseCode != null && !this.responseCode.isEmpty() || this.rule != null && !this.rule.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.sourceId != null && !this.sourceId.isEmpty() || this.validateProfileId != null && !this.validateProfileId.isEmpty() || this.value != null && !this.value.isEmpty() || this.warningOnly != null && !this.warningOnly.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.assert";
        }
    }

    @Block
    public static class SetupActionOperationRequestHeaderComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="field", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP header field name", formalDefinition="The HTTP header field e.g. \"Accept\".")
        protected StringType field;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP headerfield value", formalDefinition="The value of the header e.g. \"application/xml\".")
        protected StringType value;
        private static final long serialVersionUID = 274395337L;

        public SetupActionOperationRequestHeaderComponent() {
        }

        public SetupActionOperationRequestHeaderComponent(StringType field, StringType value) {
            this.field = field;
            this.value = value;
        }

        public StringType getFieldElement() {
            if (this.field == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationRequestHeaderComponent.field");
                }
                if (Configuration.doAutoCreate()) {
                    this.field = new StringType();
                }
            }
            return this.field;
        }

        public boolean hasFieldElement() {
            return this.field != null && !this.field.isEmpty();
        }

        public boolean hasField() {
            return this.field != null && !this.field.isEmpty();
        }

        public SetupActionOperationRequestHeaderComponent setFieldElement(StringType value) {
            this.field = value;
            return this;
        }

        public String getField() {
            return this.field == null ? null : (String)this.field.getValue();
        }

        public SetupActionOperationRequestHeaderComponent setField(String value) {
            if (this.field == null) {
                this.field = new StringType();
            }
            this.field.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationRequestHeaderComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SetupActionOperationRequestHeaderComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public SetupActionOperationRequestHeaderComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("field", "string", "The HTTP header field e.g. \"Accept\".", 0, Integer.MAX_VALUE, this.field));
            childrenList.add(new Property("value", "string", "The value of the header e.g. \"application/xml\".", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    Base[] baseArray;
                    if (this.field == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.field;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    this.field = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("field")) {
                this.field = this.castToString(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97427706: {
                    throw new FHIRException("Cannot make property field as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("field")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.field");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.value");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionOperationRequestHeaderComponent copy() {
            SetupActionOperationRequestHeaderComponent dst = new SetupActionOperationRequestHeaderComponent();
            this.copyValues(dst);
            dst.field = this.field == null ? null : this.field.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionOperationRequestHeaderComponent)) {
                return false;
            }
            SetupActionOperationRequestHeaderComponent o = (SetupActionOperationRequestHeaderComponent)other;
            return SetupActionOperationRequestHeaderComponent.compareDeep(this.field, o.field, true) && SetupActionOperationRequestHeaderComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionOperationRequestHeaderComponent)) {
                return false;
            }
            SetupActionOperationRequestHeaderComponent o = (SetupActionOperationRequestHeaderComponent)other;
            return SetupActionOperationRequestHeaderComponent.compareValues(this.field, o.field, true) && SetupActionOperationRequestHeaderComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.field != null && !this.field.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.operation.requestHeader";
        }
    }

    @Block
    public static class SetupActionOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The operation code type that will be executed", formalDefinition="Server interaction or operation type.")
        protected Coding type;
        @Child(name="resource", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource type", formalDefinition="The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.")
        protected CodeType resource;
        @Child(name="label", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/logging operation label", formalDefinition="The label would be used for tracking/logging purposes by test engines.")
        protected StringType label;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Tracking/reporting operation description", formalDefinition="The description would be used by test engines for tracking and reporting purposes.")
        protected StringType description;
        @Child(name="accept", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="xml | json", formalDefinition="The content-type or mime-type to use for RESTful operation in the 'Accept' header.")
        protected Enumeration<ContentType> accept;
        @Child(name="contentType", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="xml | json", formalDefinition="The content-type or mime-type to use for RESTful operation in the 'Content-Type' header.")
        protected Enumeration<ContentType> contentType;
        @Child(name="destination", type={IntegerType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server responding to the request", formalDefinition="The server where the request message is destined for.  Must be one of the server numbers listed in TestScript.destination section.")
        protected IntegerType destination;
        @Child(name="encodeRequestUrl", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not to send the request url in encoded format", formalDefinition="Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.")
        protected BooleanType encodeRequestUrl;
        @Child(name="origin", type={IntegerType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server initiating the request", formalDefinition="The server where the request message originates from.  Must be one of the server numbers listed in TestScript.origin section.")
        protected IntegerType origin;
        @Child(name="params", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explicitly defined path parameters", formalDefinition="Path plus parameters after [type].  Used to set parts of the request URL explicitly.")
        protected StringType params;
        @Child(name="requestHeader", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Each operation can have one ore more header elements", formalDefinition="Header elements would be used to set HTTP headers.")
        protected List<SetupActionOperationRequestHeaderComponent> requestHeader;
        @Child(name="responseId", type={IdType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of mapped response", formalDefinition="The fixture id (maybe new) to map to the response.")
        protected IdType responseId;
        @Child(name="sourceId", type={IdType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of body for PUT and POST requests", formalDefinition="The id of the fixture used as the body of a PUT or POST request.")
        protected IdType sourceId;
        @Child(name="targetId", type={IdType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of fixture used for extracting the [id],  [type], and [vid] for GET requests", formalDefinition="Id of fixture used for extracting the [id],  [type], and [vid] for GET requests.")
        protected IdType targetId;
        @Child(name="url", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Request URL", formalDefinition="Complete request URL.")
        protected StringType url;
        private static final long serialVersionUID = 606457859L;

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SetupActionOperationComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public CodeType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new CodeType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SetupActionOperationComponent setResourceElement(CodeType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SetupActionOperationComponent setResource(String value) {
            if (Utilities.noString((String)value)) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new CodeType();
                }
                this.resource.setValue(value);
            }
            return this;
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public SetupActionOperationComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public SetupActionOperationComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SetupActionOperationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SetupActionOperationComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<ContentType> getAcceptElement() {
            if (this.accept == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.accept");
                }
                if (Configuration.doAutoCreate()) {
                    this.accept = new Enumeration<ContentType>(new ContentTypeEnumFactory());
                }
            }
            return this.accept;
        }

        public boolean hasAcceptElement() {
            return this.accept != null && !this.accept.isEmpty();
        }

        public boolean hasAccept() {
            return this.accept != null && !this.accept.isEmpty();
        }

        public SetupActionOperationComponent setAcceptElement(Enumeration<ContentType> value) {
            this.accept = value;
            return this;
        }

        public ContentType getAccept() {
            return this.accept == null ? null : (ContentType)((Object)this.accept.getValue());
        }

        public SetupActionOperationComponent setAccept(ContentType value) {
            if (value == null) {
                this.accept = null;
            } else {
                if (this.accept == null) {
                    this.accept = new Enumeration<ContentType>(new ContentTypeEnumFactory());
                }
                this.accept.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ContentType> getContentTypeElement() {
            if (this.contentType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.contentType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contentType = new Enumeration<ContentType>(new ContentTypeEnumFactory());
                }
            }
            return this.contentType;
        }

        public boolean hasContentTypeElement() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public boolean hasContentType() {
            return this.contentType != null && !this.contentType.isEmpty();
        }

        public SetupActionOperationComponent setContentTypeElement(Enumeration<ContentType> value) {
            this.contentType = value;
            return this;
        }

        public ContentType getContentType() {
            return this.contentType == null ? null : (ContentType)((Object)this.contentType.getValue());
        }

        public SetupActionOperationComponent setContentType(ContentType value) {
            if (value == null) {
                this.contentType = null;
            } else {
                if (this.contentType == null) {
                    this.contentType = new Enumeration<ContentType>(new ContentTypeEnumFactory());
                }
                this.contentType.setValue((Object)value);
            }
            return this;
        }

        public IntegerType getDestinationElement() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new IntegerType();
                }
            }
            return this.destination;
        }

        public boolean hasDestinationElement() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public SetupActionOperationComponent setDestinationElement(IntegerType value) {
            this.destination = value;
            return this;
        }

        public int getDestination() {
            return this.destination == null || this.destination.isEmpty() ? 0 : (Integer)this.destination.getValue();
        }

        public SetupActionOperationComponent setDestination(int value) {
            if (this.destination == null) {
                this.destination = new IntegerType();
            }
            this.destination.setValue((Object)value);
            return this;
        }

        public BooleanType getEncodeRequestUrlElement() {
            if (this.encodeRequestUrl == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.encodeRequestUrl");
                }
                if (Configuration.doAutoCreate()) {
                    this.encodeRequestUrl = new BooleanType();
                }
            }
            return this.encodeRequestUrl;
        }

        public boolean hasEncodeRequestUrlElement() {
            return this.encodeRequestUrl != null && !this.encodeRequestUrl.isEmpty();
        }

        public boolean hasEncodeRequestUrl() {
            return this.encodeRequestUrl != null && !this.encodeRequestUrl.isEmpty();
        }

        public SetupActionOperationComponent setEncodeRequestUrlElement(BooleanType value) {
            this.encodeRequestUrl = value;
            return this;
        }

        public boolean getEncodeRequestUrl() {
            return this.encodeRequestUrl == null || this.encodeRequestUrl.isEmpty() ? false : (Boolean)this.encodeRequestUrl.getValue();
        }

        public SetupActionOperationComponent setEncodeRequestUrl(boolean value) {
            if (this.encodeRequestUrl == null) {
                this.encodeRequestUrl = new BooleanType();
            }
            this.encodeRequestUrl.setValue((Object)value);
            return this;
        }

        public IntegerType getOriginElement() {
            if (this.origin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.origin = new IntegerType();
                }
            }
            return this.origin;
        }

        public boolean hasOriginElement() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public boolean hasOrigin() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public SetupActionOperationComponent setOriginElement(IntegerType value) {
            this.origin = value;
            return this;
        }

        public int getOrigin() {
            return this.origin == null || this.origin.isEmpty() ? 0 : (Integer)this.origin.getValue();
        }

        public SetupActionOperationComponent setOrigin(int value) {
            if (this.origin == null) {
                this.origin = new IntegerType();
            }
            this.origin.setValue((Object)value);
            return this;
        }

        public StringType getParamsElement() {
            if (this.params == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.params");
                }
                if (Configuration.doAutoCreate()) {
                    this.params = new StringType();
                }
            }
            return this.params;
        }

        public boolean hasParamsElement() {
            return this.params != null && !this.params.isEmpty();
        }

        public boolean hasParams() {
            return this.params != null && !this.params.isEmpty();
        }

        public SetupActionOperationComponent setParamsElement(StringType value) {
            this.params = value;
            return this;
        }

        public String getParams() {
            return this.params == null ? null : (String)this.params.getValue();
        }

        public SetupActionOperationComponent setParams(String value) {
            if (Utilities.noString((String)value)) {
                this.params = null;
            } else {
                if (this.params == null) {
                    this.params = new StringType();
                }
                this.params.setValue(value);
            }
            return this;
        }

        public List<SetupActionOperationRequestHeaderComponent> getRequestHeader() {
            if (this.requestHeader == null) {
                this.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
            }
            return this.requestHeader;
        }

        public boolean hasRequestHeader() {
            if (this.requestHeader == null) {
                return false;
            }
            for (SetupActionOperationRequestHeaderComponent item : this.requestHeader) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionOperationRequestHeaderComponent addRequestHeader() {
            SetupActionOperationRequestHeaderComponent t = new SetupActionOperationRequestHeaderComponent();
            if (this.requestHeader == null) {
                this.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
            }
            this.requestHeader.add(t);
            return t;
        }

        public SetupActionOperationComponent addRequestHeader(SetupActionOperationRequestHeaderComponent t) {
            if (t == null) {
                return this;
            }
            if (this.requestHeader == null) {
                this.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
            }
            this.requestHeader.add(t);
            return this;
        }

        public IdType getResponseIdElement() {
            if (this.responseId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.responseId");
                }
                if (Configuration.doAutoCreate()) {
                    this.responseId = new IdType();
                }
            }
            return this.responseId;
        }

        public boolean hasResponseIdElement() {
            return this.responseId != null && !this.responseId.isEmpty();
        }

        public boolean hasResponseId() {
            return this.responseId != null && !this.responseId.isEmpty();
        }

        public SetupActionOperationComponent setResponseIdElement(IdType value) {
            this.responseId = value;
            return this;
        }

        public String getResponseId() {
            return this.responseId == null ? null : this.responseId.getValue();
        }

        public SetupActionOperationComponent setResponseId(String value) {
            if (Utilities.noString((String)value)) {
                this.responseId = null;
            } else {
                if (this.responseId == null) {
                    this.responseId = new IdType();
                }
                this.responseId.setValue(value);
            }
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public SetupActionOperationComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public SetupActionOperationComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new IdType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        public IdType getTargetIdElement() {
            if (this.targetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.targetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetId = new IdType();
                }
            }
            return this.targetId;
        }

        public boolean hasTargetIdElement() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public boolean hasTargetId() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public SetupActionOperationComponent setTargetIdElement(IdType value) {
            this.targetId = value;
            return this;
        }

        public String getTargetId() {
            return this.targetId == null ? null : this.targetId.getValue();
        }

        public SetupActionOperationComponent setTargetId(String value) {
            if (Utilities.noString((String)value)) {
                this.targetId = null;
            } else {
                if (this.targetId == null) {
                    this.targetId = new IdType();
                }
                this.targetId.setValue(value);
            }
            return this;
        }

        public StringType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionOperationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new StringType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public SetupActionOperationComponent setUrlElement(StringType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public SetupActionOperationComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new StringType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Server interaction or operation type.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("resource", "code", "The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("label", "string", "The label would be used for tracking/logging purposes by test engines.", 0, Integer.MAX_VALUE, this.label));
            childrenList.add(new Property(TestScript.SP_DESCRIPTION, "string", "The description would be used by test engines for tracking and reporting purposes.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("accept", "code", "The content-type or mime-type to use for RESTful operation in the 'Accept' header.", 0, Integer.MAX_VALUE, this.accept));
            childrenList.add(new Property("contentType", "code", "The content-type or mime-type to use for RESTful operation in the 'Content-Type' header.", 0, Integer.MAX_VALUE, this.contentType));
            childrenList.add(new Property("destination", "integer", "The server where the request message is destined for.  Must be one of the server numbers listed in TestScript.destination section.", 0, Integer.MAX_VALUE, this.destination));
            childrenList.add(new Property("encodeRequestUrl", "boolean", "Whether or not to implicitly send the request url in encoded format. The default is true to match the standard RESTful client behavior. Set to false when communicating with a server that does not support encoded url paths.", 0, Integer.MAX_VALUE, this.encodeRequestUrl));
            childrenList.add(new Property("origin", "integer", "The server where the request message originates from.  Must be one of the server numbers listed in TestScript.origin section.", 0, Integer.MAX_VALUE, this.origin));
            childrenList.add(new Property("params", "string", "Path plus parameters after [type].  Used to set parts of the request URL explicitly.", 0, Integer.MAX_VALUE, this.params));
            childrenList.add(new Property("requestHeader", "", "Header elements would be used to set HTTP headers.", 0, Integer.MAX_VALUE, this.requestHeader));
            childrenList.add(new Property("responseId", "id", "The fixture id (maybe new) to map to the response.", 0, Integer.MAX_VALUE, this.responseId));
            childrenList.add(new Property("sourceId", "id", "The id of the fixture used as the body of a PUT or POST request.", 0, Integer.MAX_VALUE, this.sourceId));
            childrenList.add(new Property("targetId", "id", "Id of fixture used for extracting the [id],  [type], and [vid] for GET requests.", 0, Integer.MAX_VALUE, this.targetId));
            childrenList.add(new Property(TestScript.SP_URL, "string", "Complete request URL.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.label;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -1423461112: {
                    Base[] baseArray;
                    if (this.accept == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.accept;
                    }
                    return baseArray;
                }
                case -389131437: {
                    Base[] baseArray;
                    if (this.contentType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.contentType;
                    }
                    return baseArray;
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.destination;
                    }
                    return baseArray;
                }
                case -1760554218: {
                    Base[] baseArray;
                    if (this.encodeRequestUrl == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.encodeRequestUrl;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    Base[] baseArray;
                    if (this.origin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.origin;
                    }
                    return baseArray;
                }
                case -995427962: {
                    Base[] baseArray;
                    if (this.params == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.params;
                    }
                    return baseArray;
                }
                case 1074158076: {
                    return this.requestHeader == null ? new Base[]{} : this.requestHeader.toArray(new Base[this.requestHeader.size()]);
                }
                case -633138884: {
                    Base[] baseArray;
                    if (this.responseId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.responseId;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.sourceId;
                    }
                    return baseArray;
                }
                case -441951604: {
                    Base[] baseArray;
                    if (this.targetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.targetId;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToCode(value);
                    break;
                }
                case 102727412: {
                    this.label = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -1423461112: {
                    this.accept = new ContentTypeEnumFactory().fromType(value);
                    break;
                }
                case -389131437: {
                    this.contentType = new ContentTypeEnumFactory().fromType(value);
                    break;
                }
                case -1429847026: {
                    this.destination = this.castToInteger(value);
                    break;
                }
                case -1760554218: {
                    this.encodeRequestUrl = this.castToBoolean(value);
                    break;
                }
                case -1008619738: {
                    this.origin = this.castToInteger(value);
                    break;
                }
                case -995427962: {
                    this.params = this.castToString(value);
                    break;
                }
                case 1074158076: {
                    this.getRequestHeader().add((SetupActionOperationRequestHeaderComponent)value);
                    break;
                }
                case -633138884: {
                    this.responseId = this.castToId(value);
                    break;
                }
                case 1746327190: {
                    this.sourceId = this.castToId(value);
                    break;
                }
                case -441951604: {
                    this.targetId = this.castToId(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToCode(value);
            } else if (name.equals("label")) {
                this.label = this.castToString(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("accept")) {
                this.accept = new ContentTypeEnumFactory().fromType(value);
            } else if (name.equals("contentType")) {
                this.contentType = new ContentTypeEnumFactory().fromType(value);
            } else if (name.equals("destination")) {
                this.destination = this.castToInteger(value);
            } else if (name.equals("encodeRequestUrl")) {
                this.encodeRequestUrl = this.castToBoolean(value);
            } else if (name.equals("origin")) {
                this.origin = this.castToInteger(value);
            } else if (name.equals("params")) {
                this.params = this.castToString(value);
            } else if (name.equals("requestHeader")) {
                this.getRequestHeader().add((SetupActionOperationRequestHeaderComponent)value);
            } else if (name.equals("responseId")) {
                this.responseId = this.castToId(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = this.castToId(value);
            } else if (name.equals("targetId")) {
                this.targetId = this.castToId(value);
            } else if (name.equals(TestScript.SP_URL)) {
                this.url = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case 102727412: {
                    throw new FHIRException("Cannot make property label as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -1423461112: {
                    throw new FHIRException("Cannot make property accept as it is not a complex type");
                }
                case -389131437: {
                    throw new FHIRException("Cannot make property contentType as it is not a complex type");
                }
                case -1429847026: {
                    throw new FHIRException("Cannot make property destination as it is not a complex type");
                }
                case -1760554218: {
                    throw new FHIRException("Cannot make property encodeRequestUrl as it is not a complex type");
                }
                case -1008619738: {
                    throw new FHIRException("Cannot make property origin as it is not a complex type");
                }
                case -995427962: {
                    throw new FHIRException("Cannot make property params as it is not a complex type");
                }
                case 1074158076: {
                    return this.addRequestHeader();
                }
                case -633138884: {
                    throw new FHIRException("Cannot make property responseId as it is not a complex type");
                }
                case 1746327190: {
                    throw new FHIRException("Cannot make property sourceId as it is not a complex type");
                }
                case -441951604: {
                    throw new FHIRException("Cannot make property targetId as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.resource");
            }
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.label");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
            }
            if (name.equals("accept")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.accept");
            }
            if (name.equals("contentType")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.contentType");
            }
            if (name.equals("destination")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.destination");
            }
            if (name.equals("encodeRequestUrl")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.encodeRequestUrl");
            }
            if (name.equals("origin")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.origin");
            }
            if (name.equals("params")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.params");
            }
            if (name.equals("requestHeader")) {
                return this.addRequestHeader();
            }
            if (name.equals("responseId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.responseId");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.sourceId");
            }
            if (name.equals("targetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.targetId");
            }
            if (name.equals(TestScript.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.url");
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionOperationComponent copy() {
            SetupActionOperationComponent dst = new SetupActionOperationComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.label = this.label == null ? null : this.label.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.accept = this.accept == null ? null : this.accept.copy();
            dst.contentType = this.contentType == null ? null : this.contentType.copy();
            dst.destination = this.destination == null ? null : this.destination.copy();
            dst.encodeRequestUrl = this.encodeRequestUrl == null ? null : this.encodeRequestUrl.copy();
            dst.origin = this.origin == null ? null : this.origin.copy();
            StringType stringType = dst.params = this.params == null ? null : this.params.copy();
            if (this.requestHeader != null) {
                dst.requestHeader = new ArrayList<SetupActionOperationRequestHeaderComponent>();
                for (SetupActionOperationRequestHeaderComponent i : this.requestHeader) {
                    dst.requestHeader.add(i.copy());
                }
            }
            dst.responseId = this.responseId == null ? null : this.responseId.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
            dst.targetId = this.targetId == null ? null : this.targetId.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionOperationComponent)) {
                return false;
            }
            SetupActionOperationComponent o = (SetupActionOperationComponent)other;
            return SetupActionOperationComponent.compareDeep(this.type, o.type, true) && SetupActionOperationComponent.compareDeep(this.resource, o.resource, true) && SetupActionOperationComponent.compareDeep(this.label, o.label, true) && SetupActionOperationComponent.compareDeep(this.description, o.description, true) && SetupActionOperationComponent.compareDeep(this.accept, o.accept, true) && SetupActionOperationComponent.compareDeep(this.contentType, o.contentType, true) && SetupActionOperationComponent.compareDeep(this.destination, o.destination, true) && SetupActionOperationComponent.compareDeep(this.encodeRequestUrl, o.encodeRequestUrl, true) && SetupActionOperationComponent.compareDeep(this.origin, o.origin, true) && SetupActionOperationComponent.compareDeep(this.params, o.params, true) && SetupActionOperationComponent.compareDeep(this.requestHeader, o.requestHeader, true) && SetupActionOperationComponent.compareDeep(this.responseId, o.responseId, true) && SetupActionOperationComponent.compareDeep(this.sourceId, o.sourceId, true) && SetupActionOperationComponent.compareDeep(this.targetId, o.targetId, true) && SetupActionOperationComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionOperationComponent)) {
                return false;
            }
            SetupActionOperationComponent o = (SetupActionOperationComponent)other;
            return SetupActionOperationComponent.compareValues(this.resource, o.resource, true) && SetupActionOperationComponent.compareValues(this.label, o.label, true) && SetupActionOperationComponent.compareValues(this.description, o.description, true) && SetupActionOperationComponent.compareValues(this.accept, o.accept, true) && SetupActionOperationComponent.compareValues(this.contentType, o.contentType, true) && SetupActionOperationComponent.compareValues(this.destination, o.destination, true) && SetupActionOperationComponent.compareValues(this.encodeRequestUrl, o.encodeRequestUrl, true) && SetupActionOperationComponent.compareValues(this.origin, o.origin, true) && SetupActionOperationComponent.compareValues(this.params, o.params, true) && SetupActionOperationComponent.compareValues(this.responseId, o.responseId, true) && SetupActionOperationComponent.compareValues(this.sourceId, o.sourceId, true) && SetupActionOperationComponent.compareValues(this.targetId, o.targetId, true) && SetupActionOperationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.label != null && !this.label.isEmpty() || this.description != null && !this.description.isEmpty() || this.accept != null && !this.accept.isEmpty() || this.contentType != null && !this.contentType.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.encodeRequestUrl != null && !this.encodeRequestUrl.isEmpty() || this.origin != null && !this.origin.isEmpty() || this.params != null && !this.params.isEmpty() || this.requestHeader != null && !this.requestHeader.isEmpty() || this.responseId != null && !this.responseId.isEmpty() || this.sourceId != null && !this.sourceId.isEmpty() || this.targetId != null && !this.targetId.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action.operation";
        }
    }

    @Block
    public static class SetupActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operation", type={}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The setup operation to perform", formalDefinition="The operation to perform.")
        protected SetupActionOperationComponent operation;
        @Child(name="assert", type={}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The assertion to perform", formalDefinition="Evaluates the results of previous operations to determine if the server under test behaves appropriately.")
        protected SetupActionAssertComponent assert_;
        private static final long serialVersionUID = -252088305L;

        public SetupActionOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new SetupActionOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public SetupActionComponent setOperation(SetupActionOperationComponent value) {
            this.operation = value;
            return this;
        }

        public SetupActionAssertComponent getAssert() {
            if (this.assert_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SetupActionComponent.assert_");
                }
                if (Configuration.doAutoCreate()) {
                    this.assert_ = new SetupActionAssertComponent();
                }
            }
            return this.assert_;
        }

        public boolean hasAssert() {
            return this.assert_ != null && !this.assert_.isEmpty();
        }

        public SetupActionComponent setAssert(SetupActionAssertComponent value) {
            this.assert_ = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("operation", "", "The operation to perform.", 0, Integer.MAX_VALUE, this.operation));
            childrenList.add(new Property("assert", "", "Evaluates the results of previous operations to determine if the server under test behaves appropriately.", 0, Integer.MAX_VALUE, this.assert_));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operation;
                    }
                    return baseArray;
                }
                case -1408208058: {
                    Base[] baseArray;
                    if (this.assert_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.assert_;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    this.operation = (SetupActionOperationComponent)value;
                    break;
                }
                case -1408208058: {
                    this.assert_ = (SetupActionAssertComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = (SetupActionOperationComponent)value;
            } else if (name.equals("assert")) {
                this.assert_ = (SetupActionAssertComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1662702951: {
                    return this.getOperation();
                }
                case -1408208058: {
                    return this.getAssert();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operation")) {
                this.operation = new SetupActionOperationComponent();
                return this.operation;
            }
            if (name.equals("assert")) {
                this.assert_ = new SetupActionAssertComponent();
                return this.assert_;
            }
            return super.addChild(name);
        }

        @Override
        public SetupActionComponent copy() {
            SetupActionComponent dst = new SetupActionComponent();
            this.copyValues(dst);
            dst.operation = this.operation == null ? null : this.operation.copy();
            dst.assert_ = this.assert_ == null ? null : this.assert_.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SetupActionComponent)) {
                return false;
            }
            SetupActionComponent o = (SetupActionComponent)other;
            return SetupActionComponent.compareDeep(this.operation, o.operation, true) && SetupActionComponent.compareDeep(this.assert_, o.assert_, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SetupActionComponent)) {
                return false;
            }
            SetupActionComponent o = (SetupActionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.operation != null && !this.operation.isEmpty() || this.assert_ != null && !this.assert_.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup.action";
        }
    }

    @Block
    public static class TestScriptSetupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="metadata", type={TestScriptMetadataComponent.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Capabilities  that are assumed to function correctly on the FHIR server being tested", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        protected TestScriptMetadataComponent metadata;
        @Child(name="action", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A setup operation or assert to perform", formalDefinition="Action would contain either an operation or an assertion.")
        protected List<SetupActionComponent> action;
        private static final long serialVersionUID = 9850834L;

        public TestScriptMetadataComponent getMetadata() {
            if (this.metadata == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptSetupComponent.metadata");
                }
                if (Configuration.doAutoCreate()) {
                    this.metadata = new TestScriptMetadataComponent();
                }
            }
            return this.metadata;
        }

        public boolean hasMetadata() {
            return this.metadata != null && !this.metadata.isEmpty();
        }

        public TestScriptSetupComponent setMetadata(TestScriptMetadataComponent value) {
            this.metadata = value;
            return this;
        }

        public List<SetupActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            return this.action;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (SetupActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SetupActionComponent addAction() {
            SetupActionComponent t = new SetupActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public TestScriptSetupComponent addAction(SetupActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<SetupActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("metadata", "@TestScript.metadata", "Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.", 0, Integer.MAX_VALUE, this.metadata));
            childrenList.add(new Property("action", "", "Action would contain either an operation or an assertion.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -450004177: {
                    Base[] baseArray;
                    if (this.metadata == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.metadata;
                    }
                    return baseArray;
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -450004177: {
                    this.metadata = (TestScriptMetadataComponent)value;
                    break;
                }
                case -1422950858: {
                    this.getAction().add((SetupActionComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("metadata")) {
                this.metadata = (TestScriptMetadataComponent)value;
            } else if (name.equals("action")) {
                this.getAction().add((SetupActionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -450004177: {
                    return this.getMetadata();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("metadata")) {
                this.metadata = new TestScriptMetadataComponent();
                return this.metadata;
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptSetupComponent copy() {
            TestScriptSetupComponent dst = new TestScriptSetupComponent();
            this.copyValues(dst);
            TestScriptMetadataComponent testScriptMetadataComponent = dst.metadata = this.metadata == null ? null : this.metadata.copy();
            if (this.action != null) {
                dst.action = new ArrayList<SetupActionComponent>();
                for (SetupActionComponent i : this.action) {
                    dst.action.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptSetupComponent)) {
                return false;
            }
            TestScriptSetupComponent o = (TestScriptSetupComponent)other;
            return TestScriptSetupComponent.compareDeep(this.metadata, o.metadata, true) && TestScriptSetupComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptSetupComponent)) {
                return false;
            }
            TestScriptSetupComponent o = (TestScriptSetupComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.metadata != null && !this.metadata.isEmpty() || this.action != null && !this.action.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.setup";
        }
    }

    @Block
    public static class TestScriptRulesetRuleParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter name matching external assert ruleset rule parameter", formalDefinition="Descriptive name for this parameter that matches the external assert ruleset rule parameter name.")
        protected StringType name;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter value defined either explicitly or dynamically", formalDefinition="The value for the parameter that will be passed on to the external ruleset rule template.")
        protected StringType value;
        private static final long serialVersionUID = 395259392L;

        public TestScriptRulesetRuleParamComponent() {
        }

        public TestScriptRulesetRuleParamComponent(StringType name, StringType value) {
            this.name = name;
            this.value = value;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRulesetRuleParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptRulesetRuleParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptRulesetRuleParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRulesetRuleParamComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TestScriptRulesetRuleParamComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public TestScriptRulesetRuleParamComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "Descriptive name for this parameter that matches the external assert ruleset rule parameter name.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value", "string", "The value for the parameter that will be passed on to the external ruleset rule template.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.value");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptRulesetRuleParamComponent copy() {
            TestScriptRulesetRuleParamComponent dst = new TestScriptRulesetRuleParamComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRulesetRuleParamComponent)) {
                return false;
            }
            TestScriptRulesetRuleParamComponent o = (TestScriptRulesetRuleParamComponent)other;
            return TestScriptRulesetRuleParamComponent.compareDeep(this.name, o.name, true) && TestScriptRulesetRuleParamComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRulesetRuleParamComponent)) {
                return false;
            }
            TestScriptRulesetRuleParamComponent o = (TestScriptRulesetRuleParamComponent)other;
            return TestScriptRulesetRuleParamComponent.compareValues(this.name, o.name, true) && TestScriptRulesetRuleParamComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.ruleset.rule.param";
        }
    }

    @Block
    public static class TestScriptRulesetRuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="ruleId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Id of referenced rule within the ruleset", formalDefinition="Id of the referenced rule within the external ruleset template.")
        protected IdType ruleId;
        @Child(name="param", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Ruleset rule parameter template", formalDefinition="Each rule template can take one or more parameters for rule evaluation.")
        protected List<TestScriptRulesetRuleParamComponent> param;
        private static final long serialVersionUID = 155033950L;

        public TestScriptRulesetRuleComponent() {
        }

        public TestScriptRulesetRuleComponent(IdType ruleId) {
            this.ruleId = ruleId;
        }

        public IdType getRuleIdElement() {
            if (this.ruleId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRulesetRuleComponent.ruleId");
                }
                if (Configuration.doAutoCreate()) {
                    this.ruleId = new IdType();
                }
            }
            return this.ruleId;
        }

        public boolean hasRuleIdElement() {
            return this.ruleId != null && !this.ruleId.isEmpty();
        }

        public boolean hasRuleId() {
            return this.ruleId != null && !this.ruleId.isEmpty();
        }

        public TestScriptRulesetRuleComponent setRuleIdElement(IdType value) {
            this.ruleId = value;
            return this;
        }

        public String getRuleId() {
            return this.ruleId == null ? null : this.ruleId.getValue();
        }

        public TestScriptRulesetRuleComponent setRuleId(String value) {
            if (this.ruleId == null) {
                this.ruleId = new IdType();
            }
            this.ruleId.setValue(value);
            return this;
        }

        public List<TestScriptRulesetRuleParamComponent> getParam() {
            if (this.param == null) {
                this.param = new ArrayList<TestScriptRulesetRuleParamComponent>();
            }
            return this.param;
        }

        public boolean hasParam() {
            if (this.param == null) {
                return false;
            }
            for (TestScriptRulesetRuleParamComponent item : this.param) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptRulesetRuleParamComponent addParam() {
            TestScriptRulesetRuleParamComponent t = new TestScriptRulesetRuleParamComponent();
            if (this.param == null) {
                this.param = new ArrayList<TestScriptRulesetRuleParamComponent>();
            }
            this.param.add(t);
            return t;
        }

        public TestScriptRulesetRuleComponent addParam(TestScriptRulesetRuleParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.param == null) {
                this.param = new ArrayList<TestScriptRulesetRuleParamComponent>();
            }
            this.param.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("ruleId", "id", "Id of the referenced rule within the external ruleset template.", 0, Integer.MAX_VALUE, this.ruleId));
            childrenList.add(new Property("param", "", "Each rule template can take one or more parameters for rule evaluation.", 0, Integer.MAX_VALUE, this.param));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    Base[] baseArray;
                    if (this.ruleId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.ruleId;
                    }
                    return baseArray;
                }
                case 106436749: {
                    return this.param == null ? new Base[]{} : this.param.toArray(new Base[this.param.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    this.ruleId = this.castToId(value);
                    break;
                }
                case 106436749: {
                    this.getParam().add((TestScriptRulesetRuleParamComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("ruleId")) {
                this.ruleId = this.castToId(value);
            } else if (name.equals("param")) {
                this.getParam().add((TestScriptRulesetRuleParamComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -919875273: {
                    throw new FHIRException("Cannot make property ruleId as it is not a complex type");
                }
                case 106436749: {
                    return this.addParam();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("ruleId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.ruleId");
            }
            if (name.equals("param")) {
                return this.addParam();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptRulesetRuleComponent copy() {
            TestScriptRulesetRuleComponent dst = new TestScriptRulesetRuleComponent();
            this.copyValues(dst);
            IdType idType = dst.ruleId = this.ruleId == null ? null : this.ruleId.copy();
            if (this.param != null) {
                dst.param = new ArrayList<TestScriptRulesetRuleParamComponent>();
                for (TestScriptRulesetRuleParamComponent i : this.param) {
                    dst.param.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRulesetRuleComponent)) {
                return false;
            }
            TestScriptRulesetRuleComponent o = (TestScriptRulesetRuleComponent)other;
            return TestScriptRulesetRuleComponent.compareDeep(this.ruleId, o.ruleId, true) && TestScriptRulesetRuleComponent.compareDeep(this.param, o.param, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRulesetRuleComponent)) {
                return false;
            }
            TestScriptRulesetRuleComponent o = (TestScriptRulesetRuleComponent)other;
            return TestScriptRulesetRuleComponent.compareValues(this.ruleId, o.ruleId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.ruleId != null && !this.ruleId.isEmpty() || this.param != null && !this.param.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.ruleset.rule";
        }
    }

    @Block
    public static class TestScriptRulesetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resource", type={}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Assert ruleset resource reference", formalDefinition="Reference to the resource (containing the contents of the ruleset needed for assertions).")
        protected Reference resource;
        protected Resource resourceTarget;
        @Child(name="rule", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The referenced rule within the ruleset", formalDefinition="The referenced rule within the external ruleset template.")
        protected List<TestScriptRulesetRuleComponent> rule;
        private static final long serialVersionUID = 5813554L;

        public TestScriptRulesetComponent() {
        }

        public TestScriptRulesetComponent(Reference resource) {
            this.resource = resource;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRulesetComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public TestScriptRulesetComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public TestScriptRulesetComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        public List<TestScriptRulesetRuleComponent> getRule() {
            if (this.rule == null) {
                this.rule = new ArrayList<TestScriptRulesetRuleComponent>();
            }
            return this.rule;
        }

        public boolean hasRule() {
            if (this.rule == null) {
                return false;
            }
            for (TestScriptRulesetRuleComponent item : this.rule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptRulesetRuleComponent addRule() {
            TestScriptRulesetRuleComponent t = new TestScriptRulesetRuleComponent();
            if (this.rule == null) {
                this.rule = new ArrayList<TestScriptRulesetRuleComponent>();
            }
            this.rule.add(t);
            return t;
        }

        public TestScriptRulesetComponent addRule(TestScriptRulesetRuleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.rule == null) {
                this.rule = new ArrayList<TestScriptRulesetRuleComponent>();
            }
            this.rule.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("resource", "Reference(Any)", "Reference to the resource (containing the contents of the ruleset needed for assertions).", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("rule", "", "The referenced rule within the external ruleset template.", 0, Integer.MAX_VALUE, this.rule));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resource;
                    }
                    return baseArray;
                }
                case 3512060: {
                    return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    this.resource = this.castToReference(value);
                    break;
                }
                case 3512060: {
                    this.getRule().add((TestScriptRulesetRuleComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else if (name.equals("rule")) {
                this.getRule().add((TestScriptRulesetRuleComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return this.getResource();
                }
                case 3512060: {
                    return this.addRule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            if (name.equals("rule")) {
                return this.addRule();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptRulesetComponent copy() {
            TestScriptRulesetComponent dst = new TestScriptRulesetComponent();
            this.copyValues(dst);
            Reference reference = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.rule != null) {
                dst.rule = new ArrayList<TestScriptRulesetRuleComponent>();
                for (TestScriptRulesetRuleComponent i : this.rule) {
                    dst.rule.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRulesetComponent)) {
                return false;
            }
            TestScriptRulesetComponent o = (TestScriptRulesetComponent)other;
            return TestScriptRulesetComponent.compareDeep(this.resource, o.resource, true) && TestScriptRulesetComponent.compareDeep(this.rule, o.rule, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRulesetComponent)) {
                return false;
            }
            TestScriptRulesetComponent o = (TestScriptRulesetComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.rule != null && !this.rule.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.ruleset";
        }
    }

    @Block
    public static class TestScriptRuleParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter name matching external assert rule parameter", formalDefinition="Descriptive name for this parameter that matches the external assert rule parameter name.")
        protected StringType name;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter value defined either explicitly or dynamically", formalDefinition="The explict or dynamic value for the parameter that will be passed on to the external rule template.")
        protected StringType value;
        private static final long serialVersionUID = 395259392L;

        public TestScriptRuleParamComponent() {
        }

        public TestScriptRuleParamComponent(StringType name, StringType value) {
            this.name = name;
            this.value = value;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRuleParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptRuleParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptRuleParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRuleParamComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TestScriptRuleParamComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public TestScriptRuleParamComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "Descriptive name for this parameter that matches the external assert rule parameter name.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value", "string", "The explict or dynamic value for the parameter that will be passed on to the external rule template.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.value");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptRuleParamComponent copy() {
            TestScriptRuleParamComponent dst = new TestScriptRuleParamComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRuleParamComponent)) {
                return false;
            }
            TestScriptRuleParamComponent o = (TestScriptRuleParamComponent)other;
            return TestScriptRuleParamComponent.compareDeep(this.name, o.name, true) && TestScriptRuleParamComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRuleParamComponent)) {
                return false;
            }
            TestScriptRuleParamComponent o = (TestScriptRuleParamComponent)other;
            return TestScriptRuleParamComponent.compareValues(this.name, o.name, true) && TestScriptRuleParamComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.rule.param";
        }
    }

    @Block
    public static class TestScriptRuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resource", type={}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Assert rule resource reference", formalDefinition="Reference to the resource (containing the contents of the rule needed for assertions).")
        protected Reference resource;
        protected Resource resourceTarget;
        @Child(name="param", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rule parameter template", formalDefinition="Each rule template can take one or more parameters for rule evaluation.")
        protected List<TestScriptRuleParamComponent> param;
        private static final long serialVersionUID = -524260474L;

        public TestScriptRuleComponent() {
        }

        public TestScriptRuleComponent(Reference resource) {
            this.resource = resource;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptRuleComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public TestScriptRuleComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public TestScriptRuleComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        public List<TestScriptRuleParamComponent> getParam() {
            if (this.param == null) {
                this.param = new ArrayList<TestScriptRuleParamComponent>();
            }
            return this.param;
        }

        public boolean hasParam() {
            if (this.param == null) {
                return false;
            }
            for (TestScriptRuleParamComponent item : this.param) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptRuleParamComponent addParam() {
            TestScriptRuleParamComponent t = new TestScriptRuleParamComponent();
            if (this.param == null) {
                this.param = new ArrayList<TestScriptRuleParamComponent>();
            }
            this.param.add(t);
            return t;
        }

        public TestScriptRuleComponent addParam(TestScriptRuleParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.param == null) {
                this.param = new ArrayList<TestScriptRuleParamComponent>();
            }
            this.param.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("resource", "Reference(Any)", "Reference to the resource (containing the contents of the rule needed for assertions).", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("param", "", "Each rule template can take one or more parameters for rule evaluation.", 0, Integer.MAX_VALUE, this.param));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resource;
                    }
                    return baseArray;
                }
                case 106436749: {
                    return this.param == null ? new Base[]{} : this.param.toArray(new Base[this.param.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    this.resource = this.castToReference(value);
                    break;
                }
                case 106436749: {
                    this.getParam().add((TestScriptRuleParamComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else if (name.equals("param")) {
                this.getParam().add((TestScriptRuleParamComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return this.getResource();
                }
                case 106436749: {
                    return this.addParam();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            if (name.equals("param")) {
                return this.addParam();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptRuleComponent copy() {
            TestScriptRuleComponent dst = new TestScriptRuleComponent();
            this.copyValues(dst);
            Reference reference = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.param != null) {
                dst.param = new ArrayList<TestScriptRuleParamComponent>();
                for (TestScriptRuleParamComponent i : this.param) {
                    dst.param.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRuleComponent)) {
                return false;
            }
            TestScriptRuleComponent o = (TestScriptRuleComponent)other;
            return TestScriptRuleComponent.compareDeep(this.resource, o.resource, true) && TestScriptRuleComponent.compareDeep(this.param, o.param, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptRuleComponent)) {
                return false;
            }
            TestScriptRuleComponent o = (TestScriptRuleComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.param != null && !this.param.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.rule";
        }
    }

    @Block
    public static class TestScriptVariableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Descriptive name for this variable", formalDefinition="Descriptive name for this variable.")
        protected StringType name;
        @Child(name="defaultValue", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Default, hard-coded, or user-defined value for this variable", formalDefinition="A default, hard-coded, or user-defined value for this variable.")
        protected StringType defaultValue;
        @Child(name="headerField", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="HTTP header field name for source", formalDefinition="Will be used to grab the HTTP header field value from the headers that sourceId is pointing to.")
        protected StringType headerField;
        @Child(name="path", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="XPath or JSONPath against the fixture body", formalDefinition="XPath or JSONPath against the fixture body.  When variables are defined, either headerField must be specified or path, but not both.")
        protected StringType path;
        @Child(name="sourceId", type={IdType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixture Id of source expression or headerField within this variable", formalDefinition="Fixture to evaluate the XPath/JSONPath expression or the headerField  against within this variable.")
        protected IdType sourceId;
        private static final long serialVersionUID = 1821729272L;

        public TestScriptVariableComponent() {
        }

        public TestScriptVariableComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptVariableComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptVariableComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDefaultValueElement() {
            if (this.defaultValue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.defaultValue");
                }
                if (Configuration.doAutoCreate()) {
                    this.defaultValue = new StringType();
                }
            }
            return this.defaultValue;
        }

        public boolean hasDefaultValueElement() {
            return this.defaultValue != null && !this.defaultValue.isEmpty();
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null && !this.defaultValue.isEmpty();
        }

        public TestScriptVariableComponent setDefaultValueElement(StringType value) {
            this.defaultValue = value;
            return this;
        }

        public String getDefaultValue() {
            return this.defaultValue == null ? null : (String)this.defaultValue.getValue();
        }

        public TestScriptVariableComponent setDefaultValue(String value) {
            if (Utilities.noString((String)value)) {
                this.defaultValue = null;
            } else {
                if (this.defaultValue == null) {
                    this.defaultValue = new StringType();
                }
                this.defaultValue.setValue(value);
            }
            return this;
        }

        public StringType getHeaderFieldElement() {
            if (this.headerField == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.headerField");
                }
                if (Configuration.doAutoCreate()) {
                    this.headerField = new StringType();
                }
            }
            return this.headerField;
        }

        public boolean hasHeaderFieldElement() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public boolean hasHeaderField() {
            return this.headerField != null && !this.headerField.isEmpty();
        }

        public TestScriptVariableComponent setHeaderFieldElement(StringType value) {
            this.headerField = value;
            return this;
        }

        public String getHeaderField() {
            return this.headerField == null ? null : (String)this.headerField.getValue();
        }

        public TestScriptVariableComponent setHeaderField(String value) {
            if (Utilities.noString((String)value)) {
                this.headerField = null;
            } else {
                if (this.headerField == null) {
                    this.headerField = new StringType();
                }
                this.headerField.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public TestScriptVariableComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public TestScriptVariableComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptVariableComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public TestScriptVariableComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public TestScriptVariableComponent setSourceId(String value) {
            if (Utilities.noString((String)value)) {
                this.sourceId = null;
            } else {
                if (this.sourceId == null) {
                    this.sourceId = new IdType();
                }
                this.sourceId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "Descriptive name for this variable.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("defaultValue", "string", "A default, hard-coded, or user-defined value for this variable.", 0, Integer.MAX_VALUE, this.defaultValue));
            childrenList.add(new Property("headerField", "string", "Will be used to grab the HTTP header field value from the headers that sourceId is pointing to.", 0, Integer.MAX_VALUE, this.headerField));
            childrenList.add(new Property("path", "string", "XPath or JSONPath against the fixture body.  When variables are defined, either headerField must be specified or path, but not both.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("sourceId", "id", "Fixture to evaluate the XPath/JSONPath expression or the headerField  against within this variable.", 0, Integer.MAX_VALUE, this.sourceId));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -659125328: {
                    Base[] baseArray;
                    if (this.defaultValue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.defaultValue;
                    }
                    return baseArray;
                }
                case 1160732269: {
                    Base[] baseArray;
                    if (this.headerField == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.headerField;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.path;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.sourceId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -659125328: {
                    this.defaultValue = this.castToString(value);
                    break;
                }
                case 1160732269: {
                    this.headerField = this.castToString(value);
                    break;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case 1746327190: {
                    this.sourceId = this.castToId(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("defaultValue")) {
                this.defaultValue = this.castToString(value);
            } else if (name.equals("headerField")) {
                this.headerField = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = this.castToId(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -659125328: {
                    throw new FHIRException("Cannot make property defaultValue as it is not a complex type");
                }
                case 1160732269: {
                    throw new FHIRException("Cannot make property headerField as it is not a complex type");
                }
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case 1746327190: {
                    throw new FHIRException("Cannot make property sourceId as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals("defaultValue")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.defaultValue");
            }
            if (name.equals("headerField")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.headerField");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.path");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.sourceId");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptVariableComponent copy() {
            TestScriptVariableComponent dst = new TestScriptVariableComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.defaultValue = this.defaultValue == null ? null : this.defaultValue.copy();
            dst.headerField = this.headerField == null ? null : this.headerField.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptVariableComponent)) {
                return false;
            }
            TestScriptVariableComponent o = (TestScriptVariableComponent)other;
            return TestScriptVariableComponent.compareDeep(this.name, o.name, true) && TestScriptVariableComponent.compareDeep(this.defaultValue, o.defaultValue, true) && TestScriptVariableComponent.compareDeep(this.headerField, o.headerField, true) && TestScriptVariableComponent.compareDeep(this.path, o.path, true) && TestScriptVariableComponent.compareDeep(this.sourceId, o.sourceId, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptVariableComponent)) {
                return false;
            }
            TestScriptVariableComponent o = (TestScriptVariableComponent)other;
            return TestScriptVariableComponent.compareValues(this.name, o.name, true) && TestScriptVariableComponent.compareValues(this.defaultValue, o.defaultValue, true) && TestScriptVariableComponent.compareValues(this.headerField, o.headerField, true) && TestScriptVariableComponent.compareValues(this.path, o.path, true) && TestScriptVariableComponent.compareValues(this.sourceId, o.sourceId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.defaultValue != null && !this.defaultValue.isEmpty() || this.headerField != null && !this.headerField.isEmpty() || this.path != null && !this.path.isEmpty() || this.sourceId != null && !this.sourceId.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.variable";
        }
    }

    @Block
    public static class TestScriptFixtureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="autocreate", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not to implicitly create the fixture during setup", formalDefinition="Whether or not to implicitly create the fixture during setup. If true, the fixture is automatically created on each server being tested during setup, therefore no create operation is required for this fixture in the TestScript.setup section.")
        protected BooleanType autocreate;
        @Child(name="autodelete", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not to implicitly delete the fixture during teardown", formalDefinition="Whether or not to implicitly delete the fixture during teardown If true, the fixture is automatically deleted on each server being tested during teardown, therefore no delete operation is required for this fixture in the TestScript.teardown section.")
        protected BooleanType autodelete;
        @Child(name="resource", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference of the resource", formalDefinition="Reference to the resource (containing the contents of the resource needed for operations).")
        protected Reference resource;
        protected Resource resourceTarget;
        private static final long serialVersionUID = 1110683307L;

        public BooleanType getAutocreateElement() {
            if (this.autocreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptFixtureComponent.autocreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.autocreate = new BooleanType();
                }
            }
            return this.autocreate;
        }

        public boolean hasAutocreateElement() {
            return this.autocreate != null && !this.autocreate.isEmpty();
        }

        public boolean hasAutocreate() {
            return this.autocreate != null && !this.autocreate.isEmpty();
        }

        public TestScriptFixtureComponent setAutocreateElement(BooleanType value) {
            this.autocreate = value;
            return this;
        }

        public boolean getAutocreate() {
            return this.autocreate == null || this.autocreate.isEmpty() ? false : (Boolean)this.autocreate.getValue();
        }

        public TestScriptFixtureComponent setAutocreate(boolean value) {
            if (this.autocreate == null) {
                this.autocreate = new BooleanType();
            }
            this.autocreate.setValue((Object)value);
            return this;
        }

        public BooleanType getAutodeleteElement() {
            if (this.autodelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptFixtureComponent.autodelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.autodelete = new BooleanType();
                }
            }
            return this.autodelete;
        }

        public boolean hasAutodeleteElement() {
            return this.autodelete != null && !this.autodelete.isEmpty();
        }

        public boolean hasAutodelete() {
            return this.autodelete != null && !this.autodelete.isEmpty();
        }

        public TestScriptFixtureComponent setAutodeleteElement(BooleanType value) {
            this.autodelete = value;
            return this;
        }

        public boolean getAutodelete() {
            return this.autodelete == null || this.autodelete.isEmpty() ? false : (Boolean)this.autodelete.getValue();
        }

        public TestScriptFixtureComponent setAutodelete(boolean value) {
            if (this.autodelete == null) {
                this.autodelete = new BooleanType();
            }
            this.autodelete.setValue((Object)value);
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptFixtureComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public TestScriptFixtureComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public TestScriptFixtureComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("autocreate", "boolean", "Whether or not to implicitly create the fixture during setup. If true, the fixture is automatically created on each server being tested during setup, therefore no create operation is required for this fixture in the TestScript.setup section.", 0, Integer.MAX_VALUE, this.autocreate));
            childrenList.add(new Property("autodelete", "boolean", "Whether or not to implicitly delete the fixture during teardown If true, the fixture is automatically deleted on each server being tested during teardown, therefore no delete operation is required for this fixture in the TestScript.teardown section.", 0, Integer.MAX_VALUE, this.autodelete));
            childrenList.add(new Property("resource", "Reference(Any)", "Reference to the resource (containing the contents of the resource needed for operations).", 0, Integer.MAX_VALUE, this.resource));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    Base[] baseArray;
                    if (this.autocreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.autocreate;
                    }
                    return baseArray;
                }
                case 89990170: {
                    Base[] baseArray;
                    if (this.autodelete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.autodelete;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    this.autocreate = this.castToBoolean(value);
                    break;
                }
                case 89990170: {
                    this.autodelete = this.castToBoolean(value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("autocreate")) {
                this.autocreate = this.castToBoolean(value);
            } else if (name.equals("autodelete")) {
                this.autodelete = this.castToBoolean(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 73154411: {
                    throw new FHIRException("Cannot make property autocreate as it is not a complex type");
                }
                case 89990170: {
                    throw new FHIRException("Cannot make property autodelete as it is not a complex type");
                }
                case -341064690: {
                    return this.getResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("autocreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.autocreate");
            }
            if (name.equals("autodelete")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.autodelete");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptFixtureComponent copy() {
            TestScriptFixtureComponent dst = new TestScriptFixtureComponent();
            this.copyValues(dst);
            dst.autocreate = this.autocreate == null ? null : this.autocreate.copy();
            dst.autodelete = this.autodelete == null ? null : this.autodelete.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptFixtureComponent)) {
                return false;
            }
            TestScriptFixtureComponent o = (TestScriptFixtureComponent)other;
            return TestScriptFixtureComponent.compareDeep(this.autocreate, o.autocreate, true) && TestScriptFixtureComponent.compareDeep(this.autodelete, o.autodelete, true) && TestScriptFixtureComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptFixtureComponent)) {
                return false;
            }
            TestScriptFixtureComponent o = (TestScriptFixtureComponent)other;
            return TestScriptFixtureComponent.compareValues(this.autocreate, o.autocreate, true) && TestScriptFixtureComponent.compareValues(this.autodelete, o.autodelete, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.autocreate != null && !this.autocreate.isEmpty() || this.autodelete != null && !this.autodelete.isEmpty() || this.resource != null && !this.resource.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.fixture";
        }
    }

    @Block
    public static class TestScriptMetadataCapabilityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="required", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Are the capabilities required?", formalDefinition="Whether or not the test execution will require the given capabilities of the server in order for this test script to execute.")
        protected BooleanType required;
        @Child(name="validated", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Are the capabilities validated?", formalDefinition="Whether or not the test execution will validate the given capabilities of the server in order for this test script to execute.")
        protected BooleanType validated;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The expected capabilities of the server", formalDefinition="Description of the capabilities that this test script is requiring the server to support.")
        protected StringType description;
        @Child(name="origin", type={IntegerType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Which origin server these requirements apply to", formalDefinition="Which origin server these requirements apply to.")
        protected List<IntegerType> origin;
        @Child(name="destination", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which server these requirements apply to", formalDefinition="Which server these requirements apply to.")
        protected IntegerType destination;
        @Child(name="link", type={UriType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Links to the FHIR specification", formalDefinition="Links to the FHIR specification that describes this interaction and the resources involved in more detail.")
        protected List<UriType> link;
        @Child(name="conformance", type={Conformance.class}, order=7, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Required Conformance", formalDefinition="Minimum conformance required of server for test script to execute successfully.   If server does not meet at a minimum the reference conformance definition, then all tests in this script are skipped.")
        protected Reference conformance;
        protected Conformance conformanceTarget;
        private static final long serialVersionUID = 500671983L;

        public TestScriptMetadataCapabilityComponent() {
        }

        public TestScriptMetadataCapabilityComponent(Reference conformance) {
            this.conformance = conformance;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public TestScriptMetadataCapabilityComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public BooleanType getValidatedElement() {
            if (this.validated == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.validated");
                }
                if (Configuration.doAutoCreate()) {
                    this.validated = new BooleanType();
                }
            }
            return this.validated;
        }

        public boolean hasValidatedElement() {
            return this.validated != null && !this.validated.isEmpty();
        }

        public boolean hasValidated() {
            return this.validated != null && !this.validated.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setValidatedElement(BooleanType value) {
            this.validated = value;
            return this;
        }

        public boolean getValidated() {
            return this.validated == null || this.validated.isEmpty() ? false : (Boolean)this.validated.getValue();
        }

        public TestScriptMetadataCapabilityComponent setValidated(boolean value) {
            if (this.validated == null) {
                this.validated = new BooleanType();
            }
            this.validated.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptMetadataCapabilityComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<IntegerType> getOrigin() {
            if (this.origin == null) {
                this.origin = new ArrayList<IntegerType>();
            }
            return this.origin;
        }

        public boolean hasOrigin() {
            if (this.origin == null) {
                return false;
            }
            for (IntegerType item : this.origin) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IntegerType addOriginElement() {
            IntegerType t = new IntegerType();
            if (this.origin == null) {
                this.origin = new ArrayList<IntegerType>();
            }
            this.origin.add(t);
            return t;
        }

        public TestScriptMetadataCapabilityComponent addOrigin(int value) {
            IntegerType t = new IntegerType();
            t.setValue((Object)value);
            if (this.origin == null) {
                this.origin = new ArrayList<IntegerType>();
            }
            this.origin.add(t);
            return this;
        }

        public boolean hasOrigin(int value) {
            if (this.origin == null) {
                return false;
            }
            for (IntegerType v : this.origin) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public IntegerType getDestinationElement() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new IntegerType();
                }
            }
            return this.destination;
        }

        public boolean hasDestinationElement() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setDestinationElement(IntegerType value) {
            this.destination = value;
            return this;
        }

        public int getDestination() {
            return this.destination == null || this.destination.isEmpty() ? 0 : (Integer)this.destination.getValue();
        }

        public TestScriptMetadataCapabilityComponent setDestination(int value) {
            if (this.destination == null) {
                this.destination = new IntegerType();
            }
            this.destination.setValue((Object)value);
            return this;
        }

        public List<UriType> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<UriType>();
            }
            return this.link;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (UriType item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addLinkElement() {
            UriType t = new UriType();
            if (this.link == null) {
                this.link = new ArrayList<UriType>();
            }
            this.link.add(t);
            return t;
        }

        public TestScriptMetadataCapabilityComponent addLink(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.link == null) {
                this.link = new ArrayList<UriType>();
            }
            this.link.add(t);
            return this;
        }

        public boolean hasLink(String value) {
            if (this.link == null) {
                return false;
            }
            for (UriType v : this.link) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Reference getConformance() {
            if (this.conformance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.conformance");
                }
                if (Configuration.doAutoCreate()) {
                    this.conformance = new Reference();
                }
            }
            return this.conformance;
        }

        public boolean hasConformance() {
            return this.conformance != null && !this.conformance.isEmpty();
        }

        public TestScriptMetadataCapabilityComponent setConformance(Reference value) {
            this.conformance = value;
            return this;
        }

        public Conformance getConformanceTarget() {
            if (this.conformanceTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataCapabilityComponent.conformance");
                }
                if (Configuration.doAutoCreate()) {
                    this.conformanceTarget = new Conformance();
                }
            }
            return this.conformanceTarget;
        }

        public TestScriptMetadataCapabilityComponent setConformanceTarget(Conformance value) {
            this.conformanceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("required", "boolean", "Whether or not the test execution will require the given capabilities of the server in order for this test script to execute.", 0, Integer.MAX_VALUE, this.required));
            childrenList.add(new Property("validated", "boolean", "Whether or not the test execution will validate the given capabilities of the server in order for this test script to execute.", 0, Integer.MAX_VALUE, this.validated));
            childrenList.add(new Property(TestScript.SP_DESCRIPTION, "string", "Description of the capabilities that this test script is requiring the server to support.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("origin", "integer", "Which origin server these requirements apply to.", 0, Integer.MAX_VALUE, this.origin));
            childrenList.add(new Property("destination", "integer", "Which server these requirements apply to.", 0, Integer.MAX_VALUE, this.destination));
            childrenList.add(new Property("link", "uri", "Links to the FHIR specification that describes this interaction and the resources involved in more detail.", 0, Integer.MAX_VALUE, this.link));
            childrenList.add(new Property("conformance", "Reference(Conformance)", "Minimum conformance required of server for test script to execute successfully.   If server does not meet at a minimum the reference conformance definition, then all tests in this script are skipped.", 0, Integer.MAX_VALUE, this.conformance));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.required;
                    }
                    return baseArray;
                }
                case -1109784050: {
                    Base[] baseArray;
                    if (this.validated == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.validated;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    return this.origin == null ? new Base[]{} : this.origin.toArray(new Base[this.origin.size()]);
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.destination;
                    }
                    return baseArray;
                }
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case 1374858133: {
                    Base[] baseArray;
                    if (this.conformance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.conformance;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    this.required = this.castToBoolean(value);
                    break;
                }
                case -1109784050: {
                    this.validated = this.castToBoolean(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -1008619738: {
                    this.getOrigin().add(this.castToInteger(value));
                    break;
                }
                case -1429847026: {
                    this.destination = this.castToInteger(value);
                    break;
                }
                case 3321850: {
                    this.getLink().add(this.castToUri(value));
                    break;
                }
                case 1374858133: {
                    this.conformance = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("required")) {
                this.required = this.castToBoolean(value);
            } else if (name.equals("validated")) {
                this.validated = this.castToBoolean(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("origin")) {
                this.getOrigin().add(this.castToInteger(value));
            } else if (name.equals("destination")) {
                this.destination = this.castToInteger(value);
            } else if (name.equals("link")) {
                this.getLink().add(this.castToUri(value));
            } else if (name.equals("conformance")) {
                this.conformance = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -393139297: {
                    throw new FHIRException("Cannot make property required as it is not a complex type");
                }
                case -1109784050: {
                    throw new FHIRException("Cannot make property validated as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -1008619738: {
                    throw new FHIRException("Cannot make property origin as it is not a complex type");
                }
                case -1429847026: {
                    throw new FHIRException("Cannot make property destination as it is not a complex type");
                }
                case 3321850: {
                    throw new FHIRException("Cannot make property link as it is not a complex type");
                }
                case 1374858133: {
                    return this.getConformance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.required");
            }
            if (name.equals("validated")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.validated");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
            }
            if (name.equals("origin")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.origin");
            }
            if (name.equals("destination")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.destination");
            }
            if (name.equals("link")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.link");
            }
            if (name.equals("conformance")) {
                this.conformance = new Reference();
                return this.conformance;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptMetadataCapabilityComponent copy() {
            TestScriptMetadataCapabilityComponent dst = new TestScriptMetadataCapabilityComponent();
            this.copyValues(dst);
            dst.required = this.required == null ? null : this.required.copy();
            dst.validated = this.validated == null ? null : this.validated.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.origin != null) {
                dst.origin = new ArrayList<IntegerType>();
                for (IntegerType integerType : this.origin) {
                    dst.origin.add(integerType.copy());
                }
            }
            IntegerType integerType = dst.destination = this.destination == null ? null : this.destination.copy();
            if (this.link != null) {
                dst.link = new ArrayList<UriType>();
                for (UriType uriType : this.link) {
                    dst.link.add(uriType.copy());
                }
            }
            dst.conformance = this.conformance == null ? null : this.conformance.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptMetadataCapabilityComponent)) {
                return false;
            }
            TestScriptMetadataCapabilityComponent o = (TestScriptMetadataCapabilityComponent)other;
            return TestScriptMetadataCapabilityComponent.compareDeep(this.required, o.required, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.validated, o.validated, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.description, o.description, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.origin, o.origin, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.destination, o.destination, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.link, o.link, true) && TestScriptMetadataCapabilityComponent.compareDeep(this.conformance, o.conformance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptMetadataCapabilityComponent)) {
                return false;
            }
            TestScriptMetadataCapabilityComponent o = (TestScriptMetadataCapabilityComponent)other;
            return TestScriptMetadataCapabilityComponent.compareValues(this.required, o.required, true) && TestScriptMetadataCapabilityComponent.compareValues(this.validated, o.validated, true) && TestScriptMetadataCapabilityComponent.compareValues(this.description, o.description, true) && TestScriptMetadataCapabilityComponent.compareValues(this.origin, o.origin, true) && TestScriptMetadataCapabilityComponent.compareValues(this.destination, o.destination, true) && TestScriptMetadataCapabilityComponent.compareValues(this.link, o.link, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.required != null && !this.required.isEmpty() || this.validated != null && !this.validated.isEmpty() || this.description != null && !this.description.isEmpty() || this.origin != null && !this.origin.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.link != null && !this.link.isEmpty() || this.conformance != null && !this.conformance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.metadata.capability";
        }
    }

    @Block
    public static class TestScriptMetadataLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="url", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="URL to the specification", formalDefinition="URL to a particular requirement or feature within the FHIR specification.")
        protected UriType url;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short description", formalDefinition="Short description of the link.")
        protected StringType description;
        private static final long serialVersionUID = 213372298L;

        public TestScriptMetadataLinkComponent() {
        }

        public TestScriptMetadataLinkComponent(UriType url) {
            this.url = url;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataLinkComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public TestScriptMetadataLinkComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public TestScriptMetadataLinkComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptMetadataLinkComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestScriptMetadataLinkComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestScriptMetadataLinkComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_URL, "uri", "URL to a particular requirement or feature within the FHIR specification.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property(TestScript.SP_DESCRIPTION, "string", "Short description of the link.", 0, Integer.MAX_VALUE, this.description));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_URL)) {
                this.url = this.castToUri(value);
            } else if (name.equals(TestScript.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.url");
            }
            if (name.equals(TestScript.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.description");
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptMetadataLinkComponent copy() {
            TestScriptMetadataLinkComponent dst = new TestScriptMetadataLinkComponent();
            this.copyValues(dst);
            dst.url = this.url == null ? null : this.url.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptMetadataLinkComponent)) {
                return false;
            }
            TestScriptMetadataLinkComponent o = (TestScriptMetadataLinkComponent)other;
            return TestScriptMetadataLinkComponent.compareDeep(this.url, o.url, true) && TestScriptMetadataLinkComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptMetadataLinkComponent)) {
                return false;
            }
            TestScriptMetadataLinkComponent o = (TestScriptMetadataLinkComponent)other;
            return TestScriptMetadataLinkComponent.compareValues(this.url, o.url, true) && TestScriptMetadataLinkComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.description != null && !this.description.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.metadata.link";
        }
    }

    @Block
    public static class TestScriptMetadataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="link", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Links to the FHIR specification", formalDefinition="A link to the FHIR specification that this test is covering.")
        protected List<TestScriptMetadataLinkComponent> link;
        @Child(name="capability", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Capabilities  that are assumed to function correctly on the FHIR server being tested", formalDefinition="Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.")
        protected List<TestScriptMetadataCapabilityComponent> capability;
        private static final long serialVersionUID = 745183328L;

        public List<TestScriptMetadataLinkComponent> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<TestScriptMetadataLinkComponent>();
            }
            return this.link;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (TestScriptMetadataLinkComponent item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptMetadataLinkComponent addLink() {
            TestScriptMetadataLinkComponent t = new TestScriptMetadataLinkComponent();
            if (this.link == null) {
                this.link = new ArrayList<TestScriptMetadataLinkComponent>();
            }
            this.link.add(t);
            return t;
        }

        public TestScriptMetadataComponent addLink(TestScriptMetadataLinkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.link == null) {
                this.link = new ArrayList<TestScriptMetadataLinkComponent>();
            }
            this.link.add(t);
            return this;
        }

        public List<TestScriptMetadataCapabilityComponent> getCapability() {
            if (this.capability == null) {
                this.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
            }
            return this.capability;
        }

        public boolean hasCapability() {
            if (this.capability == null) {
                return false;
            }
            for (TestScriptMetadataCapabilityComponent item : this.capability) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestScriptMetadataCapabilityComponent addCapability() {
            TestScriptMetadataCapabilityComponent t = new TestScriptMetadataCapabilityComponent();
            if (this.capability == null) {
                this.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
            }
            this.capability.add(t);
            return t;
        }

        public TestScriptMetadataComponent addCapability(TestScriptMetadataCapabilityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.capability == null) {
                this.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
            }
            this.capability.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("link", "", "A link to the FHIR specification that this test is covering.", 0, Integer.MAX_VALUE, this.link));
            childrenList.add(new Property("capability", "", "Capabilities that must exist and are assumed to function correctly on the FHIR server being tested.", 0, Integer.MAX_VALUE, this.capability));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case -783669992: {
                    return this.capability == null ? new Base[]{} : this.capability.toArray(new Base[this.capability.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    this.getLink().add((TestScriptMetadataLinkComponent)value);
                    break;
                }
                case -783669992: {
                    this.getCapability().add((TestScriptMetadataCapabilityComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("link")) {
                this.getLink().add((TestScriptMetadataLinkComponent)value);
            } else if (name.equals("capability")) {
                this.getCapability().add((TestScriptMetadataCapabilityComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.addLink();
                }
                case -783669992: {
                    return this.addCapability();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("link")) {
                return this.addLink();
            }
            if (name.equals("capability")) {
                return this.addCapability();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptMetadataComponent copy() {
            TestScriptMetadataComponent dst = new TestScriptMetadataComponent();
            this.copyValues(dst);
            if (this.link != null) {
                dst.link = new ArrayList<TestScriptMetadataLinkComponent>();
                for (TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : this.link) {
                    dst.link.add(testScriptMetadataLinkComponent.copy());
                }
            }
            if (this.capability != null) {
                dst.capability = new ArrayList<TestScriptMetadataCapabilityComponent>();
                for (TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : this.capability) {
                    dst.capability.add(testScriptMetadataCapabilityComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptMetadataComponent)) {
                return false;
            }
            TestScriptMetadataComponent o = (TestScriptMetadataComponent)other;
            return TestScriptMetadataComponent.compareDeep(this.link, o.link, true) && TestScriptMetadataComponent.compareDeep(this.capability, o.capability, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptMetadataComponent)) {
                return false;
            }
            TestScriptMetadataComponent o = (TestScriptMetadataComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.link != null && !this.link.isEmpty() || this.capability != null && !this.capability.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.metadata";
        }
    }

    @Block
    public static class TestScriptDestinationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="index", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The index of the abstract destination server starting at 1", formalDefinition="Abstract name given to a destination server in this test script.  The name is provided as a number starting at 1.")
        protected IntegerType index;
        @Child(name="profile", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="FHIR-Server | FHIR-SDC-FormManager | FHIR-SDC-FormReceiver | FHIR-SDC-FormProcessor", formalDefinition="The type of destination profile the test system supports.")
        protected Coding profile;
        private static final long serialVersionUID = -1239935149L;

        public TestScriptDestinationComponent() {
        }

        public TestScriptDestinationComponent(IntegerType index, Coding profile) {
            this.index = index;
            this.profile = profile;
        }

        public IntegerType getIndexElement() {
            if (this.index == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptDestinationComponent.index");
                }
                if (Configuration.doAutoCreate()) {
                    this.index = new IntegerType();
                }
            }
            return this.index;
        }

        public boolean hasIndexElement() {
            return this.index != null && !this.index.isEmpty();
        }

        public boolean hasIndex() {
            return this.index != null && !this.index.isEmpty();
        }

        public TestScriptDestinationComponent setIndexElement(IntegerType value) {
            this.index = value;
            return this;
        }

        public int getIndex() {
            return this.index == null || this.index.isEmpty() ? 0 : (Integer)this.index.getValue();
        }

        public TestScriptDestinationComponent setIndex(int value) {
            if (this.index == null) {
                this.index = new IntegerType();
            }
            this.index.setValue((Object)value);
            return this;
        }

        public Coding getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptDestinationComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Coding();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public TestScriptDestinationComponent setProfile(Coding value) {
            this.profile = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("index", "integer", "Abstract name given to a destination server in this test script.  The name is provided as a number starting at 1.", 0, Integer.MAX_VALUE, this.index));
            childrenList.add(new Property("profile", "Coding", "The type of destination profile the test system supports.", 0, Integer.MAX_VALUE, this.profile));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    Base[] baseArray;
                    if (this.index == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.index;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    this.index = this.castToInteger(value);
                    break;
                }
                case -309425751: {
                    this.profile = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("index")) {
                this.index = this.castToInteger(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    throw new FHIRException("Cannot make property index as it is not a complex type");
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("index")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.index");
            }
            if (name.equals("profile")) {
                this.profile = new Coding();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptDestinationComponent copy() {
            TestScriptDestinationComponent dst = new TestScriptDestinationComponent();
            this.copyValues(dst);
            dst.index = this.index == null ? null : this.index.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptDestinationComponent)) {
                return false;
            }
            TestScriptDestinationComponent o = (TestScriptDestinationComponent)other;
            return TestScriptDestinationComponent.compareDeep(this.index, o.index, true) && TestScriptDestinationComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptDestinationComponent)) {
                return false;
            }
            TestScriptDestinationComponent o = (TestScriptDestinationComponent)other;
            return TestScriptDestinationComponent.compareValues(this.index, o.index, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.index != null && !this.index.isEmpty() || this.profile != null && !this.profile.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.destination";
        }
    }

    @Block
    public static class TestScriptOriginComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="index", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The index of the abstract origin server starting at 1", formalDefinition="Abstract name given to an origin server in this test script.  The name is provided as a number starting at 1.")
        protected IntegerType index;
        @Child(name="profile", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="FHIR-Client | FHIR-SDC-FormFiller", formalDefinition="The type of origin profile the test system supports.")
        protected Coding profile;
        private static final long serialVersionUID = -1239935149L;

        public TestScriptOriginComponent() {
        }

        public TestScriptOriginComponent(IntegerType index, Coding profile) {
            this.index = index;
            this.profile = profile;
        }

        public IntegerType getIndexElement() {
            if (this.index == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptOriginComponent.index");
                }
                if (Configuration.doAutoCreate()) {
                    this.index = new IntegerType();
                }
            }
            return this.index;
        }

        public boolean hasIndexElement() {
            return this.index != null && !this.index.isEmpty();
        }

        public boolean hasIndex() {
            return this.index != null && !this.index.isEmpty();
        }

        public TestScriptOriginComponent setIndexElement(IntegerType value) {
            this.index = value;
            return this;
        }

        public int getIndex() {
            return this.index == null || this.index.isEmpty() ? 0 : (Integer)this.index.getValue();
        }

        public TestScriptOriginComponent setIndex(int value) {
            if (this.index == null) {
                this.index = new IntegerType();
            }
            this.index.setValue((Object)value);
            return this;
        }

        public Coding getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptOriginComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Coding();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public TestScriptOriginComponent setProfile(Coding value) {
            this.profile = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("index", "integer", "Abstract name given to an origin server in this test script.  The name is provided as a number starting at 1.", 0, Integer.MAX_VALUE, this.index));
            childrenList.add(new Property("profile", "Coding", "The type of origin profile the test system supports.", 0, Integer.MAX_VALUE, this.profile));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    Base[] baseArray;
                    if (this.index == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.index;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    this.index = this.castToInteger(value);
                    break;
                }
                case -309425751: {
                    this.profile = this.castToCoding(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("index")) {
                this.index = this.castToInteger(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 100346066: {
                    throw new FHIRException("Cannot make property index as it is not a complex type");
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("index")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.index");
            }
            if (name.equals("profile")) {
                this.profile = new Coding();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptOriginComponent copy() {
            TestScriptOriginComponent dst = new TestScriptOriginComponent();
            this.copyValues(dst);
            dst.index = this.index == null ? null : this.index.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptOriginComponent)) {
                return false;
            }
            TestScriptOriginComponent o = (TestScriptOriginComponent)other;
            return TestScriptOriginComponent.compareDeep(this.index, o.index, true) && TestScriptOriginComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptOriginComponent)) {
                return false;
            }
            TestScriptOriginComponent o = (TestScriptOriginComponent)other;
            return TestScriptOriginComponent.compareValues(this.index, o.index, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.index != null && !this.index.isEmpty() || this.profile != null && !this.profile.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.origin";
        }
    }

    @Block
    public static class TestScriptContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the Test Script.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestScriptContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestScriptContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestScriptContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public TestScriptContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(TestScript.SP_NAME, "string", "The name of an individual to contact regarding the Test Script.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(TestScript.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type TestScript.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public TestScriptContactComponent copy() {
            TestScriptContactComponent dst = new TestScriptContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TestScriptContactComponent)) {
                return false;
            }
            TestScriptContactComponent o = (TestScriptContactComponent)other;
            return TestScriptContactComponent.compareDeep(this.name, o.name, true) && TestScriptContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TestScriptContactComponent)) {
                return false;
            }
            TestScriptContactComponent o = (TestScriptContactComponent)other;
            return TestScriptContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "TestScript.contact";
        }
    }

    public static class AssertionResponseTypesEnumFactory
    implements EnumFactory<AssertionResponseTypes> {
        @Override
        public AssertionResponseTypes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("okay".equals(codeString)) {
                return AssertionResponseTypes.OKAY;
            }
            if ("created".equals(codeString)) {
                return AssertionResponseTypes.CREATED;
            }
            if ("noContent".equals(codeString)) {
                return AssertionResponseTypes.NOCONTENT;
            }
            if ("notModified".equals(codeString)) {
                return AssertionResponseTypes.NOTMODIFIED;
            }
            if ("bad".equals(codeString)) {
                return AssertionResponseTypes.BAD;
            }
            if ("forbidden".equals(codeString)) {
                return AssertionResponseTypes.FORBIDDEN;
            }
            if ("notFound".equals(codeString)) {
                return AssertionResponseTypes.NOTFOUND;
            }
            if ("methodNotAllowed".equals(codeString)) {
                return AssertionResponseTypes.METHODNOTALLOWED;
            }
            if ("conflict".equals(codeString)) {
                return AssertionResponseTypes.CONFLICT;
            }
            if ("gone".equals(codeString)) {
                return AssertionResponseTypes.GONE;
            }
            if ("preconditionFailed".equals(codeString)) {
                return AssertionResponseTypes.PRECONDITIONFAILED;
            }
            if ("unprocessable".equals(codeString)) {
                return AssertionResponseTypes.UNPROCESSABLE;
            }
            throw new IllegalArgumentException("Unknown AssertionResponseTypes code '" + codeString + "'");
        }

        public Enumeration<AssertionResponseTypes> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("okay".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.OKAY);
            }
            if ("created".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.CREATED);
            }
            if ("noContent".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NOCONTENT);
            }
            if ("notModified".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NOTMODIFIED);
            }
            if ("bad".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.BAD);
            }
            if ("forbidden".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.FORBIDDEN);
            }
            if ("notFound".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.NOTFOUND);
            }
            if ("methodNotAllowed".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.METHODNOTALLOWED);
            }
            if ("conflict".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.CONFLICT);
            }
            if ("gone".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.GONE);
            }
            if ("preconditionFailed".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.PRECONDITIONFAILED);
            }
            if ("unprocessable".equals(codeString)) {
                return new Enumeration<AssertionResponseTypes>(this, AssertionResponseTypes.UNPROCESSABLE);
            }
            throw new FHIRException("Unknown AssertionResponseTypes code '" + codeString + "'");
        }

        @Override
        public String toCode(AssertionResponseTypes code) {
            if (code == AssertionResponseTypes.OKAY) {
                return "okay";
            }
            if (code == AssertionResponseTypes.CREATED) {
                return "created";
            }
            if (code == AssertionResponseTypes.NOCONTENT) {
                return "noContent";
            }
            if (code == AssertionResponseTypes.NOTMODIFIED) {
                return "notModified";
            }
            if (code == AssertionResponseTypes.BAD) {
                return "bad";
            }
            if (code == AssertionResponseTypes.FORBIDDEN) {
                return "forbidden";
            }
            if (code == AssertionResponseTypes.NOTFOUND) {
                return "notFound";
            }
            if (code == AssertionResponseTypes.METHODNOTALLOWED) {
                return "methodNotAllowed";
            }
            if (code == AssertionResponseTypes.CONFLICT) {
                return "conflict";
            }
            if (code == AssertionResponseTypes.GONE) {
                return "gone";
            }
            if (code == AssertionResponseTypes.PRECONDITIONFAILED) {
                return "preconditionFailed";
            }
            if (code == AssertionResponseTypes.UNPROCESSABLE) {
                return "unprocessable";
            }
            return "?";
        }

        @Override
        public String toSystem(AssertionResponseTypes code) {
            return code.getSystem();
        }
    }

    public static enum AssertionResponseTypes {
        OKAY,
        CREATED,
        NOCONTENT,
        NOTMODIFIED,
        BAD,
        FORBIDDEN,
        NOTFOUND,
        METHODNOTALLOWED,
        CONFLICT,
        GONE,
        PRECONDITIONFAILED,
        UNPROCESSABLE,
        NULL;


        public static AssertionResponseTypes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("okay".equals(codeString)) {
                return OKAY;
            }
            if ("created".equals(codeString)) {
                return CREATED;
            }
            if ("noContent".equals(codeString)) {
                return NOCONTENT;
            }
            if ("notModified".equals(codeString)) {
                return NOTMODIFIED;
            }
            if ("bad".equals(codeString)) {
                return BAD;
            }
            if ("forbidden".equals(codeString)) {
                return FORBIDDEN;
            }
            if ("notFound".equals(codeString)) {
                return NOTFOUND;
            }
            if ("methodNotAllowed".equals(codeString)) {
                return METHODNOTALLOWED;
            }
            if ("conflict".equals(codeString)) {
                return CONFLICT;
            }
            if ("gone".equals(codeString)) {
                return GONE;
            }
            if ("preconditionFailed".equals(codeString)) {
                return PRECONDITIONFAILED;
            }
            if ("unprocessable".equals(codeString)) {
                return UNPROCESSABLE;
            }
            throw new FHIRException("Unknown AssertionResponseTypes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OKAY: {
                    return "okay";
                }
                case CREATED: {
                    return "created";
                }
                case NOCONTENT: {
                    return "noContent";
                }
                case NOTMODIFIED: {
                    return "notModified";
                }
                case BAD: {
                    return "bad";
                }
                case FORBIDDEN: {
                    return "forbidden";
                }
                case NOTFOUND: {
                    return "notFound";
                }
                case METHODNOTALLOWED: {
                    return "methodNotAllowed";
                }
                case CONFLICT: {
                    return "conflict";
                }
                case GONE: {
                    return "gone";
                }
                case PRECONDITIONFAILED: {
                    return "preconditionFailed";
                }
                case UNPROCESSABLE: {
                    return "unprocessable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OKAY: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case CREATED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NOCONTENT: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NOTMODIFIED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case BAD: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case FORBIDDEN: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NOTFOUND: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case METHODNOTALLOWED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case CONFLICT: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case GONE: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case PRECONDITIONFAILED: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case UNPROCESSABLE: {
                    return "http://hl7.org/fhir/assert-response-code-types";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OKAY: {
                    return "Response code is 200.";
                }
                case CREATED: {
                    return "Response code is 201.";
                }
                case NOCONTENT: {
                    return "Response code is 204.";
                }
                case NOTMODIFIED: {
                    return "Response code is 304.";
                }
                case BAD: {
                    return "Response code is 400.";
                }
                case FORBIDDEN: {
                    return "Response code is 403.";
                }
                case NOTFOUND: {
                    return "Response code is 404.";
                }
                case METHODNOTALLOWED: {
                    return "Response code is 405.";
                }
                case CONFLICT: {
                    return "Response code is 409.";
                }
                case GONE: {
                    return "Response code is 410.";
                }
                case PRECONDITIONFAILED: {
                    return "Response code is 412.";
                }
                case UNPROCESSABLE: {
                    return "Response code is 422.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OKAY: {
                    return "okay";
                }
                case CREATED: {
                    return "created";
                }
                case NOCONTENT: {
                    return "noContent";
                }
                case NOTMODIFIED: {
                    return "notModified";
                }
                case BAD: {
                    return "bad";
                }
                case FORBIDDEN: {
                    return "forbidden";
                }
                case NOTFOUND: {
                    return "notFound";
                }
                case METHODNOTALLOWED: {
                    return "methodNotAllowed";
                }
                case CONFLICT: {
                    return "conflict";
                }
                case GONE: {
                    return "gone";
                }
                case PRECONDITIONFAILED: {
                    return "preconditionFailed";
                }
                case UNPROCESSABLE: {
                    return "unprocessable";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AssertionOperatorTypeEnumFactory
    implements EnumFactory<AssertionOperatorType> {
        @Override
        public AssertionOperatorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("equals".equals(codeString)) {
                return AssertionOperatorType.EQUALS;
            }
            if ("notEquals".equals(codeString)) {
                return AssertionOperatorType.NOTEQUALS;
            }
            if ("in".equals(codeString)) {
                return AssertionOperatorType.IN;
            }
            if ("notIn".equals(codeString)) {
                return AssertionOperatorType.NOTIN;
            }
            if ("greaterThan".equals(codeString)) {
                return AssertionOperatorType.GREATERTHAN;
            }
            if ("lessThan".equals(codeString)) {
                return AssertionOperatorType.LESSTHAN;
            }
            if ("empty".equals(codeString)) {
                return AssertionOperatorType.EMPTY;
            }
            if ("notEmpty".equals(codeString)) {
                return AssertionOperatorType.NOTEMPTY;
            }
            if ("contains".equals(codeString)) {
                return AssertionOperatorType.CONTAINS;
            }
            if ("notContains".equals(codeString)) {
                return AssertionOperatorType.NOTCONTAINS;
            }
            throw new IllegalArgumentException("Unknown AssertionOperatorType code '" + codeString + "'");
        }

        public Enumeration<AssertionOperatorType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("equals".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.EQUALS);
            }
            if ("notEquals".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTEQUALS);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.IN);
            }
            if ("notIn".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTIN);
            }
            if ("greaterThan".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.GREATERTHAN);
            }
            if ("lessThan".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.LESSTHAN);
            }
            if ("empty".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.EMPTY);
            }
            if ("notEmpty".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTEMPTY);
            }
            if ("contains".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.CONTAINS);
            }
            if ("notContains".equals(codeString)) {
                return new Enumeration<AssertionOperatorType>(this, AssertionOperatorType.NOTCONTAINS);
            }
            throw new FHIRException("Unknown AssertionOperatorType code '" + codeString + "'");
        }

        @Override
        public String toCode(AssertionOperatorType code) {
            if (code == AssertionOperatorType.EQUALS) {
                return "equals";
            }
            if (code == AssertionOperatorType.NOTEQUALS) {
                return "notEquals";
            }
            if (code == AssertionOperatorType.IN) {
                return "in";
            }
            if (code == AssertionOperatorType.NOTIN) {
                return "notIn";
            }
            if (code == AssertionOperatorType.GREATERTHAN) {
                return "greaterThan";
            }
            if (code == AssertionOperatorType.LESSTHAN) {
                return "lessThan";
            }
            if (code == AssertionOperatorType.EMPTY) {
                return "empty";
            }
            if (code == AssertionOperatorType.NOTEMPTY) {
                return "notEmpty";
            }
            if (code == AssertionOperatorType.CONTAINS) {
                return "contains";
            }
            if (code == AssertionOperatorType.NOTCONTAINS) {
                return "notContains";
            }
            return "?";
        }

        @Override
        public String toSystem(AssertionOperatorType code) {
            return code.getSystem();
        }
    }

    public static enum AssertionOperatorType {
        EQUALS,
        NOTEQUALS,
        IN,
        NOTIN,
        GREATERTHAN,
        LESSTHAN,
        EMPTY,
        NOTEMPTY,
        CONTAINS,
        NOTCONTAINS,
        NULL;


        public static AssertionOperatorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("equals".equals(codeString)) {
                return EQUALS;
            }
            if ("notEquals".equals(codeString)) {
                return NOTEQUALS;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("notIn".equals(codeString)) {
                return NOTIN;
            }
            if ("greaterThan".equals(codeString)) {
                return GREATERTHAN;
            }
            if ("lessThan".equals(codeString)) {
                return LESSTHAN;
            }
            if ("empty".equals(codeString)) {
                return EMPTY;
            }
            if ("notEmpty".equals(codeString)) {
                return NOTEMPTY;
            }
            if ("contains".equals(codeString)) {
                return CONTAINS;
            }
            if ("notContains".equals(codeString)) {
                return NOTCONTAINS;
            }
            throw new FHIRException("Unknown AssertionOperatorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQUALS: {
                    return "equals";
                }
                case NOTEQUALS: {
                    return "notEquals";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "notIn";
                }
                case GREATERTHAN: {
                    return "greaterThan";
                }
                case LESSTHAN: {
                    return "lessThan";
                }
                case EMPTY: {
                    return "empty";
                }
                case NOTEMPTY: {
                    return "notEmpty";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOTCONTAINS: {
                    return "notContains";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQUALS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTEQUALS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case IN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case GREATERTHAN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case LESSTHAN: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case EMPTY: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTEMPTY: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case CONTAINS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NOTCONTAINS: {
                    return "http://hl7.org/fhir/assert-operator-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQUALS: {
                    return "Default value. Equals comparison.";
                }
                case NOTEQUALS: {
                    return "Not equals comparison.";
                }
                case IN: {
                    return "Compare value within a known set of values.";
                }
                case NOTIN: {
                    return "Compare value not within a known set of values.";
                }
                case GREATERTHAN: {
                    return "Compare value to be greater than a known value.";
                }
                case LESSTHAN: {
                    return "Compare value to be less than a known value.";
                }
                case EMPTY: {
                    return "Compare value is empty.";
                }
                case NOTEMPTY: {
                    return "Compare value is not empty.";
                }
                case CONTAINS: {
                    return "Compare value string contains a known value.";
                }
                case NOTCONTAINS: {
                    return "Compare value string does not contain a known value.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQUALS: {
                    return "equals";
                }
                case NOTEQUALS: {
                    return "notEquals";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "notIn";
                }
                case GREATERTHAN: {
                    return "greaterThan";
                }
                case LESSTHAN: {
                    return "lessThan";
                }
                case EMPTY: {
                    return "empty";
                }
                case NOTEMPTY: {
                    return "notEmpty";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOTCONTAINS: {
                    return "notContains";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AssertionDirectionTypeEnumFactory
    implements EnumFactory<AssertionDirectionType> {
        @Override
        public AssertionDirectionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("response".equals(codeString)) {
                return AssertionDirectionType.RESPONSE;
            }
            if ("request".equals(codeString)) {
                return AssertionDirectionType.REQUEST;
            }
            throw new IllegalArgumentException("Unknown AssertionDirectionType code '" + codeString + "'");
        }

        public Enumeration<AssertionDirectionType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("response".equals(codeString)) {
                return new Enumeration<AssertionDirectionType>(this, AssertionDirectionType.RESPONSE);
            }
            if ("request".equals(codeString)) {
                return new Enumeration<AssertionDirectionType>(this, AssertionDirectionType.REQUEST);
            }
            throw new FHIRException("Unknown AssertionDirectionType code '" + codeString + "'");
        }

        @Override
        public String toCode(AssertionDirectionType code) {
            if (code == AssertionDirectionType.RESPONSE) {
                return "response";
            }
            if (code == AssertionDirectionType.REQUEST) {
                return "request";
            }
            return "?";
        }

        @Override
        public String toSystem(AssertionDirectionType code) {
            return code.getSystem();
        }
    }

    public static enum AssertionDirectionType {
        RESPONSE,
        REQUEST,
        NULL;


        public static AssertionDirectionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("response".equals(codeString)) {
                return RESPONSE;
            }
            if ("request".equals(codeString)) {
                return REQUEST;
            }
            throw new FHIRException("Unknown AssertionDirectionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RESPONSE: {
                    return "response";
                }
                case REQUEST: {
                    return "request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RESPONSE: {
                    return "http://hl7.org/fhir/assert-direction-codes";
                }
                case REQUEST: {
                    return "http://hl7.org/fhir/assert-direction-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RESPONSE: {
                    return "The assertion is evaluated on the response. This is the default value.";
                }
                case REQUEST: {
                    return "The assertion is evaluated on the request.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RESPONSE: {
                    return "response";
                }
                case REQUEST: {
                    return "request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ContentTypeEnumFactory
    implements EnumFactory<ContentType> {
        @Override
        public ContentType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("xml".equals(codeString)) {
                return ContentType.XML;
            }
            if ("json".equals(codeString)) {
                return ContentType.JSON;
            }
            throw new IllegalArgumentException("Unknown ContentType code '" + codeString + "'");
        }

        public Enumeration<ContentType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("xml".equals(codeString)) {
                return new Enumeration<ContentType>(this, ContentType.XML);
            }
            if ("json".equals(codeString)) {
                return new Enumeration<ContentType>(this, ContentType.JSON);
            }
            throw new FHIRException("Unknown ContentType code '" + codeString + "'");
        }

        @Override
        public String toCode(ContentType code) {
            if (code == ContentType.XML) {
                return "xml";
            }
            if (code == ContentType.JSON) {
                return "json";
            }
            return "?";
        }

        @Override
        public String toSystem(ContentType code) {
            return code.getSystem();
        }
    }

    public static enum ContentType {
        XML,
        JSON,
        NULL;


        public static ContentType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("xml".equals(codeString)) {
                return XML;
            }
            if ("json".equals(codeString)) {
                return JSON;
            }
            throw new FHIRException("Unknown ContentType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case XML: {
                    return "xml";
                }
                case JSON: {
                    return "json";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case XML: {
                    return "http://hl7.org/fhir/content-type";
                }
                case JSON: {
                    return "http://hl7.org/fhir/content-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case XML: {
                    return "XML content-type corresponding to the application/xml+fhir mime-type.";
                }
                case JSON: {
                    return "JSON content-type corresponding to the application/json+fhir mime-type.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case XML: {
                    return "xml";
                }
                case JSON: {
                    return "json";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

