/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ServicePlace;

public class ServicePlaceEnumFactory
implements EnumFactory<ServicePlace> {
    @Override
    public ServicePlace fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("emergency".equals(codeString)) {
            return ServicePlace.EMERGENCY;
        }
        if ("clinic".equals(codeString)) {
            return ServicePlace.CLINIC;
        }
        throw new IllegalArgumentException("Unknown ServicePlace code '" + codeString + "'");
    }

    @Override
    public String toCode(ServicePlace code) {
        if (code == ServicePlace.EMERGENCY) {
            return "emergency";
        }
        if (code == ServicePlace.CLINIC) {
            return "clinic";
        }
        return "?";
    }

    @Override
    public String toSystem(ServicePlace code) {
        return code.getSystem();
    }
}

