/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OperationParameterType {
    ANY,
    NULL;


    public static OperationParameterType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Any".equals(codeString)) {
            return ANY;
        }
        throw new FHIRException("Unknown OperationParameterType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ANY: {
                return "Any";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ValueSet/special-types";
    }

    public String getDefinition() {
        switch (this) {
            case ANY: {
                return "Special type for any kind of resource";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ANY: {
                return "Any";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

