/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Age;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="FamilyMemberHistory", profile="http://hl7.org/fhir/Profile/FamilyMemberHistory")
public class FamilyMemberHistory
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External Id(s) for this record", formalDefinition="This records identifiers associated with this family member history record that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient history is about", formalDefinition="The person who this history concerns.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When history was captured/updated", formalDefinition="The date (and possibly time) when the family member history was taken.")
    protected DateTimeType date;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="partial | completed | entered-in-error | health-unknown", formalDefinition="A code specifying a state of a Family Member History record.")
    protected Enumeration<FamilyHistoryStatus> status;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The family member described", formalDefinition="This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".")
    protected StringType name;
    @Child(name="relationship", type={CodeableConcept.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relationship to the subject", formalDefinition="The type of relationship this person has to the patient (father, mother, brother etc.).")
    protected CodeableConcept relationship;
    @Child(name="gender", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the relative is considered to have for administration and record keeping purposes.")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="born", type={Period.class, DateType.class, StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(approximate) date of birth", formalDefinition="The actual or approximate date of birth of the relative.")
    protected Type born;
    @Child(name="age", type={Age.class, Range.class, StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(approximate) age", formalDefinition="The actual or approximate age of the relative at the time the family member history is recorded.")
    protected Type age;
    @Child(name="deceased", type={BooleanType.class, Age.class, Range.class, DateType.class, StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Dead? How old/when?", formalDefinition="Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.")
    protected Type deceased;
    @Child(name="note", type={Annotation.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="General note about related person", formalDefinition="This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.")
    protected Annotation note;
    @Child(name="condition", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition that the related person had", formalDefinition="The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.")
    protected List<FamilyMemberHistoryConditionComponent> condition;
    private static final long serialVersionUID = -1799103041L;
    @SearchParamDefinition(name="relationship", path="FamilyMemberHistory.relationship", description="A search by a relationship type", type="token")
    public static final String SP_RELATIONSHIP = "relationship";
    public static final TokenClientParam RELATIONSHIP = new TokenClientParam("relationship");
    @SearchParamDefinition(name="patient", path="FamilyMemberHistory.patient", description="The identity of a subject to list family member history items for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("FamilyMemberHistory:patient").toLocked();
    @SearchParamDefinition(name="gender", path="FamilyMemberHistory.gender", description="A search by a gender code of a family member", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="code", path="FamilyMemberHistory.condition.code", description="A search by a condition code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="FamilyMemberHistory.date", description="When history was captured/updated", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="FamilyMemberHistory.identifier", description="A search by a record identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public FamilyMemberHistory() {
    }

    public FamilyMemberHistory(Reference patient, Enumeration<FamilyHistoryStatus> status, CodeableConcept relationship) {
        this.patient = patient;
        this.status = status;
        this.relationship = relationship;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public FamilyMemberHistory addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public FamilyMemberHistory setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public FamilyMemberHistory setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public FamilyMemberHistory setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public FamilyMemberHistory setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Enumeration<FamilyHistoryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FamilyHistoryStatus>(new FamilyHistoryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public FamilyMemberHistory setStatusElement(Enumeration<FamilyHistoryStatus> value) {
        this.status = value;
        return this;
    }

    public FamilyHistoryStatus getStatus() {
        return this.status == null ? null : (FamilyHistoryStatus)((Object)this.status.getValue());
    }

    public FamilyMemberHistory setStatus(FamilyHistoryStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<FamilyHistoryStatus>(new FamilyHistoryStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public FamilyMemberHistory setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public FamilyMemberHistory setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public FamilyMemberHistory setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public FamilyMemberHistory setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public FamilyMemberHistory setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public Type getBorn() {
        return this.born;
    }

    public Period getBornPeriod() throws FHIRException {
        if (!(this.born instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (Period)this.born;
    }

    public boolean hasBornPeriod() {
        return this.born instanceof Period;
    }

    public DateType getBornDateType() throws FHIRException {
        if (!(this.born instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (DateType)this.born;
    }

    public boolean hasBornDateType() {
        return this.born instanceof DateType;
    }

    public StringType getBornStringType() throws FHIRException {
        if (!(this.born instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (StringType)this.born;
    }

    public boolean hasBornStringType() {
        return this.born instanceof StringType;
    }

    public boolean hasBorn() {
        return this.born != null && !this.born.isEmpty();
    }

    public FamilyMemberHistory setBorn(Type value) {
        this.born = value;
        return this;
    }

    public Type getAge() {
        return this.age;
    }

    public Age getAgeAge() throws FHIRException {
        if (!(this.age instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Age)this.age;
    }

    public boolean hasAgeAge() {
        return this.age instanceof Age;
    }

    public Range getAgeRange() throws FHIRException {
        if (!(this.age instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Range)this.age;
    }

    public boolean hasAgeRange() {
        return this.age instanceof Range;
    }

    public StringType getAgeStringType() throws FHIRException {
        if (!(this.age instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (StringType)this.age;
    }

    public boolean hasAgeStringType() {
        return this.age instanceof StringType;
    }

    public boolean hasAge() {
        return this.age != null && !this.age.isEmpty();
    }

    public FamilyMemberHistory setAge(Type value) {
        this.age = value;
        return this;
    }

    public Type getDeceased() {
        return this.deceased;
    }

    public BooleanType getDeceasedBooleanType() throws FHIRException {
        if (!(this.deceased instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.deceased;
    }

    public boolean hasDeceasedBooleanType() {
        return this.deceased instanceof BooleanType;
    }

    public Age getDeceasedAge() throws FHIRException {
        if (!(this.deceased instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (Age)this.deceased;
    }

    public boolean hasDeceasedAge() {
        return this.deceased instanceof Age;
    }

    public Range getDeceasedRange() throws FHIRException {
        if (!(this.deceased instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (Range)this.deceased;
    }

    public boolean hasDeceasedRange() {
        return this.deceased instanceof Range;
    }

    public DateType getDeceasedDateType() throws FHIRException {
        if (!(this.deceased instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (DateType)this.deceased;
    }

    public boolean hasDeceasedDateType() {
        return this.deceased instanceof DateType;
    }

    public StringType getDeceasedStringType() throws FHIRException {
        if (!(this.deceased instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (StringType)this.deceased;
    }

    public boolean hasDeceasedStringType() {
        return this.deceased instanceof StringType;
    }

    public boolean hasDeceased() {
        return this.deceased != null && !this.deceased.isEmpty();
    }

    public FamilyMemberHistory setDeceased(Type value) {
        this.deceased = value;
        return this;
    }

    public Annotation getNote() {
        if (this.note == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.note");
            }
            if (Configuration.doAutoCreate()) {
                this.note = new Annotation();
            }
        }
        return this.note;
    }

    public boolean hasNote() {
        return this.note != null && !this.note.isEmpty();
    }

    public FamilyMemberHistory setNote(Annotation value) {
        this.note = value;
        return this;
    }

    public List<FamilyMemberHistoryConditionComponent> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        return this.condition;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (FamilyMemberHistoryConditionComponent item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FamilyMemberHistoryConditionComponent addCondition() {
        FamilyMemberHistoryConditionComponent t = new FamilyMemberHistoryConditionComponent();
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        this.condition.add(t);
        return t;
    }

    public FamilyMemberHistory addCondition(FamilyMemberHistoryConditionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        this.condition.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this family member history record that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The person who this history concerns.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date (and possibly time) when the family member history was taken.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("status", SP_CODE, "A code specifying a state of a Family Member History record.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("name", "string", "This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_RELATIONSHIP, "CodeableConcept", "The type of relationship this person has to the patient (father, mother, brother etc.).", 0, Integer.MAX_VALUE, this.relationship));
        childrenList.add(new Property(SP_GENDER, SP_CODE, "Administrative Gender - the gender that the relative is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        childrenList.add(new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, Integer.MAX_VALUE, this.born));
        childrenList.add(new Property("age[x]", "Age|Range|string", "The actual or approximate age of the relative at the time the family member history is recorded.", 0, Integer.MAX_VALUE, this.age));
        childrenList.add(new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, Integer.MAX_VALUE, this.deceased));
        childrenList.add(new Property("note", "Annotation", "This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("condition", "", "The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.", 0, Integer.MAX_VALUE, this.condition));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.date;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.relationship;
                }
                return baseArray;
            }
            case -1249512767: {
                Base[] baseArray;
                if (this.gender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.gender;
                }
                return baseArray;
            }
            case 3029833: {
                Base[] baseArray;
                if (this.born == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.born;
                }
                return baseArray;
            }
            case 96511: {
                Base[] baseArray;
                if (this.age == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.age;
                }
                return baseArray;
            }
            case 561497972: {
                Base[] baseArray;
                if (this.deceased == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.deceased;
                }
                return baseArray;
            }
            case 3387378: {
                Base[] baseArray;
                if (this.note == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.note;
                }
                return baseArray;
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -892481550: {
                this.status = new FamilyHistoryStatusEnumFactory().fromType(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -261851592: {
                this.relationship = this.castToCodeableConcept(value);
                break;
            }
            case -1249512767: {
                this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
                break;
            }
            case 3029833: {
                this.born = (Type)value;
                break;
            }
            case 96511: {
                this.age = (Type)value;
                break;
            }
            case 561497972: {
                this.deceased = (Type)value;
                break;
            }
            case 3387378: {
                this.note = this.castToAnnotation(value);
                break;
            }
            case -861311717: {
                this.getCondition().add((FamilyMemberHistoryConditionComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("status")) {
            this.status = new FamilyHistoryStatusEnumFactory().fromType(value);
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = this.castToCodeableConcept(value);
        } else if (name.equals(SP_GENDER)) {
            this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
        } else if (name.equals("born[x]")) {
            this.born = (Type)value;
        } else if (name.equals("age[x]")) {
            this.age = (Type)value;
        } else if (name.equals("deceased[x]")) {
            this.deceased = (Type)value;
        } else if (name.equals("note")) {
            this.note = this.castToAnnotation(value);
        } else if (name.equals("condition")) {
            this.getCondition().add((FamilyMemberHistoryConditionComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -261851592: {
                return this.getRelationship();
            }
            case -1249512767: {
                throw new FHIRException("Cannot make property gender as it is not a complex type");
            }
            case 67532951: {
                return this.getBorn();
            }
            case -1419716831: {
                return this.getAge();
            }
            case -1311442804: {
                return this.getDeceased();
            }
            case 3387378: {
                return this.getNote();
            }
            case -861311717: {
                return this.addCondition();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type FamilyMemberHistory.date");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type FamilyMemberHistory.status");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type FamilyMemberHistory.name");
        }
        if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a primitive type FamilyMemberHistory.gender");
        }
        if (name.equals("bornPeriod")) {
            this.born = new Period();
            return this.born;
        }
        if (name.equals("bornDate")) {
            this.born = new DateType();
            return this.born;
        }
        if (name.equals("bornString")) {
            this.born = new StringType();
            return this.born;
        }
        if (name.equals("ageAge")) {
            this.age = new Age();
            return this.age;
        }
        if (name.equals("ageRange")) {
            this.age = new Range();
            return this.age;
        }
        if (name.equals("ageString")) {
            this.age = new StringType();
            return this.age;
        }
        if (name.equals("deceasedBoolean")) {
            this.deceased = new BooleanType();
            return this.deceased;
        }
        if (name.equals("deceasedAge")) {
            this.deceased = new Age();
            return this.deceased;
        }
        if (name.equals("deceasedRange")) {
            this.deceased = new Range();
            return this.deceased;
        }
        if (name.equals("deceasedDate")) {
            this.deceased = new DateType();
            return this.deceased;
        }
        if (name.equals("deceasedString")) {
            this.deceased = new StringType();
            return this.deceased;
        }
        if (name.equals("note")) {
            this.note = new Annotation();
            return this.note;
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FamilyMemberHistory";
    }

    @Override
    public FamilyMemberHistory copy() {
        FamilyMemberHistory dst = new FamilyMemberHistory();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        dst.gender = this.gender == null ? null : this.gender.copy();
        dst.born = this.born == null ? null : this.born.copy();
        dst.age = this.age == null ? null : this.age.copy();
        dst.deceased = this.deceased == null ? null : this.deceased.copy();
        Annotation annotation = dst.note = this.note == null ? null : this.note.copy();
        if (this.condition != null) {
            dst.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
            for (FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : this.condition) {
                dst.condition.add(familyMemberHistoryConditionComponent.copy());
            }
        }
        return dst;
    }

    protected FamilyMemberHistory typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof FamilyMemberHistory)) {
            return false;
        }
        FamilyMemberHistory o = (FamilyMemberHistory)other;
        return FamilyMemberHistory.compareDeep(this.identifier, o.identifier, true) && FamilyMemberHistory.compareDeep(this.patient, o.patient, true) && FamilyMemberHistory.compareDeep(this.date, o.date, true) && FamilyMemberHistory.compareDeep(this.status, o.status, true) && FamilyMemberHistory.compareDeep(this.name, o.name, true) && FamilyMemberHistory.compareDeep(this.relationship, o.relationship, true) && FamilyMemberHistory.compareDeep(this.gender, o.gender, true) && FamilyMemberHistory.compareDeep(this.born, o.born, true) && FamilyMemberHistory.compareDeep(this.age, o.age, true) && FamilyMemberHistory.compareDeep(this.deceased, o.deceased, true) && FamilyMemberHistory.compareDeep(this.note, o.note, true) && FamilyMemberHistory.compareDeep(this.condition, o.condition, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof FamilyMemberHistory)) {
            return false;
        }
        FamilyMemberHistory o = (FamilyMemberHistory)other;
        return FamilyMemberHistory.compareValues(this.date, o.date, true) && FamilyMemberHistory.compareValues(this.status, o.status, true) && FamilyMemberHistory.compareValues(this.name, o.name, true) && FamilyMemberHistory.compareValues(this.gender, o.gender, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.date != null && !this.date.isEmpty() || this.status != null && !this.status.isEmpty() || this.name != null && !this.name.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.gender != null && !this.gender.isEmpty() || this.born != null && !this.born.isEmpty() || this.age != null && !this.age.isEmpty() || this.deceased != null && !this.deceased.isEmpty() || this.note != null && !this.note.isEmpty() || this.condition != null && !this.condition.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.FamilyMemberHistory;
    }

    @Block
    public static class FamilyMemberHistoryConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Condition suffered by relation", formalDefinition="The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.")
        protected CodeableConcept code;
        @Child(name="outcome", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="deceased | permanent disability | etc.", formalDefinition="Indicates what happened as a result of this condition.  If the condition resulted in death, deceased date is captured on the relation.")
        protected CodeableConcept outcome;
        @Child(name="onset", type={Age.class, Range.class, Period.class, StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When condition first manifested", formalDefinition="Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.")
        protected Type onset;
        @Child(name="note", type={Annotation.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Extra information about condition", formalDefinition="An area where general notes can be placed about this specific condition.")
        protected Annotation note;
        private static final long serialVersionUID = -1221569121L;

        public FamilyMemberHistoryConditionComponent() {
        }

        public FamilyMemberHistoryConditionComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public Type getOnset() {
            return this.onset;
        }

        public Age getOnsetAge() throws FHIRException {
            if (!(this.onset instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Age)this.onset;
        }

        public boolean hasOnsetAge() {
            return this.onset instanceof Age;
        }

        public Range getOnsetRange() throws FHIRException {
            if (!(this.onset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Range)this.onset;
        }

        public boolean hasOnsetRange() {
            return this.onset instanceof Range;
        }

        public Period getOnsetPeriod() throws FHIRException {
            if (!(this.onset instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Period)this.onset;
        }

        public boolean hasOnsetPeriod() {
            return this.onset instanceof Period;
        }

        public StringType getOnsetStringType() throws FHIRException {
            if (!(this.onset instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (StringType)this.onset;
        }

        public boolean hasOnsetStringType() {
            return this.onset instanceof StringType;
        }

        public boolean hasOnset() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setOnset(Type value) {
            this.onset = value;
            return this;
        }

        public Annotation getNote() {
            if (this.note == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.note");
                }
                if (Configuration.doAutoCreate()) {
                    this.note = new Annotation();
                }
            }
            return this.note;
        }

        public boolean hasNote() {
            return this.note != null && !this.note.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setNote(Annotation value) {
            this.note = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("outcome", "CodeableConcept", "Indicates what happened as a result of this condition.  If the condition resulted in death, deceased date is captured on the relation.", 0, Integer.MAX_VALUE, this.outcome));
            childrenList.add(new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, Integer.MAX_VALUE, this.onset));
            childrenList.add(new Property("note", "Annotation", "An area where general notes can be placed about this specific condition.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.outcome;
                    }
                    return baseArray;
                }
                case 105901603: {
                    Base[] baseArray;
                    if (this.onset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onset;
                    }
                    return baseArray;
                }
                case 3387378: {
                    Base[] baseArray;
                    if (this.note == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.note;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case -1106507950: {
                    this.outcome = this.castToCodeableConcept(value);
                    break;
                }
                case 105901603: {
                    this.onset = (Type)value;
                    break;
                }
                case 3387378: {
                    this.note = this.castToAnnotation(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("outcome")) {
                this.outcome = this.castToCodeableConcept(value);
            } else if (name.equals("onset[x]")) {
                this.onset = (Type)value;
            } else if (name.equals("note")) {
                this.note = this.castToAnnotation(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1106507950: {
                    return this.getOutcome();
                }
                case -1886216323: {
                    return this.getOnset();
                }
                case 3387378: {
                    return this.getNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("onsetAge")) {
                this.onset = new Age();
                return this.onset;
            }
            if (name.equals("onsetRange")) {
                this.onset = new Range();
                return this.onset;
            }
            if (name.equals("onsetPeriod")) {
                this.onset = new Period();
                return this.onset;
            }
            if (name.equals("onsetString")) {
                this.onset = new StringType();
                return this.onset;
            }
            if (name.equals("note")) {
                this.note = new Annotation();
                return this.note;
            }
            return super.addChild(name);
        }

        @Override
        public FamilyMemberHistoryConditionComponent copy() {
            FamilyMemberHistoryConditionComponent dst = new FamilyMemberHistoryConditionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.onset = this.onset == null ? null : this.onset.copy();
            dst.note = this.note == null ? null : this.note.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof FamilyMemberHistoryConditionComponent)) {
                return false;
            }
            FamilyMemberHistoryConditionComponent o = (FamilyMemberHistoryConditionComponent)other;
            return FamilyMemberHistoryConditionComponent.compareDeep(this.code, o.code, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.outcome, o.outcome, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.onset, o.onset, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof FamilyMemberHistoryConditionComponent)) {
                return false;
            }
            FamilyMemberHistoryConditionComponent o = (FamilyMemberHistoryConditionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.onset != null && !this.onset.isEmpty() || this.note != null && !this.note.isEmpty());
        }

        @Override
        public String fhirType() {
            return "FamilyMemberHistory.condition";
        }
    }

    public static class FamilyHistoryStatusEnumFactory
    implements EnumFactory<FamilyHistoryStatus> {
        @Override
        public FamilyHistoryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return FamilyHistoryStatus.PARTIAL;
            }
            if ("completed".equals(codeString)) {
                return FamilyHistoryStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return FamilyHistoryStatus.ENTEREDINERROR;
            }
            if ("health-unknown".equals(codeString)) {
                return FamilyHistoryStatus.HEALTHUNKNOWN;
            }
            throw new IllegalArgumentException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        public Enumeration<FamilyHistoryStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.PARTIAL);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.ENTEREDINERROR);
            }
            if ("health-unknown".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.HEALTHUNKNOWN);
            }
            throw new FHIRException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FamilyHistoryStatus code) {
            if (code == FamilyHistoryStatus.PARTIAL) {
                return "partial";
            }
            if (code == FamilyHistoryStatus.COMPLETED) {
                return "completed";
            }
            if (code == FamilyHistoryStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == FamilyHistoryStatus.HEALTHUNKNOWN) {
                return "health-unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(FamilyHistoryStatus code) {
            return code.getSystem();
        }
    }

    public static enum FamilyHistoryStatus {
        PARTIAL,
        COMPLETED,
        ENTEREDINERROR,
        HEALTHUNKNOWN,
        NULL;


        public static FamilyHistoryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("health-unknown".equals(codeString)) {
                return HEALTHUNKNOWN;
            }
            throw new FHIRException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PARTIAL: {
                    return "partial";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case HEALTHUNKNOWN: {
                    return "health-unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PARTIAL: {
                    return "http://hl7.org/fhir/history-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/history-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/history-status";
                }
                case HEALTHUNKNOWN: {
                    return "http://hl7.org/fhir/history-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PARTIAL: {
                    return "Some health information is known and captured, but not complete - see notes for details.";
                }
                case COMPLETED: {
                    return "All relevant health information is known and captured.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case HEALTHUNKNOWN: {
                    return "Health information for this individual is unavailable/unknown.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PARTIAL: {
                    return "Partial";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case HEALTHUNKNOWN: {
                    return "Health unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

