/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DataelementStringency {
    COMPARABLE,
    FULLYSPECIFIED,
    EQUIVALENT,
    CONVERTABLE,
    SCALEABLE,
    FLEXIBLE,
    NULL;


    public static DataelementStringency fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("comparable".equals(codeString)) {
            return COMPARABLE;
        }
        if ("fully-specified".equals(codeString)) {
            return FULLYSPECIFIED;
        }
        if ("equivalent".equals(codeString)) {
            return EQUIVALENT;
        }
        if ("convertable".equals(codeString)) {
            return CONVERTABLE;
        }
        if ("scaleable".equals(codeString)) {
            return SCALEABLE;
        }
        if ("flexible".equals(codeString)) {
            return FLEXIBLE;
        }
        throw new FHIRException("Unknown DataelementStringency code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPARABLE: {
                return "comparable";
            }
            case FULLYSPECIFIED: {
                return "fully-specified";
            }
            case EQUIVALENT: {
                return "equivalent";
            }
            case CONVERTABLE: {
                return "convertable";
            }
            case SCALEABLE: {
                return "scaleable";
            }
            case FLEXIBLE: {
                return "flexible";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/dataelement-stringency";
    }

    public String getDefinition() {
        switch (this) {
            case COMPARABLE: {
                return "The data element is sufficiently well-constrained that multiple pieces of data captured according to the constraints of the data element will be comparable (though in some cases, a degree of automated conversion/normalization may be required).";
            }
            case FULLYSPECIFIED: {
                return "The data element is fully specified down to a single value set, single unit of measure, single data type, etc.  Multiple pieces of data associated with this data element are fully comparable.";
            }
            case EQUIVALENT: {
                return "The data element allows multiple units of measure having equivalent meaning; e.g. \"cc\" (cubic centimeter) and \"mL\" (milliliter).";
            }
            case CONVERTABLE: {
                return "The data element allows multiple units of measure that are convertable between each other (e.g. inches and centimeters) and/or allows data to be captured in multiple value sets for which a known mapping exists allowing conversion of meaning.";
            }
            case SCALEABLE: {
                return "A convertable data element where unit conversions are different only by a power of 10; e.g. g, mg, kg.";
            }
            case FLEXIBLE: {
                return "The data element is unconstrained in units, choice of data types and/or choice of vocabulary such that automated comparison of data captured using the data element is not possible.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPARABLE: {
                return "Comparable";
            }
            case FULLYSPECIFIED: {
                return "Fully Specified";
            }
            case EQUIVALENT: {
                return "Equivalent";
            }
            case CONVERTABLE: {
                return "Convertable";
            }
            case SCALEABLE: {
                return "Scaleable";
            }
            case FLEXIBLE: {
                return "Flexible";
            }
        }
        return "?";
    }
}

