/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Task", profile="http://hl7.org/fhir/Profile/Task")
public class Task
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Instance Identifier", formalDefinition="The business identifier for this task.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Type", formalDefinition="A name or code (or both) briefly describing what the task involves.")
    protected CodeableConcept type;
    @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Description", formalDefinition="A description of this task.")
    protected StringType description;
    @Child(name="performerType", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="requester | dispatcher | scheduler | performer | monitor | manager | acquirer | reviewer", formalDefinition="The type of participant that can execute the task.")
    protected List<Coding> performerType;
    @Child(name="priority", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="low | normal | high", formalDefinition="The priority of the task among other tasks of the same type.")
    protected Enumeration<TaskPriority> priority;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="draft | requested | received | accepted | +", formalDefinition="The current status of the task.")
    protected Enumeration<TaskStatus> status;
    @Child(name="failureReason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Failure Reason", formalDefinition="An explaination as to why this task failed.")
    protected CodeableConcept failureReason;
    @Child(name="subject", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Subject", formalDefinition="The subject of the task.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="for", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Beneficiary of the Task", formalDefinition="The entity who benefits from the performance of the service specified in the task (e.g., the patient).")
    protected Reference for_;
    protected Resource for_Target;
    @Child(name="definition", type={UriType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Definition", formalDefinition="A reference to a formal or informal definition of the task.")
    protected UriType definition;
    @Child(name="created", type={DateTimeType.class}, order=10, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Creation Date", formalDefinition="The date and time this task was created.")
    protected DateTimeType created;
    @Child(name="lastModified", type={DateTimeType.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Last Modified Date", formalDefinition="The date and time of last modification to this task.")
    protected DateTimeType lastModified;
    @Child(name="creator", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=12, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Creator", formalDefinition="The creator of the task.")
    protected Reference creator;
    protected Resource creatorTarget;
    @Child(name="owner", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Owner", formalDefinition="The owner of this task.  The participant who can execute this task.")
    protected Reference owner;
    protected Resource ownerTarget;
    @Child(name="parent", type={Task.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Composite task", formalDefinition="Task that this particular task is part of.")
    protected Reference parent;
    protected Task parentTarget;
    @Child(name="input", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Task Input", formalDefinition="Inputs to the task.")
    protected List<ParameterComponent> input;
    @Child(name="output", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Task Output", formalDefinition="Outputs produced by the Task.")
    protected List<TaskOutputComponent> output;
    private static final long serialVersionUID = 969281174L;
    @SearchParamDefinition(name="definition", path="Task.definition", description="Search by task definition", type="uri")
    public static final String SP_DEFINITION = "definition";
    public static final UriClientParam DEFINITION = new UriClientParam("definition");
    @SearchParamDefinition(name="status", path="Task.status", description="Search by task status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Task.subject", description="Search by task subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Task:subject").toLocked();
    @SearchParamDefinition(name="parent", path="Task.parent", description="Search by parent task", type="reference")
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("Task:parent").toLocked();
    @SearchParamDefinition(name="type", path="Task.type", description="Search by task type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="modified", path="Task.lastModified", description="Search by last modification date", type="date")
    public static final String SP_MODIFIED = "modified";
    public static final DateClientParam MODIFIED = new DateClientParam("modified");
    @SearchParamDefinition(name="creator", path="Task.creator", description="Search by task creator", type="reference")
    public static final String SP_CREATOR = "creator";
    public static final ReferenceClientParam CREATOR = new ReferenceClientParam("creator");
    public static final Include INCLUDE_CREATOR = new Include("Task:creator").toLocked();
    @SearchParamDefinition(name="failure", path="Task.failureReason", description="Search by failure reason", type="token")
    public static final String SP_FAILURE = "failure";
    public static final TokenClientParam FAILURE = new TokenClientParam("failure");
    @SearchParamDefinition(name="created", path="Task.created", description="Search by creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="priority", path="Task.priority", description="Search by task priority", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="owner", path="Task.owner", description="Search by task owner", type="reference")
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    public static final Include INCLUDE_OWNER = new Include("Task:owner").toLocked();
    @SearchParamDefinition(name="performer", path="Task.performerType", description="Search by recommended type of performer (e.g., Requester, Performer, Scheduler).", type="token")
    public static final String SP_PERFORMER = "performer";
    public static final TokenClientParam PERFORMER = new TokenClientParam("performer");
    @SearchParamDefinition(name="identifier", path="Task.identifier", description="Search for a task instance by its business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Task() {
    }

    public Task(Enumeration<TaskStatus> status, DateTimeType created, DateTimeType lastModified, Reference creator) {
        this.status = status;
        this.created = created;
        this.lastModified = lastModified;
        this.creator = creator;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Task setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Task setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Task setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Task setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Coding> getPerformerType() {
        if (this.performerType == null) {
            this.performerType = new ArrayList<Coding>();
        }
        return this.performerType;
    }

    public boolean hasPerformerType() {
        if (this.performerType == null) {
            return false;
        }
        for (Coding item : this.performerType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addPerformerType() {
        Coding t = new Coding();
        if (this.performerType == null) {
            this.performerType = new ArrayList<Coding>();
        }
        this.performerType.add(t);
        return t;
    }

    public Task addPerformerType(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.performerType == null) {
            this.performerType = new ArrayList<Coding>();
        }
        this.performerType.add(t);
        return this;
    }

    public Enumeration<TaskPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<TaskPriority>(new TaskPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Task setPriorityElement(Enumeration<TaskPriority> value) {
        this.priority = value;
        return this;
    }

    public TaskPriority getPriority() {
        return this.priority == null ? null : (TaskPriority)((Object)this.priority.getValue());
    }

    public Task setPriority(TaskPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<TaskPriority>(new TaskPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<TaskStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<TaskStatus>(new TaskStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Task setStatusElement(Enumeration<TaskStatus> value) {
        this.status = value;
        return this;
    }

    public TaskStatus getStatus() {
        return this.status == null ? null : (TaskStatus)((Object)this.status.getValue());
    }

    public Task setStatus(TaskStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<TaskStatus>(new TaskStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getFailureReason() {
        if (this.failureReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.failureReason");
            }
            if (Configuration.doAutoCreate()) {
                this.failureReason = new CodeableConcept();
            }
        }
        return this.failureReason;
    }

    public boolean hasFailureReason() {
        return this.failureReason != null && !this.failureReason.isEmpty();
    }

    public Task setFailureReason(CodeableConcept value) {
        this.failureReason = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Task setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Task setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getFor() {
        if (this.for_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.for_");
            }
            if (Configuration.doAutoCreate()) {
                this.for_ = new Reference();
            }
        }
        return this.for_;
    }

    public boolean hasFor() {
        return this.for_ != null && !this.for_.isEmpty();
    }

    public Task setFor(Reference value) {
        this.for_ = value;
        return this;
    }

    public Resource getForTarget() {
        return this.for_Target;
    }

    public Task setForTarget(Resource value) {
        this.for_Target = value;
        return this;
    }

    public UriType getDefinitionElement() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new UriType();
            }
        }
        return this.definition;
    }

    public boolean hasDefinitionElement() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public Task setDefinitionElement(UriType value) {
        this.definition = value;
        return this;
    }

    public String getDefinition() {
        return this.definition == null ? null : (String)this.definition.getValue();
    }

    public Task setDefinition(String value) {
        if (Utilities.noString((String)value)) {
            this.definition = null;
        } else {
            if (this.definition == null) {
                this.definition = new UriType();
            }
            this.definition.setValue(value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Task setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Task setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public DateTimeType getLastModifiedElement() {
        if (this.lastModified == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.lastModified");
            }
            if (Configuration.doAutoCreate()) {
                this.lastModified = new DateTimeType();
            }
        }
        return this.lastModified;
    }

    public boolean hasLastModifiedElement() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public boolean hasLastModified() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public Task setLastModifiedElement(DateTimeType value) {
        this.lastModified = value;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified == null ? null : (Date)this.lastModified.getValue();
    }

    public Task setLastModified(Date value) {
        if (this.lastModified == null) {
            this.lastModified = new DateTimeType();
        }
        this.lastModified.setValue(value);
        return this;
    }

    public Reference getCreator() {
        if (this.creator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.creator");
            }
            if (Configuration.doAutoCreate()) {
                this.creator = new Reference();
            }
        }
        return this.creator;
    }

    public boolean hasCreator() {
        return this.creator != null && !this.creator.isEmpty();
    }

    public Task setCreator(Reference value) {
        this.creator = value;
        return this;
    }

    public Resource getCreatorTarget() {
        return this.creatorTarget;
    }

    public Task setCreatorTarget(Resource value) {
        this.creatorTarget = value;
        return this;
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Task setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Resource getOwnerTarget() {
        return this.ownerTarget;
    }

    public Task setOwnerTarget(Resource value) {
        this.ownerTarget = value;
        return this;
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public Task setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public Task getParentTarget() {
        if (this.parentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parentTarget = new Task();
            }
        }
        return this.parentTarget;
    }

    public Task setParentTarget(Task value) {
        this.parentTarget = value;
        return this;
    }

    public List<ParameterComponent> getInput() {
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        return this.input;
    }

    public boolean hasInput() {
        if (this.input == null) {
            return false;
        }
        for (ParameterComponent item : this.input) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParameterComponent addInput() {
        ParameterComponent t = new ParameterComponent();
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        this.input.add(t);
        return t;
    }

    public Task addInput(ParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        this.input.add(t);
        return this;
    }

    public List<TaskOutputComponent> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        return this.output;
    }

    public boolean hasOutput() {
        if (this.output == null) {
            return false;
        }
        for (TaskOutputComponent item : this.output) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TaskOutputComponent addOutput() {
        TaskOutputComponent t = new TaskOutputComponent();
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        this.output.add(t);
        return t;
    }

    public Task addOutput(TaskOutputComponent t) {
        if (t == null) {
            return this;
        }
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        this.output.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The business identifier for this task.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "A name or code (or both) briefly describing what the task involves.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("description", "string", "A description of this task.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("performerType", "Coding", "The type of participant that can execute the task.", 0, Integer.MAX_VALUE, this.performerType));
        childrenList.add(new Property(SP_PRIORITY, "code", "The priority of the task among other tasks of the same type.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property(SP_STATUS, "code", "The current status of the task.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("failureReason", "CodeableConcept", "An explaination as to why this task failed.", 0, Integer.MAX_VALUE, this.failureReason));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Any)", "The subject of the task.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the task (e.g., the patient).", 0, Integer.MAX_VALUE, this.for_));
        childrenList.add(new Property(SP_DEFINITION, "uri", "A reference to a formal or informal definition of the task.", 0, Integer.MAX_VALUE, this.definition));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date and time this task was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("lastModified", "dateTime", "The date and time of last modification to this task.", 0, Integer.MAX_VALUE, this.lastModified));
        childrenList.add(new Property(SP_CREATOR, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The creator of the task.", 0, Integer.MAX_VALUE, this.creator));
        childrenList.add(new Property(SP_OWNER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The owner of this task.  The participant who can execute this task.", 0, Integer.MAX_VALUE, this.owner));
        childrenList.add(new Property(SP_PARENT, "Reference(Task)", "Task that this particular task is part of.", 0, Integer.MAX_VALUE, this.parent));
        childrenList.add(new Property("input", "", "Inputs to the task.", 0, Integer.MAX_VALUE, this.input));
        childrenList.add(new Property("output", "", "Outputs produced by the Task.", 0, Integer.MAX_VALUE, this.output));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case -901444568: {
                return this.performerType == null ? new Base[]{} : this.performerType.toArray(new Base[this.performerType.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -1990598546: {
                Base[] baseArray;
                if (this.failureReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.failureReason;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.subject;
                }
                return baseArray;
            }
            case 101577: {
                Base[] baseArray;
                if (this.for_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.for_;
                }
                return baseArray;
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.definition;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.created;
                }
                return baseArray;
            }
            case 1959003007: {
                Base[] baseArray;
                if (this.lastModified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastModified;
                }
                return baseArray;
            }
            case 1028554796: {
                Base[] baseArray;
                if (this.creator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.creator;
                }
                return baseArray;
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.owner;
                }
                return baseArray;
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.parent;
                }
                return baseArray;
            }
            case 100358090: {
                return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
            }
            case -1005512447: {
                return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -901444568: {
                this.getPerformerType().add(this.castToCoding(value));
                break;
            }
            case -1165461084: {
                this.priority = new TaskPriorityEnumFactory().fromType(value);
                break;
            }
            case -892481550: {
                this.status = new TaskStatusEnumFactory().fromType(value);
                break;
            }
            case -1990598546: {
                this.failureReason = this.castToCodeableConcept(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case 101577: {
                this.for_ = this.castToReference(value);
                break;
            }
            case -1014418093: {
                this.definition = this.castToUri(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case 1959003007: {
                this.lastModified = this.castToDateTime(value);
                break;
            }
            case 1028554796: {
                this.creator = this.castToReference(value);
                break;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                break;
            }
            case -995424086: {
                this.parent = this.castToReference(value);
                break;
            }
            case 100358090: {
                this.getInput().add((ParameterComponent)value);
                break;
            }
            case -1005512447: {
                this.getOutput().add((TaskOutputComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("performerType")) {
            this.getPerformerType().add(this.castToCoding(value));
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = new TaskPriorityEnumFactory().fromType(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new TaskStatusEnumFactory().fromType(value);
        } else if (name.equals("failureReason")) {
            this.failureReason = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("for")) {
            this.for_ = this.castToReference(value);
        } else if (name.equals(SP_DEFINITION)) {
            this.definition = this.castToUri(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("lastModified")) {
            this.lastModified = this.castToDateTime(value);
        } else if (name.equals(SP_CREATOR)) {
            this.creator = this.castToReference(value);
        } else if (name.equals(SP_OWNER)) {
            this.owner = this.castToReference(value);
        } else if (name.equals(SP_PARENT)) {
            this.parent = this.castToReference(value);
        } else if (name.equals("input")) {
            this.getInput().add((ParameterComponent)value);
        } else if (name.equals("output")) {
            this.getOutput().add((TaskOutputComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -901444568: {
                return this.addPerformerType();
            }
            case -1165461084: {
                throw new FHIRException("Cannot make property priority as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -1990598546: {
                return this.getFailureReason();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 101577: {
                return this.getFor();
            }
            case -1014418093: {
                throw new FHIRException("Cannot make property definition as it is not a complex type");
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case 1959003007: {
                throw new FHIRException("Cannot make property lastModified as it is not a complex type");
            }
            case 1028554796: {
                return this.getCreator();
            }
            case 106164915: {
                return this.getOwner();
            }
            case -995424086: {
                return this.getParent();
            }
            case 100358090: {
                return this.addInput();
            }
            case -1005512447: {
                return this.addOutput();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.description");
        }
        if (name.equals("performerType")) {
            return this.addPerformerType();
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.priority");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.status");
        }
        if (name.equals("failureReason")) {
            this.failureReason = new CodeableConcept();
            return this.failureReason;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("for")) {
            this.for_ = new Reference();
            return this.for_;
        }
        if (name.equals(SP_DEFINITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.definition");
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.created");
        }
        if (name.equals("lastModified")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.lastModified");
        }
        if (name.equals(SP_CREATOR)) {
            this.creator = new Reference();
            return this.creator;
        }
        if (name.equals(SP_OWNER)) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals(SP_PARENT)) {
            this.parent = new Reference();
            return this.parent;
        }
        if (name.equals("input")) {
            return this.addInput();
        }
        if (name.equals("output")) {
            return this.addOutput();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Task";
    }

    @Override
    public Task copy() {
        Task dst = new Task();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.performerType != null) {
            dst.performerType = new ArrayList<Coding>();
            for (Coding coding : this.performerType) {
                dst.performerType.add(coding.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.failureReason = this.failureReason == null ? null : this.failureReason.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.for_ = this.for_ == null ? null : this.for_.copy();
        dst.definition = this.definition == null ? null : this.definition.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
        dst.creator = this.creator == null ? null : this.creator.copy();
        dst.owner = this.owner == null ? null : this.owner.copy();
        Reference reference = dst.parent = this.parent == null ? null : this.parent.copy();
        if (this.input != null) {
            dst.input = new ArrayList<ParameterComponent>();
            for (ParameterComponent parameterComponent : this.input) {
                dst.input.add(parameterComponent.copy());
            }
        }
        if (this.output != null) {
            dst.output = new ArrayList<TaskOutputComponent>();
            for (TaskOutputComponent taskOutputComponent : this.output) {
                dst.output.add(taskOutputComponent.copy());
            }
        }
        return dst;
    }

    protected Task typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Task)) {
            return false;
        }
        Task o = (Task)other;
        return Task.compareDeep(this.identifier, o.identifier, true) && Task.compareDeep(this.type, o.type, true) && Task.compareDeep(this.description, o.description, true) && Task.compareDeep(this.performerType, o.performerType, true) && Task.compareDeep(this.priority, o.priority, true) && Task.compareDeep(this.status, o.status, true) && Task.compareDeep(this.failureReason, o.failureReason, true) && Task.compareDeep(this.subject, o.subject, true) && Task.compareDeep(this.for_, o.for_, true) && Task.compareDeep(this.definition, o.definition, true) && Task.compareDeep(this.created, o.created, true) && Task.compareDeep(this.lastModified, o.lastModified, true) && Task.compareDeep(this.creator, o.creator, true) && Task.compareDeep(this.owner, o.owner, true) && Task.compareDeep(this.parent, o.parent, true) && Task.compareDeep(this.input, o.input, true) && Task.compareDeep(this.output, o.output, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Task)) {
            return false;
        }
        Task o = (Task)other;
        return Task.compareValues(this.description, o.description, true) && Task.compareValues(this.priority, o.priority, true) && Task.compareValues(this.status, o.status, true) && Task.compareValues(this.definition, o.definition, true) && Task.compareValues(this.created, o.created, true) && Task.compareValues(this.lastModified, o.lastModified, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty() || this.description != null && !this.description.isEmpty() || this.performerType != null && !this.performerType.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.status != null && !this.status.isEmpty() || this.failureReason != null && !this.failureReason.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.for_ != null && !this.for_.isEmpty() || this.definition != null && !this.definition.isEmpty() || this.created != null && !this.created.isEmpty() || this.lastModified != null && !this.lastModified.isEmpty() || this.creator != null && !this.creator.isEmpty() || this.owner != null && !this.owner.isEmpty() || this.parent != null && !this.parent.isEmpty() || this.input != null && !this.input.isEmpty() || this.output != null && !this.output.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Task;
    }

    @Block
    public static class TaskOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Output Name", formalDefinition="The name of the Output parameter.")
        protected StringType name;
        @Child(name="value", type={}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Output Value", formalDefinition="The value of the Output parameter as a basic type.")
        protected Type value;
        private static final long serialVersionUID = 342865819L;

        public TaskOutputComponent() {
        }

        public TaskOutputComponent(StringType name, Type value) {
            this.name = name;
            this.value = value;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskOutputComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TaskOutputComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TaskOutputComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TaskOutputComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name of the Output parameter.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Task.name");
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public TaskOutputComponent copy() {
            TaskOutputComponent dst = new TaskOutputComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TaskOutputComponent)) {
                return false;
            }
            TaskOutputComponent o = (TaskOutputComponent)other;
            return TaskOutputComponent.compareDeep(this.name, o.name, true) && TaskOutputComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TaskOutputComponent)) {
                return false;
            }
            TaskOutputComponent o = (TaskOutputComponent)other;
            return TaskOutputComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Task.output";
        }
    }

    @Block
    public static class ParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Input Name", formalDefinition="The name of the input parameter.")
        protected StringType name;
        @Child(name="value", type={}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Input Value", formalDefinition="The value of the input parameter as a basic type.")
        protected Type value;
        private static final long serialVersionUID = 342865819L;

        public ParameterComponent() {
        }

        public ParameterComponent(StringType name, Type value) {
            this.name = name;
            this.value = value;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ParameterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name of the input parameter.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Task.name");
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ParameterComponent copy() {
            ParameterComponent dst = new ParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ParameterComponent)) {
                return false;
            }
            ParameterComponent o = (ParameterComponent)other;
            return ParameterComponent.compareDeep(this.name, o.name, true) && ParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ParameterComponent)) {
                return false;
            }
            ParameterComponent o = (ParameterComponent)other;
            return ParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Task.input";
        }
    }

    public static class TaskStatusEnumFactory
    implements EnumFactory<TaskStatus> {
        @Override
        public TaskStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return TaskStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return TaskStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return TaskStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return TaskStatus.ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return TaskStatus.REJECTED;
            }
            if ("ready".equals(codeString)) {
                return TaskStatus.READY;
            }
            if ("in-progress".equals(codeString)) {
                return TaskStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return TaskStatus.ONHOLD;
            }
            if ("failed".equals(codeString)) {
                return TaskStatus.FAILED;
            }
            if ("completed".equals(codeString)) {
                return TaskStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown TaskStatus code '" + codeString + "'");
        }

        public Enumeration<TaskStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.DRAFT);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.REQUESTED);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.RECEIVED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ACCEPTED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.REJECTED);
            }
            if ("ready".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.READY);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ONHOLD);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.FAILED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.COMPLETED);
            }
            throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskStatus code) {
            if (code == TaskStatus.DRAFT) {
                return "draft";
            }
            if (code == TaskStatus.REQUESTED) {
                return "requested";
            }
            if (code == TaskStatus.RECEIVED) {
                return "received";
            }
            if (code == TaskStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == TaskStatus.REJECTED) {
                return "rejected";
            }
            if (code == TaskStatus.READY) {
                return "ready";
            }
            if (code == TaskStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == TaskStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == TaskStatus.FAILED) {
                return "failed";
            }
            if (code == TaskStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskStatus code) {
            return code.getSystem();
        }
    }

    public static enum TaskStatus {
        DRAFT,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        REJECTED,
        READY,
        INPROGRESS,
        ONHOLD,
        FAILED,
        COMPLETED,
        NULL;


        public static TaskStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("ready".equals(codeString)) {
                return READY;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case REJECTED: {
                    return "rejected";
                }
                case READY: {
                    return "ready";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case FAILED: {
                    return "failed";
                }
                case COMPLETED: {
                    return "completed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/task-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case READY: {
                    return "http://hl7.org/fhir/task-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/task-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/task-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The task is not yet ready to be acted upon.";
                }
                case REQUESTED: {
                    return "The task is ready to be acted upon";
                }
                case RECEIVED: {
                    return "A potential performer has claimed ownership of the task and is evaluating whether to perform it";
                }
                case ACCEPTED: {
                    return "The potential performer has agreed to execute the task but has not yet started work";
                }
                case REJECTED: {
                    return "The potential performer who claimed ownership of the task has decided not to execute it prior to performing any action.";
                }
                case READY: {
                    return "Task is ready to be performed, but no action has yet been taken.  Used in place of requested/received/accepted/rejected when request assignment and acceptance is a given.";
                }
                case INPROGRESS: {
                    return "Task has been started but is not yet complete.";
                }
                case ONHOLD: {
                    return "Task has been started but work has been paused";
                }
                case FAILED: {
                    return "The task was attempted but could not be completed due to some error.";
                }
                case COMPLETED: {
                    return "The task has been completed (more or less) as requested.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case READY: {
                    return "Ready";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case FAILED: {
                    return "Failed";
                }
                case COMPLETED: {
                    return "Completed";
                }
            }
            return "?";
        }
    }

    public static class TaskPriorityEnumFactory
    implements EnumFactory<TaskPriority> {
        @Override
        public TaskPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("low".equals(codeString)) {
                return TaskPriority.LOW;
            }
            if ("normal".equals(codeString)) {
                return TaskPriority.NORMAL;
            }
            if ("high".equals(codeString)) {
                return TaskPriority.HIGH;
            }
            throw new IllegalArgumentException("Unknown TaskPriority code '" + codeString + "'");
        }

        public Enumeration<TaskPriority> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.LOW);
            }
            if ("normal".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.NORMAL);
            }
            if ("high".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.HIGH);
            }
            throw new FHIRException("Unknown TaskPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskPriority code) {
            if (code == TaskPriority.LOW) {
                return "low";
            }
            if (code == TaskPriority.NORMAL) {
                return "normal";
            }
            if (code == TaskPriority.HIGH) {
                return "high";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskPriority code) {
            return code.getSystem();
        }
    }

    public static enum TaskPriority {
        LOW,
        NORMAL,
        HIGH,
        NULL;


        public static TaskPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if ("normal".equals(codeString)) {
                return NORMAL;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            throw new FHIRException("Unknown TaskPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LOW: {
                    return "low";
                }
                case NORMAL: {
                    return "normal";
                }
                case HIGH: {
                    return "high";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LOW: {
                    return "http://hl7.org/fhir/task-priority";
                }
                case NORMAL: {
                    return "http://hl7.org/fhir/task-priority";
                }
                case HIGH: {
                    return "http://hl7.org/fhir/task-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LOW: {
                    return "This task has low priority.";
                }
                case NORMAL: {
                    return "This task has normal priority.";
                }
                case HIGH: {
                    return "This task has high priority.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LOW: {
                    return "Low";
                }
                case NORMAL: {
                    return "Normal";
                }
                case HIGH: {
                    return "High";
                }
            }
            return "?";
        }
    }
}

