/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Referralcategory {
    PROPOSAL,
    PLAN,
    REQUEST,
    NULL;


    public static Referralcategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return PLAN;
        }
        if ("request".equals(codeString)) {
            return REQUEST;
        }
        throw new FHIRException("Unknown Referralcategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLAN: {
                return "plan";
            }
            case REQUEST: {
                return "request";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/referralcategory";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSAL: {
                return "The referral request represents a suggestion or recommendation that a referral be made.";
            }
            case PLAN: {
                return "The referral request represents an intention by the author to make a referral, but no actual referral has yet been made/authorized.";
            }
            case REQUEST: {
                return "This is an actual referral request which, when active, will have the authorizations needed to allow it to be actioned.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSAL: {
                return "Proposal";
            }
            case PLAN: {
                return "Plan";
            }
            case REQUEST: {
                return "Request";
            }
        }
        return "?";
    }
}

