/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NetworkType {
    _1,
    _2,
    _3,
    _4,
    _5,
    NULL;


    public static NetworkType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        if ("3".equals(codeString)) {
            return _3;
        }
        if ("4".equals(codeString)) {
            return _4;
        }
        if ("5".equals(codeString)) {
            return _5;
        }
        throw new FHIRException("Unknown NetworkType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
            case _3: {
                return "3";
            }
            case _4: {
                return "4";
            }
            case _5: {
                return "5";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/network-type";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "The machine name, including DNS name.";
            }
            case _2: {
                return "The assigned Internet Protocol (IP) address.";
            }
            case _3: {
                return "The assigned telephone number.";
            }
            case _4: {
                return "The assigned email address.";
            }
            case _5: {
                return "URI (User directory, HTTP-PUT, ftp, etc.).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "Machine Name";
            }
            case _2: {
                return "IP Address";
            }
            case _3: {
                return "Telephone Number";
            }
            case _4: {
                return "Email address";
            }
            case _5: {
                return "URI";
            }
        }
        return "?";
    }
}

