/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaTumourType {
    EPITHELIALTUMOURS,
    MESENCHYMALTUMOURS,
    NULL;


    public static NehtaTumourType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("epithelial-tumours".equals(codeString)) {
            return EPITHELIALTUMOURS;
        }
        if ("mesenchymal-tumours".equals(codeString)) {
            return MESENCHYMALTUMOURS;
        }
        throw new FHIRException("Unknown NehtaTumourType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EPITHELIALTUMOURS: {
                return "epithelial-tumours";
            }
            case MESENCHYMALTUMOURS: {
                return "mesenchymal-tumours";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/tumour-type";
    }

    public String getDefinition() {
        switch (this) {
            case EPITHELIALTUMOURS: {
                return "";
            }
            case MESENCHYMALTUMOURS: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EPITHELIALTUMOURS: {
                return "Epithelial tumours |+";
            }
            case MESENCHYMALTUMOURS: {
                return "Mesenchymal tumours |+";
            }
        }
        return "?";
    }
}

