/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcFetalestimationmethod {
    _103241,
    _205940,
    NULL;


    public static HspcFetalestimationmethod fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("103241".equals(codeString)) {
            return _103241;
        }
        if ("205940".equals(codeString)) {
            return _205940;
        }
        throw new FHIRException("Unknown HspcFetalestimationmethod code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _103241: {
                return "103241";
            }
            case _205940: {
                return "205940";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/hspc-fetalestimationmethod";
    }

    public String getDefinition() {
        switch (this) {
            case _103241: {
                return "A method to estimate due date based on the reported date of the last known menstrual period.";
            }
            case _205940: {
                return "A method to estimate due date by measuring the size of the uterus.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _103241: {
                return "Last known menstrual period";
            }
            case _205940: {
                return "Uterine size";
            }
        }
        return "?";
    }
}

