/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CarePlan;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.EpisodeOfCare;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ReferralRequest", profile="http://hl7.org/fhir/Profile/ReferralRequest")
public class ReferralRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifier that uniquely identifies the referral/care transfer request instance.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ReferralRequest.class, CarePlan.class, DiagnosticOrder.class, ProcedureRequest.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request fulfilled by this request", formalDefinition="Indicates any plans, proposals or orders that this request is intended to satisfy - in whole or in part.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="parent", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="The business identifier of the logical \"grouping\" request/order that this referral is a part of.")
    protected Identifier parent;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | cancelled | completed | entered-in-error", formalDefinition="The status of the authorization/intention reflected by the referral request record.")
    protected Enumeration<ReferralStatus> status;
    @Child(name="category", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | request", formalDefinition="Distinguishes the \"level\" of authorization/demand implicit in this request.")
    protected Enumeration<ReferralCategory> category;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Referral/Transition of care request type", formalDefinition="An indication of the type of referral (or where applicable the type of transfer of care) request.")
    protected CodeableConcept type;
    @Child(name="priority", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Urgency of referral / transfer of care request", formalDefinition="An indication of the urgency of referral (or where applicable the type of transfer of care) request.")
    protected CodeableConcept priority;
    @Child(name="patient", type={Patient.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient referred to care or transfer", formalDefinition="The patient who is the subject of a referral or transfer of care request.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Originating encounter", formalDefinition="The encounter at which the request for referral or transfer of care is initiated.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="fulfillmentTime", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requested service(s) fulfillment time", formalDefinition="The period of time within which the services identified in the referral/transfer of care is specified or required to occur.")
    protected Period fulfillmentTime;
    @Child(name="authored", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date of creation/activation", formalDefinition="Date/DateTime of creation for draft requests and date of activation for active requests.")
    protected DateTimeType authored;
    @Child(name="requester", type={Practitioner.class, Organization.class, Patient.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requester of referral / transfer of care", formalDefinition="The healthcare provider or provider organization who/which initiated the referral/transfer of care request. Can also be  Patient (a self referral).")
    protected Reference requester;
    protected Resource requesterTarget;
    @Child(name="specialty", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The clinical specialty (discipline) that the referral is requested for", formalDefinition="Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology.")
    protected CodeableConcept specialty;
    @Child(name="recipient", type={Practitioner.class, Organization.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Receiver of referral / transfer of care request", formalDefinition="The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request.")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for referral / transfer of care request", formalDefinition="Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management.")
    protected CodeableConcept reason;
    @Child(name="description", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A textual description of the referral", formalDefinition="The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary.")
    protected StringType description;
    @Child(name="serviceRequested", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actions requested as part of the referral", formalDefinition="The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion.")
    protected List<CodeableConcept> serviceRequested;
    @Child(name="supportingInformation", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additonal information to support referral or transfer of care request", formalDefinition="Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    private static final long serialVersionUID = -1030392098L;
    @SearchParamDefinition(name="category", path="ReferralRequest.category", description="Proposal, plan or request", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="requester", path="ReferralRequest.requester", description="Requester of referral / transfer of care", type="reference")
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("ReferralRequest:requester").toLocked();
    @SearchParamDefinition(name="patient", path="ReferralRequest.patient", description="Who the referral is about", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ReferralRequest:patient").toLocked();
    @SearchParamDefinition(name="status", path="ReferralRequest.status", description="The status of the referral", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="priority", path="ReferralRequest.priority", description="The priority assigned to the referral", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="basedon", path="ReferralRequest.basedOn", description="Request being fulfilled", type="reference")
    public static final String SP_BASEDON = "basedon";
    public static final ReferenceClientParam BASEDON = new ReferenceClientParam("basedon");
    public static final Include INCLUDE_BASEDON = new Include("ReferralRequest:basedon").toLocked();
    @SearchParamDefinition(name="context", path="ReferralRequest.context", description="Part of encounter or episode of care", type="reference")
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("ReferralRequest:context").toLocked();
    @SearchParamDefinition(name="parent", path="ReferralRequest.parent", description="Part of common request", type="token")
    public static final String SP_PARENT = "parent";
    public static final TokenClientParam PARENT = new TokenClientParam("parent");
    @SearchParamDefinition(name="type", path="ReferralRequest.type", description="The type of the referral", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="date", path="ReferralRequest.authored", description="Creation or activation date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="specialty", path="ReferralRequest.specialty", description="The specialty that the referral is for", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="recipient", path="ReferralRequest.recipient", description="The person that the referral was sent to", type="reference")
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("ReferralRequest:recipient").toLocked();

    public ReferralRequest() {
    }

    public ReferralRequest(Enumeration<ReferralStatus> status, Enumeration<ReferralCategory> category) {
        this.status = status;
        this.category = category;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ReferralRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ReferralRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public Identifier getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Identifier();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public ReferralRequest setParent(Identifier value) {
        this.parent = value;
        return this;
    }

    public Enumeration<ReferralStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ReferralStatus>(new ReferralStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ReferralRequest setStatusElement(Enumeration<ReferralStatus> value) {
        this.status = value;
        return this;
    }

    public ReferralStatus getStatus() {
        return this.status == null ? null : (ReferralStatus)((Object)this.status.getValue());
    }

    public ReferralRequest setStatus(ReferralStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ReferralStatus>(new ReferralStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<ReferralCategory> getCategoryElement() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new Enumeration<ReferralCategory>(new ReferralCategoryEnumFactory());
            }
        }
        return this.category;
    }

    public boolean hasCategoryElement() {
        return this.category != null && !this.category.isEmpty();
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public ReferralRequest setCategoryElement(Enumeration<ReferralCategory> value) {
        this.category = value;
        return this;
    }

    public ReferralCategory getCategory() {
        return this.category == null ? null : (ReferralCategory)((Object)this.category.getValue());
    }

    public ReferralRequest setCategory(ReferralCategory value) {
        if (this.category == null) {
            this.category = new Enumeration<ReferralCategory>(new ReferralCategoryEnumFactory());
        }
        this.category.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ReferralRequest setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public ReferralRequest setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ReferralRequest setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ReferralRequest setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public ReferralRequest setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public ReferralRequest setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Period getFulfillmentTime() {
        if (this.fulfillmentTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.fulfillmentTime");
            }
            if (Configuration.doAutoCreate()) {
                this.fulfillmentTime = new Period();
            }
        }
        return this.fulfillmentTime;
    }

    public boolean hasFulfillmentTime() {
        return this.fulfillmentTime != null && !this.fulfillmentTime.isEmpty();
    }

    public ReferralRequest setFulfillmentTime(Period value) {
        this.fulfillmentTime = value;
        return this;
    }

    public DateTimeType getAuthoredElement() {
        if (this.authored == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.authored");
            }
            if (Configuration.doAutoCreate()) {
                this.authored = new DateTimeType();
            }
        }
        return this.authored;
    }

    public boolean hasAuthoredElement() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public boolean hasAuthored() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public ReferralRequest setAuthoredElement(DateTimeType value) {
        this.authored = value;
        return this;
    }

    public Date getAuthored() {
        return this.authored == null ? null : (Date)this.authored.getValue();
    }

    public ReferralRequest setAuthored(Date value) {
        if (value == null) {
            this.authored = null;
        } else {
            if (this.authored == null) {
                this.authored = new DateTimeType();
            }
            this.authored.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public ReferralRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public Resource getRequesterTarget() {
        return this.requesterTarget;
    }

    public ReferralRequest setRequesterTarget(Resource value) {
        this.requesterTarget = value;
        return this;
    }

    public CodeableConcept getSpecialty() {
        if (this.specialty == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.specialty");
            }
            if (Configuration.doAutoCreate()) {
                this.specialty = new CodeableConcept();
            }
        }
        return this.specialty;
    }

    public boolean hasSpecialty() {
        return this.specialty != null && !this.specialty.isEmpty();
    }

    public ReferralRequest setSpecialty(CodeableConcept value) {
        this.specialty = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public ReferralRequest addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public ReferralRequest setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ReferralRequest setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ReferralRequest setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getServiceRequested() {
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        return this.serviceRequested;
    }

    public boolean hasServiceRequested() {
        if (this.serviceRequested == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceRequested) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceRequested() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        this.serviceRequested.add(t);
        return t;
    }

    public ReferralRequest addServiceRequested(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        this.serviceRequested.add(t);
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public ReferralRequest addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public List<Resource> getSupportingInformationTarget() {
        if (this.supportingInformationTarget == null) {
            this.supportingInformationTarget = new ArrayList<Resource>();
        }
        return this.supportingInformationTarget;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("identifier", "Identifier", "Business identifier that uniquely identifies the referral/care transfer request instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("basedOn", "Reference(ReferralRequest|CarePlan|DiagnosticOrder|ProcedureRequest)", "Indicates any plans, proposals or orders that this request is intended to satisfy - in whole or in part.", 0, Integer.MAX_VALUE, this.basedOn));
        childrenList.add(new Property(SP_PARENT, "Identifier", "The business identifier of the logical \"grouping\" request/order that this referral is a part of.", 0, Integer.MAX_VALUE, this.parent));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the authorization/intention reflected by the referral request record.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_CATEGORY, "code", "Distinguishes the \"level\" of authorization/demand implicit in this request.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "An indication of the type of referral (or where applicable the type of transfer of care) request.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_PRIORITY, "CodeableConcept", "An indication of the urgency of referral (or where applicable the type of transfer of care) request.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who is the subject of a referral or transfer of care request.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter at which the request for referral or transfer of care is initiated.", 0, Integer.MAX_VALUE, this.context));
        childrenList.add(new Property("fulfillmentTime", "Period", "The period of time within which the services identified in the referral/transfer of care is specified or required to occur.", 0, Integer.MAX_VALUE, this.fulfillmentTime));
        childrenList.add(new Property("authored", "dateTime", "Date/DateTime of creation for draft requests and date of activation for active requests.", 0, Integer.MAX_VALUE, this.authored));
        childrenList.add(new Property(SP_REQUESTER, "Reference(Practitioner|Organization|Patient)", "The healthcare provider or provider organization who/which initiated the referral/transfer of care request. Can also be  Patient (a self referral).", 0, Integer.MAX_VALUE, this.requester));
        childrenList.add(new Property(SP_SPECIALTY, "CodeableConcept", "Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology.", 0, Integer.MAX_VALUE, this.specialty));
        childrenList.add(new Property(SP_RECIPIENT, "Reference(Practitioner|Organization)", "The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request.", 0, Integer.MAX_VALUE, this.recipient));
        childrenList.add(new Property("reason", "CodeableConcept", "Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("description", "string", "The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("serviceRequested", "CodeableConcept", "The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion.", 0, Integer.MAX_VALUE, this.serviceRequested));
        childrenList.add(new Property("supportingInformation", "Reference(Any)", "Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan.", 0, Integer.MAX_VALUE, this.supportingInformation));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.parent;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.priority;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.patient;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.context;
                }
                return baseArray;
            }
            case 1098185163: {
                Base[] baseArray;
                if (this.fulfillmentTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.fulfillmentTime;
                }
                return baseArray;
            }
            case 1433073514: {
                Base[] baseArray;
                if (this.authored == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.authored;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requester;
                }
                return baseArray;
            }
            case -1694759682: {
                Base[] baseArray;
                if (this.specialty == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.specialty;
                }
                return baseArray;
            }
            case 820081177: {
                return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.reason;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.description;
                }
                return baseArray;
            }
            case 190229561: {
                return this.serviceRequested == null ? new Base[]{} : this.serviceRequested.toArray(new Base[this.serviceRequested.size()]);
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                break;
            }
            case -995424086: {
                this.parent = this.castToIdentifier(value);
                break;
            }
            case -892481550: {
                this.status = new ReferralStatusEnumFactory().fromType(value);
                break;
            }
            case 50511102: {
                this.category = new ReferralCategoryEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                break;
            }
            case 1098185163: {
                this.fulfillmentTime = this.castToPeriod(value);
                break;
            }
            case 1433073514: {
                this.authored = this.castToDateTime(value);
                break;
            }
            case 693933948: {
                this.requester = this.castToReference(value);
                break;
            }
            case -1694759682: {
                this.specialty = this.castToCodeableConcept(value);
                break;
            }
            case 820081177: {
                this.getRecipient().add(this.castToReference(value));
                break;
            }
            case -934964668: {
                this.reason = this.castToCodeableConcept(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case 190229561: {
                this.getServiceRequested().add(this.castToCodeableConcept(value));
                break;
            }
            case -1248768647: {
                this.getSupportingInformation().add(this.castToReference(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_PARENT)) {
            this.parent = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new ReferralStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = new ReferralCategoryEnumFactory().fromType(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("fulfillmentTime")) {
            this.fulfillmentTime = this.castToPeriod(value);
        } else if (name.equals("authored")) {
            this.authored = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = this.castToReference(value);
        } else if (name.equals(SP_SPECIALTY)) {
            this.specialty = this.castToCodeableConcept(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals("reason")) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("serviceRequested")) {
            this.getServiceRequested().add(this.castToCodeableConcept(value));
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995424086: {
                return this.getParent();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 50511102: {
                throw new FHIRException("Cannot make property category as it is not a complex type");
            }
            case 3575610: {
                return this.getType();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 951530927: {
                return this.getContext();
            }
            case 1098185163: {
                return this.getFulfillmentTime();
            }
            case 1433073514: {
                throw new FHIRException("Cannot make property authored as it is not a complex type");
            }
            case 693933948: {
                return this.getRequester();
            }
            case -1694759682: {
                return this.getSpecialty();
            }
            case 820081177: {
                return this.addRecipient();
            }
            case -934964668: {
                return this.getReason();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case 190229561: {
                return this.addServiceRequested();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_PARENT)) {
            this.parent = new Identifier();
            return this.parent;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.status");
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.category");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_PRIORITY)) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("fulfillmentTime")) {
            this.fulfillmentTime = new Period();
            return this.fulfillmentTime;
        }
        if (name.equals("authored")) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.authored");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals(SP_SPECIALTY)) {
            this.specialty = new CodeableConcept();
            return this.specialty;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.description");
        }
        if (name.equals("serviceRequested")) {
            return this.addServiceRequested();
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ReferralRequest";
    }

    @Override
    public ReferralRequest copy() {
        ReferralRequest dst = new ReferralRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.parent = this.parent == null ? null : this.parent.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.fulfillmentTime = this.fulfillmentTime == null ? null : this.fulfillmentTime.copy();
        dst.authored = this.authored == null ? null : this.authored.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        CodeableConcept codeableConcept = dst.specialty = this.specialty == null ? null : this.specialty.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference : this.recipient) {
                dst.recipient.add(reference.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.serviceRequested != null) {
            dst.serviceRequested = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.serviceRequested) {
                dst.serviceRequested.add(codeableConcept2.copy());
            }
        }
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference : this.supportingInformation) {
                dst.supportingInformation.add(reference.copy());
            }
        }
        return dst;
    }

    protected ReferralRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ReferralRequest)) {
            return false;
        }
        ReferralRequest o = (ReferralRequest)other;
        return ReferralRequest.compareDeep(this.identifier, o.identifier, true) && ReferralRequest.compareDeep(this.basedOn, o.basedOn, true) && ReferralRequest.compareDeep(this.parent, o.parent, true) && ReferralRequest.compareDeep(this.status, o.status, true) && ReferralRequest.compareDeep(this.category, o.category, true) && ReferralRequest.compareDeep(this.type, o.type, true) && ReferralRequest.compareDeep(this.priority, o.priority, true) && ReferralRequest.compareDeep(this.patient, o.patient, true) && ReferralRequest.compareDeep(this.context, o.context, true) && ReferralRequest.compareDeep(this.fulfillmentTime, o.fulfillmentTime, true) && ReferralRequest.compareDeep(this.authored, o.authored, true) && ReferralRequest.compareDeep(this.requester, o.requester, true) && ReferralRequest.compareDeep(this.specialty, o.specialty, true) && ReferralRequest.compareDeep(this.recipient, o.recipient, true) && ReferralRequest.compareDeep(this.reason, o.reason, true) && ReferralRequest.compareDeep(this.description, o.description, true) && ReferralRequest.compareDeep(this.serviceRequested, o.serviceRequested, true) && ReferralRequest.compareDeep(this.supportingInformation, o.supportingInformation, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ReferralRequest)) {
            return false;
        }
        ReferralRequest o = (ReferralRequest)other;
        return ReferralRequest.compareValues(this.status, o.status, true) && ReferralRequest.compareValues(this.category, o.category, true) && ReferralRequest.compareValues(this.authored, o.authored, true) && ReferralRequest.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.basedOn != null && !this.basedOn.isEmpty() || this.parent != null && !this.parent.isEmpty() || this.status != null && !this.status.isEmpty() || this.category != null && !this.category.isEmpty() || this.type != null && !this.type.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.context != null && !this.context.isEmpty() || this.fulfillmentTime != null && !this.fulfillmentTime.isEmpty() || this.authored != null && !this.authored.isEmpty() || this.requester != null && !this.requester.isEmpty() || this.specialty != null && !this.specialty.isEmpty() || this.recipient != null && !this.recipient.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.description != null && !this.description.isEmpty() || this.serviceRequested != null && !this.serviceRequested.isEmpty() || this.supportingInformation != null && !this.supportingInformation.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ReferralRequest;
    }

    public static class ReferralCategoryEnumFactory
    implements EnumFactory<ReferralCategory> {
        @Override
        public ReferralCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return ReferralCategory.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return ReferralCategory.PLAN;
            }
            if ("request".equals(codeString)) {
                return ReferralCategory.REQUEST;
            }
            throw new IllegalArgumentException("Unknown ReferralCategory code '" + codeString + "'");
        }

        public Enumeration<ReferralCategory> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.PLAN);
            }
            if ("request".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.REQUEST);
            }
            throw new FHIRException("Unknown ReferralCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferralCategory code) {
            if (code == ReferralCategory.PROPOSAL) {
                return "proposal";
            }
            if (code == ReferralCategory.PLAN) {
                return "plan";
            }
            if (code == ReferralCategory.REQUEST) {
                return "request";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferralCategory code) {
            return code.getSystem();
        }
    }

    public static enum ReferralCategory {
        PROPOSAL,
        PLAN,
        REQUEST,
        NULL;


        public static ReferralCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("request".equals(codeString)) {
                return REQUEST;
            }
            throw new FHIRException("Unknown ReferralCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case REQUEST: {
                    return "request";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/referralcategory";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/referralcategory";
                }
                case REQUEST: {
                    return "http://hl7.org/fhir/referralcategory";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The referral request represents a suggestion or recommendation that a referral be made.";
                }
                case PLAN: {
                    return "The referral request represents an intention by the author to make a referral, but no actual referral has yet been made/authorized.";
                }
                case REQUEST: {
                    return "This is an actual referral request which, when active, will have the authorizations needed to allow it to be actioned.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case REQUEST: {
                    return "Request";
                }
            }
            return "?";
        }
    }

    public static class ReferralStatusEnumFactory
    implements EnumFactory<ReferralStatus> {
        @Override
        public ReferralStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ReferralStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return ReferralStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ReferralStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return ReferralStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ReferralStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ReferralStatus code '" + codeString + "'");
        }

        public Enumeration<ReferralStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.CANCELLED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ReferralStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferralStatus code) {
            if (code == ReferralStatus.DRAFT) {
                return "draft";
            }
            if (code == ReferralStatus.ACTIVE) {
                return "active";
            }
            if (code == ReferralStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ReferralStatus.COMPLETED) {
                return "completed";
            }
            if (code == ReferralStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferralStatus code) {
            return code.getSystem();
        }
    }

    public static enum ReferralStatus {
        DRAFT,
        ACTIVE,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static ReferralStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown ReferralStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/referralstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "A draft referral that has yet to be send.";
                }
                case ACTIVE: {
                    return "The referral is complete and is ready for fulfillment.";
                }
                case CANCELLED: {
                    return "The referral has been cancelled without being completed. For example it is no longer needed.";
                }
                case COMPLETED: {
                    return "The referral has been completely actioned.";
                }
                case ENTEREDINERROR: {
                    return "This referral record should never have existed, though it's possible some degree of real-world activity or decisions may have been taken due to its existence";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

