/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="ProcedureRequest", profile="http://hl7.org/fhir/Profile/ProcedureRequest")
public class ProcedureRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier for the request", formalDefinition="Identifiers assigned to this order by the order or by the receiver.")
    protected List<Identifier> identifier;
    @Child(name="subject", type={Patient.class, Group.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the procedure should be done to", formalDefinition="The person, animal or group that should receive the procedure.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What procedure to perform", formalDefinition="The specific procedure that is ordered. Use text if the exact nature of the procedure cannot be coded.")
    protected CodeableConcept code;
    @Child(name="bodySite", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What part of body to perform on", formalDefinition="Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).")
    protected List<CodeableConcept> bodySite;
    @Child(name="reason", type={CodeableConcept.class, Condition.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why procedure should occur", formalDefinition="The reason why the procedure is being proposed or ordered. This procedure request may be motivated by a Condition for instance.")
    protected Type reason;
    @Child(name="scheduled", type={DateTimeType.class, Period.class, Timing.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When procedure should occur", formalDefinition="The timing schedule for the proposed or ordered procedure. The Schedule data type allows many different expressions.  E.g. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
    protected Type scheduled;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter request created during", formalDefinition="The encounter within which the procedure proposal or request was created.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="performer", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who should perform the procedure", formalDefinition="For example, the surgeon, anaethetist, endoscopist, etc.")
    protected Reference performer;
    protected Resource performerTarget;
    @Child(name="status", type={CodeType.class}, order=8, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | draft | requested | received | accepted | in-progress | completed | suspended | rejected | aborted", formalDefinition="The status of the order.")
    protected Enumeration<ProcedureRequestStatus> status;
    @Child(name="notes", type={Annotation.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information about desired procedure", formalDefinition="Any other notes associated with this proposal or order - e.g. provider instructions.")
    protected List<Annotation> notes;
    @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Preconditions for procedure", formalDefinition="If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.")
    protected Type asNeeded;
    @Child(name="orderedOn", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When request was created", formalDefinition="The time when the request was made.")
    protected DateTimeType orderedOn;
    @Child(name="orderer", type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who made request", formalDefinition="The healthcare professional responsible for proposing or ordering the procedure.")
    protected Reference orderer;
    protected Resource ordererTarget;
    @Child(name="priority", type={CodeType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | stat | asap", formalDefinition="The clinical priority associated with this order.")
    protected Enumeration<ProcedureRequestPriority> priority;
    private static final long serialVersionUID = -916650578L;
    @SearchParamDefinition(name="orderer", path="ProcedureRequest.orderer", description="Who made request", type="reference")
    public static final String SP_ORDERER = "orderer";
    public static final ReferenceClientParam ORDERER = new ReferenceClientParam("orderer");
    public static final Include INCLUDE_ORDERER = new Include("ProcedureRequest:orderer").toLocked();
    @SearchParamDefinition(name="patient", path="ProcedureRequest.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ProcedureRequest:patient").toLocked();
    @SearchParamDefinition(name="subject", path="ProcedureRequest.subject", description="Search by subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ProcedureRequest:subject").toLocked();
    @SearchParamDefinition(name="performer", path="ProcedureRequest.performer", description="Who should perform the procedure", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("ProcedureRequest:performer").toLocked();
    @SearchParamDefinition(name="encounter", path="ProcedureRequest.encounter", description="Encounter request created during", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ProcedureRequest:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="ProcedureRequest.identifier", description="A unique identifier of the Procedure Request", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public ProcedureRequest() {
    }

    public ProcedureRequest(Reference subject, CodeableConcept code) {
        this.subject = subject;
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ProcedureRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ProcedureRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public ProcedureRequest setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ProcedureRequest setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public ProcedureRequest addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public ProcedureRequest setReason(Type value) {
        this.reason = value;
        return this;
    }

    public Type getScheduled() {
        return this.scheduled;
    }

    public DateTimeType getScheduledDateTimeType() throws FHIRException {
        if (!(this.scheduled instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.scheduled.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.scheduled;
    }

    public boolean hasScheduledDateTimeType() {
        return this.scheduled instanceof DateTimeType;
    }

    public Period getScheduledPeriod() throws FHIRException {
        if (!(this.scheduled instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.scheduled.getClass().getName() + " was encountered");
        }
        return (Period)this.scheduled;
    }

    public boolean hasScheduledPeriod() {
        return this.scheduled instanceof Period;
    }

    public Timing getScheduledTiming() throws FHIRException {
        if (!(this.scheduled instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.scheduled.getClass().getName() + " was encountered");
        }
        return (Timing)this.scheduled;
    }

    public boolean hasScheduledTiming() {
        return this.scheduled instanceof Timing;
    }

    public boolean hasScheduled() {
        return this.scheduled != null && !this.scheduled.isEmpty();
    }

    public ProcedureRequest setScheduled(Type value) {
        this.scheduled = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ProcedureRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public ProcedureRequest setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public ProcedureRequest setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Resource getPerformerTarget() {
        return this.performerTarget;
    }

    public ProcedureRequest setPerformerTarget(Resource value) {
        this.performerTarget = value;
        return this;
    }

    public Enumeration<ProcedureRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ProcedureRequestStatus>(new ProcedureRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ProcedureRequest setStatusElement(Enumeration<ProcedureRequestStatus> value) {
        this.status = value;
        return this;
    }

    public ProcedureRequestStatus getStatus() {
        return this.status == null ? null : (ProcedureRequestStatus)((Object)this.status.getValue());
    }

    public ProcedureRequest setStatus(ProcedureRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ProcedureRequestStatus>(new ProcedureRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<Annotation> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        return this.notes;
    }

    public boolean hasNotes() {
        if (this.notes == null) {
            return false;
        }
        for (Annotation item : this.notes) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNotes() {
        Annotation t = new Annotation();
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        this.notes.add(t);
        return t;
    }

    public ProcedureRequest addNotes(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        this.notes.add(t);
        return this;
    }

    public Type getAsNeeded() {
        return this.asNeeded;
    }

    public BooleanType getAsNeededBooleanType() throws FHIRException {
        if (!(this.asNeeded instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.asNeeded;
    }

    public boolean hasAsNeededBooleanType() {
        return this.asNeeded instanceof BooleanType;
    }

    public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
        if (!(this.asNeeded instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.asNeeded;
    }

    public boolean hasAsNeededCodeableConcept() {
        return this.asNeeded instanceof CodeableConcept;
    }

    public boolean hasAsNeeded() {
        return this.asNeeded != null && !this.asNeeded.isEmpty();
    }

    public ProcedureRequest setAsNeeded(Type value) {
        this.asNeeded = value;
        return this;
    }

    public DateTimeType getOrderedOnElement() {
        if (this.orderedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.orderedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.orderedOn = new DateTimeType();
            }
        }
        return this.orderedOn;
    }

    public boolean hasOrderedOnElement() {
        return this.orderedOn != null && !this.orderedOn.isEmpty();
    }

    public boolean hasOrderedOn() {
        return this.orderedOn != null && !this.orderedOn.isEmpty();
    }

    public ProcedureRequest setOrderedOnElement(DateTimeType value) {
        this.orderedOn = value;
        return this;
    }

    public Date getOrderedOn() {
        return this.orderedOn == null ? null : (Date)this.orderedOn.getValue();
    }

    public ProcedureRequest setOrderedOn(Date value) {
        if (value == null) {
            this.orderedOn = null;
        } else {
            if (this.orderedOn == null) {
                this.orderedOn = new DateTimeType();
            }
            this.orderedOn.setValue(value);
        }
        return this;
    }

    public Reference getOrderer() {
        if (this.orderer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.orderer");
            }
            if (Configuration.doAutoCreate()) {
                this.orderer = new Reference();
            }
        }
        return this.orderer;
    }

    public boolean hasOrderer() {
        return this.orderer != null && !this.orderer.isEmpty();
    }

    public ProcedureRequest setOrderer(Reference value) {
        this.orderer = value;
        return this;
    }

    public Resource getOrdererTarget() {
        return this.ordererTarget;
    }

    public ProcedureRequest setOrdererTarget(Resource value) {
        this.ordererTarget = value;
        return this;
    }

    public Enumeration<ProcedureRequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<ProcedureRequestPriority>(new ProcedureRequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public ProcedureRequest setPriorityElement(Enumeration<ProcedureRequestPriority> value) {
        this.priority = value;
        return this;
    }

    public ProcedureRequestPriority getPriority() {
        return this.priority == null ? null : (ProcedureRequestPriority)((Object)this.priority.getValue());
    }

    public ProcedureRequest setPriority(ProcedureRequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<ProcedureRequestPriority>(new ProcedureRequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the order or by the receiver.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group that should receive the procedure.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("code", "CodeableConcept", "The specific procedure that is ordered. Use text if the exact nature of the procedure cannot be coded.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("bodySite", "CodeableConcept", "Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("reason[x]", "CodeableConcept|Reference(Condition)", "The reason why the procedure is being proposed or ordered. This procedure request may be motivated by a Condition for instance.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("scheduled[x]", "dateTime|Period|Timing", "The timing schedule for the proposed or ordered procedure. The Schedule data type allows many different expressions.  E.g. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, Integer.MAX_VALUE, this.scheduled));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter within which the procedure proposal or request was created.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_PERFORMER, "Reference(Practitioner|Organization|Patient|RelatedPerson)", "For example, the surgeon, anaethetist, endoscopist, etc.", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property("status", "code", "The status of the order.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("notes", "Annotation", "Any other notes associated with this proposal or order - e.g. provider instructions.", 0, Integer.MAX_VALUE, this.notes));
        childrenList.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.", 0, Integer.MAX_VALUE, this.asNeeded));
        childrenList.add(new Property("orderedOn", "dateTime", "The time when the request was made.", 0, Integer.MAX_VALUE, this.orderedOn));
        childrenList.add(new Property(SP_ORDERER, "Reference(Practitioner|Patient|RelatedPerson|Device)", "The healthcare professional responsible for proposing or ordering the procedure.", 0, Integer.MAX_VALUE, this.orderer));
        childrenList.add(new Property("priority", "code", "The clinical priority associated with this order.", 0, Integer.MAX_VALUE, this.priority));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.reason;
                }
                return baseArray;
            }
            case -160710483: {
                Base[] baseArray;
                if (this.scheduled == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.scheduled;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.performer;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case 105008833: {
                return this.notes == null ? new Base[]{} : this.notes.toArray(new Base[this.notes.size()]);
            }
            case -1432923513: {
                Base[] baseArray;
                if (this.asNeeded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.asNeeded;
                }
                return baseArray;
            }
            case -391079124: {
                Base[] baseArray;
                if (this.orderedOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.orderedOn;
                }
                return baseArray;
            }
            case -1207109509: {
                Base[] baseArray;
                if (this.orderer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.orderer;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.priority;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                break;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                break;
            }
            case -934964668: {
                this.reason = (Type)value;
                break;
            }
            case -160710483: {
                this.scheduled = (Type)value;
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case 481140686: {
                this.performer = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new ProcedureRequestStatusEnumFactory().fromType(value);
                break;
            }
            case 105008833: {
                this.getNotes().add(this.castToAnnotation(value));
                break;
            }
            case -1432923513: {
                this.asNeeded = (Type)value;
                break;
            }
            case -391079124: {
                this.orderedOn = this.castToDateTime(value);
                break;
            }
            case -1207109509: {
                this.orderer = this.castToReference(value);
                break;
            }
            case -1165461084: {
                this.priority = new ProcedureRequestPriorityEnumFactory().fromType(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("reason[x]")) {
            this.reason = (Type)value;
        } else if (name.equals("scheduled[x]")) {
            this.scheduled = (Type)value;
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = this.castToReference(value);
        } else if (name.equals("status")) {
            this.status = new ProcedureRequestStatusEnumFactory().fromType(value);
        } else if (name.equals("notes")) {
            this.getNotes().add(this.castToAnnotation(value));
        } else if (name.equals("asNeeded[x]")) {
            this.asNeeded = (Type)value;
        } else if (name.equals("orderedOn")) {
            this.orderedOn = this.castToDateTime(value);
        } else if (name.equals(SP_ORDERER)) {
            this.orderer = this.castToReference(value);
        } else if (name.equals("priority")) {
            this.priority = new ProcedureRequestPriorityEnumFactory().fromType(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case -669418564: {
                return this.getReason();
            }
            case 1162627251: {
                return this.getScheduled();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 105008833: {
                return this.addNotes();
            }
            case -544329575: {
                return this.getAsNeeded();
            }
            case -391079124: {
                throw new FHIRException("Cannot make property orderedOn as it is not a complex type");
            }
            case -1207109509: {
                return this.getOrderer();
            }
            case -1165461084: {
                throw new FHIRException("Cannot make property priority as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("scheduledDateTime")) {
            this.scheduled = new DateTimeType();
            return this.scheduled;
        }
        if (name.equals("scheduledPeriod")) {
            this.scheduled = new Period();
            return this.scheduled;
        }
        if (name.equals("scheduledTiming")) {
            this.scheduled = new Timing();
            return this.scheduled;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.status");
        }
        if (name.equals("notes")) {
            return this.addNotes();
        }
        if (name.equals("asNeededBoolean")) {
            this.asNeeded = new BooleanType();
            return this.asNeeded;
        }
        if (name.equals("asNeededCodeableConcept")) {
            this.asNeeded = new CodeableConcept();
            return this.asNeeded;
        }
        if (name.equals("orderedOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.orderedOn");
        }
        if (name.equals(SP_ORDERER)) {
            this.orderer = new Reference();
            return this.orderer;
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.priority");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProcedureRequest";
    }

    @Override
    public ProcedureRequest copy() {
        ProcedureRequest dst = new ProcedureRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.bodySite) {
                dst.bodySite.add(codeableConcept2.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.scheduled = this.scheduled == null ? null : this.scheduled.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        Enumeration<ProcedureRequestStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.notes != null) {
            dst.notes = new ArrayList<Annotation>();
            for (Annotation annotation : this.notes) {
                dst.notes.add(annotation.copy());
            }
        }
        dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
        dst.orderedOn = this.orderedOn == null ? null : this.orderedOn.copy();
        dst.orderer = this.orderer == null ? null : this.orderer.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        return dst;
    }

    protected ProcedureRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ProcedureRequest)) {
            return false;
        }
        ProcedureRequest o = (ProcedureRequest)other;
        return ProcedureRequest.compareDeep(this.identifier, o.identifier, true) && ProcedureRequest.compareDeep(this.subject, o.subject, true) && ProcedureRequest.compareDeep(this.code, o.code, true) && ProcedureRequest.compareDeep(this.bodySite, o.bodySite, true) && ProcedureRequest.compareDeep(this.reason, o.reason, true) && ProcedureRequest.compareDeep(this.scheduled, o.scheduled, true) && ProcedureRequest.compareDeep(this.encounter, o.encounter, true) && ProcedureRequest.compareDeep(this.performer, o.performer, true) && ProcedureRequest.compareDeep(this.status, o.status, true) && ProcedureRequest.compareDeep(this.notes, o.notes, true) && ProcedureRequest.compareDeep(this.asNeeded, o.asNeeded, true) && ProcedureRequest.compareDeep(this.orderedOn, o.orderedOn, true) && ProcedureRequest.compareDeep(this.orderer, o.orderer, true) && ProcedureRequest.compareDeep(this.priority, o.priority, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ProcedureRequest)) {
            return false;
        }
        ProcedureRequest o = (ProcedureRequest)other;
        return ProcedureRequest.compareValues(this.status, o.status, true) && ProcedureRequest.compareValues(this.orderedOn, o.orderedOn, true) && ProcedureRequest.compareValues(this.priority, o.priority, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.code != null && !this.code.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.scheduled != null && !this.scheduled.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.status != null && !this.status.isEmpty() || this.notes != null && !this.notes.isEmpty() || this.asNeeded != null && !this.asNeeded.isEmpty() || this.orderedOn != null && !this.orderedOn.isEmpty() || this.orderer != null && !this.orderer.isEmpty() || this.priority != null && !this.priority.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ProcedureRequest;
    }

    public static class ProcedureRequestPriorityEnumFactory
    implements EnumFactory<ProcedureRequestPriority> {
        @Override
        public ProcedureRequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ProcedureRequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return ProcedureRequestPriority.URGENT;
            }
            if ("stat".equals(codeString)) {
                return ProcedureRequestPriority.STAT;
            }
            if ("asap".equals(codeString)) {
                return ProcedureRequestPriority.ASAP;
            }
            throw new IllegalArgumentException("Unknown ProcedureRequestPriority code '" + codeString + "'");
        }

        public Enumeration<ProcedureRequestPriority> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.URGENT);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.STAT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.ASAP);
            }
            throw new FHIRException("Unknown ProcedureRequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureRequestPriority code) {
            if (code == ProcedureRequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == ProcedureRequestPriority.URGENT) {
                return "urgent";
            }
            if (code == ProcedureRequestPriority.STAT) {
                return "stat";
            }
            if (code == ProcedureRequestPriority.ASAP) {
                return "asap";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureRequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureRequestPriority {
        ROUTINE,
        URGENT,
        STAT,
        ASAP,
        NULL;


        public static ProcedureRequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            throw new FHIRException("Unknown ProcedureRequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case STAT: {
                    return "stat";
                }
                case ASAP: {
                    return "asap";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/procedure-request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/procedure-request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/procedure-request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/procedure-request-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has a normal priority.";
                }
                case URGENT: {
                    return "The request should be done urgently.";
                }
                case STAT: {
                    return "The request is time-critical.";
                }
                case ASAP: {
                    return "The request should be acted on as soon as possible.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case STAT: {
                    return "Stat";
                }
                case ASAP: {
                    return "ASAP";
                }
            }
            return "?";
        }
    }

    public static class ProcedureRequestStatusEnumFactory
    implements EnumFactory<ProcedureRequestStatus> {
        @Override
        public ProcedureRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return ProcedureRequestStatus.PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return ProcedureRequestStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return ProcedureRequestStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return ProcedureRequestStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ProcedureRequestStatus.ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return ProcedureRequestStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return ProcedureRequestStatus.COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return ProcedureRequestStatus.SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return ProcedureRequestStatus.REJECTED;
            }
            if ("aborted".equals(codeString)) {
                return ProcedureRequestStatus.ABORTED;
            }
            throw new IllegalArgumentException("Unknown ProcedureRequestStatus code '" + codeString + "'");
        }

        public Enumeration<ProcedureRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.PROPOSED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.DRAFT);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.REQUESTED);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.RECEIVED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.ACCEPTED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.COMPLETED);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.SUSPENDED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.REJECTED);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.ABORTED);
            }
            throw new FHIRException("Unknown ProcedureRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureRequestStatus code) {
            if (code == ProcedureRequestStatus.PROPOSED) {
                return "proposed";
            }
            if (code == ProcedureRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == ProcedureRequestStatus.REQUESTED) {
                return "requested";
            }
            if (code == ProcedureRequestStatus.RECEIVED) {
                return "received";
            }
            if (code == ProcedureRequestStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == ProcedureRequestStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == ProcedureRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == ProcedureRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == ProcedureRequestStatus.REJECTED) {
                return "rejected";
            }
            if (code == ProcedureRequestStatus.ABORTED) {
                return "aborted";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureRequestStatus {
        PROPOSED,
        DRAFT,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        INPROGRESS,
        COMPLETED,
        SUSPENDED,
        REJECTED,
        ABORTED,
        NULL;


        public static ProcedureRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            throw new FHIRException("Unknown ProcedureRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case REJECTED: {
                    return "rejected";
                }
                case ABORTED: {
                    return "aborted";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/procedure-request-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The request has been proposed.";
                }
                case DRAFT: {
                    return "The request is in preliminary form, prior to being requested.";
                }
                case REQUESTED: {
                    return "The request has been placed.";
                }
                case RECEIVED: {
                    return "The receiving system has received the request but not yet decided whether it will be performed.";
                }
                case ACCEPTED: {
                    return "The receiving system has accepted the request, but work has not yet commenced.";
                }
                case INPROGRESS: {
                    return "The work to fulfill the request is happening.";
                }
                case COMPLETED: {
                    return "The work has been completed, the report(s) released, and no further work is planned.";
                }
                case SUSPENDED: {
                    return "The request has been held by originating system/user request.";
                }
                case REJECTED: {
                    return "The receiving system has declined to fulfill the request.";
                }
                case ABORTED: {
                    return "The request was attempted, but due to some procedural error, it could not be completed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case ABORTED: {
                    return "Aborted";
                }
            }
            return "?";
        }
    }
}

