/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.validator.ProfileKnowledgeWorkerR5;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.common.hapi.validation.validator.VersionTypeConverterDstu3;
import org.hl7.fhir.common.hapi.validation.validator.VersionTypeConverterR4;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotGeneratingValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(SnapshotGeneratingValidationSupport.class);
    private final FhirContext myCtx;

    public SnapshotGeneratingValidationSupport(FhirContext theCtx) {
        Validate.notNull((Object)theCtx);
        this.myCtx = theCtx;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        IBaseResource iBaseResource;
        org.hl7.fhir.r5.model.StructureDefinition inputCanonical;
        VersionSpecificWorkerContextWrapper.IVersionTypeConverter converter;
        String inputUrl = null;
        try {
            assert (theInput.getStructureFhirVersionEnum() == this.myCtx.getVersion().getVersion());
            switch (theInput.getStructureFhirVersionEnum()) {
                case DSTU3: {
                    converter = new VersionTypeConverterDstu3();
                    break;
                }
                case R4: {
                    converter = new VersionTypeConverterR4();
                    break;
                }
                case R5: {
                    converter = VersionSpecificWorkerContextWrapper.IDENTITY_VERSION_TYPE_CONVERTER;
                    break;
                }
                default: {
                    throw new IllegalStateException("Can not generate snapshot for version: " + theInput.getStructureFhirVersionEnum());
                }
            }
            inputCanonical = (org.hl7.fhir.r5.model.StructureDefinition)converter.toCanonical(theInput);
            inputUrl = inputCanonical.getUrl();
            if (theValidationSupportContext.getCurrentlyGeneratingSnapshots().contains(inputUrl)) {
                ourLog.warn("Detected circular dependency, already generating snapshot for: {}", (Object)inputUrl);
                IBaseResource iBaseResource2 = theInput;
                if (inputUrl == null) return iBaseResource2;
                theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
                return iBaseResource2;
            }
        }
        catch (BaseServerResponseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new InternalErrorException("Failed to generate snapshot", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (inputUrl == null) throw throwable;
                theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
                throw throwable;
            }
        }
        {
            theValidationSupportContext.getCurrentlyGeneratingSnapshots().add(inputUrl);
            String baseDefinition = inputCanonical.getBaseDefinition();
            if (StringUtils.isBlank((CharSequence)baseDefinition)) {
                throw new PreconditionFailedException("StructureDefinition[id=" + inputCanonical.getIdElement().getId() + ", url=" + inputCanonical.getUrl() + "] has no base");
            }
            IBaseResource base = theValidationSupportContext.getRootValidationSupport().fetchStructureDefinition(baseDefinition);
            if (base == null) {
                throw new PreconditionFailedException("Unknown base definition: " + baseDefinition);
            }
            org.hl7.fhir.r5.model.StructureDefinition baseCanonical = (org.hl7.fhir.r5.model.StructureDefinition)converter.toCanonical(base);
            if (baseCanonical.getSnapshot().getElement().isEmpty()) {
                theValidationSupportContext.getRootValidationSupport().generateSnapshot(theValidationSupportContext, base, null, null, null);
                baseCanonical = (org.hl7.fhir.r5.model.StructureDefinition)converter.toCanonical(base);
            }
            ArrayList messages = new ArrayList();
            ProfileKnowledgeWorkerR5 profileKnowledgeProvider = new ProfileKnowledgeWorkerR5(this.myCtx);
            VersionSpecificWorkerContextWrapper context = new VersionSpecificWorkerContextWrapper(theValidationSupportContext, converter);
            ProfileUtilities profileUtilities = new ProfileUtilities((IWorkerContext)context, messages, (ProfileUtilities.ProfileKnowledgeProvider)profileKnowledgeProvider);
            profileUtilities.generateSnapshot(baseCanonical, inputCanonical, theUrl, theWebUrl, theProfileName);
            switch (theInput.getStructureFhirVersionEnum()) {
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.StructureDefinition generatedDstu3 = (org.hl7.fhir.dstu3.model.StructureDefinition)converter.fromCanonical((Resource)inputCanonical);
                    ((org.hl7.fhir.dstu3.model.StructureDefinition)theInput).getSnapshot().getElement().clear();
                    ((org.hl7.fhir.dstu3.model.StructureDefinition)theInput).getSnapshot().getElement().addAll(generatedDstu3.getSnapshot().getElement());
                    break;
                }
                case R4: {
                    StructureDefinition generatedR4 = (StructureDefinition)converter.fromCanonical((Resource)inputCanonical);
                    ((StructureDefinition)theInput).getSnapshot().getElement().clear();
                    ((StructureDefinition)theInput).getSnapshot().getElement().addAll(generatedR4.getSnapshot().getElement());
                    break;
                }
                case R5: {
                    org.hl7.fhir.r5.model.StructureDefinition generatedR5 = (org.hl7.fhir.r5.model.StructureDefinition)converter.fromCanonical((Resource)inputCanonical);
                    ((org.hl7.fhir.r5.model.StructureDefinition)theInput).getSnapshot().getElement().clear();
                    ((org.hl7.fhir.r5.model.StructureDefinition)theInput).getSnapshot().getElement().addAll(generatedR5.getSnapshot().getElement());
                    break;
                }
                default: {
                    throw new IllegalStateException("Can not generate snapshot for version: " + theInput.getStructureFhirVersionEnum());
                }
            }
            iBaseResource = theInput;
            if (inputUrl == null) return iBaseResource;
            theValidationSupportContext.getCurrentlyGeneratingSnapshots().remove(inputUrl);
        }
        return iBaseResource;
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }
}

