/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;

public class RemoteTerminologyServiceValidationSupport
extends BaseValidationSupport
implements IValidationSupport {
    private String myBaseUrl;
    private List<Object> myClientInterceptors = new ArrayList<Object>();

    public RemoteTerminologyServiceValidationSupport(FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return this.invokeRemoteValidateCode(theCodeSystem, theCode, theDisplay, theValueSetUrl, null);
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        if (theOptions != null && theOptions.isInferSystem()) {
            return null;
        }
        IBaseResource valueSet = theValueSet;
        String valueSetUrl = DefaultProfileValidationSupport.getConformanceResourceUrl((FhirContext)this.myCtx, (IBaseResource)valueSet);
        if (StringUtils.isNotBlank((CharSequence)valueSetUrl)) {
            valueSet = null;
        } else {
            valueSetUrl = null;
        }
        return this.invokeRemoteValidateCode(theCodeSystem, theCode, theDisplay, valueSetUrl, valueSet);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        IGenericClient client = this.provideClient();
        Class bundleType = this.myCtx.getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class);
        IBaseBundle results = (IBaseBundle)client.search().forResource("CodeSystem").where(CodeSystem.URL.matches().value(theSystem)).returnBundle(bundleType).execute();
        List resultsList = BundleUtil.toListOfResources((FhirContext)this.myCtx, (IBaseBundle)results);
        if (resultsList.size() > 0) {
            return (IBaseResource)resultsList.get(0);
        }
        return null;
    }

    public IBaseResource fetchValueSet(String theValueSetUrl) {
        IGenericClient client = this.provideClient();
        Class bundleType = this.myCtx.getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class);
        IBaseBundle results = (IBaseBundle)client.search().forResource("ValueSet").where(CodeSystem.URL.matches().value(theValueSetUrl)).returnBundle(bundleType).execute();
        List resultsList = BundleUtil.toListOfResources((FhirContext)this.myCtx, (IBaseBundle)results);
        if (resultsList.size() > 0) {
            return (IBaseResource)resultsList.get(0);
        }
        return null;
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.fetchCodeSystem(theSystem) != null;
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.fetchValueSet(theValueSetUrl) != null;
    }

    private IGenericClient provideClient() {
        IGenericClient retVal = this.myCtx.newRestfulGenericClient(this.myBaseUrl);
        for (Object next : this.myClientInterceptors) {
            retVal.registerInterceptor(next);
        }
        return retVal;
    }

    protected IValidationSupport.CodeValidationResult invokeRemoteValidateCode(String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl, IBaseResource theValueSet) {
        if (StringUtils.isBlank((CharSequence)theCode)) {
            return null;
        }
        IGenericClient client = this.provideClient();
        IBaseParameters input = ParametersUtil.newInstance((FhirContext)this.getFhirContext());
        String resourceType = "ValueSet";
        if (theValueSet == null && theValueSetUrl == null) {
            resourceType = "CodeSystem";
            ParametersUtil.addParameterToParametersUri((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"url", (String)theCodeSystem);
            ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"code", (String)theCode);
            if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
                ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"display", (String)theDisplay);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
                ParametersUtil.addParameterToParametersUri((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"url", (String)theValueSetUrl);
            }
            ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"code", (String)theCode);
            if (StringUtils.isNotBlank((CharSequence)theCodeSystem)) {
                ParametersUtil.addParameterToParametersUri((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"system", (String)theCodeSystem);
            }
            if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
                ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"display", (String)theDisplay);
            }
            if (theValueSet != null) {
                ParametersUtil.addParameterToParameters((FhirContext)this.getFhirContext(), (IBaseParameters)input, (String)"valueSet", (Object)theValueSet);
            }
        }
        IBaseParameters output = (IBaseParameters)((IOperationUnnamed)client.operation().onType(resourceType)).named("validate-code").withParameters(input).execute();
        List resultValues = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.getFhirContext(), (IBaseParameters)output, (String)"result");
        if (resultValues.size() < 1 || StringUtils.isBlank((CharSequence)((CharSequence)resultValues.get(0)))) {
            return null;
        }
        Validate.isTrue((resultValues.size() == 1 ? 1 : 0) != 0, (String)"Response contained %d 'result' values", (long)resultValues.size());
        boolean success = "true".equalsIgnoreCase((String)resultValues.get(0));
        IValidationSupport.CodeValidationResult retVal = new IValidationSupport.CodeValidationResult();
        if (success) {
            retVal.setCode(theCode);
            List displayValues = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.getFhirContext(), (IBaseParameters)output, (String)"display");
            if (displayValues.size() > 0) {
                retVal.setDisplay((String)displayValues.get(0));
            }
        } else {
            retVal.setSeverity(IValidationSupport.IssueSeverity.ERROR);
            List messageValues = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.getFhirContext(), (IBaseParameters)output, (String)"message");
            if (messageValues.size() > 0) {
                retVal.setMessage((String)messageValues.get(0));
            }
        }
        return retVal;
    }

    public void setBaseUrl(String theBaseUrl) {
        Validate.notBlank((CharSequence)theBaseUrl, (String)"theBaseUrl must be provided", (Object[])new Object[0]);
        this.myBaseUrl = theBaseUrl;
    }

    public void addClientInterceptor(@Nonnull Object theClientInterceptor) {
        Validate.notNull((Object)theClientInterceptor, (String)"theClientInterceptor must not be null", (Object[])new Object[0]);
        this.myClientInterceptors.add(theClientInterceptor);
    }
}

