/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AddressTypeEnum {
    POSTAL("postal", "http://hl7.org/fhir/address-type"),
    PHYSICAL("physical", "http://hl7.org/fhir/address-type"),
    POSTAL___PHYSICAL("both", "http://hl7.org/fhir/address-type");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "AddressType";
    private static Map<String, AddressTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AddressTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AddressTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static AddressTypeEnum forCode(String theCode) {
        AddressTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AddressTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AddressTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AddressTypeEnum>>();
        for (AddressTypeEnum next : AddressTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AddressTypeEnum>(){

            public String toCodeString(AddressTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AddressTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public AddressTypeEnum fromCodeString(String theCodeString) {
                return (AddressTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public AddressTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (AddressTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

