/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.VisionBaseEnum;
import ca.uhn.fhir.model.dstu2.valueset.VisionEyesEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="VisionPrescription", profile="http://hl7.org/fhir/profiles/VisionPrescription", id="visionprescription")
public class VisionPrescription
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="datewritten", path="VisionPrescription.dateWritten", description="Return prescriptions written on this date", type="date")
    public static final String SP_DATEWRITTEN = "datewritten";
    public static final DateClientParam DATEWRITTEN = new DateClientParam("datewritten");
    @SearchParamDefinition(name="encounter", path="VisionPrescription.encounter", description="Return prescriptions with this encounter identifier", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="identifier", path="VisionPrescription.identifier", description="Return prescriptions with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="VisionPrescription.patient", description="The identity of a patient to list dispenses for", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="prescriber", path="VisionPrescription.prescriber", description="", type="reference", providesMembershipIn={@Compartment(name="RelatedPerson")})
    public static final String SP_PRESCRIBER = "prescriber";
    public static final ReferenceClientParam PRESCRIBER = new ReferenceClientParam("prescriber");
    public static final Include INCLUDE_ENCOUNTER = new Include("VisionPrescription:encounter");
    public static final Include INCLUDE_PATIENT = new Include("VisionPrescription:patient");
    public static final Include INCLUDE_PRESCRIBER = new Include("VisionPrescription:prescriber");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Business identifier which may be used by other parties to reference or identify the prescription.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="dateWritten", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date (and perhaps time) when the prescription was written")
    private DateTimeDt myDateWritten;
    @Child(name="patient", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="A link to a resource representing the person to whom the vision products will be supplied.")
    private ResourceReferenceDt myPatient;
    @Child(name="prescriber", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The healthcare professional responsible for authorizing the prescription")
    private ResourceReferenceDt myPrescriber;
    @Child(name="encounter", order=4, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="", formalDefinition="A link to a resource that identifies the particular occurrence of contact between patient and health care provider.")
    private ResourceReferenceDt myEncounter;
    @Child(name="reason", order=5, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Condition.class})
    @Description(shortDefinition="", formalDefinition="Can be the reason or the indication for writing the prescription.")
    private IDatatype myReason;
    @Child(name="dispense", order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Deals with details of the dispense part of the supply specification.")
    private List<Dispense> myDispense;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDateWritten, this.myPatient, this.myPrescriber, this.myEncounter, this.myReason, this.myDispense});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDateWritten, this.myPatient, this.myPrescriber, this.myEncounter, this.myReason, this.myDispense});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public VisionPrescription setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public VisionPrescription addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DateTimeDt getDateWrittenElement() {
        if (this.myDateWritten == null) {
            this.myDateWritten = new DateTimeDt();
        }
        return this.myDateWritten;
    }

    public Date getDateWritten() {
        return (Date)this.getDateWrittenElement().getValue();
    }

    public VisionPrescription setDateWritten(DateTimeDt theValue) {
        this.myDateWritten = theValue;
        return this;
    }

    public VisionPrescription setDateWritten(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateWritten = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public VisionPrescription setDateWrittenWithSecondsPrecision(Date theDate) {
        this.myDateWritten = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public VisionPrescription setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getPrescriber() {
        if (this.myPrescriber == null) {
            this.myPrescriber = new ResourceReferenceDt();
        }
        return this.myPrescriber;
    }

    public VisionPrescription setPrescriber(ResourceReferenceDt theValue) {
        this.myPrescriber = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public VisionPrescription setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public VisionPrescription setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public List<Dispense> getDispense() {
        if (this.myDispense == null) {
            this.myDispense = new ArrayList<Dispense>();
        }
        return this.myDispense;
    }

    public VisionPrescription setDispense(List<Dispense> theValue) {
        this.myDispense = theValue;
        return this;
    }

    public Dispense addDispense() {
        Dispense newType = new Dispense();
        this.getDispense().add(newType);
        return newType;
    }

    public VisionPrescription addDispense(Dispense theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDispense().add(theValue);
        return this;
    }

    public Dispense getDispenseFirstRep() {
        if (this.getDispense().isEmpty()) {
            return this.addDispense();
        }
        return this.getDispense().get(0);
    }

    public String getResourceName() {
        return "VisionPrescription";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Dispense
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="product", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the type of vision correction product which is required for the patient.")
        private CodingDt myProduct;
        @Child(name="eye", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The eye for which the lens applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vision-eye-codes")
        private BoundCodeDt<VisionEyesEnum> myEye;
        @Child(name="sphere", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Lens power measured in diopters (0.25 units).")
        private DecimalDt mySphere;
        @Child(name="cylinder", type={DecimalDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Power adjustment for astigmatism measured in diopters (0.25 units).")
        private DecimalDt myCylinder;
        @Child(name="axis", type={IntegerDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Adjustment for astigmatism measured in integer degrees.")
        private IntegerDt myAxis;
        @Child(name="prism", type={DecimalDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Amount of prism to compensate for eye alignment in fractional units.")
        private DecimalDt myPrism;
        @Child(name="base", type={CodeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The relative base, or reference lens edge, for the prism.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vision-base-codes")
        private BoundCodeDt<VisionBaseEnum> myBase;
        @Child(name="add", type={DecimalDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Power adjustment for multifocal lenses measured in diopters (0.25 units).")
        private DecimalDt myAdd;
        @Child(name="power", type={DecimalDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact lens power measured in diopters (0.25 units).")
        private DecimalDt myPower;
        @Child(name="backCurve", type={DecimalDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Back curvature measured in millimeters.")
        private DecimalDt myBackCurve;
        @Child(name="diameter", type={DecimalDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact lens diameter measured in millimeters.")
        private DecimalDt myDiameter;
        @Child(name="duration", type={SimpleQuantityDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The recommended maximum wear period for the lens.")
        private SimpleQuantityDt myDuration;
        @Child(name="color", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Special color or pattern.")
        private StringDt myColor;
        @Child(name="brand", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Brand recommendations or restrictions.")
        private StringDt myBrand;
        @Child(name="notes", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Notes for special requirements such as coatings and lens materials.")
        private StringDt myNotes;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myProduct, this.myEye, this.mySphere, this.myCylinder, this.myAxis, this.myPrism, this.myBase, this.myAdd, this.myPower, this.myBackCurve, this.myDiameter, this.myDuration, this.myColor, this.myBrand, this.myNotes});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myProduct, this.myEye, this.mySphere, this.myCylinder, this.myAxis, this.myPrism, this.myBase, this.myAdd, this.myPower, this.myBackCurve, this.myDiameter, this.myDuration, this.myColor, this.myBrand, this.myNotes});
        }

        public CodingDt getProduct() {
            if (this.myProduct == null) {
                this.myProduct = new CodingDt();
            }
            return this.myProduct;
        }

        public Dispense setProduct(CodingDt theValue) {
            this.myProduct = theValue;
            return this;
        }

        public BoundCodeDt<VisionEyesEnum> getEyeElement() {
            if (this.myEye == null) {
                this.myEye = new BoundCodeDt(VisionEyesEnum.VALUESET_BINDER);
            }
            return this.myEye;
        }

        public String getEye() {
            return (String)this.getEyeElement().getValue();
        }

        public Dispense setEye(BoundCodeDt<VisionEyesEnum> theValue) {
            this.myEye = theValue;
            return this;
        }

        public Dispense setEye(VisionEyesEnum theValue) {
            this.setEye((BoundCodeDt<VisionEyesEnum>)new BoundCodeDt(VisionEyesEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public DecimalDt getSphereElement() {
            if (this.mySphere == null) {
                this.mySphere = new DecimalDt();
            }
            return this.mySphere;
        }

        public BigDecimal getSphere() {
            return (BigDecimal)this.getSphereElement().getValue();
        }

        public Dispense setSphere(DecimalDt theValue) {
            this.mySphere = theValue;
            return this;
        }

        public Dispense setSphere(long theValue) {
            this.mySphere = new DecimalDt(theValue);
            return this;
        }

        public Dispense setSphere(double theValue) {
            this.mySphere = new DecimalDt(theValue);
            return this;
        }

        public Dispense setSphere(BigDecimal theValue) {
            this.mySphere = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getCylinderElement() {
            if (this.myCylinder == null) {
                this.myCylinder = new DecimalDt();
            }
            return this.myCylinder;
        }

        public BigDecimal getCylinder() {
            return (BigDecimal)this.getCylinderElement().getValue();
        }

        public Dispense setCylinder(DecimalDt theValue) {
            this.myCylinder = theValue;
            return this;
        }

        public Dispense setCylinder(long theValue) {
            this.myCylinder = new DecimalDt(theValue);
            return this;
        }

        public Dispense setCylinder(double theValue) {
            this.myCylinder = new DecimalDt(theValue);
            return this;
        }

        public Dispense setCylinder(BigDecimal theValue) {
            this.myCylinder = new DecimalDt(theValue);
            return this;
        }

        public IntegerDt getAxisElement() {
            if (this.myAxis == null) {
                this.myAxis = new IntegerDt();
            }
            return this.myAxis;
        }

        public Integer getAxis() {
            return (Integer)this.getAxisElement().getValue();
        }

        public Dispense setAxis(IntegerDt theValue) {
            this.myAxis = theValue;
            return this;
        }

        public Dispense setAxis(int theInteger) {
            this.myAxis = new IntegerDt(theInteger);
            return this;
        }

        public DecimalDt getPrismElement() {
            if (this.myPrism == null) {
                this.myPrism = new DecimalDt();
            }
            return this.myPrism;
        }

        public BigDecimal getPrism() {
            return (BigDecimal)this.getPrismElement().getValue();
        }

        public Dispense setPrism(DecimalDt theValue) {
            this.myPrism = theValue;
            return this;
        }

        public Dispense setPrism(long theValue) {
            this.myPrism = new DecimalDt(theValue);
            return this;
        }

        public Dispense setPrism(double theValue) {
            this.myPrism = new DecimalDt(theValue);
            return this;
        }

        public Dispense setPrism(BigDecimal theValue) {
            this.myPrism = new DecimalDt(theValue);
            return this;
        }

        public BoundCodeDt<VisionBaseEnum> getBaseElement() {
            if (this.myBase == null) {
                this.myBase = new BoundCodeDt(VisionBaseEnum.VALUESET_BINDER);
            }
            return this.myBase;
        }

        public String getBase() {
            return (String)this.getBaseElement().getValue();
        }

        public Dispense setBase(BoundCodeDt<VisionBaseEnum> theValue) {
            this.myBase = theValue;
            return this;
        }

        public Dispense setBase(VisionBaseEnum theValue) {
            this.setBase((BoundCodeDt<VisionBaseEnum>)new BoundCodeDt(VisionBaseEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public DecimalDt getAddElement() {
            if (this.myAdd == null) {
                this.myAdd = new DecimalDt();
            }
            return this.myAdd;
        }

        public BigDecimal getAdd() {
            return (BigDecimal)this.getAddElement().getValue();
        }

        public Dispense setAdd(DecimalDt theValue) {
            this.myAdd = theValue;
            return this;
        }

        public Dispense setAdd(long theValue) {
            this.myAdd = new DecimalDt(theValue);
            return this;
        }

        public Dispense setAdd(double theValue) {
            this.myAdd = new DecimalDt(theValue);
            return this;
        }

        public Dispense setAdd(BigDecimal theValue) {
            this.myAdd = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPowerElement() {
            if (this.myPower == null) {
                this.myPower = new DecimalDt();
            }
            return this.myPower;
        }

        public BigDecimal getPower() {
            return (BigDecimal)this.getPowerElement().getValue();
        }

        public Dispense setPower(DecimalDt theValue) {
            this.myPower = theValue;
            return this;
        }

        public Dispense setPower(long theValue) {
            this.myPower = new DecimalDt(theValue);
            return this;
        }

        public Dispense setPower(double theValue) {
            this.myPower = new DecimalDt(theValue);
            return this;
        }

        public Dispense setPower(BigDecimal theValue) {
            this.myPower = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getBackCurveElement() {
            if (this.myBackCurve == null) {
                this.myBackCurve = new DecimalDt();
            }
            return this.myBackCurve;
        }

        public BigDecimal getBackCurve() {
            return (BigDecimal)this.getBackCurveElement().getValue();
        }

        public Dispense setBackCurve(DecimalDt theValue) {
            this.myBackCurve = theValue;
            return this;
        }

        public Dispense setBackCurve(long theValue) {
            this.myBackCurve = new DecimalDt(theValue);
            return this;
        }

        public Dispense setBackCurve(double theValue) {
            this.myBackCurve = new DecimalDt(theValue);
            return this;
        }

        public Dispense setBackCurve(BigDecimal theValue) {
            this.myBackCurve = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getDiameterElement() {
            if (this.myDiameter == null) {
                this.myDiameter = new DecimalDt();
            }
            return this.myDiameter;
        }

        public BigDecimal getDiameter() {
            return (BigDecimal)this.getDiameterElement().getValue();
        }

        public Dispense setDiameter(DecimalDt theValue) {
            this.myDiameter = theValue;
            return this;
        }

        public Dispense setDiameter(long theValue) {
            this.myDiameter = new DecimalDt(theValue);
            return this;
        }

        public Dispense setDiameter(double theValue) {
            this.myDiameter = new DecimalDt(theValue);
            return this;
        }

        public Dispense setDiameter(BigDecimal theValue) {
            this.myDiameter = new DecimalDt(theValue);
            return this;
        }

        public SimpleQuantityDt getDuration() {
            if (this.myDuration == null) {
                this.myDuration = new SimpleQuantityDt();
            }
            return this.myDuration;
        }

        public Dispense setDuration(SimpleQuantityDt theValue) {
            this.myDuration = theValue;
            return this;
        }

        public StringDt getColorElement() {
            if (this.myColor == null) {
                this.myColor = new StringDt();
            }
            return this.myColor;
        }

        public String getColor() {
            return (String)this.getColorElement().getValue();
        }

        public Dispense setColor(StringDt theValue) {
            this.myColor = theValue;
            return this;
        }

        public Dispense setColor(String theString) {
            this.myColor = new StringDt(theString);
            return this;
        }

        public StringDt getBrandElement() {
            if (this.myBrand == null) {
                this.myBrand = new StringDt();
            }
            return this.myBrand;
        }

        public String getBrand() {
            return (String)this.getBrandElement().getValue();
        }

        public Dispense setBrand(StringDt theValue) {
            this.myBrand = theValue;
            return this;
        }

        public Dispense setBrand(String theString) {
            this.myBrand = new StringDt(theString);
            return this;
        }

        public StringDt getNotesElement() {
            if (this.myNotes == null) {
                this.myNotes = new StringDt();
            }
            return this.myNotes;
        }

        public String getNotes() {
            return (String)this.getNotesElement().getValue();
        }

        public Dispense setNotes(StringDt theValue) {
            this.myNotes = theValue;
            return this;
        }

        public Dispense setNotes(String theString) {
            this.myNotes = new StringDt(theString);
            return this;
        }
    }
}

