/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Coverage;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="EnrollmentRequest", profile="http://hl7.org/fhir/profiles/EnrollmentRequest", id="enrollmentrequest")
public class EnrollmentRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="EnrollmentRequest.identifier", description="The business identifier of the Enrollment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="EnrollmentRequest.subject", description="The party to be enrolled", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="EnrollmentRequest.subject", description="The party to be enrolled", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EnrollmentRequest:patient");
    public static final Include INCLUDE_SUBJECT = new Include("EnrollmentRequest:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="ruleset", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when this resource was created.")
    private DateTimeDt myCreated;
    @Child(name="target", order=4, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The Insurer who is target  of the request.")
    private ResourceReferenceDt myTarget;
    @Child(name="provider", order=5, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myProvider;
    @Child(name="organization", order=6, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myOrganization;
    @Child(name="subject", order=7, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="Patient Resource")
    private ResourceReferenceDt mySubject;
    @Child(name="coverage", order=8, min=1, max=1, summary=false, modifier=false, type={Coverage.class})
    @Description(shortDefinition="", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
    private ResourceReferenceDt myCoverage;
    @Child(name="relationship", type={CodingDt.class}, order=9, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The relationship of the patient to the subscriber")
    private CodingDt myRelationship;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.mySubject, this.myCoverage, this.myRelationship});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.mySubject, this.myCoverage, this.myRelationship});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public EnrollmentRequest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public EnrollmentRequest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public EnrollmentRequest setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public EnrollmentRequest setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public EnrollmentRequest setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public EnrollmentRequest setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public EnrollmentRequest setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public EnrollmentRequest setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public EnrollmentRequest setProvider(ResourceReferenceDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public EnrollmentRequest setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public EnrollmentRequest setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getCoverage() {
        if (this.myCoverage == null) {
            this.myCoverage = new ResourceReferenceDt();
        }
        return this.myCoverage;
    }

    public EnrollmentRequest setCoverage(ResourceReferenceDt theValue) {
        this.myCoverage = theValue;
        return this;
    }

    public CodingDt getRelationship() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodingDt();
        }
        return this.myRelationship;
    }

    public EnrollmentRequest setRelationship(CodingDt theValue) {
        this.myRelationship = theValue;
        return this;
    }

    public String getResourceName() {
        return "EnrollmentRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

