/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.ProcedureRequestPriorityEnum;
import ca.uhn.fhir.model.dstu2.valueset.ProcedureRequestStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ProcedureRequest", profile="http://hl7.org/fhir/profiles/ProcedureRequest", id="procedurerequest")
public class ProcedureRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ProcedureRequest.identifier", description="A unique identifier of the Procedure Request", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="ProcedureRequest.subject", description="Search by subject", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="ProcedureRequest.subject", description="Search by subject - a patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="orderer", path="ProcedureRequest.orderer", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner"), @Compartment(name="Device")})
    public static final String SP_ORDERER = "orderer";
    public static final ReferenceClientParam ORDERER = new ReferenceClientParam("orderer");
    @SearchParamDefinition(name="performer", path="ProcedureRequest.performer", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner")})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="encounter", path="ProcedureRequest.encounter", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ProcedureRequest:encounter");
    public static final Include INCLUDE_ORDERER = new Include("ProcedureRequest:orderer");
    public static final Include INCLUDE_PATIENT = new Include("ProcedureRequest:patient");
    public static final Include INCLUDE_PERFORMER = new Include("ProcedureRequest:performer");
    public static final Include INCLUDE_SUBJECT = new Include("ProcedureRequest:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifiers assigned to this order by the order or by the receiver.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class, Group.class})
    @Description(shortDefinition="who.focus", formalDefinition="The person, animal or group that should receive the procedure.")
    private ResourceReferenceDt mySubject;
    @Child(name="code", type={CodeableConceptDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The specific procedure that is ordered. Use text if the exact nature of the procedure cannot be coded.")
    private CodeableConceptDt myCode;
    @Child(name="bodySite", type={CodeableConceptDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).")
    private List<CodeableConceptDt> myBodySite;
    @Child(name="reason", order=4, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Condition.class})
    @Description(shortDefinition="", formalDefinition="The reason why the procedure is being proposed or ordered. This procedure request may be motivated by a Condition for instance.")
    private IDatatype myReason;
    @Child(name="scheduled", order=5, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class, TimingDt.class})
    @Description(shortDefinition="when.planned", formalDefinition="The timing schedule for the proposed or ordered procedure. The Schedule data type allows many different expressions.  E.g. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
    private IDatatype myScheduled;
    @Child(name="encounter", order=6, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The encounter within which the procedure proposal or request was created.")
    private ResourceReferenceDt myEncounter;
    @Child(name="performer", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.actor", formalDefinition="For example, the surgeon, anaethetist, endoscopist, etc.")
    private ResourceReferenceDt myPerformer;
    @Child(name="status", type={CodeDt.class}, order=8, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of the order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-request-status")
    private BoundCodeDt<ProcedureRequestStatusEnum> myStatus;
    @Child(name="notes", type={AnnotationDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Any other notes associated with this proposal or order - e.g. provider instructions.")
    private List<AnnotationDt> myNotes;
    @Child(name="asNeeded", order=10, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
    @Description(shortDefinition="", formalDefinition="If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.")
    private IDatatype myAsNeeded;
    @Child(name="orderedOn", type={DateTimeDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The time when the request was made.")
    private DateTimeDt myOrderedOn;
    @Child(name="orderer", order=12, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class})
    @Description(shortDefinition="who.author", formalDefinition="The healthcare professional responsible for proposing or ordering the procedure.")
    private ResourceReferenceDt myOrderer;
    @Child(name="priority", type={CodeDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="grade", formalDefinition="The clinical priority associated with this order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-request-priority")
    private BoundCodeDt<ProcedureRequestPriorityEnum> myPriority;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myCode, this.myBodySite, this.myReason, this.myScheduled, this.myEncounter, this.myPerformer, this.myStatus, this.myNotes, this.myAsNeeded, this.myOrderedOn, this.myOrderer, this.myPriority});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myCode, this.myBodySite, this.myReason, this.myScheduled, this.myEncounter, this.myPerformer, this.myStatus, this.myNotes, this.myAsNeeded, this.myOrderedOn, this.myOrderer, this.myPriority});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ProcedureRequest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ProcedureRequest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ProcedureRequest setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public ProcedureRequest setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public List<CodeableConceptDt> getBodySite() {
        if (this.myBodySite == null) {
            this.myBodySite = new ArrayList<CodeableConceptDt>();
        }
        return this.myBodySite;
    }

    public ProcedureRequest setBodySite(List<CodeableConceptDt> theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public CodeableConceptDt addBodySite() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getBodySite().add(newType);
        return newType;
    }

    public ProcedureRequest addBodySite(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getBodySite().add(theValue);
        return this;
    }

    public CodeableConceptDt getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            return this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public ProcedureRequest setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public IDatatype getScheduled() {
        return this.myScheduled;
    }

    public ProcedureRequest setScheduled(IDatatype theValue) {
        this.myScheduled = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ProcedureRequest setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public ProcedureRequest setPerformer(ResourceReferenceDt theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public BoundCodeDt<ProcedureRequestStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ProcedureRequestStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ProcedureRequest setStatus(BoundCodeDt<ProcedureRequestStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ProcedureRequest setStatus(ProcedureRequestStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ProcedureRequestStatusEnum>)new BoundCodeDt(ProcedureRequestStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<AnnotationDt> getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<AnnotationDt>();
        }
        return this.myNotes;
    }

    public ProcedureRequest setNotes(List<AnnotationDt> theValue) {
        this.myNotes = theValue;
        return this;
    }

    public AnnotationDt addNotes() {
        AnnotationDt newType = new AnnotationDt();
        this.getNotes().add(newType);
        return newType;
    }

    public ProcedureRequest addNotes(AnnotationDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNotes().add(theValue);
        return this;
    }

    public AnnotationDt getNotesFirstRep() {
        if (this.getNotes().isEmpty()) {
            return this.addNotes();
        }
        return this.getNotes().get(0);
    }

    public IDatatype getAsNeeded() {
        return this.myAsNeeded;
    }

    public ProcedureRequest setAsNeeded(IDatatype theValue) {
        this.myAsNeeded = theValue;
        return this;
    }

    public DateTimeDt getOrderedOnElement() {
        if (this.myOrderedOn == null) {
            this.myOrderedOn = new DateTimeDt();
        }
        return this.myOrderedOn;
    }

    public Date getOrderedOn() {
        return (Date)this.getOrderedOnElement().getValue();
    }

    public ProcedureRequest setOrderedOn(DateTimeDt theValue) {
        this.myOrderedOn = theValue;
        return this;
    }

    public ProcedureRequest setOrderedOnWithSecondsPrecision(Date theDate) {
        this.myOrderedOn = new DateTimeDt(theDate);
        return this;
    }

    public ProcedureRequest setOrderedOn(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myOrderedOn = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getOrderer() {
        if (this.myOrderer == null) {
            this.myOrderer = new ResourceReferenceDt();
        }
        return this.myOrderer;
    }

    public ProcedureRequest setOrderer(ResourceReferenceDt theValue) {
        this.myOrderer = theValue;
        return this;
    }

    public BoundCodeDt<ProcedureRequestPriorityEnum> getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeDt(ProcedureRequestPriorityEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public String getPriority() {
        return (String)this.getPriorityElement().getValue();
    }

    public ProcedureRequest setPriority(BoundCodeDt<ProcedureRequestPriorityEnum> theValue) {
        this.myPriority = theValue;
        return this;
    }

    public ProcedureRequest setPriority(ProcedureRequestPriorityEnum theValue) {
        this.setPriority((BoundCodeDt<ProcedureRequestPriorityEnum>)new BoundCodeDt(ProcedureRequestPriorityEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public String getResourceName() {
        return "ProcedureRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

