/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;

@DatatypeDef(name="Attachment")
public class AttachmentDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="contentType", type={CodeDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate")
    private CodeDt myContentType;
    @Child(name="language", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The human language of the content. The value can be any valid value according to BCP 47")
    private CodeDt myLanguage;
    @Child(name="data", type={Base64BinaryDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The actual data of the attachment - a sequence of bytes. In XML, represented using base64")
    private Base64BinaryDt myData;
    @Child(name="url", type={UriDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An alternative location where the data can be accessed")
    private UriDt myUrl;
    @Child(name="size", type={UnsignedIntDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The number of bytes of data that make up this attachment.")
    private UnsignedIntDt mySize;
    @Child(name="hash", type={Base64BinaryDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The calculated hash of the data using SHA-1. Represented using base64")
    private Base64BinaryDt myHash;
    @Child(name="title", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A label or set of text to display in place of the data")
    private StringDt myTitle;
    @Child(name="creation", type={DateTimeDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date that the attachment was first created")
    private DateTimeDt myCreation;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContentType, this.myLanguage, this.myData, this.myUrl, this.mySize, this.myHash, this.myTitle, this.myCreation});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContentType, this.myLanguage, this.myData, this.myUrl, this.mySize, this.myHash, this.myTitle, this.myCreation});
    }

    public CodeDt getContentTypeElement() {
        if (this.myContentType == null) {
            this.myContentType = new CodeDt();
        }
        return this.myContentType;
    }

    public String getContentType() {
        return (String)this.getContentTypeElement().getValue();
    }

    public AttachmentDt setContentType(CodeDt theValue) {
        this.myContentType = theValue;
        return this;
    }

    public AttachmentDt setContentType(String theCode) {
        this.myContentType = new CodeDt(theCode);
        return this;
    }

    public CodeDt getLanguageElement() {
        if (this.myLanguage == null) {
            this.myLanguage = new CodeDt();
        }
        return this.myLanguage;
    }

    public String getLanguage() {
        return (String)this.getLanguageElement().getValue();
    }

    public AttachmentDt setLanguage(CodeDt theValue) {
        this.myLanguage = theValue;
        return this;
    }

    public AttachmentDt setLanguage(String theCode) {
        this.myLanguage = new CodeDt(theCode);
        return this;
    }

    public Base64BinaryDt getDataElement() {
        if (this.myData == null) {
            this.myData = new Base64BinaryDt();
        }
        return this.myData;
    }

    public byte[] getData() {
        return (byte[])this.getDataElement().getValue();
    }

    public AttachmentDt setData(Base64BinaryDt theValue) {
        this.myData = theValue;
        return this;
    }

    public AttachmentDt setData(byte[] theBytes) {
        this.myData = new Base64BinaryDt(theBytes);
        return this;
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public AttachmentDt setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public AttachmentDt setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public UnsignedIntDt getSizeElement() {
        if (this.mySize == null) {
            this.mySize = new UnsignedIntDt();
        }
        return this.mySize;
    }

    public Integer getSize() {
        return (Integer)this.getSizeElement().getValue();
    }

    public AttachmentDt setSize(UnsignedIntDt theValue) {
        this.mySize = theValue;
        return this;
    }

    public AttachmentDt setSize(int theInteger) {
        this.mySize = new UnsignedIntDt(theInteger);
        return this;
    }

    public Base64BinaryDt getHashElement() {
        if (this.myHash == null) {
            this.myHash = new Base64BinaryDt();
        }
        return this.myHash;
    }

    public byte[] getHash() {
        return (byte[])this.getHashElement().getValue();
    }

    public AttachmentDt setHash(Base64BinaryDt theValue) {
        this.myHash = theValue;
        return this;
    }

    public AttachmentDt setHash(byte[] theBytes) {
        this.myHash = new Base64BinaryDt(theBytes);
        return this;
    }

    public StringDt getTitleElement() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public String getTitle() {
        return (String)this.getTitleElement().getValue();
    }

    public AttachmentDt setTitle(StringDt theValue) {
        this.myTitle = theValue;
        return this;
    }

    public AttachmentDt setTitle(String theString) {
        this.myTitle = new StringDt(theString);
        return this;
    }

    public DateTimeDt getCreationElement() {
        if (this.myCreation == null) {
            this.myCreation = new DateTimeDt();
        }
        return this.myCreation;
    }

    public Date getCreation() {
        return (Date)this.getCreationElement().getValue();
    }

    public AttachmentDt setCreation(DateTimeDt theValue) {
        this.myCreation = theValue;
        return this;
    }

    public AttachmentDt setCreationWithSecondsPrecision(Date theDate) {
        this.myCreation = new DateTimeDt(theDate);
        return this;
    }

    public AttachmentDt setCreation(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreation = new DateTimeDt(theDate, thePrecision);
        return this;
    }
}

