/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.ImagingObjectSelection;
import ca.uhn.fhir.model.dstu2.resource.ImagingStudy;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Media;
import ca.uhn.fhir.model.dstu2.resource.Observation;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ProcedureRequest;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.resource.Specimen;
import ca.uhn.fhir.model.dstu2.valueset.DiagnosticReportStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DiagnosticReport", profile="http://hl7.org/fhir/profiles/DiagnosticReport", id="diagnosticreport")
public class DiagnosticReport
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="DiagnosticReport.status", description="The status of the report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="issued", path="DiagnosticReport.issued", description="When the report was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="subject", path="DiagnosticReport.subject", description="The subject of the report", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="performer", path="DiagnosticReport.performer", description="Who was the source of the report (organization)", type="reference", providesMembershipIn={@Compartment(name="RelatedPerson")})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="identifier", path="DiagnosticReport.identifier", description="An identifier for the report", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="category", path="DiagnosticReport.category", description="Which diagnostic discipline/department created the report", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="date", path="DiagnosticReport.effective[x]", description="The clinically relevant time of the report", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="specimen", path="DiagnosticReport.specimen", description="The specimen details", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    @SearchParamDefinition(name="code", path="DiagnosticReport.code", description="The code for the report as a whole, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="result", path="DiagnosticReport.result", description="Link to an atomic result (observation resource)", type="reference")
    public static final String SP_RESULT = "result";
    public static final ReferenceClientParam RESULT = new ReferenceClientParam("result");
    @SearchParamDefinition(name="diagnosis", path="DiagnosticReport.codedDiagnosis", description="A coded diagnosis on the report", type="token")
    public static final String SP_DIAGNOSIS = "diagnosis";
    public static final TokenClientParam DIAGNOSIS = new TokenClientParam("diagnosis");
    @SearchParamDefinition(name="image", path="DiagnosticReport.image.link", description="A reference to the image source.", type="reference")
    public static final String SP_IMAGE = "image";
    public static final ReferenceClientParam IMAGE = new ReferenceClientParam("image");
    @SearchParamDefinition(name="request", path="DiagnosticReport.request", description="Reference to the test or procedure request.", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    @SearchParamDefinition(name="patient", path="DiagnosticReport.subject", description="The subject of the report if a patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="encounter", path="DiagnosticReport.encounter", description="The Encounter when the order was made", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DiagnosticReport:encounter");
    public static final Include INCLUDE_IMAGE = new Include("DiagnosticReport:image");
    public static final Include INCLUDE_PATIENT = new Include("DiagnosticReport:patient");
    public static final Include INCLUDE_PERFORMER = new Include("DiagnosticReport:performer");
    public static final Include INCLUDE_REQUEST = new Include("DiagnosticReport:request");
    public static final Include INCLUDE_RESULT = new Include("DiagnosticReport:result");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticReport:specimen");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticReport:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="The local ID assigned to the report by the order filler, usually by the Information System of the diagnostic service provider")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of the diagnostic report as a whole")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-report-status")
    private BoundCodeDt<DiagnosticReportStatusEnum> myStatus;
    @Child(name="category", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.")
    private CodeableConceptDt myCategory;
    @Child(name="code", type={CodeableConceptDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="what", formalDefinition="A code or name that describes this diagnostic report")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-report-codes")
    private CodeableConceptDt myCode;
    @Child(name="subject", order=4, min=1, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="who.focus", formalDefinition="The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources.")
    private ResourceReferenceDt mySubject;
    @Child(name="encounter", order=5, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The link to the health care event (encounter) when the order was made.")
    private ResourceReferenceDt myEncounter;
    @Child(name="effective", order=6, min=1, max=1, summary=true, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="when.done", formalDefinition="The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.")
    private IDatatype myEffective;
    @Child(name="issued", type={InstantDt.class}, order=7, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date and time that this version of the report was released from the source diagnostic service")
    private InstantDt myIssued;
    @Child(name="performer", order=8, min=1, max=1, summary=true, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="who.witness", formalDefinition="The diagnostic service that is responsible for issuing the report")
    private ResourceReferenceDt myPerformer;
    @Child(name="request", order=9, min=0, max=-1, summary=false, modifier=false, type={DiagnosticOrder.class, ProcedureRequest.class, ReferralRequest.class})
    @Description(shortDefinition="", formalDefinition="Details concerning a test or procedure requested.")
    private List<ResourceReferenceDt> myRequest;
    @Child(name="specimen", order=10, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="", formalDefinition="Details about the specimens on which this diagnostic report is based")
    private List<ResourceReferenceDt> mySpecimen;
    @Child(name="result", order=11, min=0, max=-1, summary=false, modifier=false, type={Observation.class})
    @Description(shortDefinition="", formalDefinition="Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. \"atomic\" results), or they can be grouping observations that include references to other members of the group (e.g. \"panels\").")
    private List<ResourceReferenceDt> myResult;
    @Child(name="imagingStudy", order=12, min=0, max=-1, summary=false, modifier=false, type={ImagingStudy.class, ImagingObjectSelection.class})
    @Description(shortDefinition="", formalDefinition="One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.")
    private List<ResourceReferenceDt> myImagingStudy;
    @Child(name="image", order=13, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).")
    private List<Image> myImage;
    @Child(name="conclusion", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Concise and clinically contextualized narrative interpretation of the diagnostic report")
    private StringDt myConclusion;
    @Child(name="codedDiagnosis", type={CodeableConceptDt.class}, order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<CodeableConceptDt> myCodedDiagnosis;
    @Child(name="presentedForm", type={AttachmentDt.class}, order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.")
    private List<AttachmentDt> myPresentedForm;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myCategory, this.myCode, this.mySubject, this.myEncounter, this.myEffective, this.myIssued, this.myPerformer, this.myRequest, this.mySpecimen, this.myResult, this.myImagingStudy, this.myImage, this.myConclusion, this.myCodedDiagnosis, this.myPresentedForm});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myCategory, this.myCode, this.mySubject, this.myEncounter, this.myEffective, this.myIssued, this.myPerformer, this.myRequest, this.mySpecimen, this.myResult, this.myImagingStudy, this.myImage, this.myConclusion, this.myCodedDiagnosis, this.myPresentedForm});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DiagnosticReport setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DiagnosticReport addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<DiagnosticReportStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DiagnosticReportStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public DiagnosticReport setStatus(BoundCodeDt<DiagnosticReportStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DiagnosticReport setStatus(DiagnosticReportStatusEnum theValue) {
        this.setStatus((BoundCodeDt<DiagnosticReportStatusEnum>)new BoundCodeDt(DiagnosticReportStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public DiagnosticReport setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public DiagnosticReport setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DiagnosticReport setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public DiagnosticReport setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public IDatatype getEffective() {
        return this.myEffective;
    }

    public DiagnosticReport setEffective(IDatatype theValue) {
        this.myEffective = theValue;
        return this;
    }

    public InstantDt getIssuedElement() {
        if (this.myIssued == null) {
            this.myIssued = new InstantDt();
        }
        return this.myIssued;
    }

    public Date getIssued() {
        return (Date)this.getIssuedElement().getValue();
    }

    public DiagnosticReport setIssued(InstantDt theValue) {
        this.myIssued = theValue;
        return this;
    }

    public DiagnosticReport setIssuedWithMillisPrecision(Date theDate) {
        this.myIssued = new InstantDt(theDate);
        return this;
    }

    public DiagnosticReport setIssued(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIssued = new InstantDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public DiagnosticReport setPerformer(ResourceReferenceDt theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRequest;
    }

    public DiagnosticReport setRequest(List<ResourceReferenceDt> theValue) {
        this.myRequest = theValue;
        return this;
    }

    public ResourceReferenceDt addRequest() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRequest().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySpecimen;
    }

    public DiagnosticReport setSpecimen(List<ResourceReferenceDt> theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public ResourceReferenceDt addSpecimen() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSpecimen().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getResult() {
        if (this.myResult == null) {
            this.myResult = new ArrayList<ResourceReferenceDt>();
        }
        return this.myResult;
    }

    public DiagnosticReport setResult(List<ResourceReferenceDt> theValue) {
        this.myResult = theValue;
        return this;
    }

    public ResourceReferenceDt addResult() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getResult().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getImagingStudy() {
        if (this.myImagingStudy == null) {
            this.myImagingStudy = new ArrayList<ResourceReferenceDt>();
        }
        return this.myImagingStudy;
    }

    public DiagnosticReport setImagingStudy(List<ResourceReferenceDt> theValue) {
        this.myImagingStudy = theValue;
        return this;
    }

    public ResourceReferenceDt addImagingStudy() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getImagingStudy().add(newType);
        return newType;
    }

    public List<Image> getImage() {
        if (this.myImage == null) {
            this.myImage = new ArrayList<Image>();
        }
        return this.myImage;
    }

    public DiagnosticReport setImage(List<Image> theValue) {
        this.myImage = theValue;
        return this;
    }

    public Image addImage() {
        Image newType = new Image();
        this.getImage().add(newType);
        return newType;
    }

    public DiagnosticReport addImage(Image theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getImage().add(theValue);
        return this;
    }

    public Image getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            return this.addImage();
        }
        return this.getImage().get(0);
    }

    public StringDt getConclusionElement() {
        if (this.myConclusion == null) {
            this.myConclusion = new StringDt();
        }
        return this.myConclusion;
    }

    public String getConclusion() {
        return (String)this.getConclusionElement().getValue();
    }

    public DiagnosticReport setConclusion(StringDt theValue) {
        this.myConclusion = theValue;
        return this;
    }

    public DiagnosticReport setConclusion(String theString) {
        this.myConclusion = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getCodedDiagnosis() {
        if (this.myCodedDiagnosis == null) {
            this.myCodedDiagnosis = new ArrayList<CodeableConceptDt>();
        }
        return this.myCodedDiagnosis;
    }

    public DiagnosticReport setCodedDiagnosis(List<CodeableConceptDt> theValue) {
        this.myCodedDiagnosis = theValue;
        return this;
    }

    public CodeableConceptDt addCodedDiagnosis() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCodedDiagnosis().add(newType);
        return newType;
    }

    public DiagnosticReport addCodedDiagnosis(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCodedDiagnosis().add(theValue);
        return this;
    }

    public CodeableConceptDt getCodedDiagnosisFirstRep() {
        if (this.getCodedDiagnosis().isEmpty()) {
            return this.addCodedDiagnosis();
        }
        return this.getCodedDiagnosis().get(0);
    }

    public List<AttachmentDt> getPresentedForm() {
        if (this.myPresentedForm == null) {
            this.myPresentedForm = new ArrayList<AttachmentDt>();
        }
        return this.myPresentedForm;
    }

    public DiagnosticReport setPresentedForm(List<AttachmentDt> theValue) {
        this.myPresentedForm = theValue;
        return this;
    }

    public AttachmentDt addPresentedForm() {
        AttachmentDt newType = new AttachmentDt();
        this.getPresentedForm().add(newType);
        return newType;
    }

    public DiagnosticReport addPresentedForm(AttachmentDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPresentedForm().add(theValue);
        return this;
    }

    public AttachmentDt getPresentedFormFirstRep() {
        if (this.getPresentedForm().isEmpty()) {
            return this.addPresentedForm();
        }
        return this.getPresentedForm().get(0);
    }

    public String getResourceName() {
        return "DiagnosticReport";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Image
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="comment", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features.")
        private StringDt myComment;
        @Child(name="link", order=1, min=1, max=1, summary=true, modifier=false, type={Media.class})
        @Description(shortDefinition="", formalDefinition="")
        private ResourceReferenceDt myLink;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myComment, this.myLink});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myComment, this.myLink});
        }

        public StringDt getCommentElement() {
            if (this.myComment == null) {
                this.myComment = new StringDt();
            }
            return this.myComment;
        }

        public String getComment() {
            return (String)this.getCommentElement().getValue();
        }

        public Image setComment(StringDt theValue) {
            this.myComment = theValue;
            return this;
        }

        public Image setComment(String theString) {
            this.myComment = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getLink() {
            if (this.myLink == null) {
                this.myLink = new ResourceReferenceDt();
            }
            return this.myLink;
        }

        public Image setLink(ResourceReferenceDt theValue) {
            this.myLink = theValue;
            return this;
        }
    }
}

