/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider.dstu2;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.model.dstu2.resource.OperationDefinition;
import ca.uhn.fhir.model.dstu2.valueset.ConditionalDeleteStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceStatementKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.OperationKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.OperationParameterUseEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.RestfulConformanceModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.SystemRestfulInteractionEnum;
import ca.uhn.fhir.model.dstu2.valueset.TypeRestfulInteractionEnum;
import ca.uhn.fhir.model.dstu2.valueset.UnknownContentCodeEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Initialize;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.DynamicSearchMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.OperationMethodBinding;
import ca.uhn.fhir.rest.method.OperationParameter;
import ca.uhn.fhir.rest.method.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.method.SearchMethodBinding;
import ca.uhn.fhir.rest.method.SearchParameter;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestulfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ServerConformanceProvider
implements IServerConformanceProvider<Conformance> {
    private boolean myCache = true;
    private volatile Conformance myConformance;
    private IdentityHashMap<OperationMethodBinding, String> myOperationBindingToName;
    private HashMap<String, List<OperationMethodBinding>> myOperationNameToBindings;
    private String myPublisher = "Not provided";
    private RestulfulServerConfiguration myServerConfiguration;

    public ServerConformanceProvider(RestfulServer theRestfulServer) {
        this.myServerConfiguration = theRestfulServer.createConfiguration();
    }

    public ServerConformanceProvider(RestulfulServerConfiguration theServerConfiguration) {
        this.myServerConfiguration = theServerConfiguration;
    }

    public ServerConformanceProvider() {
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
        this.myServerConfiguration = theRestfulServer.createConfiguration();
    }

    private void checkBindingForSystemOps(Conformance.Rest rest, Set<SystemRestfulInteractionEnum> systemOps, BaseMethodBinding<?> nextMethodBinding) {
        String sysOpCode;
        if (nextMethodBinding.getRestOperationType() != null && (sysOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
            SystemRestfulInteractionEnum sysOp = (SystemRestfulInteractionEnum)SystemRestfulInteractionEnum.VALUESET_BINDER.fromCodeString(sysOpCode);
            if (sysOp == null) {
                return;
            }
            if (!systemOps.contains((Object)sysOp)) {
                systemOps.add(sysOp);
                rest.addInteraction().setCode(sysOp);
            }
        }
    }

    private Map<String, List<BaseMethodBinding<?>>> collectMethodBindings() {
        String resourceName;
        TreeMap resourceToMethods = new TreeMap();
        for (ResourceBinding next : this.myServerConfiguration.getResourceBindings()) {
            resourceName = next.getResourceName();
            for (BaseMethodBinding nextMethodBinding : next.getMethodBindings()) {
                if (!resourceToMethods.containsKey(resourceName)) {
                    resourceToMethods.put(resourceName, new ArrayList());
                }
                ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
            }
        }
        for (BaseMethodBinding nextMethodBinding : this.myServerConfiguration.getServerBindings()) {
            resourceName = "";
            if (!resourceToMethods.containsKey(resourceName)) {
                resourceToMethods.put(resourceName, new ArrayList());
            }
            ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
        }
        return resourceToMethods;
    }

    private String createOperationName(OperationMethodBinding theMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (theMethodBinding.getResourceName() != null) {
            retVal.append(theMethodBinding.getResourceName());
        }
        retVal.append('-');
        if (theMethodBinding.isCanOperateAtInstanceLevel()) {
            retVal.append('i');
        }
        if (theMethodBinding.isCanOperateAtServerLevel()) {
            retVal.append('s');
        }
        retVal.append('-');
        retVal.append(theMethodBinding.getName(), 1, theMethodBinding.getName().length());
        return retVal.toString();
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    @Metadata
    public Conformance getServerConformance(HttpServletRequest theRequest) {
        if (this.myConformance != null && this.myCache) {
            return this.myConformance;
        }
        Conformance retVal = new Conformance();
        retVal.setPublisher(this.myPublisher);
        retVal.setDate(this.conformanceDate());
        retVal.setFhirVersion("1.0.2");
        retVal.setAcceptUnknown(UnknownContentCodeEnum.UNKNOWN_EXTENSIONS);
        retVal.getImplementation().setDescription(this.myServerConfiguration.getImplementationDescription());
        retVal.setKind(ConformanceStatementKindEnum.INSTANCE);
        retVal.getSoftware().setName(this.myServerConfiguration.getServerName());
        retVal.getSoftware().setVersion(this.myServerConfiguration.getServerVersion());
        retVal.addFormat("application/xml+fhir");
        retVal.addFormat("application/json+fhir");
        Conformance.Rest rest = retVal.addRest();
        rest.setMode(RestfulConformanceModeEnum.SERVER);
        HashSet<SystemRestfulInteractionEnum> systemOps = new HashSet<SystemRestfulInteractionEnum>();
        HashSet<String> operationNames = new HashSet<String>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings();
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            if (!nextEntry.getKey().isEmpty()) {
                HashSet<TypeRestfulInteractionEnum> resourceOps = new HashSet<TypeRestfulInteractionEnum>();
                Conformance.RestResource resource = rest.addResource();
                String resourceName = nextEntry.getKey();
                RuntimeResourceDefinition def = this.myServerConfiguration.getFhirContext().getResourceDefinition(resourceName);
                resource.getTypeElement().setValue((Object)def.getName());
                ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
                String serverBase = this.myServerConfiguration.getServerAddressStrategy().determineServerBase(servletContext, theRequest);
                resource.getProfile().setReference(new IdDt(def.getResourceProfile(serverBase)));
                TreeSet<String> includes = new TreeSet<String>();
                for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                    OperationMethodBinding methodBinding;
                    String opName;
                    TypeRestfulInteractionEnum resOp;
                    String resOpCode;
                    if (nextMethodBinding.getRestOperationType() != null && (resOpCode = nextMethodBinding.getRestOperationType().getCode()) != null && (resOp = (TypeRestfulInteractionEnum)TypeRestfulInteractionEnum.VALUESET_BINDER.fromCodeString(resOpCode)) != null) {
                        if (!resourceOps.contains((Object)resOp)) {
                            resourceOps.add(resOp);
                            resource.addInteraction().setCode(resOp);
                        }
                        if ("vread".equals(resOpCode) && !resourceOps.contains((Object)(resOp = TypeRestfulInteractionEnum.READ))) {
                            resourceOps.add(resOp);
                            resource.addInteraction().setCode(resOp);
                        }
                        if (nextMethodBinding.isSupportsConditional()) {
                            switch (resOp) {
                                case CREATE: {
                                    resource.setConditionalCreate(true);
                                    break;
                                }
                                case DELETE: {
                                    if (nextMethodBinding.isSupportsConditionalMultiple()) {
                                        resource.setConditionalDelete(ConditionalDeleteStatusEnum.MULTIPLE_DELETES_SUPPORTED);
                                        break;
                                    }
                                    resource.setConditionalDelete(ConditionalDeleteStatusEnum.SINGLE_DELETES_SUPPORTED);
                                    break;
                                }
                                case UPDATE: {
                                    resource.setConditionalUpdate(true);
                                    break;
                                }
                            }
                        }
                    }
                    this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                    if (nextMethodBinding instanceof SearchMethodBinding) {
                        this.handleSearchMethodBinding(rest, resource, resourceName, def, includes, (SearchMethodBinding)nextMethodBinding);
                    } else if (nextMethodBinding instanceof DynamicSearchMethodBinding) {
                        this.handleDynamicSearchMethodBinding(resource, def, includes, (DynamicSearchMethodBinding)nextMethodBinding);
                    } else if (nextMethodBinding instanceof OperationMethodBinding && operationNames.add(opName = this.myOperationBindingToName.get(methodBinding = (OperationMethodBinding)nextMethodBinding))) {
                        rest.addOperation().setName(methodBinding.getName().substring(1)).getDefinition().setReference("OperationDefinition/" + opName);
                    }
                    Collections.sort(resource.getInteraction(), new Comparator<Conformance.RestResourceInteraction>(){

                        @Override
                        public int compare(Conformance.RestResourceInteraction theO1, Conformance.RestResourceInteraction theO2) {
                            TypeRestfulInteractionEnum o1 = (TypeRestfulInteractionEnum)theO1.getCodeElement().getValueAsEnum();
                            TypeRestfulInteractionEnum o2 = (TypeRestfulInteractionEnum)theO2.getCodeElement().getValueAsEnum();
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            if (o2 == null) {
                                return -1;
                            }
                            return o1.ordinal() - o2.ordinal();
                        }
                    });
                }
                for (String nextInclude : includes) {
                    resource.addSearchInclude(nextInclude);
                }
                continue;
            }
            for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                OperationMethodBinding methodBinding;
                String opName;
                this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                if (!(nextMethodBinding instanceof OperationMethodBinding) || !operationNames.add(opName = this.myOperationBindingToName.get(methodBinding = (OperationMethodBinding)nextMethodBinding))) continue;
                rest.addOperation().setName(methodBinding.getName().substring(1)).getDefinition().setReference("OperationDefinition/" + opName);
            }
        }
        this.myConformance = retVal;
        return retVal;
    }

    private DateTimeDt conformanceDate() {
        String buildDate = this.myServerConfiguration.getConformanceDate();
        if (buildDate != null) {
            try {
                return new DateTimeDt(buildDate);
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return DateTimeDt.withCurrentTime();
    }

    private void handleDynamicSearchMethodBinding(Conformance.RestResource resource, RuntimeResourceDefinition def, TreeSet<String> includes, DynamicSearchMethodBinding searchMethodBinding) {
        includes.addAll(searchMethodBinding.getIncludes());
        ArrayList<RuntimeSearchParam> searchParameters = new ArrayList<RuntimeSearchParam>();
        searchParameters.addAll(searchMethodBinding.getSearchParams());
        this.sortRuntimeSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            for (RuntimeSearchParam nextParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName;
                String nextParamUnchainedName = nextParamName = nextParameter.getName();
                if (nextParamName.contains(".")) {
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = nextParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                Conformance.RestResourceSearchParam param = resource.addSearchParam();
                param.setName(nextParamName);
                param.setDocumentation(nextParamDescription);
            }
        }
    }

    private void handleSearchMethodBinding(Conformance.Rest rest, Conformance.RestResource resource, String resourceName, RuntimeResourceDefinition def, TreeSet<String> includes, SearchMethodBinding searchMethodBinding) {
        includes.addAll(searchMethodBinding.getIncludes());
        List params = searchMethodBinding.getParameters();
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (IParameter iParameter : params) {
            if (!(iParameter instanceof SearchParameter)) continue;
            searchParameters.add((SearchParameter)iParameter);
        }
        this.sortSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            for (SearchParameter searchParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName = searchParameter.getName();
                String chain = null;
                String nextParamUnchainedName = nextParamName;
                if (nextParamName.contains(".")) {
                    chain = nextParamName.substring(nextParamName.indexOf(46) + 1);
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = searchParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                Conformance.RestResourceSearchParam param = resource.addSearchParam();
                param.setName(nextParamUnchainedName);
                if (StringUtils.isNotBlank((CharSequence)chain)) {
                    param.addChain(chain);
                }
                if (searchParameter.getParamType() == RestSearchParameterTypeEnum.REFERENCE) {
                    for (String nextWhitelist : new TreeSet(searchParameter.getQualifierWhitelist())) {
                        if (!nextWhitelist.startsWith(".")) continue;
                        param.addChain(nextWhitelist.substring(1));
                    }
                }
                param.setDocumentation(nextParamDescription);
                if (searchParameter.getParamType() != null) {
                    param.getTypeElement().setValueAsString(searchParameter.getParamType().getCode());
                }
                for (Class nextTarget : searchParameter.getDeclaredTypes()) {
                    ResourceTypeEnum code;
                    RuntimeResourceDefinition targetDef = this.myServerConfiguration.getFhirContext().getResourceDefinition(nextTarget);
                    if (targetDef == null || (code = (ResourceTypeEnum)ResourceTypeEnum.VALUESET_BINDER.fromCodeString(targetDef.getName())) == null) continue;
                    param.addTarget(code);
                }
            }
        }
    }

    @Initialize
    public void initializeOperations() {
        this.myOperationBindingToName = new IdentityHashMap();
        this.myOperationNameToBindings = new HashMap();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings();
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            List<BaseMethodBinding<?>> nextMethodBindings = nextEntry.getValue();
            for (BaseMethodBinding<?> nextMethodBinding : nextMethodBindings) {
                OperationMethodBinding methodBinding;
                if (!(nextMethodBinding instanceof OperationMethodBinding) || this.myOperationBindingToName.containsKey(methodBinding = (OperationMethodBinding)nextMethodBinding)) continue;
                String name = this.createOperationName(methodBinding);
                this.myOperationBindingToName.put(methodBinding, name);
                if (!this.myOperationNameToBindings.containsKey(name)) {
                    this.myOperationNameToBindings.put(name, new ArrayList());
                }
                this.myOperationNameToBindings.get(name).add(methodBinding);
            }
        }
    }

    @Read(type=OperationDefinition.class)
    public OperationDefinition readOperationDefinition(@IdParam IdDt theId) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException(theId);
        }
        List<OperationMethodBinding> sharedDescriptions = this.myOperationNameToBindings.get(theId.getIdPart());
        if (sharedDescriptions == null || sharedDescriptions.isEmpty()) {
            throw new ResourceNotFoundException(theId);
        }
        OperationDefinition op = new OperationDefinition();
        op.setStatus(ConformanceResourceStatusEnum.ACTIVE);
        op.setKind(OperationKindEnum.OPERATION);
        op.setIdempotent(true);
        HashSet<String> inParams = new HashSet<String>();
        HashSet<String> outParams = new HashSet<String>();
        for (OperationMethodBinding sharedDescription : sharedDescriptions) {
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getDescription())) {
                op.setDescription(sharedDescription.getDescription());
            }
            if (!sharedDescription.isIdempotent()) {
                op.setIdempotent(sharedDescription.isIdempotent());
            }
            op.setCode(sharedDescription.getName().substring(1));
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(sharedDescription.isCanOperateAtInstanceLevel());
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(sharedDescription.isCanOperateAtServerLevel());
            }
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getResourceName())) {
                op.addType().setValue((Object)sharedDescription.getResourceName());
            }
            for (IParameter nextParamUntyped : sharedDescription.getParameters()) {
                if (!(nextParamUntyped instanceof OperationParameter)) continue;
                OperationParameter nextParam = (OperationParameter)nextParamUntyped;
                OperationDefinition.Parameter param = op.addParameter();
                if (!inParams.add(nextParam.getName())) continue;
                param.setUse(OperationParameterUseEnum.IN);
                if (nextParam.getParamType() != null) {
                    param.setType(nextParam.getParamType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
            for (OperationMethodBinding.ReturnType nextParam : sharedDescription.getReturnParams()) {
                if (!outParams.add(nextParam.getName())) continue;
                OperationDefinition.Parameter param = op.addParameter();
                param.setUse(OperationParameterUseEnum.OUT);
                if (nextParam.getType() != null) {
                    param.setType(nextParam.getType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
        }
        if (StringUtils.isBlank((CharSequence)op.getName())) {
            if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                op.setName(op.getDescription());
            } else {
                op.setName(op.getCode());
            }
        }
        if (op.getSystem() == null) {
            op.setSystem(false);
        }
        if (op.getInstance() == null) {
            op.setInstance(false);
        }
        return op;
    }

    public void setCache(boolean theCache) {
        this.myCache = theCache;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    private void sortRuntimeSearchParameters(List<RuntimeSearchParam> searchParameters) {
        Collections.sort(searchParameters, new Comparator<RuntimeSearchParam>(){

            @Override
            public int compare(RuntimeSearchParam theO1, RuntimeSearchParam theO2) {
                return theO1.getName().compareTo(theO2.getName());
            }
        });
    }

    private void sortSearchParameters(List<SearchParameter> searchParameters) {
        Collections.sort(searchParameters, new Comparator<SearchParameter>(){

            @Override
            public int compare(SearchParameter theO1, SearchParameter theO2) {
                if (theO1.isRequired() == theO2.isRequired()) {
                    return theO1.getName().compareTo(theO2.getName());
                }
                if (theO1.isRequired()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

