/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AddressDt;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.AdministrativeGenderEnum;
import ca.uhn.fhir.model.dstu2.valueset.IdentityAssuranceLevelEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Person", profile="http://hl7.org/fhir/profiles/Person", id="person")
public class Person
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Person.identifier", description="A person Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Person.name", description="A portion of name in any name part", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="phonetic", path="Person.name", description="A portion of name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Person.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="phone", path="Person.telecom(system=phone)", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="email", path="Person.telecom(system=email)", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="address", path="Person.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-city", path="Person.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="Person.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-postalcode", path="Person.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Person.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-use", path="Person.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="gender", path="Person.gender", description="The gender of the person", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="birthdate", path="Person.birthDate", description="The person's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    @SearchParamDefinition(name="organization", path="Person.managingOrganization", description="The organization at which this person record is being managed", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="link", path="Person.link.target", description="Any link has this Patient, Person, RelatedPerson or Practitioner reference", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_LINK = "link";
    public static final ReferenceClientParam LINK = new ReferenceClientParam("link");
    @SearchParamDefinition(name="patient", path="Person.link.target", description="The Person links to this Patient", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="practitioner", path="Person.link.target", description="The Person links to this Practitioner", type="reference", providesMembershipIn={@Compartment(name="RelatedPerson")}, target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    @SearchParamDefinition(name="relatedperson", path="Person.link.target", description="The Person links to this RelatedPerson", type="reference", target={RelatedPerson.class})
    public static final String SP_RELATEDPERSON = "relatedperson";
    public static final ReferenceClientParam RELATEDPERSON = new ReferenceClientParam("relatedperson");
    public static final Include INCLUDE_LINK = new Include("Person:link");
    public static final Include INCLUDE_ORGANIZATION = new Include("Person:organization");
    public static final Include INCLUDE_PATIENT = new Include("Person:patient");
    public static final Include INCLUDE_PRACTITIONER = new Include("Person:practitioner");
    public static final Include INCLUDE_RELATEDPERSON = new Include("Person:relatedperson");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier for a person within a particular scope.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A name associated with the person")
    private List<HumanNameDt> myName;
    @Child(name="telecom", type={ContactPointDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
    private List<ContactPointDt> myTelecom;
    @Child(name="gender", type={CodeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Administrative Gender")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    private BoundCodeDt<AdministrativeGenderEnum> myGender;
    @Child(name="birthDate", type={DateDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The birth date for the person.")
    private DateDt myBirthDate;
    @Child(name="address", type={AddressDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="One or more addresses for the person")
    private List<AddressDt> myAddress;
    @Child(name="photo", type={AttachmentDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An image that can be displayed as a thumbnail of the person to enhance the identification of the individual")
    private AttachmentDt myPhoto;
    @Child(name="managingOrganization", order=7, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization that is the custodian of the person record")
    private ResourceReferenceDt myManagingOrganization;
    @Child(name="active", type={BooleanDt.class}, order=8, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Whether this person's record is in active use")
    private BooleanDt myActive;
    @Child(name="link", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Link> myLink;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myAddress, this.myPhoto, this.myManagingOrganization, this.myActive, this.myLink});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myAddress, this.myPhoto, this.myManagingOrganization, this.myActive, this.myLink});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Person setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Person addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<HumanNameDt> getName() {
        if (this.myName == null) {
            this.myName = new ArrayList<HumanNameDt>();
        }
        return this.myName;
    }

    public Person setName(List<HumanNameDt> theValue) {
        this.myName = theValue;
        return this;
    }

    public HumanNameDt addName() {
        HumanNameDt newType = new HumanNameDt();
        this.getName().add(newType);
        return newType;
    }

    public Person addName(HumanNameDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getName().add(theValue);
        return this;
    }

    public HumanNameDt getNameFirstRep() {
        if (this.getName().isEmpty()) {
            return this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public Person setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public Person addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public BoundCodeDt<AdministrativeGenderEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public String getGender() {
        return (String)this.getGenderElement().getValue();
    }

    public Person setGender(BoundCodeDt<AdministrativeGenderEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public Person setGender(AdministrativeGenderEnum theValue) {
        this.setGender((BoundCodeDt<AdministrativeGenderEnum>)new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateDt getBirthDateElement() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateDt();
        }
        return this.myBirthDate;
    }

    public Date getBirthDate() {
        return (Date)this.getBirthDateElement().getValue();
    }

    public Person setBirthDate(DateDt theValue) {
        this.myBirthDate = theValue;
        return this;
    }

    public Person setBirthDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myBirthDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Person setBirthDateWithDayPrecision(Date theDate) {
        this.myBirthDate = new DateDt(theDate);
        return this;
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public Person setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public Person addAddress(AddressDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAddress().add(theValue);
        return this;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public AttachmentDt getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new AttachmentDt();
        }
        return this.myPhoto;
    }

    public Person setPhoto(AttachmentDt theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public ResourceReferenceDt getManagingOrganization() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public Person setManagingOrganization(ResourceReferenceDt theValue) {
        this.myManagingOrganization = theValue;
        return this;
    }

    public BooleanDt getActiveElement() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public Boolean getActive() {
        return (Boolean)this.getActiveElement().getValue();
    }

    public Person setActive(BooleanDt theValue) {
        this.myActive = theValue;
        return this;
    }

    public Person setActive(boolean theBoolean) {
        this.myActive = new BooleanDt(theBoolean);
        return this;
    }

    public List<Link> getLink() {
        if (this.myLink == null) {
            this.myLink = new ArrayList<Link>();
        }
        return this.myLink;
    }

    public Person setLink(List<Link> theValue) {
        this.myLink = theValue;
        return this;
    }

    public Link addLink() {
        Link newType = new Link();
        this.getLink().add(newType);
        return newType;
    }

    public Person addLink(Link theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getLink().add(theValue);
        return this;
    }

    public Link getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            return this.addLink();
        }
        return this.getLink().get(0);
    }

    public String getResourceName() {
        return "Person";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Link
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="target", order=0, min=1, max=1, summary=false, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class, Person.class})
        @Description(shortDefinition="", formalDefinition="")
        private ResourceReferenceDt myTarget;
        @Child(name="assurance", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Level of assurance that this link is actually associated with the target resource")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/identity-assuranceLevel")
        private BoundCodeDt<IdentityAssuranceLevelEnum> myAssurance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myTarget, this.myAssurance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTarget, this.myAssurance});
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public Link setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }

        public BoundCodeDt<IdentityAssuranceLevelEnum> getAssuranceElement() {
            if (this.myAssurance == null) {
                this.myAssurance = new BoundCodeDt(IdentityAssuranceLevelEnum.VALUESET_BINDER);
            }
            return this.myAssurance;
        }

        public String getAssurance() {
            return (String)this.getAssuranceElement().getValue();
        }

        public Link setAssurance(BoundCodeDt<IdentityAssuranceLevelEnum> theValue) {
            this.myAssurance = theValue;
            return this;
        }

        public Link setAssurance(IdentityAssuranceLevelEnum theValue) {
            this.setAssurance((BoundCodeDt<IdentityAssuranceLevelEnum>)new BoundCodeDt(IdentityAssuranceLevelEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }
    }
}

