/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.MoneyDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.ClaimResponse;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.MedicationOrder;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.resource.VisionPrescription;
import ca.uhn.fhir.model.dstu2.valueset.ClaimTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.UseEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Claim", profile="http://hl7.org/fhir/profiles/Claim", id="claim")
public class Claim
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Claim.identifier", description="The primary identifier of the financial resource", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="use", path="Claim.use", description="The kind of financial resource", type="token")
    public static final String SP_USE = "use";
    public static final TokenClientParam USE = new TokenClientParam("use");
    @SearchParamDefinition(name="priority", path="Claim.priority", description="Processing priority requested", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="patient", path="Claim.patient", description="Patient", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="provider", path="Claim.provider", description="Provider responsible for the claim", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PATIENT = new Include("Claim:patient");
    public static final Include INCLUDE_PROVIDER = new Include("Claim:provider");
    @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The category of claim this is")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-type-link")
    private BoundCodeDt<ClaimTypeEnum> myType;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="ruleset", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the specification on which this instance relies.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the specification from which the original instance was created.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when the enclosed suite of services were performed or completed")
    private DateTimeDt myCreated;
    @Child(name="target", order=5, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Insurer Identifier, typical BIN number (6 digit).")
    private ResourceReferenceDt myTarget;
    @Child(name="provider", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The provider which is responsible for the bill, claim pre-determination, pre-authorization.")
    private ResourceReferenceDt myProvider;
    @Child(name="organization", order=7, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the bill, claim pre-determination, pre-authorization.")
    private ResourceReferenceDt myOrganization;
    @Child(name="use", type={CodeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Complete (Bill or Claim), Proposed (Pre-Authorization), Exploratory (Pre-determination).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-use-link")
    private BoundCodeDt<UseEnum> myUse;
    @Child(name="priority", type={CodingDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Immediate (stat), best effort (normal), deferred (deferred)")
    private CodingDt myPriority;
    @Child(name="fundsReserve", type={CodingDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="In the case of a Pre-Determination/Pre-Authorization the provider may request that funds in the amount of the expected Benefit be reserved ('Patient' or 'Provider') to pay for the Benefits determined on the subsequent claim(s). 'None' explicitly indicates no funds reserving is requested.")
    private CodingDt myFundsReserve;
    @Child(name="enterer", order=11, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="Person who created the invoice/claim/pre-determination or pre-authorization.")
    private ResourceReferenceDt myEnterer;
    @Child(name="facility", order=12, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="Facility where the services were provided.")
    private ResourceReferenceDt myFacility;
    @Child(name="prescription", order=13, min=0, max=1, summary=false, modifier=false, type={MedicationOrder.class, VisionPrescription.class})
    @Description(shortDefinition="", formalDefinition="Prescription to support the dispensing of Pharmacy or Vision products.")
    private ResourceReferenceDt myPrescription;
    @Child(name="originalPrescription", order=14, min=0, max=1, summary=false, modifier=false, type={MedicationOrder.class})
    @Description(shortDefinition="", formalDefinition="Original prescription to support the dispensing of pharmacy services, medications or products.")
    private ResourceReferenceDt myOriginalPrescription;
    @Child(name="payee", order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The party to be reimbursed for the services.")
    private Payee myPayee;
    @Child(name="referral", order=16, min=0, max=1, summary=false, modifier=false, type={ReferralRequest.class})
    @Description(shortDefinition="", formalDefinition="The referral resource which lists the date, practitioner, reason and other supporting information.")
    private ResourceReferenceDt myReferral;
    @Child(name="diagnosis", order=17, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Ordered list of patient diagnosis for which care is sought.")
    private List<Diagnosis> myDiagnosis;
    @Child(name="condition", type={CodingDt.class}, order=18, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of patient conditions for which care is sought.")
    private List<CodingDt> myCondition;
    @Child(name="patient", order=19, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="Patient Resource")
    private ResourceReferenceDt myPatient;
    @Child(name="coverage", order=20, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Financial instrument by which payment information for health care")
    private List<Coverage> myCoverage;
    @Child(name="exception", type={CodingDt.class}, order=21, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Factors which may influence the applicability of coverage.")
    private List<CodingDt> myException;
    @Child(name="school", type={StringDt.class}, order=22, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Name of school for over-aged dependents.")
    private StringDt mySchool;
    @Child(name="accident", type={DateDt.class}, order=23, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Date of an accident which these services are addressing.")
    private DateDt myAccident;
    @Child(name="accidentType", type={CodingDt.class}, order=24, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Type of accident: work, auto, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActIncidentCode")
    private CodingDt myAccidentType;
    @Child(name="interventionException", type={CodingDt.class}, order=25, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A list of intervention and exception codes which may influence the adjudication of the claim.")
    private List<CodingDt> myInterventionException;
    @Child(name="item", order=26, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="First tier of goods and services")
    private List<Item> myItem;
    @Child(name="additionalMaterials", type={CodingDt.class}, order=27, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Code to indicate that Xrays, images, emails, documents, models or attachments are being sent in support of this submission.")
    private List<CodingDt> myAdditionalMaterials;
    @Child(name="missingTeeth", order=28, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A list of teeth which would be expected but are not found due to having been previously  extracted or for other reasons.")
    private List<MissingTeeth> myMissingTeeth;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.myUse, this.myPriority, this.myFundsReserve, this.myEnterer, this.myFacility, this.myPrescription, this.myOriginalPrescription, this.myPayee, this.myReferral, this.myDiagnosis, this.myCondition, this.myPatient, this.myCoverage, this.myException, this.mySchool, this.myAccident, this.myAccidentType, this.myInterventionException, this.myItem, this.myAdditionalMaterials, this.myMissingTeeth});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.myUse, this.myPriority, this.myFundsReserve, this.myEnterer, this.myFacility, this.myPrescription, this.myOriginalPrescription, this.myPayee, this.myReferral, this.myDiagnosis, this.myCondition, this.myPatient, this.myCoverage, this.myException, this.mySchool, this.myAccident, this.myAccidentType, this.myInterventionException, this.myItem, this.myAdditionalMaterials, this.myMissingTeeth});
    }

    public BoundCodeDt<ClaimTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(ClaimTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public Claim setType(BoundCodeDt<ClaimTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Claim setType(ClaimTypeEnum theValue) {
        this.setType((BoundCodeDt<ClaimTypeEnum>)new BoundCodeDt(ClaimTypeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Claim setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Claim addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public Claim setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public Claim setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public Claim setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public Claim setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Claim setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public Claim setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public Claim setProvider(ResourceReferenceDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public Claim setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public BoundCodeDt<UseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(UseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public String getUse() {
        return (String)this.getUseElement().getValue();
    }

    public Claim setUse(BoundCodeDt<UseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public Claim setUse(UseEnum theValue) {
        this.setUse((BoundCodeDt<UseEnum>)new BoundCodeDt(UseEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodingDt getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new CodingDt();
        }
        return this.myPriority;
    }

    public Claim setPriority(CodingDt theValue) {
        this.myPriority = theValue;
        return this;
    }

    public CodingDt getFundsReserve() {
        if (this.myFundsReserve == null) {
            this.myFundsReserve = new CodingDt();
        }
        return this.myFundsReserve;
    }

    public Claim setFundsReserve(CodingDt theValue) {
        this.myFundsReserve = theValue;
        return this;
    }

    public ResourceReferenceDt getEnterer() {
        if (this.myEnterer == null) {
            this.myEnterer = new ResourceReferenceDt();
        }
        return this.myEnterer;
    }

    public Claim setEnterer(ResourceReferenceDt theValue) {
        this.myEnterer = theValue;
        return this;
    }

    public ResourceReferenceDt getFacility() {
        if (this.myFacility == null) {
            this.myFacility = new ResourceReferenceDt();
        }
        return this.myFacility;
    }

    public Claim setFacility(ResourceReferenceDt theValue) {
        this.myFacility = theValue;
        return this;
    }

    public ResourceReferenceDt getPrescription() {
        if (this.myPrescription == null) {
            this.myPrescription = new ResourceReferenceDt();
        }
        return this.myPrescription;
    }

    public Claim setPrescription(ResourceReferenceDt theValue) {
        this.myPrescription = theValue;
        return this;
    }

    public ResourceReferenceDt getOriginalPrescription() {
        if (this.myOriginalPrescription == null) {
            this.myOriginalPrescription = new ResourceReferenceDt();
        }
        return this.myOriginalPrescription;
    }

    public Claim setOriginalPrescription(ResourceReferenceDt theValue) {
        this.myOriginalPrescription = theValue;
        return this;
    }

    public Payee getPayee() {
        if (this.myPayee == null) {
            this.myPayee = new Payee();
        }
        return this.myPayee;
    }

    public Claim setPayee(Payee theValue) {
        this.myPayee = theValue;
        return this;
    }

    public ResourceReferenceDt getReferral() {
        if (this.myReferral == null) {
            this.myReferral = new ResourceReferenceDt();
        }
        return this.myReferral;
    }

    public Claim setReferral(ResourceReferenceDt theValue) {
        this.myReferral = theValue;
        return this;
    }

    public List<Diagnosis> getDiagnosis() {
        if (this.myDiagnosis == null) {
            this.myDiagnosis = new ArrayList<Diagnosis>();
        }
        return this.myDiagnosis;
    }

    public Claim setDiagnosis(List<Diagnosis> theValue) {
        this.myDiagnosis = theValue;
        return this;
    }

    public Diagnosis addDiagnosis() {
        Diagnosis newType = new Diagnosis();
        this.getDiagnosis().add(newType);
        return newType;
    }

    public Claim addDiagnosis(Diagnosis theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDiagnosis().add(theValue);
        return this;
    }

    public Diagnosis getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            return this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<CodingDt> getCondition() {
        if (this.myCondition == null) {
            this.myCondition = new ArrayList<CodingDt>();
        }
        return this.myCondition;
    }

    public Claim setCondition(List<CodingDt> theValue) {
        this.myCondition = theValue;
        return this;
    }

    public CodingDt addCondition() {
        CodingDt newType = new CodingDt();
        this.getCondition().add(newType);
        return newType;
    }

    public Claim addCondition(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCondition().add(theValue);
        return this;
    }

    public CodingDt getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            return this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Claim setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public List<Coverage> getCoverage() {
        if (this.myCoverage == null) {
            this.myCoverage = new ArrayList<Coverage>();
        }
        return this.myCoverage;
    }

    public Claim setCoverage(List<Coverage> theValue) {
        this.myCoverage = theValue;
        return this;
    }

    public Coverage addCoverage() {
        Coverage newType = new Coverage();
        this.getCoverage().add(newType);
        return newType;
    }

    public Claim addCoverage(Coverage theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCoverage().add(theValue);
        return this;
    }

    public Coverage getCoverageFirstRep() {
        if (this.getCoverage().isEmpty()) {
            return this.addCoverage();
        }
        return this.getCoverage().get(0);
    }

    public List<CodingDt> getException() {
        if (this.myException == null) {
            this.myException = new ArrayList<CodingDt>();
        }
        return this.myException;
    }

    public Claim setException(List<CodingDt> theValue) {
        this.myException = theValue;
        return this;
    }

    public CodingDt addException() {
        CodingDt newType = new CodingDt();
        this.getException().add(newType);
        return newType;
    }

    public Claim addException(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getException().add(theValue);
        return this;
    }

    public CodingDt getExceptionFirstRep() {
        if (this.getException().isEmpty()) {
            return this.addException();
        }
        return this.getException().get(0);
    }

    public StringDt getSchoolElement() {
        if (this.mySchool == null) {
            this.mySchool = new StringDt();
        }
        return this.mySchool;
    }

    public String getSchool() {
        return (String)this.getSchoolElement().getValue();
    }

    public Claim setSchool(StringDt theValue) {
        this.mySchool = theValue;
        return this;
    }

    public Claim setSchool(String theString) {
        this.mySchool = new StringDt(theString);
        return this;
    }

    public DateDt getAccidentElement() {
        if (this.myAccident == null) {
            this.myAccident = new DateDt();
        }
        return this.myAccident;
    }

    public Date getAccident() {
        return (Date)this.getAccidentElement().getValue();
    }

    public Claim setAccident(DateDt theValue) {
        this.myAccident = theValue;
        return this;
    }

    public Claim setAccident(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myAccident = new DateDt(theDate, thePrecision);
        return this;
    }

    public Claim setAccidentWithDayPrecision(Date theDate) {
        this.myAccident = new DateDt(theDate);
        return this;
    }

    public CodingDt getAccidentType() {
        if (this.myAccidentType == null) {
            this.myAccidentType = new CodingDt();
        }
        return this.myAccidentType;
    }

    public Claim setAccidentType(CodingDt theValue) {
        this.myAccidentType = theValue;
        return this;
    }

    public List<CodingDt> getInterventionException() {
        if (this.myInterventionException == null) {
            this.myInterventionException = new ArrayList<CodingDt>();
        }
        return this.myInterventionException;
    }

    public Claim setInterventionException(List<CodingDt> theValue) {
        this.myInterventionException = theValue;
        return this;
    }

    public CodingDt addInterventionException() {
        CodingDt newType = new CodingDt();
        this.getInterventionException().add(newType);
        return newType;
    }

    public Claim addInterventionException(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getInterventionException().add(theValue);
        return this;
    }

    public CodingDt getInterventionExceptionFirstRep() {
        if (this.getInterventionException().isEmpty()) {
            return this.addInterventionException();
        }
        return this.getInterventionException().get(0);
    }

    public List<Item> getItem() {
        if (this.myItem == null) {
            this.myItem = new ArrayList<Item>();
        }
        return this.myItem;
    }

    public Claim setItem(List<Item> theValue) {
        this.myItem = theValue;
        return this;
    }

    public Item addItem() {
        Item newType = new Item();
        this.getItem().add(newType);
        return newType;
    }

    public Claim addItem(Item theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getItem().add(theValue);
        return this;
    }

    public Item getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            return this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<CodingDt> getAdditionalMaterials() {
        if (this.myAdditionalMaterials == null) {
            this.myAdditionalMaterials = new ArrayList<CodingDt>();
        }
        return this.myAdditionalMaterials;
    }

    public Claim setAdditionalMaterials(List<CodingDt> theValue) {
        this.myAdditionalMaterials = theValue;
        return this;
    }

    public CodingDt addAdditionalMaterials() {
        CodingDt newType = new CodingDt();
        this.getAdditionalMaterials().add(newType);
        return newType;
    }

    public Claim addAdditionalMaterials(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAdditionalMaterials().add(theValue);
        return this;
    }

    public CodingDt getAdditionalMaterialsFirstRep() {
        if (this.getAdditionalMaterials().isEmpty()) {
            return this.addAdditionalMaterials();
        }
        return this.getAdditionalMaterials().get(0);
    }

    public List<MissingTeeth> getMissingTeeth() {
        if (this.myMissingTeeth == null) {
            this.myMissingTeeth = new ArrayList<MissingTeeth>();
        }
        return this.myMissingTeeth;
    }

    public Claim setMissingTeeth(List<MissingTeeth> theValue) {
        this.myMissingTeeth = theValue;
        return this;
    }

    public MissingTeeth addMissingTeeth() {
        MissingTeeth newType = new MissingTeeth();
        this.getMissingTeeth().add(newType);
        return newType;
    }

    public Claim addMissingTeeth(MissingTeeth theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMissingTeeth().add(theValue);
        return this;
    }

    public MissingTeeth getMissingTeethFirstRep() {
        if (this.getMissingTeeth().isEmpty()) {
            return this.addMissingTeeth();
        }
        return this.getMissingTeeth().get(0);
    }

    public String getResourceName() {
        return "Claim";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class MissingTeeth
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="tooth", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The code identifying which tooth is missing.")
        private CodingDt myTooth;
        @Child(name="reason", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Missing reason may be: E-extraction, O-other")
        private CodingDt myReason;
        @Child(name="extractionDate", type={DateDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date of the extraction either known from records or patient reported estimate.")
        private DateDt myExtractionDate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myTooth, this.myReason, this.myExtractionDate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTooth, this.myReason, this.myExtractionDate});
        }

        public CodingDt getTooth() {
            if (this.myTooth == null) {
                this.myTooth = new CodingDt();
            }
            return this.myTooth;
        }

        public MissingTeeth setTooth(CodingDt theValue) {
            this.myTooth = theValue;
            return this;
        }

        public CodingDt getReason() {
            if (this.myReason == null) {
                this.myReason = new CodingDt();
            }
            return this.myReason;
        }

        public MissingTeeth setReason(CodingDt theValue) {
            this.myReason = theValue;
            return this;
        }

        public DateDt getExtractionDateElement() {
            if (this.myExtractionDate == null) {
                this.myExtractionDate = new DateDt();
            }
            return this.myExtractionDate;
        }

        public Date getExtractionDate() {
            return (Date)this.getExtractionDateElement().getValue();
        }

        public MissingTeeth setExtractionDate(DateDt theValue) {
            this.myExtractionDate = theValue;
            return this;
        }

        public MissingTeeth setExtractionDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myExtractionDate = new DateDt(theDate, thePrecision);
            return this;
        }

        public MissingTeeth setExtractionDateWithDayPrecision(Date theDate) {
            this.myExtractionDate = new DateDt(theDate);
            return this;
        }
    }

    @Block
    public static class ItemProsthesis
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="initial", type={BooleanDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates whether this is the initial placement of a fixed prosthesis.")
        private BooleanDt myInitial;
        @Child(name="priorDate", type={DateDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Date of the initial placement.")
        private DateDt myPriorDate;
        @Child(name="priorMaterial", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Material of the prior denture or bridge prosthesis. (Oral)")
        private CodingDt myPriorMaterial;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myInitial, this.myPriorDate, this.myPriorMaterial});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myInitial, this.myPriorDate, this.myPriorMaterial});
        }

        public BooleanDt getInitialElement() {
            if (this.myInitial == null) {
                this.myInitial = new BooleanDt();
            }
            return this.myInitial;
        }

        public Boolean getInitial() {
            return (Boolean)this.getInitialElement().getValue();
        }

        public ItemProsthesis setInitial(BooleanDt theValue) {
            this.myInitial = theValue;
            return this;
        }

        public ItemProsthesis setInitial(boolean theBoolean) {
            this.myInitial = new BooleanDt(theBoolean);
            return this;
        }

        public DateDt getPriorDateElement() {
            if (this.myPriorDate == null) {
                this.myPriorDate = new DateDt();
            }
            return this.myPriorDate;
        }

        public Date getPriorDate() {
            return (Date)this.getPriorDateElement().getValue();
        }

        public ItemProsthesis setPriorDate(DateDt theValue) {
            this.myPriorDate = theValue;
            return this;
        }

        public ItemProsthesis setPriorDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myPriorDate = new DateDt(theDate, thePrecision);
            return this;
        }

        public ItemProsthesis setPriorDateWithDayPrecision(Date theDate) {
            this.myPriorDate = new DateDt(theDate);
            return this;
        }

        public CodingDt getPriorMaterial() {
            if (this.myPriorMaterial == null) {
                this.myPriorMaterial = new CodingDt();
            }
            return this.myPriorMaterial;
        }

        public ItemProsthesis setPriorMaterial(CodingDt theValue) {
            this.myPriorMaterial = theValue;
            return this;
        }
    }

    @Block
    public static class ItemDetailSubDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private PositiveIntDt mySequence;
        @Child(name="type", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActInvoiceGroupCode")
        private CodingDt myType;
        @Child(name="service", type={CodingDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The fee for an additional  service or product or charge.")
        private CodingDt myService;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The number of repetitions of a service or product.")
        private SimpleQuantityDt myQuantity;
        @Child(name="unitPrice", type={MoneyDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The fee for an additional  service or product or charge.")
        private MoneyDt myUnitPrice;
        @Child(name="factor", type={DecimalDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        private DecimalDt myFactor;
        @Child(name="points", type={DecimalDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        private DecimalDt myPoints;
        @Child(name="net", type={MoneyDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        private MoneyDt myNet;
        @Child(name="udi", type={CodingDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        private CodingDt myUdi;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySequence, this.myType, this.myService, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet, this.myUdi});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequence, this.myType, this.myService, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet, this.myUdi});
        }

        public PositiveIntDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new PositiveIntDt();
            }
            return this.mySequence;
        }

        public Integer getSequence() {
            return (Integer)this.getSequenceElement().getValue();
        }

        public ItemDetailSubDetail setSequence(PositiveIntDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public ItemDetailSubDetail setSequence(int theInteger) {
            this.mySequence = new PositiveIntDt(theInteger);
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public ItemDetailSubDetail setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodingDt getService() {
            if (this.myService == null) {
                this.myService = new CodingDt();
            }
            return this.myService;
        }

        public ItemDetailSubDetail setService(CodingDt theValue) {
            this.myService = theValue;
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public ItemDetailSubDetail setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public MoneyDt getUnitPrice() {
            if (this.myUnitPrice == null) {
                this.myUnitPrice = new MoneyDt();
            }
            return this.myUnitPrice;
        }

        public ItemDetailSubDetail setUnitPrice(MoneyDt theValue) {
            this.myUnitPrice = theValue;
            return this;
        }

        public DecimalDt getFactorElement() {
            if (this.myFactor == null) {
                this.myFactor = new DecimalDt();
            }
            return this.myFactor;
        }

        public BigDecimal getFactor() {
            return (BigDecimal)this.getFactorElement().getValue();
        }

        public ItemDetailSubDetail setFactor(DecimalDt theValue) {
            this.myFactor = theValue;
            return this;
        }

        public ItemDetailSubDetail setFactor(long theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailSubDetail setFactor(double theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailSubDetail setFactor(BigDecimal theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPointsElement() {
            if (this.myPoints == null) {
                this.myPoints = new DecimalDt();
            }
            return this.myPoints;
        }

        public BigDecimal getPoints() {
            return (BigDecimal)this.getPointsElement().getValue();
        }

        public ItemDetailSubDetail setPoints(DecimalDt theValue) {
            this.myPoints = theValue;
            return this;
        }

        public ItemDetailSubDetail setPoints(long theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailSubDetail setPoints(double theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public ItemDetailSubDetail setPoints(BigDecimal theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public MoneyDt getNet() {
            if (this.myNet == null) {
                this.myNet = new MoneyDt();
            }
            return this.myNet;
        }

        public ItemDetailSubDetail setNet(MoneyDt theValue) {
            this.myNet = theValue;
            return this;
        }

        public CodingDt getUdi() {
            if (this.myUdi == null) {
                this.myUdi = new CodingDt();
            }
            return this.myUdi;
        }

        public ItemDetailSubDetail setUdi(CodingDt theValue) {
            this.myUdi = theValue;
            return this;
        }
    }

    @Block
    public static class ItemDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private PositiveIntDt mySequence;
        @Child(name="type", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActInvoiceGroupCode")
        private CodingDt myType;
        @Child(name="service", type={CodingDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.")
        private CodingDt myService;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The number of repetitions of a service or product.")
        private SimpleQuantityDt myQuantity;
        @Child(name="unitPrice", type={MoneyDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        private MoneyDt myUnitPrice;
        @Child(name="factor", type={DecimalDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        private DecimalDt myFactor;
        @Child(name="points", type={DecimalDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        private DecimalDt myPoints;
        @Child(name="net", type={MoneyDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        private MoneyDt myNet;
        @Child(name="udi", type={CodingDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        private CodingDt myUdi;
        @Child(name="subDetail", order=9, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Third tier of goods and services")
        private List<ItemDetailSubDetail> mySubDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequence, this.myType, this.myService, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet, this.myUdi, this.mySubDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequence, this.myType, this.myService, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet, this.myUdi, this.mySubDetail});
        }

        public PositiveIntDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new PositiveIntDt();
            }
            return this.mySequence;
        }

        public Integer getSequence() {
            return (Integer)this.getSequenceElement().getValue();
        }

        public ItemDetail setSequence(PositiveIntDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public ItemDetail setSequence(int theInteger) {
            this.mySequence = new PositiveIntDt(theInteger);
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public ItemDetail setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodingDt getService() {
            if (this.myService == null) {
                this.myService = new CodingDt();
            }
            return this.myService;
        }

        public ItemDetail setService(CodingDt theValue) {
            this.myService = theValue;
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public ItemDetail setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public MoneyDt getUnitPrice() {
            if (this.myUnitPrice == null) {
                this.myUnitPrice = new MoneyDt();
            }
            return this.myUnitPrice;
        }

        public ItemDetail setUnitPrice(MoneyDt theValue) {
            this.myUnitPrice = theValue;
            return this;
        }

        public DecimalDt getFactorElement() {
            if (this.myFactor == null) {
                this.myFactor = new DecimalDt();
            }
            return this.myFactor;
        }

        public BigDecimal getFactor() {
            return (BigDecimal)this.getFactorElement().getValue();
        }

        public ItemDetail setFactor(DecimalDt theValue) {
            this.myFactor = theValue;
            return this;
        }

        public ItemDetail setFactor(long theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public ItemDetail setFactor(double theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public ItemDetail setFactor(BigDecimal theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPointsElement() {
            if (this.myPoints == null) {
                this.myPoints = new DecimalDt();
            }
            return this.myPoints;
        }

        public BigDecimal getPoints() {
            return (BigDecimal)this.getPointsElement().getValue();
        }

        public ItemDetail setPoints(DecimalDt theValue) {
            this.myPoints = theValue;
            return this;
        }

        public ItemDetail setPoints(long theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public ItemDetail setPoints(double theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public ItemDetail setPoints(BigDecimal theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public MoneyDt getNet() {
            if (this.myNet == null) {
                this.myNet = new MoneyDt();
            }
            return this.myNet;
        }

        public ItemDetail setNet(MoneyDt theValue) {
            this.myNet = theValue;
            return this;
        }

        public CodingDt getUdi() {
            if (this.myUdi == null) {
                this.myUdi = new CodingDt();
            }
            return this.myUdi;
        }

        public ItemDetail setUdi(CodingDt theValue) {
            this.myUdi = theValue;
            return this;
        }

        public List<ItemDetailSubDetail> getSubDetail() {
            if (this.mySubDetail == null) {
                this.mySubDetail = new ArrayList<ItemDetailSubDetail>();
            }
            return this.mySubDetail;
        }

        public ItemDetail setSubDetail(List<ItemDetailSubDetail> theValue) {
            this.mySubDetail = theValue;
            return this;
        }

        public ItemDetailSubDetail addSubDetail() {
            ItemDetailSubDetail newType = new ItemDetailSubDetail();
            this.getSubDetail().add(newType);
            return newType;
        }

        public ItemDetail addSubDetail(ItemDetailSubDetail theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSubDetail().add(theValue);
            return this;
        }

        public ItemDetailSubDetail getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                return this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }
    }

    @Block
    public static class Item
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private PositiveIntDt mySequence;
        @Child(name="type", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActInvoiceGroupCode")
        private CodingDt myType;
        @Child(name="provider", order=2, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient")
        private ResourceReferenceDt myProvider;
        @Child(name="diagnosisLinkId", type={PositiveIntDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Diagnosis applicable for this service or product line.")
        private List<PositiveIntDt> myDiagnosisLinkId;
        @Child(name="service", type={CodingDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.")
        private CodingDt myService;
        @Child(name="serviceDate", type={DateDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date when the enclosed suite of services were performed or completed")
        private DateDt myServiceDate;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The number of repetitions of a service or product.")
        private SimpleQuantityDt myQuantity;
        @Child(name="unitPrice", type={MoneyDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        private MoneyDt myUnitPrice;
        @Child(name="factor", type={DecimalDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        private DecimalDt myFactor;
        @Child(name="points", type={DecimalDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        private DecimalDt myPoints;
        @Child(name="net", type={MoneyDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        private MoneyDt myNet;
        @Child(name="udi", type={CodingDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        private CodingDt myUdi;
        @Child(name="bodySite", type={CodingDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        private CodingDt myBodySite;
        @Child(name="subSite", type={CodingDt.class}, order=13, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A region or surface of the site, e.g. limb region or tooth surface(s).")
        private List<CodingDt> mySubSite;
        @Child(name="modifier", type={CodingDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.")
        private List<CodingDt> myModifier;
        @Child(name="detail", order=15, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Second tier of goods and services")
        private List<ItemDetail> myDetail;
        @Child(name="prosthesis", order=16, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The materials and placement date of prior fixed prosthesis.")
        private ItemProsthesis myProsthesis;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequence, this.myType, this.myProvider, this.myDiagnosisLinkId, this.myService, this.myServiceDate, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet, this.myUdi, this.myBodySite, this.mySubSite, this.myModifier, this.myDetail, this.myProsthesis});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequence, this.myType, this.myProvider, this.myDiagnosisLinkId, this.myService, this.myServiceDate, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet, this.myUdi, this.myBodySite, this.mySubSite, this.myModifier, this.myDetail, this.myProsthesis});
        }

        public PositiveIntDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new PositiveIntDt();
            }
            return this.mySequence;
        }

        public Integer getSequence() {
            return (Integer)this.getSequenceElement().getValue();
        }

        public Item setSequence(PositiveIntDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public Item setSequence(int theInteger) {
            this.mySequence = new PositiveIntDt(theInteger);
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Item setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public ResourceReferenceDt getProvider() {
            if (this.myProvider == null) {
                this.myProvider = new ResourceReferenceDt();
            }
            return this.myProvider;
        }

        public Item setProvider(ResourceReferenceDt theValue) {
            this.myProvider = theValue;
            return this;
        }

        public List<PositiveIntDt> getDiagnosisLinkId() {
            if (this.myDiagnosisLinkId == null) {
                this.myDiagnosisLinkId = new ArrayList<PositiveIntDt>();
            }
            return this.myDiagnosisLinkId;
        }

        public Item setDiagnosisLinkId(List<PositiveIntDt> theValue) {
            this.myDiagnosisLinkId = theValue;
            return this;
        }

        public PositiveIntDt addDiagnosisLinkId() {
            PositiveIntDt newType = new PositiveIntDt();
            this.getDiagnosisLinkId().add(newType);
            return newType;
        }

        public Item addDiagnosisLinkId(PositiveIntDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDiagnosisLinkId().add(theValue);
            return this;
        }

        public PositiveIntDt getDiagnosisLinkIdFirstRep() {
            if (this.getDiagnosisLinkId().isEmpty()) {
                return this.addDiagnosisLinkId();
            }
            return this.getDiagnosisLinkId().get(0);
        }

        public Item addDiagnosisLinkId(int theInteger) {
            if (this.myDiagnosisLinkId == null) {
                this.myDiagnosisLinkId = new ArrayList<PositiveIntDt>();
            }
            this.myDiagnosisLinkId.add(new PositiveIntDt(theInteger));
            return this;
        }

        public CodingDt getService() {
            if (this.myService == null) {
                this.myService = new CodingDt();
            }
            return this.myService;
        }

        public Item setService(CodingDt theValue) {
            this.myService = theValue;
            return this;
        }

        public DateDt getServiceDateElement() {
            if (this.myServiceDate == null) {
                this.myServiceDate = new DateDt();
            }
            return this.myServiceDate;
        }

        public Date getServiceDate() {
            return (Date)this.getServiceDateElement().getValue();
        }

        public Item setServiceDate(DateDt theValue) {
            this.myServiceDate = theValue;
            return this;
        }

        public Item setServiceDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myServiceDate = new DateDt(theDate, thePrecision);
            return this;
        }

        public Item setServiceDateWithDayPrecision(Date theDate) {
            this.myServiceDate = new DateDt(theDate);
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public Item setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public MoneyDt getUnitPrice() {
            if (this.myUnitPrice == null) {
                this.myUnitPrice = new MoneyDt();
            }
            return this.myUnitPrice;
        }

        public Item setUnitPrice(MoneyDt theValue) {
            this.myUnitPrice = theValue;
            return this;
        }

        public DecimalDt getFactorElement() {
            if (this.myFactor == null) {
                this.myFactor = new DecimalDt();
            }
            return this.myFactor;
        }

        public BigDecimal getFactor() {
            return (BigDecimal)this.getFactorElement().getValue();
        }

        public Item setFactor(DecimalDt theValue) {
            this.myFactor = theValue;
            return this;
        }

        public Item setFactor(long theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public Item setFactor(double theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public Item setFactor(BigDecimal theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPointsElement() {
            if (this.myPoints == null) {
                this.myPoints = new DecimalDt();
            }
            return this.myPoints;
        }

        public BigDecimal getPoints() {
            return (BigDecimal)this.getPointsElement().getValue();
        }

        public Item setPoints(DecimalDt theValue) {
            this.myPoints = theValue;
            return this;
        }

        public Item setPoints(long theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public Item setPoints(double theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public Item setPoints(BigDecimal theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public MoneyDt getNet() {
            if (this.myNet == null) {
                this.myNet = new MoneyDt();
            }
            return this.myNet;
        }

        public Item setNet(MoneyDt theValue) {
            this.myNet = theValue;
            return this;
        }

        public CodingDt getUdi() {
            if (this.myUdi == null) {
                this.myUdi = new CodingDt();
            }
            return this.myUdi;
        }

        public Item setUdi(CodingDt theValue) {
            this.myUdi = theValue;
            return this;
        }

        public CodingDt getBodySite() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodingDt();
            }
            return this.myBodySite;
        }

        public Item setBodySite(CodingDt theValue) {
            this.myBodySite = theValue;
            return this;
        }

        public List<CodingDt> getSubSite() {
            if (this.mySubSite == null) {
                this.mySubSite = new ArrayList<CodingDt>();
            }
            return this.mySubSite;
        }

        public Item setSubSite(List<CodingDt> theValue) {
            this.mySubSite = theValue;
            return this;
        }

        public CodingDt addSubSite() {
            CodingDt newType = new CodingDt();
            this.getSubSite().add(newType);
            return newType;
        }

        public Item addSubSite(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSubSite().add(theValue);
            return this;
        }

        public CodingDt getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                return this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        public List<CodingDt> getModifier() {
            if (this.myModifier == null) {
                this.myModifier = new ArrayList<CodingDt>();
            }
            return this.myModifier;
        }

        public Item setModifier(List<CodingDt> theValue) {
            this.myModifier = theValue;
            return this;
        }

        public CodingDt addModifier() {
            CodingDt newType = new CodingDt();
            this.getModifier().add(newType);
            return newType;
        }

        public Item addModifier(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getModifier().add(theValue);
            return this;
        }

        public CodingDt getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                return this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<ItemDetail> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ItemDetail>();
            }
            return this.myDetail;
        }

        public Item setDetail(List<ItemDetail> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ItemDetail addDetail() {
            ItemDetail newType = new ItemDetail();
            this.getDetail().add(newType);
            return newType;
        }

        public Item addDetail(ItemDetail theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDetail().add(theValue);
            return this;
        }

        public ItemDetail getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                return this.addDetail();
            }
            return this.getDetail().get(0);
        }

        public ItemProsthesis getProsthesis() {
            if (this.myProsthesis == null) {
                this.myProsthesis = new ItemProsthesis();
            }
            return this.myProsthesis;
        }

        public Item setProsthesis(ItemProsthesis theValue) {
            this.myProsthesis = theValue;
            return this;
        }
    }

    @Block
    public static class Coverage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line item.")
        private PositiveIntDt mySequence;
        @Child(name="focal", type={BooleanDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        private BooleanDt myFocal;
        @Child(name="coverage", order=2, min=1, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu2.resource.Coverage.class})
        @Description(shortDefinition="", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        private ResourceReferenceDt myCoverage;
        @Child(name="businessArrangement", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        private StringDt myBusinessArrangement;
        @Child(name="relationship", type={CodingDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The relationship of the patient to the subscriber")
        private CodingDt myRelationship;
        @Child(name="preAuthRef", type={StringDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A list of references from the Insurer to which these services pertain.")
        private List<StringDt> myPreAuthRef;
        @Child(name="claimResponse", order=6, min=0, max=1, summary=false, modifier=false, type={ClaimResponse.class})
        @Description(shortDefinition="", formalDefinition="The Coverages adjudication details.")
        private ResourceReferenceDt myClaimResponse;
        @Child(name="originalRuleset", type={CodingDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
        private CodingDt myOriginalRuleset;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequence, this.myFocal, this.myCoverage, this.myBusinessArrangement, this.myRelationship, this.myPreAuthRef, this.myClaimResponse, this.myOriginalRuleset});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequence, this.myFocal, this.myCoverage, this.myBusinessArrangement, this.myRelationship, this.myPreAuthRef, this.myClaimResponse, this.myOriginalRuleset});
        }

        public PositiveIntDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new PositiveIntDt();
            }
            return this.mySequence;
        }

        public Integer getSequence() {
            return (Integer)this.getSequenceElement().getValue();
        }

        public Coverage setSequence(PositiveIntDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public Coverage setSequence(int theInteger) {
            this.mySequence = new PositiveIntDt(theInteger);
            return this;
        }

        public BooleanDt getFocalElement() {
            if (this.myFocal == null) {
                this.myFocal = new BooleanDt();
            }
            return this.myFocal;
        }

        public Boolean getFocal() {
            return (Boolean)this.getFocalElement().getValue();
        }

        public Coverage setFocal(BooleanDt theValue) {
            this.myFocal = theValue;
            return this;
        }

        public Coverage setFocal(boolean theBoolean) {
            this.myFocal = new BooleanDt(theBoolean);
            return this;
        }

        public ResourceReferenceDt getCoverage() {
            if (this.myCoverage == null) {
                this.myCoverage = new ResourceReferenceDt();
            }
            return this.myCoverage;
        }

        public Coverage setCoverage(ResourceReferenceDt theValue) {
            this.myCoverage = theValue;
            return this;
        }

        public StringDt getBusinessArrangementElement() {
            if (this.myBusinessArrangement == null) {
                this.myBusinessArrangement = new StringDt();
            }
            return this.myBusinessArrangement;
        }

        public String getBusinessArrangement() {
            return (String)this.getBusinessArrangementElement().getValue();
        }

        public Coverage setBusinessArrangement(StringDt theValue) {
            this.myBusinessArrangement = theValue;
            return this;
        }

        public Coverage setBusinessArrangement(String theString) {
            this.myBusinessArrangement = new StringDt(theString);
            return this;
        }

        public CodingDt getRelationship() {
            if (this.myRelationship == null) {
                this.myRelationship = new CodingDt();
            }
            return this.myRelationship;
        }

        public Coverage setRelationship(CodingDt theValue) {
            this.myRelationship = theValue;
            return this;
        }

        public List<StringDt> getPreAuthRef() {
            if (this.myPreAuthRef == null) {
                this.myPreAuthRef = new ArrayList<StringDt>();
            }
            return this.myPreAuthRef;
        }

        public Coverage setPreAuthRef(List<StringDt> theValue) {
            this.myPreAuthRef = theValue;
            return this;
        }

        public StringDt addPreAuthRef() {
            StringDt newType = new StringDt();
            this.getPreAuthRef().add(newType);
            return newType;
        }

        public Coverage addPreAuthRef(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPreAuthRef().add(theValue);
            return this;
        }

        public StringDt getPreAuthRefFirstRep() {
            if (this.getPreAuthRef().isEmpty()) {
                return this.addPreAuthRef();
            }
            return this.getPreAuthRef().get(0);
        }

        public Coverage addPreAuthRef(String theString) {
            if (this.myPreAuthRef == null) {
                this.myPreAuthRef = new ArrayList<StringDt>();
            }
            this.myPreAuthRef.add(new StringDt(theString));
            return this;
        }

        public ResourceReferenceDt getClaimResponse() {
            if (this.myClaimResponse == null) {
                this.myClaimResponse = new ResourceReferenceDt();
            }
            return this.myClaimResponse;
        }

        public Coverage setClaimResponse(ResourceReferenceDt theValue) {
            this.myClaimResponse = theValue;
            return this;
        }

        public CodingDt getOriginalRuleset() {
            if (this.myOriginalRuleset == null) {
                this.myOriginalRuleset = new CodingDt();
            }
            return this.myOriginalRuleset;
        }

        public Coverage setOriginalRuleset(CodingDt theValue) {
            this.myOriginalRuleset = theValue;
            return this;
        }
    }

    @Block
    public static class Diagnosis
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Sequence of diagnosis which serves to order and provide a link.")
        private PositiveIntDt mySequence;
        @Child(name="diagnosis", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The diagnosis.")
        private CodingDt myDiagnosis;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySequence, this.myDiagnosis});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequence, this.myDiagnosis});
        }

        public PositiveIntDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new PositiveIntDt();
            }
            return this.mySequence;
        }

        public Integer getSequence() {
            return (Integer)this.getSequenceElement().getValue();
        }

        public Diagnosis setSequence(PositiveIntDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public Diagnosis setSequence(int theInteger) {
            this.mySequence = new PositiveIntDt(theInteger);
            return this;
        }

        public CodingDt getDiagnosis() {
            if (this.myDiagnosis == null) {
                this.myDiagnosis = new CodingDt();
            }
            return this.myDiagnosis;
        }

        public Diagnosis setDiagnosis(CodingDt theValue) {
            this.myDiagnosis = theValue;
            return this;
        }
    }

    @Block
    public static class Payee
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
        private CodingDt myType;
        @Child(name="provider", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="", formalDefinition="The provider who is to be reimbursed for the claim (the party to whom any benefit is assigned)")
        private ResourceReferenceDt myProvider;
        @Child(name="organization", order=2, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="The organization who is to be reimbursed for the claim (the party to whom any benefit is assigned)")
        private ResourceReferenceDt myOrganization;
        @Child(name="person", order=3, min=0, max=1, summary=false, modifier=false, type={Patient.class})
        @Description(shortDefinition="", formalDefinition="The person other than the subscriber who is to be reimbursed for the claim (the party to whom any benefit is assigned)")
        private ResourceReferenceDt myPerson;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myProvider, this.myOrganization, this.myPerson});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myProvider, this.myOrganization, this.myPerson});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Payee setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public ResourceReferenceDt getProvider() {
            if (this.myProvider == null) {
                this.myProvider = new ResourceReferenceDt();
            }
            return this.myProvider;
        }

        public Payee setProvider(ResourceReferenceDt theValue) {
            this.myProvider = theValue;
            return this;
        }

        public ResourceReferenceDt getOrganization() {
            if (this.myOrganization == null) {
                this.myOrganization = new ResourceReferenceDt();
            }
            return this.myOrganization;
        }

        public Payee setOrganization(ResourceReferenceDt theValue) {
            this.myOrganization = theValue;
            return this;
        }

        public ResourceReferenceDt getPerson() {
            if (this.myPerson == null) {
                this.myPerson = new ResourceReferenceDt();
            }
            return this.myPerson;
        }

        public Payee setPerson(ResourceReferenceDt theValue) {
            this.myPerson = theValue;
            return this;
        }
    }
}

