/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.fluentpath.IFluentPath;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContainedDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.StructureDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.provider.dstu2.Dstu2BundleFactory;
import ca.uhn.fhir.rest.server.provider.dstu2.ServerConformanceProvider;
import ca.uhn.fhir.rest.server.provider.dstu2.ServerProfileProvider;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirDstu2
implements IFhirVersion {
    private String myId;

    public IFluentPath createFluentPathExecutor(FhirContext theFhirContext) {
        throw new UnsupportedOperationException("FluentPath is not supported in DSTU2 contexts");
    }

    public ServerConformanceProvider createServerConformanceProvider(RestfulServer theServer) {
        return new ServerConformanceProvider(theServer);
    }

    public IResourceProvider createServerProfilesProvider(RestfulServer theRestfulServer) {
        return new ServerProfileProvider(theRestfulServer);
    }

    public IContextValidationSupport<?, ?, ?, ?, ?, ?> createValidationSupport() {
        throw new UnsupportedOperationException("Validation support is not supported in DSTU2 contexts");
    }

    public IResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId(new IdDt(this.myId));
        return retVal;
    }

    public Class<? extends BaseContainedDt> getContainedType() {
        return ContainedDt.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        InputStream str = FhirDstu2.class.getResourceAsStream("/ca/uhn/fhir/model/dstu2/fhirversion.properties");
        if (str == null) {
            str = FhirDstu2.class.getResourceAsStream("ca/uhn/fhir/model/dstu2/fhirversion.properties");
        }
        if (str == null) {
            throw new ConfigurationException("Can not find model property file on classpath: /ca/uhn/fhir/model/dstu2/fhirversion.properties");
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return (IPrimitiveType)ResourceMetadataKeyEnum.UPDATED.get((IResource)theResource);
    }

    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/instance/model/schema";
    }

    public Class<? extends BaseResourceReferenceDt> getResourceReferenceType() {
        return ResourceReferenceDt.class;
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.DSTU2;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new Dstu2BundleFactory(theContext);
    }

    public BaseCodingDt newCodingDt() {
        return new CodingDt();
    }

    public IIdType newIdType() {
        return new IdDt();
    }
}

