/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.audit;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.MedicationPrescription;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import java.util.Map;

public class MedicationPrescriptionAuditor
implements IResourceAuditor<MedicationPrescription> {
    MedicationPrescription myMedicationPrescription;

    @Override
    public boolean isAuditable() {
        return this.myMedicationPrescription != null;
    }

    @Override
    public String getName() {
        if (this.myMedicationPrescription != null) {
            Medication m;
            if (this.myMedicationPrescription.getMedication() != null && (m = (Medication)this.myMedicationPrescription.getMedication().getResource()) != null) {
                return "Medication Prescription: " + (String)m.getName().getValue();
            }
            return "Medication Prescription: " + this.myMedicationPrescription.getId().getValueAsString();
        }
        return "";
    }

    @Override
    public IdentifierDt getIdentifier() {
        if (this.myMedicationPrescription != null) {
            return this.myMedicationPrescription.getIdentifierFirstRep();
        }
        return null;
    }

    @Override
    public SecurityEventObjectTypeEnum getType() {
        return SecurityEventObjectTypeEnum.OTHER;
    }

    @Override
    public MedicationPrescription getResource() {
        return this.myMedicationPrescription;
    }

    @Override
    public void setResource(MedicationPrescription theMedicationPrescription) {
        this.myMedicationPrescription = theMedicationPrescription;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Map<String, String> getDetail() {
        return null;
    }

    @Override
    public BaseCodingDt getSensitivity() {
        return null;
    }
}

