/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.IBoundCodeableConcept;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@DatatypeDef(name="CodeableConcept", isSpecialization=true)
public class BoundCodeableConceptDt<T extends Enum<?>>
extends CodeableConceptDt
implements IBoundCodeableConcept {
    private IValueSetEnumBinder<T> myBinder;

    public BoundCodeableConceptDt(IValueSetEnumBinder<T> theBinder) {
        this.myBinder = theBinder;
    }

    public BoundCodeableConceptDt(IValueSetEnumBinder<T> theBinder, T theValue) {
        this.myBinder = theBinder;
        this.setValueAsEnum(theValue);
    }

    public BoundCodeableConceptDt(IValueSetEnumBinder<T> theBinder, Collection<T> theValues) {
        this.myBinder = theBinder;
        this.setValueAsEnum((T)theValues);
    }

    public void setValueAsEnum(Collection<T> theValues) {
        this.getCoding().clear();
        if (theValues != null) {
            for (Enum next : theValues) {
                this.getCoding().add(new CodingDt(this.myBinder.toSystemString(next), this.myBinder.toCodeString(next)));
            }
        }
    }

    public void setValueAsEnum(T theValue) {
        this.getCoding().clear();
        if (theValue == null) {
            return;
        }
        this.getCoding().add(new CodingDt(this.myBinder.toSystemString(theValue), this.myBinder.toCodeString(theValue)));
    }

    public Set<T> getValueAsEnum() {
        HashSet<Enum> retVal = new HashSet<Enum>();
        for (CodingDt next : this.getCoding()) {
            Enum nextT;
            if (next == null || (nextT = this.myBinder.fromCodeString(StringUtils.defaultString((String)((String)next.getCode().getValue())), StringUtils.defaultString((String)next.getSystem().getValueAsString()))) == null) continue;
            retVal.add(nextT);
        }
        return retVal;
    }
}

