/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ValueSetStatusEnum {
    DRAFT("draft", "http://hl7.org/fhir/valueset-status"),
    ACTIVE("active", "http://hl7.org/fhir/valueset-status"),
    RETIRED("retired", "http://hl7.org/fhir/valueset-status");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/valueset-status";
    public static final String VALUESET_NAME = "ValueSetStatus";
    private static Map<String, ValueSetStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ValueSetStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ValueSetStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ValueSetStatusEnum forCode(String theCode) {
        ValueSetStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ValueSetStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ValueSetStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ValueSetStatusEnum>>();
        for (ValueSetStatusEnum next : ValueSetStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ValueSetStatusEnum>(){

            public String toCodeString(ValueSetStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ValueSetStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public ValueSetStatusEnum fromCodeString(String theCodeString) {
                return (ValueSetStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ValueSetStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ValueSetStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

