/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SupplyTypeEnum {
    CENTRAL_SUPPLY("central", "http://hl7.org/fhir/supply-type"),
    NON_STOCK("nonstock", "http://hl7.org/fhir/supply-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/supply-type";
    public static final String VALUESET_NAME = "Supply Type";
    private static Map<String, SupplyTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SupplyTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SupplyTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static SupplyTypeEnum forCode(String theCode) {
        SupplyTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SupplyTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SupplyTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SupplyTypeEnum>>();
        for (SupplyTypeEnum next : SupplyTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SupplyTypeEnum>(){

            public String toCodeString(SupplyTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SupplyTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public SupplyTypeEnum fromCodeString(String theCodeString) {
                return (SupplyTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SupplyTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SupplyTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

