/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum QuestionnaireNameEnum {
    CANCER_TREATMENT_QUALITY_QUESTIONNAIRE_2012("CTQQ-2012", "http://hl7.org/fhir/questionnaire-name"),
    PRE_ADMISSION_STANDARD_FORM_A("PA.form.A", "http://hl7.org/fhir/questionnaire-name"),
    BRAZELTON_NEONATAL_ASSESSMENT_SCALE("BNAS", "http://hl7.org/fhir/questionnaire-name");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/questionnaire-name";
    public static final String VALUESET_NAME = "QuestionnaireName";
    private static Map<String, QuestionnaireNameEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, QuestionnaireNameEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<QuestionnaireNameEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static QuestionnaireNameEnum forCode(String theCode) {
        QuestionnaireNameEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private QuestionnaireNameEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, QuestionnaireNameEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, QuestionnaireNameEnum>>();
        for (QuestionnaireNameEnum next : QuestionnaireNameEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<QuestionnaireNameEnum>(){

            public String toCodeString(QuestionnaireNameEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(QuestionnaireNameEnum theEnum) {
                return theEnum.getSystem();
            }

            public QuestionnaireNameEnum fromCodeString(String theCodeString) {
                return (QuestionnaireNameEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public QuestionnaireNameEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (QuestionnaireNameEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

