/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum NameUseEnum {
    USUAL("usual", "http://hl7.org/fhir/name-use"),
    OFFICIAL("official", "http://hl7.org/fhir/name-use"),
    TEMP("temp", "http://hl7.org/fhir/name-use"),
    NICKNAME("nickname", "http://hl7.org/fhir/name-use"),
    ANONYMOUS("anonymous", "http://hl7.org/fhir/name-use"),
    OLD("old", "http://hl7.org/fhir/name-use"),
    MAIDEN("maiden", "http://hl7.org/fhir/name-use");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/name-use";
    public static final String VALUESET_NAME = "NameUse";
    private static Map<String, NameUseEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, NameUseEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<NameUseEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static NameUseEnum forCode(String theCode) {
        NameUseEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private NameUseEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, NameUseEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, NameUseEnum>>();
        for (NameUseEnum next : NameUseEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<NameUseEnum>(){

            public String toCodeString(NameUseEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(NameUseEnum theEnum) {
                return theEnum.getSystem();
            }

            public NameUseEnum fromCodeString(String theCodeString) {
                return (NameUseEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public NameUseEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (NameUseEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

