/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum IssueTypeEnum {
    INVALID("invalid", "http://hl7.org/fhir/issue-type"),
    STRUCTURE("structure", "http://hl7.org/fhir/issue-type"),
    REQUIRED("required", "http://hl7.org/fhir/issue-type"),
    VALUE("value", "http://hl7.org/fhir/issue-type"),
    INVARIANT("invariant", "http://hl7.org/fhir/issue-type"),
    SECURITY("security", "http://hl7.org/fhir/issue-type"),
    LOGIN("login", "http://hl7.org/fhir/issue-type"),
    UNKNOWN("unknown", "http://hl7.org/fhir/issue-type"),
    EXPIRED("expired", "http://hl7.org/fhir/issue-type"),
    FORBIDDEN("forbidden", "http://hl7.org/fhir/issue-type"),
    PROCESSING("processing", "http://hl7.org/fhir/issue-type"),
    NOT_SUPPORTED("not-supported", "http://hl7.org/fhir/issue-type"),
    DUPLICATE("duplicate", "http://hl7.org/fhir/issue-type"),
    NOT_FOUND("not-found", "http://hl7.org/fhir/issue-type"),
    TOO_LONG("too-long", "http://hl7.org/fhir/issue-type"),
    CODE_UNKNOWN("code-unknown", "http://hl7.org/fhir/issue-type"),
    EXTENSION("extension", "http://hl7.org/fhir/issue-type"),
    TOO_COSTLY("too-costly", "http://hl7.org/fhir/issue-type"),
    BUSINESS_RULE("business-rule", "http://hl7.org/fhir/issue-type"),
    CONFLICT("conflict", "http://hl7.org/fhir/issue-type"),
    TRANSIENT("transient", "http://hl7.org/fhir/issue-type"),
    LOCK_ERROR("lock-error", "http://hl7.org/fhir/issue-type"),
    NO_STORE("no-store", "http://hl7.org/fhir/issue-type"),
    EXCEPTION("exception", "http://hl7.org/fhir/issue-type"),
    TIMEOUT("timeout", "http://hl7.org/fhir/issue-type"),
    THROTTLED("throttled", "http://hl7.org/fhir/issue-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/issue-type";
    public static final String VALUESET_NAME = "IssueType";
    private static Map<String, IssueTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, IssueTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<IssueTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static IssueTypeEnum forCode(String theCode) {
        IssueTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private IssueTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, IssueTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, IssueTypeEnum>>();
        for (IssueTypeEnum next : IssueTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<IssueTypeEnum>(){

            public String toCodeString(IssueTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(IssueTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public IssueTypeEnum fromCodeString(String theCodeString) {
                return (IssueTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public IssueTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (IssueTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

