/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum FilterOperatorEnum {
    EQUALS("=", "http://hl7.org/fhir/filter-operator"),
    IS_A("is-a", "http://hl7.org/fhir/filter-operator"),
    IS_NOT_A("is-not-a", "http://hl7.org/fhir/filter-operator"),
    REGEX("regex", "http://hl7.org/fhir/filter-operator"),
    IN("in", "http://hl7.org/fhir/filter-operator"),
    NOT_IN("not in", "http://hl7.org/fhir/filter-operator");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/filter-operator";
    public static final String VALUESET_NAME = "FilterOperator";
    private static Map<String, FilterOperatorEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, FilterOperatorEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<FilterOperatorEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static FilterOperatorEnum forCode(String theCode) {
        FilterOperatorEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private FilterOperatorEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, FilterOperatorEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, FilterOperatorEnum>>();
        for (FilterOperatorEnum next : FilterOperatorEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<FilterOperatorEnum>(){

            public String toCodeString(FilterOperatorEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(FilterOperatorEnum theEnum) {
                return theEnum.getSystem();
            }

            public FilterOperatorEnum fromCodeString(String theCodeString) {
                return (FilterOperatorEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public FilterOperatorEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (FilterOperatorEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

