/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ExposureTypeEnum {
    DRUGADMIN("drugadmin", "http://hl7.org/fhir/exposureType"),
    IMMUNIZ("immuniz", "http://hl7.org/fhir/exposureType"),
    COINCIDENTAL("coincidental", "http://hl7.org/fhir/exposureType");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/exposureType";
    public static final String VALUESET_NAME = "ExposureType";
    private static Map<String, ExposureTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ExposureTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ExposureTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ExposureTypeEnum forCode(String theCode) {
        ExposureTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ExposureTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ExposureTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ExposureTypeEnum>>();
        for (ExposureTypeEnum next : ExposureTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ExposureTypeEnum>(){

            public String toCodeString(ExposureTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ExposureTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public ExposureTypeEnum fromCodeString(String theCodeString) {
                return (ExposureTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ExposureTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ExposureTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

