/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Substance", profile="http://hl7.org/fhir/profiles/Substance", id="substance")
public class Substance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Substance.type", description="The type of the substance", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="Substance.instance.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="expiry", path="Substance.instance.expiry", description="", type="date")
    public static final String SP_EXPIRY = "expiry";
    public static final DateClientParam EXPIRY = new DateClientParam("expiry");
    @SearchParamDefinition(name="quantity", path="Substance.instance.quantity", description="", type="number")
    public static final String SP_QUANTITY = "quantity";
    public static final NumberClientParam QUANTITY = new NumberClientParam("quantity");
    @SearchParamDefinition(name="substance", path="Substance.ingredient.substance", description="", type="reference")
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_INGREDIENT_SUBSTANCE = new Include("Substance.ingredient.substance");
    @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="What kind of substance this is", formalDefinition="A code (or set of codes) that identify this substance")
    private CodeableConceptDt myType;
    @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Textual description of the substance, comments", formalDefinition="A description of the substance - its appearance, handling requirements, and other usage notes")
    private StringDt myDescription;
    @Child(name="instance", order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="If this describes a specific package/container of the substance", formalDefinition="Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance")
    private Instance myInstance;
    @Child(name="ingredient", order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Composition information about the substance", formalDefinition="A substance can be composed of other substances")
    private List<Ingredient> myIngredient;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myDescription, this.myInstance, this.myIngredient});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myDescription, this.myInstance, this.myIngredient});
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Substance setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public Substance setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Substance setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public Instance getInstance() {
        if (this.myInstance == null) {
            this.myInstance = new Instance();
        }
        return this.myInstance;
    }

    public Instance getInstanceElement() {
        if (this.myInstance == null) {
            this.myInstance = new Instance();
        }
        return this.myInstance;
    }

    public Substance setInstance(Instance theValue) {
        this.myInstance = theValue;
        return this;
    }

    public List<Ingredient> getIngredient() {
        if (this.myIngredient == null) {
            this.myIngredient = new ArrayList<Ingredient>();
        }
        return this.myIngredient;
    }

    public List<Ingredient> getIngredientElement() {
        if (this.myIngredient == null) {
            this.myIngredient = new ArrayList<Ingredient>();
        }
        return this.myIngredient;
    }

    public Substance setIngredient(List<Ingredient> theValue) {
        this.myIngredient = theValue;
        return this;
    }

    public Ingredient addIngredient() {
        Ingredient newType = new Ingredient();
        this.getIngredient().add(newType);
        return newType;
    }

    public Ingredient getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            return this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public String getResourceName() {
        return "Substance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Ingredient
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="quantity", type={RatioDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Optional amount (concentration)", formalDefinition="The amount of the ingredient in the substance - a concentration ratio")
        private RatioDt myQuantity;
        @Child(name="substance", order=1, min=1, max=1, summary=false, modifier=false, type={Substance.class})
        @Description(shortDefinition="A component of the substance", formalDefinition="Another substance that is a component of this substance")
        private ResourceReferenceDt mySubstance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myQuantity, this.mySubstance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myQuantity, this.mySubstance});
        }

        public RatioDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new RatioDt();
            }
            return this.myQuantity;
        }

        public RatioDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new RatioDt();
            }
            return this.myQuantity;
        }

        public Ingredient setQuantity(RatioDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public ResourceReferenceDt getSubstance() {
            if (this.mySubstance == null) {
                this.mySubstance = new ResourceReferenceDt();
            }
            return this.mySubstance;
        }

        public ResourceReferenceDt getSubstanceElement() {
            if (this.mySubstance == null) {
                this.mySubstance = new ResourceReferenceDt();
            }
            return this.mySubstance;
        }

        public Ingredient setSubstance(ResourceReferenceDt theValue) {
            this.mySubstance = theValue;
            return this;
        }
    }

    @Block
    public static class Instance
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the package/container", formalDefinition="Identifier associated with the package/container (usually a label affixed directly)")
        private IdentifierDt myIdentifier;
        @Child(name="expiry", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="When no longer valid to use", formalDefinition="When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.")
        private DateTimeDt myExpiry;
        @Child(name="quantity", type={QuantityDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount of substance in the package", formalDefinition="The amount of the substance")
        private QuantityDt myQuantity;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myExpiry, this.myQuantity});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myExpiry, this.myQuantity});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public IdentifierDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Instance setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Instance setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Instance setIdentifier(String theSystem, String theValue) {
            this.myIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public DateTimeDt getExpiry() {
            if (this.myExpiry == null) {
                this.myExpiry = new DateTimeDt();
            }
            return this.myExpiry;
        }

        public DateTimeDt getExpiryElement() {
            if (this.myExpiry == null) {
                this.myExpiry = new DateTimeDt();
            }
            return this.myExpiry;
        }

        public Instance setExpiry(DateTimeDt theValue) {
            this.myExpiry = theValue;
            return this;
        }

        public Instance setExpiry(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myExpiry = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Instance setExpiryWithSecondsPrecision(Date theDate) {
            this.myExpiry = new DateTimeDt(theDate);
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Instance setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Instance setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Instance setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Instance setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Instance setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Instance setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Instance setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }
    }
}

