/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.valueset.AdministrativeGenderCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.PractitionerRoleEnum;
import ca.uhn.fhir.model.dstu.valueset.PractitionerSpecialtyEnum;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Practitioner", profile="http://hl7.org/fhir/profiles/Practitioner", id="practitioner")
public class Practitioner
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Practitioner.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Practitioner.name", description="A portion of either family or given name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="family", path="Practitioner.name", description="A portion of the family name", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="given", path="Practitioner.name", description="A portion of the given name", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="phonetic", path="Practitioner.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Practitioner.telecom", description="The value in any kind of contact", type="string")
    public static final String SP_TELECOM = "telecom";
    public static final StringClientParam TELECOM = new StringClientParam("telecom");
    @SearchParamDefinition(name="address", path="Practitioner.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="gender", path="Practitioner.gender", description="Gender of the practitioner", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="organization", path="Practitioner.organization", description="The identity of the organization the practitioner represents / acts on behalf of", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Practitioner.organization");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="A identifier for the person as this agent", formalDefinition="An identifier that applies to this person in this role")
    private List<IdentifierDt> myIdentifier;
    @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the person")
    private HumanNameDt myName;
    @Child(name="telecom", type={ContactDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="A contact detail for the practitioner", formalDefinition="A contact detail for the practitioner, e.g. a telephone number or an email address.")
    private List<ContactDt> myTelecom;
    @Child(name="address", type={AddressDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Where practitioner can be found/visited", formalDefinition="The postal address where the practitioner can be found or visited or to which mail can be delivered")
    private AddressDt myAddress;
    @Child(name="gender", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Gender for administrative purposes", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    private BoundCodeableConceptDt<AdministrativeGenderCodesEnum> myGender;
    @Child(name="birthDate", type={DateTimeDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="The date and time of birth for the practitioner", formalDefinition="The date and time of birth for the practitioner")
    private DateTimeDt myBirthDate;
    @Child(name="photo", type={AttachmentDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person")
    private List<AttachmentDt> myPhoto;
    @Child(name="organization", order=7, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="The represented organization", formalDefinition="The organization that the practitioner represents")
    private ResourceReferenceDt myOrganization;
    @Child(name="role", type={CodeableConceptDt.class}, order=8, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Roles which this practitioner may perform", formalDefinition="Roles which this practitioner is authorized to perform for the organization")
    private List<BoundCodeableConceptDt<PractitionerRoleEnum>> myRole;
    @Child(name="specialty", type={CodeableConceptDt.class}, order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Specific specialty of the practitioner", formalDefinition="Specific specialty of the practitioner")
    private List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> mySpecialty;
    @Child(name="period", type={PeriodDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="The period during which the practitioner is authorized to perform in these role(s)", formalDefinition="The period during which the person is authorized to act as a practitioner in these role(s) for the organization")
    private PeriodDt myPeriod;
    @Child(name="location", order=11, min=0, max=-1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="The location(s) at which this practitioner provides care", formalDefinition="The location(s) at which this practitioner provides care")
    private List<ResourceReferenceDt> myLocation;
    @Child(name="qualification", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Qualifications obtained by training and certification", formalDefinition="")
    private List<Qualification> myQualification;
    @Child(name="communication", type={CodeableConceptDt.class}, order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A language the practitioner is able to use in patient communication", formalDefinition="A language the practitioner is able to use in patient communication")
    private List<CodeableConceptDt> myCommunication;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myBirthDate, this.myPhoto, this.myOrganization, this.myRole, this.mySpecialty, this.myPeriod, this.myLocation, this.myQualification, this.myCommunication});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myBirthDate, this.myPhoto, this.myOrganization, this.myRole, this.mySpecialty, this.myPeriod, this.myLocation, this.myQualification, this.myCommunication});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Practitioner setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Practitioner addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Practitioner addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public HumanNameDt getName() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public HumanNameDt getNameElement() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public Practitioner setName(HumanNameDt theValue) {
        this.myName = theValue;
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public Practitioner setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Practitioner addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Practitioner addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public AddressDt getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public AddressDt getAddressElement() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public Practitioner setAddress(AddressDt theValue) {
        this.myAddress = theValue;
        return this;
    }

    public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGender() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public Practitioner setGender(BoundCodeableConceptDt<AdministrativeGenderCodesEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public Practitioner setGender(AdministrativeGenderCodesEnum theValue) {
        this.getGender().setValueAsEnum(theValue);
        return this;
    }

    public DateTimeDt getBirthDate() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateTimeDt();
        }
        return this.myBirthDate;
    }

    public DateTimeDt getBirthDateElement() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateTimeDt();
        }
        return this.myBirthDate;
    }

    public Practitioner setBirthDate(DateTimeDt theValue) {
        this.myBirthDate = theValue;
        return this;
    }

    public Practitioner setBirthDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myBirthDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Practitioner setBirthDateWithSecondsPrecision(Date theDate) {
        this.myBirthDate = new DateTimeDt(theDate);
        return this;
    }

    public List<AttachmentDt> getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public List<AttachmentDt> getPhotoElement() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public Practitioner setPhoto(List<AttachmentDt> theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public AttachmentDt addPhoto() {
        AttachmentDt newType = new AttachmentDt();
        this.getPhoto().add(newType);
        return newType;
    }

    public AttachmentDt getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            return this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public ResourceReferenceDt getOrganizationElement() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public Practitioner setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public List<BoundCodeableConceptDt<PractitionerRoleEnum>> getRole() {
        if (this.myRole == null) {
            this.myRole = new ArrayList<BoundCodeableConceptDt<PractitionerRoleEnum>>();
        }
        return this.myRole;
    }

    public List<BoundCodeableConceptDt<PractitionerRoleEnum>> getRoleElement() {
        if (this.myRole == null) {
            this.myRole = new ArrayList<BoundCodeableConceptDt<PractitionerRoleEnum>>();
        }
        return this.myRole;
    }

    public Practitioner setRole(List<BoundCodeableConceptDt<PractitionerRoleEnum>> theValue) {
        this.myRole = theValue;
        return this;
    }

    public BoundCodeableConceptDt<PractitionerRoleEnum> addRole(PractitionerRoleEnum theValue) {
        BoundCodeableConceptDt<PractitionerRoleEnum> retVal = new BoundCodeableConceptDt<PractitionerRoleEnum>(PractitionerRoleEnum.VALUESET_BINDER, theValue);
        this.getRole().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<PractitionerRoleEnum> getRoleFirstRep() {
        if (this.getRole().size() == 0) {
            this.addRole();
        }
        return this.getRole().get(0);
    }

    public BoundCodeableConceptDt<PractitionerRoleEnum> addRole() {
        BoundCodeableConceptDt<PractitionerRoleEnum> retVal = new BoundCodeableConceptDt<PractitionerRoleEnum>(PractitionerRoleEnum.VALUESET_BINDER);
        this.getRole().add(retVal);
        return retVal;
    }

    public Practitioner setRole(PractitionerRoleEnum theValue) {
        this.getRole().clear();
        this.addRole(theValue);
        return this;
    }

    public List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> getSpecialty() {
        if (this.mySpecialty == null) {
            this.mySpecialty = new ArrayList<BoundCodeableConceptDt<PractitionerSpecialtyEnum>>();
        }
        return this.mySpecialty;
    }

    public List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> getSpecialtyElement() {
        if (this.mySpecialty == null) {
            this.mySpecialty = new ArrayList<BoundCodeableConceptDt<PractitionerSpecialtyEnum>>();
        }
        return this.mySpecialty;
    }

    public Practitioner setSpecialty(List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> theValue) {
        this.mySpecialty = theValue;
        return this;
    }

    public BoundCodeableConceptDt<PractitionerSpecialtyEnum> addSpecialty(PractitionerSpecialtyEnum theValue) {
        BoundCodeableConceptDt<PractitionerSpecialtyEnum> retVal = new BoundCodeableConceptDt<PractitionerSpecialtyEnum>(PractitionerSpecialtyEnum.VALUESET_BINDER, theValue);
        this.getSpecialty().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<PractitionerSpecialtyEnum> getSpecialtyFirstRep() {
        if (this.getSpecialty().size() == 0) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public BoundCodeableConceptDt<PractitionerSpecialtyEnum> addSpecialty() {
        BoundCodeableConceptDt<PractitionerSpecialtyEnum> retVal = new BoundCodeableConceptDt<PractitionerSpecialtyEnum>(PractitionerSpecialtyEnum.VALUESET_BINDER);
        this.getSpecialty().add(retVal);
        return retVal;
    }

    public Practitioner setSpecialty(PractitionerSpecialtyEnum theValue) {
        this.getSpecialty().clear();
        this.addSpecialty(theValue);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Practitioner setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<ResourceReferenceDt>();
        }
        return this.myLocation;
    }

    public List<ResourceReferenceDt> getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<ResourceReferenceDt>();
        }
        return this.myLocation;
    }

    public Practitioner setLocation(List<ResourceReferenceDt> theValue) {
        this.myLocation = theValue;
        return this;
    }

    public ResourceReferenceDt addLocation() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getLocation().add(newType);
        return newType;
    }

    public List<Qualification> getQualification() {
        if (this.myQualification == null) {
            this.myQualification = new ArrayList<Qualification>();
        }
        return this.myQualification;
    }

    public List<Qualification> getQualificationElement() {
        if (this.myQualification == null) {
            this.myQualification = new ArrayList<Qualification>();
        }
        return this.myQualification;
    }

    public Practitioner setQualification(List<Qualification> theValue) {
        this.myQualification = theValue;
        return this;
    }

    public Qualification addQualification() {
        Qualification newType = new Qualification();
        this.getQualification().add(newType);
        return newType;
    }

    public Qualification getQualificationFirstRep() {
        if (this.getQualification().isEmpty()) {
            return this.addQualification();
        }
        return this.getQualification().get(0);
    }

    public List<CodeableConceptDt> getCommunication() {
        if (this.myCommunication == null) {
            this.myCommunication = new ArrayList<CodeableConceptDt>();
        }
        return this.myCommunication;
    }

    public List<CodeableConceptDt> getCommunicationElement() {
        if (this.myCommunication == null) {
            this.myCommunication = new ArrayList<CodeableConceptDt>();
        }
        return this.myCommunication;
    }

    public Practitioner setCommunication(List<CodeableConceptDt> theValue) {
        this.myCommunication = theValue;
        return this;
    }

    public CodeableConceptDt addCommunication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCommunication().add(newType);
        return newType;
    }

    public CodeableConceptDt getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            return this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    public String getResourceName() {
        return "Practitioner";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Qualification
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Coded representation of the qualification", formalDefinition="")
        private CodeableConceptDt myCode;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Period during which the qualification is valid", formalDefinition="Period during which the qualification is valid")
        private PeriodDt myPeriod;
        @Child(name="issuer", order=2, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="Organization that regulates and issues the qualification", formalDefinition="Organization that regulates and issues the qualification")
        private ResourceReferenceDt myIssuer;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myPeriod, this.myIssuer});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myPeriod, this.myIssuer});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Qualification setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Qualification setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public ResourceReferenceDt getIssuer() {
            if (this.myIssuer == null) {
                this.myIssuer = new ResourceReferenceDt();
            }
            return this.myIssuer;
        }

        public ResourceReferenceDt getIssuerElement() {
            if (this.myIssuer == null) {
                this.myIssuer = new ResourceReferenceDt();
            }
            return this.myIssuer;
        }

        public Qualification setIssuer(ResourceReferenceDt theValue) {
            this.myIssuer = theValue;
            return this;
        }
    }
}

