/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.AdministrativeGenderCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.AnimalSpeciesEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.LinkTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.MaritalStatusCodesEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Patient", profile="http://hl7.org/fhir/profiles/Patient", id="patient")
public class Patient
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Patient.identifier", description="A patient identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Patient.name", description="A portion of either family or given name of the patient", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="family", path="Patient.name.family", description="A portion of the family name of the patient", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="given", path="Patient.name.given", description="A portion of the given name of the patient", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="phonetic", path="", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Patient.telecom", description="The value in any kind of telecom details of the patient", type="string")
    public static final String SP_TELECOM = "telecom";
    public static final StringClientParam TELECOM = new StringClientParam("telecom");
    @SearchParamDefinition(name="address", path="Patient.address", description="An address in any kind of address/part of the patient", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="gender", path="Patient.gender", description="Gender of the patient", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="language", path="Patient.communication", description="Language code (irrespective of use value)", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="birthdate", path="Patient.birthDate", description="The patient's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    @SearchParamDefinition(name="provider", path="Patient.managingOrganization", description="The organization at which this person is a patient", type="reference")
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_MANAGINGORGANIZATION = new Include("Patient.managingOrganization");
    @SearchParamDefinition(name="active", path="Patient.active", description="Whether the patient record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="animal-species", path="Patient.animal.species", description="The species for animal patients", type="token")
    public static final String SP_ANIMAL_SPECIES = "animal-species";
    public static final TokenClientParam ANIMAL_SPECIES = new TokenClientParam("animal-species");
    @SearchParamDefinition(name="animal-breed", path="Patient.animal.breed", description="The breed for animal patients", type="token")
    public static final String SP_ANIMAL_BREED = "animal-breed";
    public static final TokenClientParam ANIMAL_BREED = new TokenClientParam("animal-breed");
    @SearchParamDefinition(name="link", path="Patient.link.other", description="All patients linked to the given patient", type="reference")
    public static final String SP_LINK = "link";
    public static final ReferenceClientParam LINK = new ReferenceClientParam("link");
    public static final Include INCLUDE_LINK_OTHER = new Include("Patient.link.other");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="An identifier for the person as this patient", formalDefinition="An identifier that applies to this person as a patient")
    private List<IdentifierDt> myIdentifier;
    @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="A name associated with the patient", formalDefinition="A name associated with the individual.")
    private List<HumanNameDt> myName;
    @Child(name="telecom", type={ContactDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="A contact detail for the individual", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.")
    private List<ContactDt> myTelecom;
    @Child(name="gender", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Gender for administrative purposes", formalDefinition="Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.")
    private BoundCodeableConceptDt<AdministrativeGenderCodesEnum> myGender;
    @Child(name="birthDate", type={DateTimeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="The date and time of birth for the individual", formalDefinition="The date and time of birth for the individual")
    private DateTimeDt myBirthDate;
    @Child(name="deceased", order=5, min=0, max=1, summary=true, modifier=true, type={BooleanDt.class, DateTimeDt.class})
    @Description(shortDefinition="Indicates if the individual is deceased or not", formalDefinition="Indicates if the individual is deceased or not")
    private IDatatype myDeceased;
    @Child(name="address", type={AddressDt.class}, order=6, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Addresses for the individual", formalDefinition="Addresses for the individual")
    private List<AddressDt> myAddress;
    @Child(name="maritalStatus", type={CodeableConceptDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Marital (civil) status of a person", formalDefinition="This field contains a patient's most recent marital (civil) status.")
    private BoundCodeableConceptDt<MaritalStatusCodesEnum> myMaritalStatus;
    @Child(name="multipleBirth", order=8, min=0, max=1, summary=true, modifier=false, type={BooleanDt.class, IntegerDt.class})
    @Description(shortDefinition="Whether patient is part of a multiple birth", formalDefinition="Indicates whether the patient is part of a multiple or indicates the actual birth order.")
    private IDatatype myMultipleBirth;
    @Child(name="photo", type={AttachmentDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person")
    private List<AttachmentDt> myPhoto;
    @Child(name="contact", order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A contact party (e.g. guardian, partner, friend) for the patient", formalDefinition="A contact party (e.g. guardian, partner, friend) for the patient")
    private List<Contact> myContact;
    @Child(name="animal", order=11, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="If this patient is an animal (non-human)", formalDefinition="This element has a value if the patient is an animal")
    private Animal myAnimal;
    @Child(name="communication", type={CodeableConceptDt.class}, order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Languages which may be used to communicate with the patient about his or her health", formalDefinition="Languages which may be used to communicate with the patient about his or her health")
    private List<CodeableConceptDt> myCommunication;
    @Child(name="careProvider", order=13, min=0, max=-1, summary=false, modifier=false, type={Organization.class, Practitioner.class})
    @Description(shortDefinition="Patient's nominated care provider", formalDefinition="Patient's nominated care provider")
    private List<ResourceReferenceDt> myCareProvider;
    @Child(name="managingOrganization", order=14, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="Organization that is the custodian of the patient record", formalDefinition="Organization that is the custodian of the patient record")
    private ResourceReferenceDt myManagingOrganization;
    @Child(name="link", order=15, min=0, max=-1, summary=true, modifier=true)
    @Description(shortDefinition="Link to another patient resource that concerns the same actual person", formalDefinition="Link to another patient resource that concerns the same actual person")
    private List<Link> myLink;
    @Child(name="active", type={BooleanDt.class}, order=16, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="Whether this patient's record is in active use", formalDefinition="Whether this patient record is in active use")
    private BooleanDt myActive;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myDeceased, this.myAddress, this.myMaritalStatus, this.myMultipleBirth, this.myPhoto, this.myContact, this.myAnimal, this.myCommunication, this.myCareProvider, this.myManagingOrganization, this.myLink, this.myActive});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myDeceased, this.myAddress, this.myMaritalStatus, this.myMultipleBirth, this.myPhoto, this.myContact, this.myAnimal, this.myCommunication, this.myCareProvider, this.myManagingOrganization, this.myLink, this.myActive});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Patient setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Patient addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Patient addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public List<HumanNameDt> getName() {
        if (this.myName == null) {
            this.myName = new ArrayList<HumanNameDt>();
        }
        return this.myName;
    }

    public List<HumanNameDt> getNameElement() {
        if (this.myName == null) {
            this.myName = new ArrayList<HumanNameDt>();
        }
        return this.myName;
    }

    public Patient setName(List<HumanNameDt> theValue) {
        this.myName = theValue;
        return this;
    }

    public HumanNameDt addName() {
        HumanNameDt newType = new HumanNameDt();
        this.getName().add(newType);
        return newType;
    }

    public HumanNameDt getNameFirstRep() {
        if (this.getName().isEmpty()) {
            return this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public Patient setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Patient addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Patient addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGender() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public Patient setGender(BoundCodeableConceptDt<AdministrativeGenderCodesEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public Patient setGender(AdministrativeGenderCodesEnum theValue) {
        this.getGender().setValueAsEnum(theValue);
        return this;
    }

    public DateTimeDt getBirthDate() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateTimeDt();
        }
        return this.myBirthDate;
    }

    public DateTimeDt getBirthDateElement() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateTimeDt();
        }
        return this.myBirthDate;
    }

    public Patient setBirthDate(DateTimeDt theValue) {
        this.myBirthDate = theValue;
        return this;
    }

    public Patient setBirthDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myBirthDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Patient setBirthDateWithSecondsPrecision(Date theDate) {
        this.myBirthDate = new DateTimeDt(theDate);
        return this;
    }

    public IDatatype getDeceased() {
        return this.myDeceased;
    }

    public IDatatype getDeceasedElement() {
        return this.myDeceased;
    }

    public Patient setDeceased(IDatatype theValue) {
        this.myDeceased = theValue;
        return this;
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public List<AddressDt> getAddressElement() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public Patient setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public BoundCodeableConceptDt<MaritalStatusCodesEnum> getMaritalStatus() {
        if (this.myMaritalStatus == null) {
            this.myMaritalStatus = new BoundCodeableConceptDt<MaritalStatusCodesEnum>(MaritalStatusCodesEnum.VALUESET_BINDER);
        }
        return this.myMaritalStatus;
    }

    public BoundCodeableConceptDt<MaritalStatusCodesEnum> getMaritalStatusElement() {
        if (this.myMaritalStatus == null) {
            this.myMaritalStatus = new BoundCodeableConceptDt<MaritalStatusCodesEnum>(MaritalStatusCodesEnum.VALUESET_BINDER);
        }
        return this.myMaritalStatus;
    }

    public Patient setMaritalStatus(BoundCodeableConceptDt<MaritalStatusCodesEnum> theValue) {
        this.myMaritalStatus = theValue;
        return this;
    }

    public Patient setMaritalStatus(MaritalStatusCodesEnum theValue) {
        this.getMaritalStatus().setValueAsEnum(theValue);
        return this;
    }

    public IDatatype getMultipleBirth() {
        return this.myMultipleBirth;
    }

    public IDatatype getMultipleBirthElement() {
        return this.myMultipleBirth;
    }

    public Patient setMultipleBirth(IDatatype theValue) {
        this.myMultipleBirth = theValue;
        return this;
    }

    public List<AttachmentDt> getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public List<AttachmentDt> getPhotoElement() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public Patient setPhoto(List<AttachmentDt> theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public AttachmentDt addPhoto() {
        AttachmentDt newType = new AttachmentDt();
        this.getPhoto().add(newType);
        return newType;
    }

    public AttachmentDt getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            return this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public List<Contact> getContactElement() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public Patient setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public Animal getAnimal() {
        if (this.myAnimal == null) {
            this.myAnimal = new Animal();
        }
        return this.myAnimal;
    }

    public Animal getAnimalElement() {
        if (this.myAnimal == null) {
            this.myAnimal = new Animal();
        }
        return this.myAnimal;
    }

    public Patient setAnimal(Animal theValue) {
        this.myAnimal = theValue;
        return this;
    }

    public List<CodeableConceptDt> getCommunication() {
        if (this.myCommunication == null) {
            this.myCommunication = new ArrayList<CodeableConceptDt>();
        }
        return this.myCommunication;
    }

    public List<CodeableConceptDt> getCommunicationElement() {
        if (this.myCommunication == null) {
            this.myCommunication = new ArrayList<CodeableConceptDt>();
        }
        return this.myCommunication;
    }

    public Patient setCommunication(List<CodeableConceptDt> theValue) {
        this.myCommunication = theValue;
        return this;
    }

    public CodeableConceptDt addCommunication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCommunication().add(newType);
        return newType;
    }

    public CodeableConceptDt getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            return this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    public List<ResourceReferenceDt> getCareProvider() {
        if (this.myCareProvider == null) {
            this.myCareProvider = new ArrayList<ResourceReferenceDt>();
        }
        return this.myCareProvider;
    }

    public List<ResourceReferenceDt> getCareProviderElement() {
        if (this.myCareProvider == null) {
            this.myCareProvider = new ArrayList<ResourceReferenceDt>();
        }
        return this.myCareProvider;
    }

    public Patient setCareProvider(List<ResourceReferenceDt> theValue) {
        this.myCareProvider = theValue;
        return this;
    }

    public ResourceReferenceDt addCareProvider() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getCareProvider().add(newType);
        return newType;
    }

    public ResourceReferenceDt getManagingOrganization() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public ResourceReferenceDt getManagingOrganizationElement() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public Patient setManagingOrganization(ResourceReferenceDt theValue) {
        this.myManagingOrganization = theValue;
        return this;
    }

    public List<Link> getLink() {
        if (this.myLink == null) {
            this.myLink = new ArrayList<Link>();
        }
        return this.myLink;
    }

    public List<Link> getLinkElement() {
        if (this.myLink == null) {
            this.myLink = new ArrayList<Link>();
        }
        return this.myLink;
    }

    public Patient setLink(List<Link> theValue) {
        this.myLink = theValue;
        return this;
    }

    public Link addLink() {
        Link newType = new Link();
        this.getLink().add(newType);
        return newType;
    }

    public Link getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            return this.addLink();
        }
        return this.getLink().get(0);
    }

    public BooleanDt getActive() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public BooleanDt getActiveElement() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public Patient setActive(BooleanDt theValue) {
        this.myActive = theValue;
        return this;
    }

    public Patient setActive(boolean theBoolean) {
        this.myActive = new BooleanDt(theBoolean);
        return this;
    }

    public String getResourceName() {
        return "Patient";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Link
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="other", order=0, min=1, max=1, summary=true, modifier=true, type={Patient.class})
        @Description(shortDefinition="The other patient resource that the link refers to", formalDefinition="The other patient resource that the link refers to")
        private ResourceReferenceDt myOther;
        @Child(name="type", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
        @Description(shortDefinition="replace | refer | seealso - type of link", formalDefinition="The type of link between this patient resource and another patient resource.")
        private BoundCodeDt<LinkTypeEnum> myType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOther, this.myType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOther, this.myType});
        }

        public ResourceReferenceDt getOther() {
            if (this.myOther == null) {
                this.myOther = new ResourceReferenceDt();
            }
            return this.myOther;
        }

        public ResourceReferenceDt getOtherElement() {
            if (this.myOther == null) {
                this.myOther = new ResourceReferenceDt();
            }
            return this.myOther;
        }

        public Link setOther(ResourceReferenceDt theValue) {
            this.myOther = theValue;
            return this;
        }

        public BoundCodeDt<LinkTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(LinkTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<LinkTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(LinkTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public Link setType(BoundCodeDt<LinkTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Link setType(LinkTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }
    }

    @Block
    public static class Animal
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="species", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="E.g. Dog, Cow", formalDefinition="Identifies the high level categorization of the kind of animal")
        private BoundCodeableConceptDt<AnimalSpeciesEnum> mySpecies;
        @Child(name="breed", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="E.g. Poodle, Angus", formalDefinition="Identifies the detailed categorization of the kind of animal.")
        private CodeableConceptDt myBreed;
        @Child(name="genderStatus", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="E.g. Neutered, Intact", formalDefinition="Indicates the current state of the animal's reproductive organs")
        private CodeableConceptDt myGenderStatus;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySpecies, this.myBreed, this.myGenderStatus});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySpecies, this.myBreed, this.myGenderStatus});
        }

        public BoundCodeableConceptDt<AnimalSpeciesEnum> getSpecies() {
            if (this.mySpecies == null) {
                this.mySpecies = new BoundCodeableConceptDt<AnimalSpeciesEnum>(AnimalSpeciesEnum.VALUESET_BINDER);
            }
            return this.mySpecies;
        }

        public BoundCodeableConceptDt<AnimalSpeciesEnum> getSpeciesElement() {
            if (this.mySpecies == null) {
                this.mySpecies = new BoundCodeableConceptDt<AnimalSpeciesEnum>(AnimalSpeciesEnum.VALUESET_BINDER);
            }
            return this.mySpecies;
        }

        public Animal setSpecies(BoundCodeableConceptDt<AnimalSpeciesEnum> theValue) {
            this.mySpecies = theValue;
            return this;
        }

        public Animal setSpecies(AnimalSpeciesEnum theValue) {
            this.getSpecies().setValueAsEnum(theValue);
            return this;
        }

        public CodeableConceptDt getBreed() {
            if (this.myBreed == null) {
                this.myBreed = new CodeableConceptDt();
            }
            return this.myBreed;
        }

        public CodeableConceptDt getBreedElement() {
            if (this.myBreed == null) {
                this.myBreed = new CodeableConceptDt();
            }
            return this.myBreed;
        }

        public Animal setBreed(CodeableConceptDt theValue) {
            this.myBreed = theValue;
            return this;
        }

        public CodeableConceptDt getGenderStatus() {
            if (this.myGenderStatus == null) {
                this.myGenderStatus = new CodeableConceptDt();
            }
            return this.myGenderStatus;
        }

        public CodeableConceptDt getGenderStatusElement() {
            if (this.myGenderStatus == null) {
                this.myGenderStatus = new CodeableConceptDt();
            }
            return this.myGenderStatus;
        }

        public Animal setGenderStatus(CodeableConceptDt theValue) {
            this.myGenderStatus = theValue;
            return this;
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="relationship", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="The kind of relationship", formalDefinition="The nature of the relationship between the patient and the contact person")
        private List<CodeableConceptDt> myRelationship;
        @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the person")
        private HumanNameDt myName;
        @Child(name="telecom", type={ContactDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
        private List<ContactDt> myTelecom;
        @Child(name="address", type={AddressDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Address for the contact person", formalDefinition="Address for the contact person")
        private AddressDt myAddress;
        @Child(name="gender", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Gender for administrative purposes", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
        private BoundCodeableConceptDt<AdministrativeGenderCodesEnum> myGender;
        @Child(name="organization", order=5, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="Organization that is associated with the contact", formalDefinition="Organization on behalf of which the contact is acting or for which the contact is working.")
        private ResourceReferenceDt myOrganization;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRelationship, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myOrganization});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRelationship, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myOrganization});
        }

        public List<CodeableConceptDt> getRelationship() {
            if (this.myRelationship == null) {
                this.myRelationship = new ArrayList<CodeableConceptDt>();
            }
            return this.myRelationship;
        }

        public List<CodeableConceptDt> getRelationshipElement() {
            if (this.myRelationship == null) {
                this.myRelationship = new ArrayList<CodeableConceptDt>();
            }
            return this.myRelationship;
        }

        public Contact setRelationship(List<CodeableConceptDt> theValue) {
            this.myRelationship = theValue;
            return this;
        }

        public CodeableConceptDt addRelationship() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRelationship().add(newType);
            return newType;
        }

        public CodeableConceptDt getRelationshipFirstRep() {
            if (this.getRelationship().isEmpty()) {
                return this.addRelationship();
            }
            return this.getRelationship().get(0);
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public HumanNameDt getNameElement() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public Contact setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public List<ContactDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            return this.myTelecom;
        }

        public List<ContactDt> getTelecomElement() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactDt addTelecom() {
            ContactDt newType = new ContactDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public ContactDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public Contact addTelecom(ContactUseEnum theContactUse, String theValue) {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            this.myTelecom.add(new ContactDt(theContactUse, theValue));
            return this;
        }

        public Contact addTelecom(String theValue) {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            this.myTelecom.add(new ContactDt(theValue));
            return this;
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public AddressDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public Contact setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGender() {
            if (this.myGender == null) {
                this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
            }
            return this.myGender;
        }

        public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGenderElement() {
            if (this.myGender == null) {
                this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
            }
            return this.myGender;
        }

        public Contact setGender(BoundCodeableConceptDt<AdministrativeGenderCodesEnum> theValue) {
            this.myGender = theValue;
            return this;
        }

        public Contact setGender(AdministrativeGenderCodesEnum theValue) {
            this.getGender().setValueAsEnum(theValue);
            return this;
        }

        public ResourceReferenceDt getOrganization() {
            if (this.myOrganization == null) {
                this.myOrganization = new ResourceReferenceDt();
            }
            return this.myOrganization;
        }

        public ResourceReferenceDt getOrganizationElement() {
            if (this.myOrganization == null) {
                this.myOrganization = new ResourceReferenceDt();
            }
            return this.myOrganization;
        }

        public Contact setOrganization(ResourceReferenceDt theValue) {
            this.myOrganization = theValue;
            return this;
        }
    }
}

