/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.valueset.IssueSeverityEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="OperationOutcome", profile="http://hl7.org/fhir/profiles/OperationOutcome", id="operationoutcome")
public class OperationOutcome
extends BaseResource
implements BaseOperationOutcome {
    @Child(name="issue", order=0, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A single issue associated with the action", formalDefinition="An error, warning or information message that results from a system action")
    private List<Issue> myIssue;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty(this.myIssue);
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIssue});
    }

    public List<Issue> getIssue() {
        if (this.myIssue == null) {
            this.myIssue = new ArrayList<Issue>();
        }
        return this.myIssue;
    }

    public List<Issue> getIssueElement() {
        if (this.myIssue == null) {
            this.myIssue = new ArrayList<Issue>();
        }
        return this.myIssue;
    }

    public OperationOutcome setIssue(List<Issue> theValue) {
        this.myIssue = theValue;
        return this;
    }

    public Issue addIssue() {
        Issue newType = new Issue();
        this.getIssue().add(newType);
        return newType;
    }

    public Issue getIssueFirstRep() {
        if (this.getIssue().isEmpty()) {
            return this.addIssue();
        }
        return this.getIssue().get(0);
    }

    public String getResourceName() {
        return "OperationOutcome";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Issue
    extends BaseOperationOutcome.BaseIssue
    implements IResourceBlock {
        @Child(name="severity", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="fatal | error | warning | information", formalDefinition="Indicates whether the issue indicates a variation from successful processing")
        private BoundCodeDt<IssueSeverityEnum> mySeverity;
        @Child(name="type", type={CodingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Error or warning code", formalDefinition="A code indicating the type of error, warning or information message.")
        private CodingDt myType;
        @Child(name="details", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Additional description of the issue", formalDefinition="Additional description of the issue")
        private StringDt myDetails;
        @Child(name="location", type={StringDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="XPath of element(s) related to issue", formalDefinition="A simple XPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.")
        private List<StringDt> myLocation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySeverity, this.myType, this.myDetails, this.myLocation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySeverity, this.myType, this.myDetails, this.myLocation});
        }

        public BoundCodeDt<IssueSeverityEnum> getSeverity() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(IssueSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public BoundCodeDt<IssueSeverityEnum> getSeverityElement() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(IssueSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public Issue setSeverity(BoundCodeDt<IssueSeverityEnum> theValue) {
            this.mySeverity = theValue;
            return this;
        }

        public Issue setSeverity(IssueSeverityEnum theValue) {
            this.getSeverity().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public CodingDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Issue setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public StringDt getDetails() {
            if (this.myDetails == null) {
                this.myDetails = new StringDt();
            }
            return this.myDetails;
        }

        public StringDt getDetailsElement() {
            if (this.myDetails == null) {
                this.myDetails = new StringDt();
            }
            return this.myDetails;
        }

        public Issue setDetails(StringDt theValue) {
            this.myDetails = theValue;
            return this;
        }

        public Issue setDetails(String theString) {
            this.myDetails = new StringDt(theString);
            return this;
        }

        public List<StringDt> getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ArrayList<StringDt>();
            }
            return this.myLocation;
        }

        public List<StringDt> getLocationElement() {
            if (this.myLocation == null) {
                this.myLocation = new ArrayList<StringDt>();
            }
            return this.myLocation;
        }

        public Issue setLocation(List<StringDt> theValue) {
            this.myLocation = theValue;
            return this;
        }

        public StringDt addLocation() {
            StringDt newType = new StringDt();
            this.getLocation().add(newType);
            return newType;
        }

        public StringDt getLocationFirstRep() {
            if (this.getLocation().isEmpty()) {
                return this.addLocation();
            }
            return this.getLocation().get(0);
        }

        public Issue addLocation(String theString) {
            if (this.myLocation == null) {
                this.myLocation = new ArrayList<StringDt>();
            }
            this.myLocation.add(new StringDt(theString));
            return this;
        }

        public BaseOperationOutcome.BaseIssue setDiagnostics(String theString) {
            return this.setDetails(theString);
        }
    }
}

