/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RangeDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.SampledDataDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Specimen;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ObservationRelationshipTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.ObservationReliabilityEnum;
import ca.uhn.fhir.model.dstu.valueset.ObservationStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Observation", profile="http://hl7.org/fhir/profiles/Observation", id="observation")
public class Observation
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="name", path="Observation.name", description="The name of the observation type", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="value-quantity", path="Observation.value[x]", description="The value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_VALUE_QUANTITY = "value-quantity";
    public static final QuantityClientParam VALUE_QUANTITY = new QuantityClientParam("value-quantity");
    @SearchParamDefinition(name="value-concept", path="Observation.value[x]", description="The value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_VALUE_CONCEPT = "value-concept";
    public static final TokenClientParam VALUE_CONCEPT = new TokenClientParam("value-concept");
    @SearchParamDefinition(name="value-date", path="Observation.value[x]", description="The value of the observation, if the value is a Period", type="date")
    public static final String SP_VALUE_DATE = "value-date";
    public static final DateClientParam VALUE_DATE = new DateClientParam("value-date");
    @SearchParamDefinition(name="value-string", path="Observation.value[x]", description="The value of the observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_VALUE_STRING = "value-string";
    public static final StringClientParam VALUE_STRING = new StringClientParam("value-string");
    @SearchParamDefinition(name="date", path="Observation.applies[x]", description="Obtained date/time. If the obtained element is a period, a date that falls in the period", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="Observation.status", description="The status of the observation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="reliability", path="Observation.reliability", description="The reliability of the observation", type="token")
    public static final String SP_RELIABILITY = "reliability";
    public static final TokenClientParam RELIABILITY = new TokenClientParam("reliability");
    @SearchParamDefinition(name="subject", path="Observation.subject", description="The subject that the observation is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Observation.subject");
    @SearchParamDefinition(name="performer", path="Observation.performer", description="Who and/or what performed the observation", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Observation.performer");
    @SearchParamDefinition(name="specimen", path="Observation.specimen", description="", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("Observation.specimen");
    @SearchParamDefinition(name="related-type", path="Observation.related.type", description="", type="token")
    public static final String SP_RELATED_TYPE = "related-type";
    public static final TokenClientParam RELATED_TYPE = new TokenClientParam("related-type");
    @SearchParamDefinition(name="related-target", path="Observation.related.target", description="", type="reference")
    public static final String SP_RELATED_TARGET = "related-target";
    public static final ReferenceClientParam RELATED_TARGET = new ReferenceClientParam("related-target");
    public static final Include INCLUDE_RELATED_TARGET = new Include("Observation.related.target");
    @SearchParamDefinition(name="name-value-quantity", path="name & value-[x]", description="Both name and one of the value parameters", type="composite", compositeOf={"name", "value-quantity"})
    public static final String SP_NAME_VALUE_QUANTITY = "name-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> NAME_VALUE_QUANTITY = new CompositeClientParam("name-value-quantity");
    @SearchParamDefinition(name="name-value-concept", path="name & value-[x]", description="Both name and one of the value parameters", type="composite", compositeOf={"name", "value-concept"})
    public static final String SP_NAME_VALUE_CONCEPT = "name-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> NAME_VALUE_CONCEPT = new CompositeClientParam("name-value-concept");
    @SearchParamDefinition(name="name-value-date", path="name & value-[x]", description="Both name and one of the value parameters", type="composite", compositeOf={"name", "value-date"})
    public static final String SP_NAME_VALUE_DATE = "name-value-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> NAME_VALUE_DATE = new CompositeClientParam("name-value-date");
    @SearchParamDefinition(name="name-value-string", path="name & value-[x]", description="Both name and one of the value parameters", type="composite", compositeOf={"name", "value-string"})
    public static final String SP_NAME_VALUE_STRING = "name-value-string";
    public static final CompositeClientParam<TokenClientParam, StringClientParam> NAME_VALUE_STRING = new CompositeClientParam("name-value-string");
    @SearchParamDefinition(name="related-target-related-type", path="related-target & related-type", description="Related Observations - search on related-type and related-target together", type="composite", compositeOf={"related-target", "related-type"})
    public static final String SP_RELATED_TARGET_RELATED_TYPE = "related-target-related-type";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATED_TARGET_RELATED_TYPE = new CompositeClientParam("related-target-related-type");
    @Child(name="name", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Type of observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"code\"")
    private CodeableConceptDt myName;
    @Child(name="value", order=1, min=0, max=1, summary=false, modifier=false, type={QuantityDt.class, CodeableConceptDt.class, AttachmentDt.class, RatioDt.class, PeriodDt.class, SampledDataDt.class, StringDt.class})
    @Description(shortDefinition="Actual result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value")
    private IDatatype myValue;
    @Child(name="interpretation", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="High, low, normal, etc.", formalDefinition="The assessment made based on the result of the observation.")
    private CodeableConceptDt myInterpretation;
    @Child(name="comments", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Comments about result", formalDefinition="May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.")
    private StringDt myComments;
    @Child(name="applies", order=4, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="Physiologically Relevant time/time-period for observation", formalDefinition="The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself")
    private IDatatype myApplies;
    @Child(name="issued", type={InstantDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date/Time this was made available", formalDefinition="")
    private InstantDt myIssued;
    @Child(name="status", type={CodeDt.class}, order=6, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="The status of the result value")
    private BoundCodeDt<ObservationStatusEnum> myStatus;
    @Child(name="reliability", type={CodeDt.class}, order=7, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="ok | ongoing | early | questionable | calibrating | error +", formalDefinition="An estimate of the degree to which quality issues have impacted on the value reported")
    private BoundCodeDt<ObservationReliabilityEnum> myReliability;
    @Child(name="bodySite", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Observed body part", formalDefinition="Indicates where on the subject's body the observation was made.")
    private CodeableConceptDt myBodySite;
    @Child(name="method", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="How it was done", formalDefinition="Indicates the mechanism used to perform the observation")
    private CodeableConceptDt myMethod;
    @Child(name="identifier", type={IdentifierDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Unique Id for this particular observation", formalDefinition="A unique identifier for the simple observation")
    private IdentifierDt myIdentifier;
    @Child(name="subject", order=11, min=0, max=1, summary=false, modifier=false, type={Patient.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="Who and/or what this is about", formalDefinition="The thing the observation is being made about")
    private ResourceReferenceDt mySubject;
    @Child(name="specimen", order=12, min=0, max=1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="Specimen used for this observation", formalDefinition="The specimen that was used when this observation was made")
    private ResourceReferenceDt mySpecimen;
    @Child(name="performer", order=13, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class, Device.class, Organization.class})
    @Description(shortDefinition="Who did the observation", formalDefinition="Who was responsible for asserting the observed value as \"true\"")
    private List<ResourceReferenceDt> myPerformer;
    @Child(name="referenceRange", order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Provides guide for interpretation", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range")
    private List<ReferenceRange> myReferenceRange;
    @Child(name="related", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Observations related to this observation", formalDefinition="Related observations - either components, or previous observations, or statements of derivation")
    private List<Related> myRelated;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myValue, this.myInterpretation, this.myComments, this.myApplies, this.myIssued, this.myStatus, this.myReliability, this.myBodySite, this.myMethod, this.myIdentifier, this.mySubject, this.mySpecimen, this.myPerformer, this.myReferenceRange, this.myRelated});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myValue, this.myInterpretation, this.myComments, this.myApplies, this.myIssued, this.myStatus, this.myReliability, this.myBodySite, this.myMethod, this.myIdentifier, this.mySubject, this.mySpecimen, this.myPerformer, this.myReferenceRange, this.myRelated});
    }

    public CodeableConceptDt getName() {
        if (this.myName == null) {
            this.myName = new CodeableConceptDt();
        }
        return this.myName;
    }

    public CodeableConceptDt getNameElement() {
        if (this.myName == null) {
            this.myName = new CodeableConceptDt();
        }
        return this.myName;
    }

    public Observation setName(CodeableConceptDt theValue) {
        this.myName = theValue;
        return this;
    }

    public IDatatype getValue() {
        return this.myValue;
    }

    public IDatatype getValueElement() {
        return this.myValue;
    }

    public Observation setValue(IDatatype theValue) {
        this.myValue = theValue;
        return this;
    }

    public CodeableConceptDt getInterpretation() {
        if (this.myInterpretation == null) {
            this.myInterpretation = new CodeableConceptDt();
        }
        return this.myInterpretation;
    }

    public CodeableConceptDt getInterpretationElement() {
        if (this.myInterpretation == null) {
            this.myInterpretation = new CodeableConceptDt();
        }
        return this.myInterpretation;
    }

    public Observation setInterpretation(CodeableConceptDt theValue) {
        this.myInterpretation = theValue;
        return this;
    }

    public StringDt getComments() {
        if (this.myComments == null) {
            this.myComments = new StringDt();
        }
        return this.myComments;
    }

    public StringDt getCommentsElement() {
        if (this.myComments == null) {
            this.myComments = new StringDt();
        }
        return this.myComments;
    }

    public Observation setComments(StringDt theValue) {
        this.myComments = theValue;
        return this;
    }

    public Observation setComments(String theString) {
        this.myComments = new StringDt(theString);
        return this;
    }

    public IDatatype getApplies() {
        return this.myApplies;
    }

    public IDatatype getAppliesElement() {
        return this.myApplies;
    }

    public Observation setApplies(IDatatype theValue) {
        this.myApplies = theValue;
        return this;
    }

    public InstantDt getIssued() {
        if (this.myIssued == null) {
            this.myIssued = new InstantDt();
        }
        return this.myIssued;
    }

    public InstantDt getIssuedElement() {
        if (this.myIssued == null) {
            this.myIssued = new InstantDt();
        }
        return this.myIssued;
    }

    public Observation setIssued(InstantDt theValue) {
        this.myIssued = theValue;
        return this;
    }

    public Observation setIssuedWithMillisPrecision(Date theDate) {
        this.myIssued = new InstantDt(theDate);
        return this;
    }

    public Observation setIssued(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIssued = new InstantDt(theDate, thePrecision);
        return this;
    }

    public BoundCodeDt<ObservationStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ObservationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<ObservationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ObservationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Observation setStatus(BoundCodeDt<ObservationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Observation setStatus(ObservationStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<ObservationReliabilityEnum> getReliability() {
        if (this.myReliability == null) {
            this.myReliability = new BoundCodeDt(ObservationReliabilityEnum.VALUESET_BINDER);
        }
        return this.myReliability;
    }

    public BoundCodeDt<ObservationReliabilityEnum> getReliabilityElement() {
        if (this.myReliability == null) {
            this.myReliability = new BoundCodeDt(ObservationReliabilityEnum.VALUESET_BINDER);
        }
        return this.myReliability;
    }

    public Observation setReliability(BoundCodeDt<ObservationReliabilityEnum> theValue) {
        this.myReliability = theValue;
        return this;
    }

    public Observation setReliability(ObservationReliabilityEnum theValue) {
        this.getReliability().setValueAsEnum((Enum)theValue);
        return this;
    }

    public CodeableConceptDt getBodySite() {
        if (this.myBodySite == null) {
            this.myBodySite = new CodeableConceptDt();
        }
        return this.myBodySite;
    }

    public CodeableConceptDt getBodySiteElement() {
        if (this.myBodySite == null) {
            this.myBodySite = new CodeableConceptDt();
        }
        return this.myBodySite;
    }

    public Observation setBodySite(CodeableConceptDt theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public CodeableConceptDt getMethod() {
        if (this.myMethod == null) {
            this.myMethod = new CodeableConceptDt();
        }
        return this.myMethod;
    }

    public CodeableConceptDt getMethodElement() {
        if (this.myMethod == null) {
            this.myMethod = new CodeableConceptDt();
        }
        return this.myMethod;
    }

    public Observation setMethod(CodeableConceptDt theValue) {
        this.myMethod = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Observation setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Observation setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Observation setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Observation setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ResourceReferenceDt();
        }
        return this.mySpecimen;
    }

    public ResourceReferenceDt getSpecimenElement() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ResourceReferenceDt();
        }
        return this.mySpecimen;
    }

    public Observation setSpecimen(ResourceReferenceDt theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPerformer;
    }

    public List<ResourceReferenceDt> getPerformerElement() {
        if (this.myPerformer == null) {
            this.myPerformer = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPerformer;
    }

    public Observation setPerformer(List<ResourceReferenceDt> theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public ResourceReferenceDt addPerformer() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getPerformer().add(newType);
        return newType;
    }

    public List<ReferenceRange> getReferenceRange() {
        if (this.myReferenceRange == null) {
            this.myReferenceRange = new ArrayList<ReferenceRange>();
        }
        return this.myReferenceRange;
    }

    public List<ReferenceRange> getReferenceRangeElement() {
        if (this.myReferenceRange == null) {
            this.myReferenceRange = new ArrayList<ReferenceRange>();
        }
        return this.myReferenceRange;
    }

    public Observation setReferenceRange(List<ReferenceRange> theValue) {
        this.myReferenceRange = theValue;
        return this;
    }

    public ReferenceRange addReferenceRange() {
        ReferenceRange newType = new ReferenceRange();
        this.getReferenceRange().add(newType);
        return newType;
    }

    public ReferenceRange getReferenceRangeFirstRep() {
        if (this.getReferenceRange().isEmpty()) {
            return this.addReferenceRange();
        }
        return this.getReferenceRange().get(0);
    }

    public List<Related> getRelated() {
        if (this.myRelated == null) {
            this.myRelated = new ArrayList<Related>();
        }
        return this.myRelated;
    }

    public List<Related> getRelatedElement() {
        if (this.myRelated == null) {
            this.myRelated = new ArrayList<Related>();
        }
        return this.myRelated;
    }

    public Observation setRelated(List<Related> theValue) {
        this.myRelated = theValue;
        return this;
    }

    public Related addRelated() {
        Related newType = new Related();
        this.getRelated().add(newType);
        return newType;
    }

    public Related getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            return this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public String getResourceName() {
        return "Observation";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Related
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="has-component | has-member | derived-from | sequel-to | replaces | qualified-by | interfered-by", formalDefinition="A code specifying the kind of relationship that exists with the target observation")
        private BoundCodeDt<ObservationRelationshipTypeEnum> myType;
        @Child(name="target", order=1, min=1, max=1, summary=false, modifier=false, type={Observation.class})
        @Description(shortDefinition="Observation that is related to this one", formalDefinition="A reference to the observation that is related to this observation")
        private ResourceReferenceDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myTarget});
        }

        public BoundCodeDt<ObservationRelationshipTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ObservationRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<ObservationRelationshipTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ObservationRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public Related setType(BoundCodeDt<ObservationRelationshipTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Related setType(ObservationRelationshipTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public ResourceReferenceDt getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public Related setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }
    }

    @Block
    public static class ReferenceRange
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="low", type={QuantityDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Low Range, if relevant", formalDefinition="The value of the low bound of the reference range. If this is omitted, the low bound of the reference range is assumed to be meaningless. E.g. <2.3")
        private QuantityDt myLow;
        @Child(name="high", type={QuantityDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="High Range, if relevant", formalDefinition="The value of the high bound of the reference range. If this is omitted, the high bound of the reference range is assumed to be meaningless. E.g. >5")
        private QuantityDt myHigh;
        @Child(name="meaning", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Indicates the meaning/use of this range of this range", formalDefinition="Code for the meaning of the reference range")
        private CodeableConceptDt myMeaning;
        @Child(name="age", type={RangeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Applicable age range, if relevant", formalDefinition="The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so")
        private RangeDt myAge;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLow, this.myHigh, this.myMeaning, this.myAge});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLow, this.myHigh, this.myMeaning, this.myAge});
        }

        public QuantityDt getLow() {
            if (this.myLow == null) {
                this.myLow = new QuantityDt();
            }
            return this.myLow;
        }

        public QuantityDt getLowElement() {
            if (this.myLow == null) {
                this.myLow = new QuantityDt();
            }
            return this.myLow;
        }

        public ReferenceRange setLow(QuantityDt theValue) {
            this.myLow = theValue;
            return this;
        }

        public ReferenceRange setLow(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myLow = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ReferenceRange setLow(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myLow = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ReferenceRange setLow(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myLow = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ReferenceRange setLow(double theValue) {
            this.myLow = new QuantityDt(theValue);
            return this;
        }

        public ReferenceRange setLow(long theValue) {
            this.myLow = new QuantityDt(theValue);
            return this;
        }

        public ReferenceRange setLow(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myLow = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public QuantityDt getHigh() {
            if (this.myHigh == null) {
                this.myHigh = new QuantityDt();
            }
            return this.myHigh;
        }

        public QuantityDt getHighElement() {
            if (this.myHigh == null) {
                this.myHigh = new QuantityDt();
            }
            return this.myHigh;
        }

        public ReferenceRange setHigh(QuantityDt theValue) {
            this.myHigh = theValue;
            return this;
        }

        public ReferenceRange setHigh(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myHigh = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ReferenceRange setHigh(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myHigh = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ReferenceRange setHigh(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myHigh = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ReferenceRange setHigh(double theValue) {
            this.myHigh = new QuantityDt(theValue);
            return this;
        }

        public ReferenceRange setHigh(long theValue) {
            this.myHigh = new QuantityDt(theValue);
            return this;
        }

        public ReferenceRange setHigh(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myHigh = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public CodeableConceptDt getMeaning() {
            if (this.myMeaning == null) {
                this.myMeaning = new CodeableConceptDt();
            }
            return this.myMeaning;
        }

        public CodeableConceptDt getMeaningElement() {
            if (this.myMeaning == null) {
                this.myMeaning = new CodeableConceptDt();
            }
            return this.myMeaning;
        }

        public ReferenceRange setMeaning(CodeableConceptDt theValue) {
            this.myMeaning = theValue;
            return this;
        }

        public RangeDt getAge() {
            if (this.myAge == null) {
                this.myAge = new RangeDt();
            }
            return this.myAge;
        }

        public RangeDt getAgeElement() {
            if (this.myAge == null) {
                this.myAge = new RangeDt();
            }
            return this.myAge;
        }

        public ReferenceRange setAge(RangeDt theValue) {
            this.myAge = theValue;
            return this;
        }
    }
}

