/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Specimen;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.MediaTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Media", profile="http://hl7.org/fhir/profiles/Media", id="media")
public class Media
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Media.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="subtype", path="Media.subtype", description="", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="identifier", path="Media.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="date", path="Media.dateTime", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="Media.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Media.subject");
    @SearchParamDefinition(name="operator", path="Media.operator", description="", type="reference")
    public static final String SP_OPERATOR = "operator";
    public static final ReferenceClientParam OPERATOR = new ReferenceClientParam("operator");
    public static final Include INCLUDE_OPERATOR = new Include("Media.operator");
    @SearchParamDefinition(name="view", path="Media.view", description="", type="token")
    public static final String SP_VIEW = "view";
    public static final TokenClientParam VIEW = new TokenClientParam("view");
    @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="photo | video | audio", formalDefinition="Whether the media is a photo (still image), an audio recording, or a video recording")
    private BoundCodeDt<MediaTypeEnum> myType;
    @Child(name="subtype", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="The type of acquisition equipment/process", formalDefinition="Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality")
    private CodeableConceptDt mySubtype;
    @Child(name="identifier", type={IdentifierDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Identifier(s) for the image", formalDefinition="Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers")
    private List<IdentifierDt> myIdentifier;
    @Child(name="dateTime", type={DateTimeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="When the media was taken/recorded (end)", formalDefinition="When the media was originally recorded. For video and audio, if the length of the recording is not insignificant, this is the end of the recording")
    private DateTimeDt myDateTime;
    @Child(name="subject", order=4, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, Group.class, Device.class, Specimen.class})
    @Description(shortDefinition="Who/What this Media is a record of", formalDefinition="Who/What this Media is a record of")
    private ResourceReferenceDt mySubject;
    @Child(name="operator", order=5, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="The person who generated the image", formalDefinition="The person who administered the collection of the image")
    private ResourceReferenceDt myOperator;
    @Child(name="view", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Imaging view e.g Lateral or Antero-posterior", formalDefinition="The name of the imaging view e.g Lateral or Antero-posterior (AP).")
    private CodeableConceptDt myView;
    @Child(name="deviceName", type={StringDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Name of the device/manufacturer", formalDefinition="The name of the device / manufacturer of the device  that was used to make the recording")
    private StringDt myDeviceName;
    @Child(name="height", type={IntegerDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Height of the image in pixels(photo/video)", formalDefinition="Height of the image in pixels(photo/video)")
    private IntegerDt myHeight;
    @Child(name="width", type={IntegerDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Width of the image in pixels (photo/video)", formalDefinition="Width of the image in pixels (photo/video)")
    private IntegerDt myWidth;
    @Child(name="frames", type={IntegerDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Number of frames if > 1 (photo)", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required")
    private IntegerDt myFrames;
    @Child(name="length", type={IntegerDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Length in seconds (audio / video)", formalDefinition="The length of the recording in seconds - for audio and video")
    private IntegerDt myLength;
    @Child(name="content", type={AttachmentDt.class}, order=12, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Actual Media - reference or data", formalDefinition="The actual content of the media - inline or by direct reference to the media source file")
    private AttachmentDt myContent;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.mySubtype, this.myIdentifier, this.myDateTime, this.mySubject, this.myOperator, this.myView, this.myDeviceName, this.myHeight, this.myWidth, this.myFrames, this.myLength, this.myContent});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySubtype, this.myIdentifier, this.myDateTime, this.mySubject, this.myOperator, this.myView, this.myDeviceName, this.myHeight, this.myWidth, this.myFrames, this.myLength, this.myContent});
    }

    public BoundCodeDt<MediaTypeEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(MediaTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public BoundCodeDt<MediaTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(MediaTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public Media setType(BoundCodeDt<MediaTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Media setType(MediaTypeEnum theValue) {
        this.getType().setValueAsEnum((Enum)theValue);
        return this;
    }

    public CodeableConceptDt getSubtype() {
        if (this.mySubtype == null) {
            this.mySubtype = new CodeableConceptDt();
        }
        return this.mySubtype;
    }

    public CodeableConceptDt getSubtypeElement() {
        if (this.mySubtype == null) {
            this.mySubtype = new CodeableConceptDt();
        }
        return this.mySubtype;
    }

    public Media setSubtype(CodeableConceptDt theValue) {
        this.mySubtype = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Media setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Media addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Media addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public DateTimeDt getDateTime() {
        if (this.myDateTime == null) {
            this.myDateTime = new DateTimeDt();
        }
        return this.myDateTime;
    }

    public DateTimeDt getDateTimeElement() {
        if (this.myDateTime == null) {
            this.myDateTime = new DateTimeDt();
        }
        return this.myDateTime;
    }

    public Media setDateTime(DateTimeDt theValue) {
        this.myDateTime = theValue;
        return this;
    }

    public Media setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Media setDateTimeWithSecondsPrecision(Date theDate) {
        this.myDateTime = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Media setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getOperator() {
        if (this.myOperator == null) {
            this.myOperator = new ResourceReferenceDt();
        }
        return this.myOperator;
    }

    public ResourceReferenceDt getOperatorElement() {
        if (this.myOperator == null) {
            this.myOperator = new ResourceReferenceDt();
        }
        return this.myOperator;
    }

    public Media setOperator(ResourceReferenceDt theValue) {
        this.myOperator = theValue;
        return this;
    }

    public CodeableConceptDt getView() {
        if (this.myView == null) {
            this.myView = new CodeableConceptDt();
        }
        return this.myView;
    }

    public CodeableConceptDt getViewElement() {
        if (this.myView == null) {
            this.myView = new CodeableConceptDt();
        }
        return this.myView;
    }

    public Media setView(CodeableConceptDt theValue) {
        this.myView = theValue;
        return this;
    }

    public StringDt getDeviceName() {
        if (this.myDeviceName == null) {
            this.myDeviceName = new StringDt();
        }
        return this.myDeviceName;
    }

    public StringDt getDeviceNameElement() {
        if (this.myDeviceName == null) {
            this.myDeviceName = new StringDt();
        }
        return this.myDeviceName;
    }

    public Media setDeviceName(StringDt theValue) {
        this.myDeviceName = theValue;
        return this;
    }

    public Media setDeviceName(String theString) {
        this.myDeviceName = new StringDt(theString);
        return this;
    }

    public IntegerDt getHeight() {
        if (this.myHeight == null) {
            this.myHeight = new IntegerDt();
        }
        return this.myHeight;
    }

    public IntegerDt getHeightElement() {
        if (this.myHeight == null) {
            this.myHeight = new IntegerDt();
        }
        return this.myHeight;
    }

    public Media setHeight(IntegerDt theValue) {
        this.myHeight = theValue;
        return this;
    }

    public Media setHeight(int theInteger) {
        this.myHeight = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getWidth() {
        if (this.myWidth == null) {
            this.myWidth = new IntegerDt();
        }
        return this.myWidth;
    }

    public IntegerDt getWidthElement() {
        if (this.myWidth == null) {
            this.myWidth = new IntegerDt();
        }
        return this.myWidth;
    }

    public Media setWidth(IntegerDt theValue) {
        this.myWidth = theValue;
        return this;
    }

    public Media setWidth(int theInteger) {
        this.myWidth = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getFrames() {
        if (this.myFrames == null) {
            this.myFrames = new IntegerDt();
        }
        return this.myFrames;
    }

    public IntegerDt getFramesElement() {
        if (this.myFrames == null) {
            this.myFrames = new IntegerDt();
        }
        return this.myFrames;
    }

    public Media setFrames(IntegerDt theValue) {
        this.myFrames = theValue;
        return this;
    }

    public Media setFrames(int theInteger) {
        this.myFrames = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getLength() {
        if (this.myLength == null) {
            this.myLength = new IntegerDt();
        }
        return this.myLength;
    }

    public IntegerDt getLengthElement() {
        if (this.myLength == null) {
            this.myLength = new IntegerDt();
        }
        return this.myLength;
    }

    public Media setLength(IntegerDt theValue) {
        this.myLength = theValue;
        return this;
    }

    public Media setLength(int theInteger) {
        this.myLength = new IntegerDt(theInteger);
        return this;
    }

    public AttachmentDt getContent() {
        if (this.myContent == null) {
            this.myContent = new AttachmentDt();
        }
        return this.myContent;
    }

    public AttachmentDt getContentElement() {
        if (this.myContent == null) {
            this.myContent = new AttachmentDt();
        }
        return this.myContent;
    }

    public Media setContent(AttachmentDt theValue) {
        this.myContent = theValue;
        return this;
    }

    public String getResourceName() {
        return "Media";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

