/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.AdverseReaction;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ImmunizationReasonCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.ImmunizationRouteCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Immunization", profile="http://hl7.org/fhir/profiles/Immunization", id="immunization")
public class Immunization
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="Immunization.date", description="Vaccination  Administration / Refusal Date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="dose-sequence", path="Immunization.vaccinationProtocol.doseSequence", description="", type="number")
    public static final String SP_DOSE_SEQUENCE = "dose-sequence";
    public static final NumberClientParam DOSE_SEQUENCE = new NumberClientParam("dose-sequence");
    @SearchParamDefinition(name="identifier", path="Immunization.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="Immunization.location", description="The service delivery location or facility in which the vaccine was / was to be administered", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Immunization.location");
    @SearchParamDefinition(name="lot-number", path="Immunization.lotNumber", description="Vaccine Lot Number", type="string")
    public static final String SP_LOT_NUMBER = "lot-number";
    public static final StringClientParam LOT_NUMBER = new StringClientParam("lot-number");
    @SearchParamDefinition(name="manufacturer", path="Immunization.manufacturer", description="Vaccine Manufacturer", type="reference")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Immunization.manufacturer");
    @SearchParamDefinition(name="performer", path="Immunization.performer", description="The practitioner who administered the vaccination", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Immunization.performer");
    @SearchParamDefinition(name="reaction", path="Immunization.reaction.detail", description="", type="reference")
    public static final String SP_REACTION = "reaction";
    public static final ReferenceClientParam REACTION = new ReferenceClientParam("reaction");
    public static final Include INCLUDE_REACTION_DETAIL = new Include("Immunization.reaction.detail");
    @SearchParamDefinition(name="reaction-date", path="Immunization.reaction.date", description="", type="date")
    public static final String SP_REACTION_DATE = "reaction-date";
    public static final DateClientParam REACTION_DATE = new DateClientParam("reaction-date");
    @SearchParamDefinition(name="reason", path="Immunization.explanation.reason", description="", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="refusal-reason", path="Immunization.explanation.refusalReason", description="Explanation of refusal / exemption", type="token")
    public static final String SP_REFUSAL_REASON = "refusal-reason";
    public static final TokenClientParam REFUSAL_REASON = new TokenClientParam("refusal-reason");
    @SearchParamDefinition(name="refused", path="Immunization.refusedIndicator", description="", type="token")
    public static final String SP_REFUSED = "refused";
    public static final TokenClientParam REFUSED = new TokenClientParam("refused");
    @SearchParamDefinition(name="requester", path="Immunization.requester", description="The practitioner who ordered the vaccination", type="reference")
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("Immunization.requester");
    @SearchParamDefinition(name="subject", path="Immunization.subject", description="The subject of the vaccination event / refusal", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Immunization.subject");
    @SearchParamDefinition(name="vaccine-type", path="Immunization.vaccineType", description="Vaccine Product Type Administered", type="token")
    public static final String SP_VACCINE_TYPE = "vaccine-type";
    public static final TokenClientParam VACCINE_TYPE = new TokenClientParam("vaccine-type");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this adverse reaction record.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Vaccination administration date", formalDefinition="Date vaccine administered or was to be administered")
    private DateTimeDt myDate;
    @Child(name="vaccineType", type={CodeableConceptDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Vaccine product administered", formalDefinition="Vaccine that was administered or was to be administered")
    private CodeableConceptDt myVaccineType;
    @Child(name="subject", order=3, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who was immunized?", formalDefinition="The patient to whom the vaccine was to be administered")
    private ResourceReferenceDt mySubject;
    @Child(name="refusedIndicator", type={BooleanDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Was immunization refused?", formalDefinition="Indicates if the vaccination was refused.")
    private BooleanDt myRefusedIndicator;
    @Child(name="reported", type={BooleanDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Is this a self-reported record?", formalDefinition="True if this administration was reported rather than directly administered.")
    private BooleanDt myReported;
    @Child(name="performer", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Who administered vaccine?", formalDefinition="Clinician who administered the vaccine")
    private ResourceReferenceDt myPerformer;
    @Child(name="requester", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Who ordered vaccination?", formalDefinition="Clinician who ordered the vaccination")
    private ResourceReferenceDt myRequester;
    @Child(name="manufacturer", order=8, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="Vaccine manufacturer", formalDefinition="Name of vaccine manufacturer")
    private ResourceReferenceDt myManufacturer;
    @Child(name="location", order=9, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="Where did vaccination occur?", formalDefinition="The service delivery location where the vaccine administration occurred.")
    private ResourceReferenceDt myLocation;
    @Child(name="lotNumber", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Vaccine lot number", formalDefinition="Lot number of the  vaccine product")
    private StringDt myLotNumber;
    @Child(name="expirationDate", type={DateDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Vaccine expiration date", formalDefinition="Date vaccine batch expires")
    private DateDt myExpirationDate;
    @Child(name="site", type={CodeableConceptDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Body site vaccine  was administered", formalDefinition="Body site where vaccine was administered")
    private CodeableConceptDt mySite;
    @Child(name="route", type={CodeableConceptDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="How vaccine entered body", formalDefinition="The path by which the vaccine product is taken into the body.")
    private BoundCodeableConceptDt<ImmunizationRouteCodesEnum> myRoute;
    @Child(name="doseQuantity", type={QuantityDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Amount of vaccine administered", formalDefinition="The quantity of vaccine product that was administered")
    private QuantityDt myDoseQuantity;
    @Child(name="explanation", order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Administration / refusal reasons", formalDefinition="Reasons why a vaccine was administered or refused")
    private Explanation myExplanation;
    @Child(name="reaction", order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Details of a reaction that follows immunization", formalDefinition="Categorical data indicating that an adverse event is associated in time to an immunization")
    private List<Reaction> myReaction;
    @Child(name="vaccinationProtocol", order=17, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="What protocol was followed", formalDefinition="Contains information about the protocol(s) under which the vaccine was administered")
    private List<VaccinationProtocol> myVaccinationProtocol;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDate, this.myVaccineType, this.mySubject, this.myRefusedIndicator, this.myReported, this.myPerformer, this.myRequester, this.myManufacturer, this.myLocation, this.myLotNumber, this.myExpirationDate, this.mySite, this.myRoute, this.myDoseQuantity, this.myExplanation, this.myReaction, this.myVaccinationProtocol});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDate, this.myVaccineType, this.mySubject, this.myRefusedIndicator, this.myReported, this.myPerformer, this.myRequester, this.myManufacturer, this.myLocation, this.myLotNumber, this.myExpirationDate, this.mySite, this.myRoute, this.myDoseQuantity, this.myExplanation, this.myReaction, this.myVaccinationProtocol});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Immunization setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Immunization addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Immunization addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Immunization setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Immunization setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Immunization setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public CodeableConceptDt getVaccineType() {
        if (this.myVaccineType == null) {
            this.myVaccineType = new CodeableConceptDt();
        }
        return this.myVaccineType;
    }

    public CodeableConceptDt getVaccineTypeElement() {
        if (this.myVaccineType == null) {
            this.myVaccineType = new CodeableConceptDt();
        }
        return this.myVaccineType;
    }

    public Immunization setVaccineType(CodeableConceptDt theValue) {
        this.myVaccineType = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Immunization setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public BooleanDt getRefusedIndicator() {
        if (this.myRefusedIndicator == null) {
            this.myRefusedIndicator = new BooleanDt();
        }
        return this.myRefusedIndicator;
    }

    public BooleanDt getRefusedIndicatorElement() {
        if (this.myRefusedIndicator == null) {
            this.myRefusedIndicator = new BooleanDt();
        }
        return this.myRefusedIndicator;
    }

    public Immunization setRefusedIndicator(BooleanDt theValue) {
        this.myRefusedIndicator = theValue;
        return this;
    }

    public Immunization setRefusedIndicator(boolean theBoolean) {
        this.myRefusedIndicator = new BooleanDt(theBoolean);
        return this;
    }

    public BooleanDt getReported() {
        if (this.myReported == null) {
            this.myReported = new BooleanDt();
        }
        return this.myReported;
    }

    public BooleanDt getReportedElement() {
        if (this.myReported == null) {
            this.myReported = new BooleanDt();
        }
        return this.myReported;
    }

    public Immunization setReported(BooleanDt theValue) {
        this.myReported = theValue;
        return this;
    }

    public Immunization setReported(boolean theBoolean) {
        this.myReported = new BooleanDt(theBoolean);
        return this;
    }

    public ResourceReferenceDt getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public ResourceReferenceDt getPerformerElement() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public Immunization setPerformer(ResourceReferenceDt theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public ResourceReferenceDt getRequester() {
        if (this.myRequester == null) {
            this.myRequester = new ResourceReferenceDt();
        }
        return this.myRequester;
    }

    public ResourceReferenceDt getRequesterElement() {
        if (this.myRequester == null) {
            this.myRequester = new ResourceReferenceDt();
        }
        return this.myRequester;
    }

    public Immunization setRequester(ResourceReferenceDt theValue) {
        this.myRequester = theValue;
        return this;
    }

    public ResourceReferenceDt getManufacturer() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new ResourceReferenceDt();
        }
        return this.myManufacturer;
    }

    public ResourceReferenceDt getManufacturerElement() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new ResourceReferenceDt();
        }
        return this.myManufacturer;
    }

    public Immunization setManufacturer(ResourceReferenceDt theValue) {
        this.myManufacturer = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public ResourceReferenceDt getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Immunization setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public StringDt getLotNumber() {
        if (this.myLotNumber == null) {
            this.myLotNumber = new StringDt();
        }
        return this.myLotNumber;
    }

    public StringDt getLotNumberElement() {
        if (this.myLotNumber == null) {
            this.myLotNumber = new StringDt();
        }
        return this.myLotNumber;
    }

    public Immunization setLotNumber(StringDt theValue) {
        this.myLotNumber = theValue;
        return this;
    }

    public Immunization setLotNumber(String theString) {
        this.myLotNumber = new StringDt(theString);
        return this;
    }

    public DateDt getExpirationDate() {
        if (this.myExpirationDate == null) {
            this.myExpirationDate = new DateDt();
        }
        return this.myExpirationDate;
    }

    public DateDt getExpirationDateElement() {
        if (this.myExpirationDate == null) {
            this.myExpirationDate = new DateDt();
        }
        return this.myExpirationDate;
    }

    public Immunization setExpirationDate(DateDt theValue) {
        this.myExpirationDate = theValue;
        return this;
    }

    public Immunization setExpirationDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myExpirationDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Immunization setExpirationDateWithDayPrecision(Date theDate) {
        this.myExpirationDate = new DateDt(theDate);
        return this;
    }

    public CodeableConceptDt getSite() {
        if (this.mySite == null) {
            this.mySite = new CodeableConceptDt();
        }
        return this.mySite;
    }

    public CodeableConceptDt getSiteElement() {
        if (this.mySite == null) {
            this.mySite = new CodeableConceptDt();
        }
        return this.mySite;
    }

    public Immunization setSite(CodeableConceptDt theValue) {
        this.mySite = theValue;
        return this;
    }

    public BoundCodeableConceptDt<ImmunizationRouteCodesEnum> getRoute() {
        if (this.myRoute == null) {
            this.myRoute = new BoundCodeableConceptDt<ImmunizationRouteCodesEnum>(ImmunizationRouteCodesEnum.VALUESET_BINDER);
        }
        return this.myRoute;
    }

    public BoundCodeableConceptDt<ImmunizationRouteCodesEnum> getRouteElement() {
        if (this.myRoute == null) {
            this.myRoute = new BoundCodeableConceptDt<ImmunizationRouteCodesEnum>(ImmunizationRouteCodesEnum.VALUESET_BINDER);
        }
        return this.myRoute;
    }

    public Immunization setRoute(BoundCodeableConceptDt<ImmunizationRouteCodesEnum> theValue) {
        this.myRoute = theValue;
        return this;
    }

    public Immunization setRoute(ImmunizationRouteCodesEnum theValue) {
        this.getRoute().setValueAsEnum(theValue);
        return this;
    }

    public QuantityDt getDoseQuantity() {
        if (this.myDoseQuantity == null) {
            this.myDoseQuantity = new QuantityDt();
        }
        return this.myDoseQuantity;
    }

    public QuantityDt getDoseQuantityElement() {
        if (this.myDoseQuantity == null) {
            this.myDoseQuantity = new QuantityDt();
        }
        return this.myDoseQuantity;
    }

    public Immunization setDoseQuantity(QuantityDt theValue) {
        this.myDoseQuantity = theValue;
        return this;
    }

    public Immunization setDoseQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
        this.myDoseQuantity = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public Immunization setDoseQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.myDoseQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public Immunization setDoseQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.myDoseQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public Immunization setDoseQuantity(double theValue) {
        this.myDoseQuantity = new QuantityDt(theValue);
        return this;
    }

    public Immunization setDoseQuantity(long theValue) {
        this.myDoseQuantity = new QuantityDt(theValue);
        return this;
    }

    public Immunization setDoseQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
        this.myDoseQuantity = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public Explanation getExplanation() {
        if (this.myExplanation == null) {
            this.myExplanation = new Explanation();
        }
        return this.myExplanation;
    }

    public Explanation getExplanationElement() {
        if (this.myExplanation == null) {
            this.myExplanation = new Explanation();
        }
        return this.myExplanation;
    }

    public Immunization setExplanation(Explanation theValue) {
        this.myExplanation = theValue;
        return this;
    }

    public List<Reaction> getReaction() {
        if (this.myReaction == null) {
            this.myReaction = new ArrayList<Reaction>();
        }
        return this.myReaction;
    }

    public List<Reaction> getReactionElement() {
        if (this.myReaction == null) {
            this.myReaction = new ArrayList<Reaction>();
        }
        return this.myReaction;
    }

    public Immunization setReaction(List<Reaction> theValue) {
        this.myReaction = theValue;
        return this;
    }

    public Reaction addReaction() {
        Reaction newType = new Reaction();
        this.getReaction().add(newType);
        return newType;
    }

    public Reaction getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            return this.addReaction();
        }
        return this.getReaction().get(0);
    }

    public List<VaccinationProtocol> getVaccinationProtocol() {
        if (this.myVaccinationProtocol == null) {
            this.myVaccinationProtocol = new ArrayList<VaccinationProtocol>();
        }
        return this.myVaccinationProtocol;
    }

    public List<VaccinationProtocol> getVaccinationProtocolElement() {
        if (this.myVaccinationProtocol == null) {
            this.myVaccinationProtocol = new ArrayList<VaccinationProtocol>();
        }
        return this.myVaccinationProtocol;
    }

    public Immunization setVaccinationProtocol(List<VaccinationProtocol> theValue) {
        this.myVaccinationProtocol = theValue;
        return this;
    }

    public VaccinationProtocol addVaccinationProtocol() {
        VaccinationProtocol newType = new VaccinationProtocol();
        this.getVaccinationProtocol().add(newType);
        return newType;
    }

    public VaccinationProtocol getVaccinationProtocolFirstRep() {
        if (this.getVaccinationProtocol().isEmpty()) {
            return this.addVaccinationProtocol();
        }
        return this.getVaccinationProtocol().get(0);
    }

    public String getResourceName() {
        return "Immunization";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class VaccinationProtocol
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="doseSequence", type={IntegerDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="What dose number within series?", formalDefinition="Nominal position in a series")
        private IntegerDt myDoseSequence;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Details of vaccine protocol", formalDefinition="Contains the description about the protocol under which the vaccine was administered")
        private StringDt myDescription;
        @Child(name="authority", order=2, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="Who is responsible for protocol", formalDefinition="Indicates the authority who published the protocol?  E.g. ACIP")
        private ResourceReferenceDt myAuthority;
        @Child(name="series", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of vaccine series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority")
        private StringDt mySeries;
        @Child(name="seriesDoses", type={IntegerDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Recommended number of doses for immunity", formalDefinition="The recommended number of doses to achieve immunity.")
        private IntegerDt mySeriesDoses;
        @Child(name="doseTarget", type={CodeableConceptDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Disease immunized against", formalDefinition="The targeted disease")
        private CodeableConceptDt myDoseTarget;
        @Child(name="doseStatus", type={CodeableConceptDt.class}, order=6, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Does dose count towards immunity?", formalDefinition="Indicates if the immunization event should \"count\" against  the protocol.")
        private CodeableConceptDt myDoseStatus;
        @Child(name="doseStatusReason", type={CodeableConceptDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Why does does count/not count?", formalDefinition="Provides an explanation as to why a immunization event should or should not count against the protocol.")
        private CodeableConceptDt myDoseStatusReason;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDoseSequence, this.myDescription, this.myAuthority, this.mySeries, this.mySeriesDoses, this.myDoseTarget, this.myDoseStatus, this.myDoseStatusReason});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDoseSequence, this.myDescription, this.myAuthority, this.mySeries, this.mySeriesDoses, this.myDoseTarget, this.myDoseStatus, this.myDoseStatusReason});
        }

        public IntegerDt getDoseSequence() {
            if (this.myDoseSequence == null) {
                this.myDoseSequence = new IntegerDt();
            }
            return this.myDoseSequence;
        }

        public IntegerDt getDoseSequenceElement() {
            if (this.myDoseSequence == null) {
                this.myDoseSequence = new IntegerDt();
            }
            return this.myDoseSequence;
        }

        public VaccinationProtocol setDoseSequence(IntegerDt theValue) {
            this.myDoseSequence = theValue;
            return this;
        }

        public VaccinationProtocol setDoseSequence(int theInteger) {
            this.myDoseSequence = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public VaccinationProtocol setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public VaccinationProtocol setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getAuthority() {
            if (this.myAuthority == null) {
                this.myAuthority = new ResourceReferenceDt();
            }
            return this.myAuthority;
        }

        public ResourceReferenceDt getAuthorityElement() {
            if (this.myAuthority == null) {
                this.myAuthority = new ResourceReferenceDt();
            }
            return this.myAuthority;
        }

        public VaccinationProtocol setAuthority(ResourceReferenceDt theValue) {
            this.myAuthority = theValue;
            return this;
        }

        public StringDt getSeries() {
            if (this.mySeries == null) {
                this.mySeries = new StringDt();
            }
            return this.mySeries;
        }

        public StringDt getSeriesElement() {
            if (this.mySeries == null) {
                this.mySeries = new StringDt();
            }
            return this.mySeries;
        }

        public VaccinationProtocol setSeries(StringDt theValue) {
            this.mySeries = theValue;
            return this;
        }

        public VaccinationProtocol setSeries(String theString) {
            this.mySeries = new StringDt(theString);
            return this;
        }

        public IntegerDt getSeriesDoses() {
            if (this.mySeriesDoses == null) {
                this.mySeriesDoses = new IntegerDt();
            }
            return this.mySeriesDoses;
        }

        public IntegerDt getSeriesDosesElement() {
            if (this.mySeriesDoses == null) {
                this.mySeriesDoses = new IntegerDt();
            }
            return this.mySeriesDoses;
        }

        public VaccinationProtocol setSeriesDoses(IntegerDt theValue) {
            this.mySeriesDoses = theValue;
            return this;
        }

        public VaccinationProtocol setSeriesDoses(int theInteger) {
            this.mySeriesDoses = new IntegerDt(theInteger);
            return this;
        }

        public CodeableConceptDt getDoseTarget() {
            if (this.myDoseTarget == null) {
                this.myDoseTarget = new CodeableConceptDt();
            }
            return this.myDoseTarget;
        }

        public CodeableConceptDt getDoseTargetElement() {
            if (this.myDoseTarget == null) {
                this.myDoseTarget = new CodeableConceptDt();
            }
            return this.myDoseTarget;
        }

        public VaccinationProtocol setDoseTarget(CodeableConceptDt theValue) {
            this.myDoseTarget = theValue;
            return this;
        }

        public CodeableConceptDt getDoseStatus() {
            if (this.myDoseStatus == null) {
                this.myDoseStatus = new CodeableConceptDt();
            }
            return this.myDoseStatus;
        }

        public CodeableConceptDt getDoseStatusElement() {
            if (this.myDoseStatus == null) {
                this.myDoseStatus = new CodeableConceptDt();
            }
            return this.myDoseStatus;
        }

        public VaccinationProtocol setDoseStatus(CodeableConceptDt theValue) {
            this.myDoseStatus = theValue;
            return this;
        }

        public CodeableConceptDt getDoseStatusReason() {
            if (this.myDoseStatusReason == null) {
                this.myDoseStatusReason = new CodeableConceptDt();
            }
            return this.myDoseStatusReason;
        }

        public CodeableConceptDt getDoseStatusReasonElement() {
            if (this.myDoseStatusReason == null) {
                this.myDoseStatusReason = new CodeableConceptDt();
            }
            return this.myDoseStatusReason;
        }

        public VaccinationProtocol setDoseStatusReason(CodeableConceptDt theValue) {
            this.myDoseStatusReason = theValue;
            return this;
        }
    }

    @Block
    public static class Reaction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="date", type={DateTimeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="When did reaction start?", formalDefinition="Date of reaction to the immunization")
        private DateTimeDt myDate;
        @Child(name="detail", order=1, min=0, max=1, summary=false, modifier=false, type={AdverseReaction.class, Observation.class})
        @Description(shortDefinition="Additional information on reaction", formalDefinition="Details of the reaction")
        private ResourceReferenceDt myDetail;
        @Child(name="reported", type={BooleanDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Was reaction self-reported?", formalDefinition="Self-reported indicator")
        private BooleanDt myReported;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDate, this.myDetail, this.myReported});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDate, this.myDetail, this.myReported});
        }

        public DateTimeDt getDate() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Reaction setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Reaction setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Reaction setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public ResourceReferenceDt getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ResourceReferenceDt();
            }
            return this.myDetail;
        }

        public ResourceReferenceDt getDetailElement() {
            if (this.myDetail == null) {
                this.myDetail = new ResourceReferenceDt();
            }
            return this.myDetail;
        }

        public Reaction setDetail(ResourceReferenceDt theValue) {
            this.myDetail = theValue;
            return this;
        }

        public BooleanDt getReported() {
            if (this.myReported == null) {
                this.myReported = new BooleanDt();
            }
            return this.myReported;
        }

        public BooleanDt getReportedElement() {
            if (this.myReported == null) {
                this.myReported = new BooleanDt();
            }
            return this.myReported;
        }

        public Reaction setReported(BooleanDt theValue) {
            this.myReported = theValue;
            return this;
        }

        public Reaction setReported(boolean theBoolean) {
            this.myReported = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class Explanation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="reason", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Why immunization occurred", formalDefinition="Reasons why a vaccine was administered")
        private List<BoundCodeableConceptDt<ImmunizationReasonCodesEnum>> myReason;
        @Child(name="refusalReason", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Why immunization did not occur", formalDefinition="Refusal or exemption reasons")
        private List<CodeableConceptDt> myRefusalReason;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myReason, this.myRefusalReason});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myReason, this.myRefusalReason});
        }

        public List<BoundCodeableConceptDt<ImmunizationReasonCodesEnum>> getReason() {
            if (this.myReason == null) {
                this.myReason = new ArrayList<BoundCodeableConceptDt<ImmunizationReasonCodesEnum>>();
            }
            return this.myReason;
        }

        public List<BoundCodeableConceptDt<ImmunizationReasonCodesEnum>> getReasonElement() {
            if (this.myReason == null) {
                this.myReason = new ArrayList<BoundCodeableConceptDt<ImmunizationReasonCodesEnum>>();
            }
            return this.myReason;
        }

        public Explanation setReason(List<BoundCodeableConceptDt<ImmunizationReasonCodesEnum>> theValue) {
            this.myReason = theValue;
            return this;
        }

        public BoundCodeableConceptDt<ImmunizationReasonCodesEnum> addReason(ImmunizationReasonCodesEnum theValue) {
            BoundCodeableConceptDt<ImmunizationReasonCodesEnum> retVal = new BoundCodeableConceptDt<ImmunizationReasonCodesEnum>(ImmunizationReasonCodesEnum.VALUESET_BINDER, theValue);
            this.getReason().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<ImmunizationReasonCodesEnum> getReasonFirstRep() {
            if (this.getReason().size() == 0) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        public BoundCodeableConceptDt<ImmunizationReasonCodesEnum> addReason() {
            BoundCodeableConceptDt<ImmunizationReasonCodesEnum> retVal = new BoundCodeableConceptDt<ImmunizationReasonCodesEnum>(ImmunizationReasonCodesEnum.VALUESET_BINDER);
            this.getReason().add(retVal);
            return retVal;
        }

        public Explanation setReason(ImmunizationReasonCodesEnum theValue) {
            this.getReason().clear();
            this.addReason(theValue);
            return this;
        }

        public List<CodeableConceptDt> getRefusalReason() {
            if (this.myRefusalReason == null) {
                this.myRefusalReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myRefusalReason;
        }

        public List<CodeableConceptDt> getRefusalReasonElement() {
            if (this.myRefusalReason == null) {
                this.myRefusalReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myRefusalReason;
        }

        public Explanation setRefusalReason(List<CodeableConceptDt> theValue) {
            this.myRefusalReason = theValue;
            return this;
        }

        public CodeableConceptDt addRefusalReason() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRefusalReason().add(newType);
            return newType;
        }

        public CodeableConceptDt getRefusalReasonFirstRep() {
            if (this.getRefusalReason().isEmpty()) {
                return this.addRefusalReason();
            }
            return this.getRefusalReason().get(0);
        }
    }
}

