/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.DocumentReferenceStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.DocumentRelationshipTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DocumentReference", profile="http://hl7.org/fhir/profiles/DocumentReference", id="documentreference")
public class DocumentReference
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="DocumentReference.masterIdentifier | DocumentReference.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="DocumentReference.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentReference.subject");
    @SearchParamDefinition(name="type", path="DocumentReference.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="class", path="DocumentReference.class", description="", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="author", path="DocumentReference.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentReference.author");
    @SearchParamDefinition(name="custodian", path="DocumentReference.custodian", description="", type="reference")
    public static final String SP_CUSTODIAN = "custodian";
    public static final ReferenceClientParam CUSTODIAN = new ReferenceClientParam("custodian");
    public static final Include INCLUDE_CUSTODIAN = new Include("DocumentReference.custodian");
    @SearchParamDefinition(name="authenticator", path="DocumentReference.authenticator", description="", type="reference")
    public static final String SP_AUTHENTICATOR = "authenticator";
    public static final ReferenceClientParam AUTHENTICATOR = new ReferenceClientParam("authenticator");
    public static final Include INCLUDE_AUTHENTICATOR = new Include("DocumentReference.authenticator");
    @SearchParamDefinition(name="created", path="DocumentReference.created", description="", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="indexed", path="DocumentReference.indexed", description="", type="date")
    public static final String SP_INDEXED = "indexed";
    public static final DateClientParam INDEXED = new DateClientParam("indexed");
    @SearchParamDefinition(name="status", path="DocumentReference.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="relatesto", path="DocumentReference.relatesTo.target", description="", type="reference")
    public static final String SP_RELATESTO = "relatesto";
    public static final ReferenceClientParam RELATESTO = new ReferenceClientParam("relatesto");
    public static final Include INCLUDE_RELATESTO_TARGET = new Include("DocumentReference.relatesTo.target");
    @SearchParamDefinition(name="relation", path="DocumentReference.relatesTo.code", description="", type="token")
    public static final String SP_RELATION = "relation";
    public static final TokenClientParam RELATION = new TokenClientParam("relation");
    @SearchParamDefinition(name="description", path="DocumentReference.description", description="", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="confidentiality", path="DocumentReference.confidentiality", description="", type="token")
    public static final String SP_CONFIDENTIALITY = "confidentiality";
    public static final TokenClientParam CONFIDENTIALITY = new TokenClientParam("confidentiality");
    @SearchParamDefinition(name="language", path="DocumentReference.primaryLanguage", description="", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="format", path="DocumentReference.format", description="", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="size", path="DocumentReference.size", description="", type="number")
    public static final String SP_SIZE = "size";
    public static final NumberClientParam SIZE = new NumberClientParam("size");
    @SearchParamDefinition(name="location", path="DocumentReference.location", description="", type="string")
    public static final String SP_LOCATION = "location";
    public static final StringClientParam LOCATION = new StringClientParam("location");
    @SearchParamDefinition(name="event", path="DocumentReference.context.event", description="", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="period", path="DocumentReference.context.period", description="", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="facility", path="DocumentReference.context.facilityType", description="", type="token")
    public static final String SP_FACILITY = "facility";
    public static final TokenClientParam FACILITY = new TokenClientParam("facility");
    @SearchParamDefinition(name="relatesto-relation", path="relatesto & relation", description="Combination of relation and relatesTo", type="composite", compositeOf={"relatesto", "relation"})
    public static final String SP_RELATESTO_RELATION = "relatesto-relation";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATESTO_RELATION = new CompositeClientParam("relatesto-relation");
    @Child(name="masterIdentifier", type={IdentifierDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Master Version Specific Identifier", formalDefinition="Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document")
    private IdentifierDt myMasterIdentifier;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Other identifiers for the document", formalDefinition="Other identifiers associated with the document, including version independent, source record and workflow related identifiers")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=2, min=1, max=1, summary=false, modifier=false, type={Patient.class, Practitioner.class, Group.class, Device.class})
    @Description(shortDefinition="Who|what is the subject of the document", formalDefinition="Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (I.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure)")
    private ResourceReferenceDt mySubject;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="What kind of document this is (LOINC if possible)", formalDefinition="Specifies the particular kind of document (e.g. Patient Summary, Discharge Summary, Prescription, etc.)")
    private CodeableConceptDt myType;
    @Child(name="class", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Categorization of Document", formalDefinition="A categorization for the type of the document. This may be implied by or derived from the code specified in the Document Type")
    private CodeableConceptDt myClassElement;
    @Child(name="author", order=5, min=1, max=-1, summary=false, modifier=false, type={Practitioner.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who and/or what authored the document", formalDefinition="Identifies who is responsible for adding the information to the document")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="custodian", order=6, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="Org which maintains the document", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the document")
    private ResourceReferenceDt myCustodian;
    @Child(name="policyManager", type={UriDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Manages access policies for the document", formalDefinition="A reference to a domain or server that manages policies under which the document is accessed and/or made available")
    private UriDt myPolicyManager;
    @Child(name="authenticator", order=8, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="Who/What authenticated the document", formalDefinition="Which person or organization authenticates that this document is valid")
    private ResourceReferenceDt myAuthenticator;
    @Child(name="created", type={DateTimeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Document creation time", formalDefinition="When the document was created")
    private DateTimeDt myCreated;
    @Child(name="indexed", type={InstantDt.class}, order=10, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When this document reference created", formalDefinition="When the document reference was created")
    private InstantDt myIndexed;
    @Child(name="status", type={CodeDt.class}, order=11, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="current | superceded | entered in error", formalDefinition="The status of this document reference")
    private BoundCodeDt<DocumentReferenceStatusEnum> myStatus;
    @Child(name="docStatus", type={CodeableConceptDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="preliminary | final | appended | amended | entered in error", formalDefinition="The status of the underlying document")
    private CodeableConceptDt myDocStatus;
    @Child(name="relatesTo", order=13, min=0, max=-1, summary=false, modifier=true)
    @Description(shortDefinition="Relationships to other documents", formalDefinition="Relationships that this document has with other document references that already exist")
    private List<RelatesTo> myRelatesTo;
    @Child(name="description", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Human-readable description (title)", formalDefinition="Human-readable description of the source document. This is sometimes known as the \"title\"")
    private StringDt myDescription;
    @Child(name="confidentiality", type={CodeableConceptDt.class}, order=15, min=0, max=-1, summary=false, modifier=true)
    @Description(shortDefinition="Sensitivity of source document", formalDefinition="A code specifying the level of confidentiality of the XDS Document")
    private List<CodeableConceptDt> myConfidentiality;
    @Child(name="primaryLanguage", type={CodeDt.class}, order=16, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The marked primary language for the document", formalDefinition="The primary language in which the source document is written")
    private CodeDt myPrimaryLanguage;
    @Child(name="mimeType", type={CodeDt.class}, order=17, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Mime type, + maybe character encoding", formalDefinition="The mime type of the source document")
    private CodeDt myMimeType;
    @Child(name="format", type={UriDt.class}, order=18, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Format/content rules for the document", formalDefinition="An identifier that identifies that the format and content of the document conforms to additional rules beyond the base format indicated in the mimeType")
    private List<UriDt> myFormat;
    @Child(name="size", type={IntegerDt.class}, order=19, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Size of the document in bytes", formalDefinition="The size of the source document this reference refers to in bytes")
    private IntegerDt mySize;
    @Child(name="hash", type={StringDt.class}, order=20, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="HexBinary representation of SHA1", formalDefinition="A hash of the source document to ensure that changes have not occurred")
    private StringDt myHash;
    @Child(name="location", type={UriDt.class}, order=21, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Where to access the document", formalDefinition="A url at which the document can be accessed")
    private UriDt myLocation;
    @Child(name="service", order=22, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="If access is not fully described by location", formalDefinition="A description of a service call that can be used to retrieve the document")
    private Service myService;
    @Child(name="context", order=23, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Clinical context of document", formalDefinition="The clinical context in which the document was prepared")
    private Context myContext;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myType, this.myClassElement, this.myAuthor, this.myCustodian, this.myPolicyManager, this.myAuthenticator, this.myCreated, this.myIndexed, this.myStatus, this.myDocStatus, this.myRelatesTo, this.myDescription, this.myConfidentiality, this.myPrimaryLanguage, this.myMimeType, this.myFormat, this.mySize, this.myHash, this.myLocation, this.myService, this.myContext});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myType, this.myClassElement, this.myAuthor, this.myCustodian, this.myPolicyManager, this.myAuthenticator, this.myCreated, this.myIndexed, this.myStatus, this.myDocStatus, this.myRelatesTo, this.myDescription, this.myConfidentiality, this.myPrimaryLanguage, this.myMimeType, this.myFormat, this.mySize, this.myHash, this.myLocation, this.myService, this.myContext});
    }

    public IdentifierDt getMasterIdentifier() {
        if (this.myMasterIdentifier == null) {
            this.myMasterIdentifier = new IdentifierDt();
        }
        return this.myMasterIdentifier;
    }

    public IdentifierDt getMasterIdentifierElement() {
        if (this.myMasterIdentifier == null) {
            this.myMasterIdentifier = new IdentifierDt();
        }
        return this.myMasterIdentifier;
    }

    public DocumentReference setMasterIdentifier(IdentifierDt theValue) {
        this.myMasterIdentifier = theValue;
        return this;
    }

    public DocumentReference setMasterIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myMasterIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public DocumentReference setMasterIdentifier(String theSystem, String theValue) {
        this.myMasterIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DocumentReference setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DocumentReference addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public DocumentReference addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DocumentReference setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public DocumentReference setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt getClassElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new CodeableConceptDt();
        }
        return this.myClassElement;
    }

    public CodeableConceptDt getClassElementElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new CodeableConceptDt();
        }
        return this.myClassElement;
    }

    public DocumentReference setClassElement(CodeableConceptDt theValue) {
        this.myClassElement = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public List<ResourceReferenceDt> getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public DocumentReference setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public ResourceReferenceDt getCustodian() {
        if (this.myCustodian == null) {
            this.myCustodian = new ResourceReferenceDt();
        }
        return this.myCustodian;
    }

    public ResourceReferenceDt getCustodianElement() {
        if (this.myCustodian == null) {
            this.myCustodian = new ResourceReferenceDt();
        }
        return this.myCustodian;
    }

    public DocumentReference setCustodian(ResourceReferenceDt theValue) {
        this.myCustodian = theValue;
        return this;
    }

    public UriDt getPolicyManager() {
        if (this.myPolicyManager == null) {
            this.myPolicyManager = new UriDt();
        }
        return this.myPolicyManager;
    }

    public UriDt getPolicyManagerElement() {
        if (this.myPolicyManager == null) {
            this.myPolicyManager = new UriDt();
        }
        return this.myPolicyManager;
    }

    public DocumentReference setPolicyManager(UriDt theValue) {
        this.myPolicyManager = theValue;
        return this;
    }

    public DocumentReference setPolicyManager(String theUri) {
        this.myPolicyManager = new UriDt(theUri);
        return this;
    }

    public ResourceReferenceDt getAuthenticator() {
        if (this.myAuthenticator == null) {
            this.myAuthenticator = new ResourceReferenceDt();
        }
        return this.myAuthenticator;
    }

    public ResourceReferenceDt getAuthenticatorElement() {
        if (this.myAuthenticator == null) {
            this.myAuthenticator = new ResourceReferenceDt();
        }
        return this.myAuthenticator;
    }

    public DocumentReference setAuthenticator(ResourceReferenceDt theValue) {
        this.myAuthenticator = theValue;
        return this;
    }

    public DateTimeDt getCreated() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public DocumentReference setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public DocumentReference setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DocumentReference setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public InstantDt getIndexed() {
        if (this.myIndexed == null) {
            this.myIndexed = new InstantDt();
        }
        return this.myIndexed;
    }

    public InstantDt getIndexedElement() {
        if (this.myIndexed == null) {
            this.myIndexed = new InstantDt();
        }
        return this.myIndexed;
    }

    public DocumentReference setIndexed(InstantDt theValue) {
        this.myIndexed = theValue;
        return this;
    }

    public DocumentReference setIndexedWithMillisPrecision(Date theDate) {
        this.myIndexed = new InstantDt(theDate);
        return this;
    }

    public DocumentReference setIndexed(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIndexed = new InstantDt(theDate, thePrecision);
        return this;
    }

    public BoundCodeDt<DocumentReferenceStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<DocumentReferenceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public DocumentReference setStatus(BoundCodeDt<DocumentReferenceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DocumentReference setStatus(DocumentReferenceStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public CodeableConceptDt getDocStatus() {
        if (this.myDocStatus == null) {
            this.myDocStatus = new CodeableConceptDt();
        }
        return this.myDocStatus;
    }

    public CodeableConceptDt getDocStatusElement() {
        if (this.myDocStatus == null) {
            this.myDocStatus = new CodeableConceptDt();
        }
        return this.myDocStatus;
    }

    public DocumentReference setDocStatus(CodeableConceptDt theValue) {
        this.myDocStatus = theValue;
        return this;
    }

    public List<RelatesTo> getRelatesTo() {
        if (this.myRelatesTo == null) {
            this.myRelatesTo = new ArrayList<RelatesTo>();
        }
        return this.myRelatesTo;
    }

    public List<RelatesTo> getRelatesToElement() {
        if (this.myRelatesTo == null) {
            this.myRelatesTo = new ArrayList<RelatesTo>();
        }
        return this.myRelatesTo;
    }

    public DocumentReference setRelatesTo(List<RelatesTo> theValue) {
        this.myRelatesTo = theValue;
        return this;
    }

    public RelatesTo addRelatesTo() {
        RelatesTo newType = new RelatesTo();
        this.getRelatesTo().add(newType);
        return newType;
    }

    public RelatesTo getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            return this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public DocumentReference setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public DocumentReference setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getConfidentiality() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new ArrayList<CodeableConceptDt>();
        }
        return this.myConfidentiality;
    }

    public List<CodeableConceptDt> getConfidentialityElement() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new ArrayList<CodeableConceptDt>();
        }
        return this.myConfidentiality;
    }

    public DocumentReference setConfidentiality(List<CodeableConceptDt> theValue) {
        this.myConfidentiality = theValue;
        return this;
    }

    public CodeableConceptDt addConfidentiality() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getConfidentiality().add(newType);
        return newType;
    }

    public CodeableConceptDt getConfidentialityFirstRep() {
        if (this.getConfidentiality().isEmpty()) {
            return this.addConfidentiality();
        }
        return this.getConfidentiality().get(0);
    }

    public CodeDt getPrimaryLanguage() {
        if (this.myPrimaryLanguage == null) {
            this.myPrimaryLanguage = new CodeDt();
        }
        return this.myPrimaryLanguage;
    }

    public CodeDt getPrimaryLanguageElement() {
        if (this.myPrimaryLanguage == null) {
            this.myPrimaryLanguage = new CodeDt();
        }
        return this.myPrimaryLanguage;
    }

    public DocumentReference setPrimaryLanguage(CodeDt theValue) {
        this.myPrimaryLanguage = theValue;
        return this;
    }

    public DocumentReference setPrimaryLanguage(String theCode) {
        this.myPrimaryLanguage = new CodeDt(theCode);
        return this;
    }

    public CodeDt getMimeType() {
        if (this.myMimeType == null) {
            this.myMimeType = new CodeDt();
        }
        return this.myMimeType;
    }

    public CodeDt getMimeTypeElement() {
        if (this.myMimeType == null) {
            this.myMimeType = new CodeDt();
        }
        return this.myMimeType;
    }

    public DocumentReference setMimeType(CodeDt theValue) {
        this.myMimeType = theValue;
        return this;
    }

    public DocumentReference setMimeType(String theCode) {
        this.myMimeType = new CodeDt(theCode);
        return this;
    }

    public List<UriDt> getFormat() {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<UriDt>();
        }
        return this.myFormat;
    }

    public List<UriDt> getFormatElement() {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<UriDt>();
        }
        return this.myFormat;
    }

    public DocumentReference setFormat(List<UriDt> theValue) {
        this.myFormat = theValue;
        return this;
    }

    public UriDt addFormat() {
        UriDt newType = new UriDt();
        this.getFormat().add(newType);
        return newType;
    }

    public UriDt getFormatFirstRep() {
        if (this.getFormat().isEmpty()) {
            return this.addFormat();
        }
        return this.getFormat().get(0);
    }

    public DocumentReference addFormat(String theUri) {
        if (this.myFormat == null) {
            this.myFormat = new ArrayList<UriDt>();
        }
        this.myFormat.add(new UriDt(theUri));
        return this;
    }

    public IntegerDt getSize() {
        if (this.mySize == null) {
            this.mySize = new IntegerDt();
        }
        return this.mySize;
    }

    public IntegerDt getSizeElement() {
        if (this.mySize == null) {
            this.mySize = new IntegerDt();
        }
        return this.mySize;
    }

    public DocumentReference setSize(IntegerDt theValue) {
        this.mySize = theValue;
        return this;
    }

    public DocumentReference setSize(int theInteger) {
        this.mySize = new IntegerDt(theInteger);
        return this;
    }

    public StringDt getHash() {
        if (this.myHash == null) {
            this.myHash = new StringDt();
        }
        return this.myHash;
    }

    public StringDt getHashElement() {
        if (this.myHash == null) {
            this.myHash = new StringDt();
        }
        return this.myHash;
    }

    public DocumentReference setHash(StringDt theValue) {
        this.myHash = theValue;
        return this;
    }

    public DocumentReference setHash(String theString) {
        this.myHash = new StringDt(theString);
        return this;
    }

    public UriDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new UriDt();
        }
        return this.myLocation;
    }

    public UriDt getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new UriDt();
        }
        return this.myLocation;
    }

    public DocumentReference setLocation(UriDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public DocumentReference setLocation(String theUri) {
        this.myLocation = new UriDt(theUri);
        return this;
    }

    public Service getService() {
        if (this.myService == null) {
            this.myService = new Service();
        }
        return this.myService;
    }

    public Service getServiceElement() {
        if (this.myService == null) {
            this.myService = new Service();
        }
        return this.myService;
    }

    public DocumentReference setService(Service theValue) {
        this.myService = theValue;
        return this;
    }

    public Context getContext() {
        if (this.myContext == null) {
            this.myContext = new Context();
        }
        return this.myContext;
    }

    public Context getContextElement() {
        if (this.myContext == null) {
            this.myContext = new Context();
        }
        return this.myContext;
    }

    public DocumentReference setContext(Context theValue) {
        this.myContext = theValue;
        return this;
    }

    public String getResourceName() {
        return "DocumentReference";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Context
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="event", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Main Clinical Acts Documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act")
        private List<CodeableConceptDt> myEvent;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Time of service that is being documented", formalDefinition="The time period over which the service that is described by the document was provided")
        private PeriodDt myPeriod;
        @Child(name="facilityType", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Kind of facility where patient was seen", formalDefinition="The kind of facility where the patient was seen")
        private CodeableConceptDt myFacilityType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEvent, this.myPeriod, this.myFacilityType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEvent, this.myPeriod, this.myFacilityType});
        }

        public List<CodeableConceptDt> getEvent() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<CodeableConceptDt>();
            }
            return this.myEvent;
        }

        public List<CodeableConceptDt> getEventElement() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<CodeableConceptDt>();
            }
            return this.myEvent;
        }

        public Context setEvent(List<CodeableConceptDt> theValue) {
            this.myEvent = theValue;
            return this;
        }

        public CodeableConceptDt addEvent() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getEvent().add(newType);
            return newType;
        }

        public CodeableConceptDt getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                return this.addEvent();
            }
            return this.getEvent().get(0);
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Context setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public CodeableConceptDt getFacilityType() {
            if (this.myFacilityType == null) {
                this.myFacilityType = new CodeableConceptDt();
            }
            return this.myFacilityType;
        }

        public CodeableConceptDt getFacilityTypeElement() {
            if (this.myFacilityType == null) {
                this.myFacilityType = new CodeableConceptDt();
            }
            return this.myFacilityType;
        }

        public Context setFacilityType(CodeableConceptDt theValue) {
            this.myFacilityType = theValue;
            return this;
        }
    }

    @Block
    public static class ServiceParameter
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Parameter name in service call", formalDefinition="The name of a parameter")
        private StringDt myName;
        @Child(name="value", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Parameter value for the name", formalDefinition="The value of the named parameter")
        private StringDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myValue});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public ServiceParameter setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public ServiceParameter setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getValue() {
            if (this.myValue == null) {
                this.myValue = new StringDt();
            }
            return this.myValue;
        }

        public StringDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new StringDt();
            }
            return this.myValue;
        }

        public ServiceParameter setValue(StringDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ServiceParameter setValue(String theString) {
            this.myValue = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Service
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of service (i.e. XDS.b)", formalDefinition="The type of the service that can be used to access the documents")
        private CodeableConceptDt myType;
        @Child(name="address", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Where service is located (usually a URL)", formalDefinition="Where the service end-point is located")
        private StringDt myAddress;
        @Child(name="parameter", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Service call parameters", formalDefinition="A list of named parameters that is used in the service call")
        private List<ServiceParameter> myParameter;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myAddress, this.myParameter});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myAddress, this.myParameter});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Service setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public StringDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new StringDt();
            }
            return this.myAddress;
        }

        public StringDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new StringDt();
            }
            return this.myAddress;
        }

        public Service setAddress(StringDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public Service setAddress(String theString) {
            this.myAddress = new StringDt(theString);
            return this;
        }

        public List<ServiceParameter> getParameter() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<ServiceParameter>();
            }
            return this.myParameter;
        }

        public List<ServiceParameter> getParameterElement() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<ServiceParameter>();
            }
            return this.myParameter;
        }

        public Service setParameter(List<ServiceParameter> theValue) {
            this.myParameter = theValue;
            return this;
        }

        public ServiceParameter addParameter() {
            ServiceParameter newType = new ServiceParameter();
            this.getParameter().add(newType);
            return newType;
        }

        public ServiceParameter getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                return this.addParameter();
            }
            return this.getParameter().get(0);
        }
    }

    @Block
    public static class RelatesTo
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="replaces | transforms | signs | appends", formalDefinition="The type of relationship that this document has with anther document")
        private BoundCodeDt<DocumentRelationshipTypeEnum> myCode;
        @Child(name="target", order=1, min=1, max=1, summary=false, modifier=false, type={DocumentReference.class})
        @Description(shortDefinition="Target of the relationship", formalDefinition="The target document of this relationship")
        private ResourceReferenceDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myTarget});
        }

        public BoundCodeDt<DocumentRelationshipTypeEnum> getCode() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(DocumentRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public BoundCodeDt<DocumentRelationshipTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(DocumentRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public RelatesTo setCode(BoundCodeDt<DocumentRelationshipTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RelatesTo setCode(DocumentRelationshipTypeEnum theValue) {
            this.getCode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public ResourceReferenceDt getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public RelatesTo setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }
    }
}

