/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/profiles/Device", id="device")
public class Device
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final StringClientParam MANUFACTURER = new StringClientParam("manufacturer");
    @SearchParamDefinition(name="model", path="Device.model", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    public static final StringClientParam MODEL = new StringClientParam("model");
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_OWNER = new Include("Device.owner");
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Device.location");
    @SearchParamDefinition(name="patient", path="Device.patient", description="Patient information, if the resource is affixed to a person", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Device.patient");
    @SearchParamDefinition(name="udi", path="Device.udi", description="", type="string")
    public static final String SP_UDI = "udi";
    public static final StringClientParam UDI = new StringClientParam("udi");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Instance id from manufacturer, owner and others", formalDefinition="Identifiers assigned to this device by various organizations. The most likely organizations to assign identifiers are the manufacturer and the owner, though regulatory agencies may also assign an identifier. The identifiers identify the particular device, not the kind of device")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="What kind of device this is", formalDefinition="A kind of this device")
    private CodeableConceptDt myType;
    @Child(name="manufacturer", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer")
    private StringDt myManufacturer;
    @Child(name="model", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Model id assigned by the manufacturer", formalDefinition="The \"model\" - an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type")
    private StringDt myModel;
    @Child(name="version", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Version number (i.e. software)", formalDefinition="The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware")
    private StringDt myVersion;
    @Child(name="expiry", type={DateDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date of expiry of this device (if applicable)", formalDefinition="Date of expiry of this device (if applicable)")
    private DateDt myExpiry;
    @Child(name="udi", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="FDA Mandated Unique Device Identifier", formalDefinition="FDA Mandated Unique Device Identifier. Use the human readable information (the content that the user sees, which is sometimes different to the exact syntax represented in the barcode)  - see http://www.fda.gov/MedicalDevices/DeviceRegulationandGuidance/UniqueDeviceIdentification/default.htm")
    private StringDt myUdi;
    @Child(name="lotNumber", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Lot number of manufacture", formalDefinition="Lot number assigned by the manufacturer")
    private StringDt myLotNumber;
    @Child(name="owner", order=8, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device")
    private ResourceReferenceDt myOwner;
    @Child(name="location", order=9, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="Where the resource is found", formalDefinition="The resource may be found in a literal location (i.e. GPS coordinates), a logical place (i.e. \"in/with the patient\"), or a coded location")
    private ResourceReferenceDt myLocation;
    @Child(name="patient", order=10, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="If the resource is affixed to a person", formalDefinition="Patient information, if the resource is affixed to a person")
    private ResourceReferenceDt myPatient;
    @Child(name="contact", type={ContactDt.class}, order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device")
    private List<ContactDt> myContact;
    @Child(name="url", type={UriDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly")
    private UriDt myUrl;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myManufacturer, this.myModel, this.myVersion, this.myExpiry, this.myUdi, this.myLotNumber, this.myOwner, this.myLocation, this.myPatient, this.myContact, this.myUrl});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myManufacturer, this.myModel, this.myVersion, this.myExpiry, this.myUdi, this.myLotNumber, this.myOwner, this.myLocation, this.myPatient, this.myContact, this.myUrl});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Device setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Device addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Device addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Device setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public StringDt getManufacturer() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new StringDt();
        }
        return this.myManufacturer;
    }

    public StringDt getManufacturerElement() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new StringDt();
        }
        return this.myManufacturer;
    }

    public Device setManufacturer(StringDt theValue) {
        this.myManufacturer = theValue;
        return this;
    }

    public Device setManufacturer(String theString) {
        this.myManufacturer = new StringDt(theString);
        return this;
    }

    public StringDt getModel() {
        if (this.myModel == null) {
            this.myModel = new StringDt();
        }
        return this.myModel;
    }

    public StringDt getModelElement() {
        if (this.myModel == null) {
            this.myModel = new StringDt();
        }
        return this.myModel;
    }

    public Device setModel(StringDt theValue) {
        this.myModel = theValue;
        return this;
    }

    public Device setModel(String theString) {
        this.myModel = new StringDt(theString);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public Device setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public Device setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public DateDt getExpiry() {
        if (this.myExpiry == null) {
            this.myExpiry = new DateDt();
        }
        return this.myExpiry;
    }

    public DateDt getExpiryElement() {
        if (this.myExpiry == null) {
            this.myExpiry = new DateDt();
        }
        return this.myExpiry;
    }

    public Device setExpiry(DateDt theValue) {
        this.myExpiry = theValue;
        return this;
    }

    public Device setExpiry(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myExpiry = new DateDt(theDate, thePrecision);
        return this;
    }

    public Device setExpiryWithDayPrecision(Date theDate) {
        this.myExpiry = new DateDt(theDate);
        return this;
    }

    public StringDt getUdi() {
        if (this.myUdi == null) {
            this.myUdi = new StringDt();
        }
        return this.myUdi;
    }

    public StringDt getUdiElement() {
        if (this.myUdi == null) {
            this.myUdi = new StringDt();
        }
        return this.myUdi;
    }

    public Device setUdi(StringDt theValue) {
        this.myUdi = theValue;
        return this;
    }

    public Device setUdi(String theString) {
        this.myUdi = new StringDt(theString);
        return this;
    }

    public StringDt getLotNumber() {
        if (this.myLotNumber == null) {
            this.myLotNumber = new StringDt();
        }
        return this.myLotNumber;
    }

    public StringDt getLotNumberElement() {
        if (this.myLotNumber == null) {
            this.myLotNumber = new StringDt();
        }
        return this.myLotNumber;
    }

    public Device setLotNumber(StringDt theValue) {
        this.myLotNumber = theValue;
        return this;
    }

    public Device setLotNumber(String theString) {
        this.myLotNumber = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getOwner() {
        if (this.myOwner == null) {
            this.myOwner = new ResourceReferenceDt();
        }
        return this.myOwner;
    }

    public ResourceReferenceDt getOwnerElement() {
        if (this.myOwner == null) {
            this.myOwner = new ResourceReferenceDt();
        }
        return this.myOwner;
    }

    public Device setOwner(ResourceReferenceDt theValue) {
        this.myOwner = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public ResourceReferenceDt getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Device setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Device setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public List<ContactDt> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        return this.myContact;
    }

    public List<ContactDt> getContactElement() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        return this.myContact;
    }

    public Device setContact(List<ContactDt> theValue) {
        this.myContact = theValue;
        return this;
    }

    public ContactDt addContact() {
        ContactDt newType = new ContactDt();
        this.getContact().add(newType);
        return newType;
    }

    public ContactDt getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public Device addContact(ContactUseEnum theContactUse, String theValue) {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        this.myContact.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Device addContact(String theValue) {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        this.myContact.add(new ContactDt(theValue));
        return this;
    }

    public UriDt getUrl() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public Device setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public Device setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public String getResourceName() {
        return "Device";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

