/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.ValueSet;
import ca.uhn.fhir.model.dstu.valueset.ConceptMapEquivalenceEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ValueSetStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ConceptMap", profile="http://hl7.org/fhir/profiles/ConceptMap", id="conceptmap")
public class ConceptMap
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ConceptMap.identifier", description="The identifier of the concept map", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="ConceptMap.version", description="The version identifier of the concept map", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="ConceptMap.name", description="Name of the concept map", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ConceptMap.publisher", description="Name of the publisher of the concept map", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="ConceptMap.description", description="Text search in the description of the concept map", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="ConceptMap.status", description="Status of the concept map", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="ConceptMap.date", description="The concept map publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="source", path="ConceptMap.source", description="The system for any concepts mapped by this concept map", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("ConceptMap.source");
    @SearchParamDefinition(name="target", path="ConceptMap.target", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("ConceptMap.target");
    @SearchParamDefinition(name="system", path="ConceptMap.concept.map.system", description="The system for any destination concepts mapped by this map", type="token")
    public static final String SP_SYSTEM = "system";
    public static final TokenClientParam SYSTEM = new TokenClientParam("system");
    @SearchParamDefinition(name="dependson", path="ConceptMap.concept.dependsOn.concept", description="", type="token")
    public static final String SP_DEPENDSON = "dependson";
    public static final TokenClientParam DEPENDSON = new TokenClientParam("dependson");
    @SearchParamDefinition(name="product", path="ConceptMap.concept.map.product.concept", description="", type="token")
    public static final String SP_PRODUCT = "product";
    public static final TokenClientParam PRODUCT = new TokenClientParam("product");
    @Child(name="identifier", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Logical id to reference this concept map", formalDefinition="The identifier that is used to identify this concept map when it is referenced in a specification, model, design or an instance (should be globally unique OID, UUID, or URI)")
    private StringDt myIdentifier;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Logical id for this version of the concept map", formalDefinition="The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Informal name for this concept map", formalDefinition="A free text natural language name describing the concept map")
    private StringDt myName;
    @Child(name="publisher", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the concept map")
    private StringDt myPublisher;
    @Child(name="telecom", type={ContactDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Contact information of the publisher", formalDefinition="Contacts of the publisher to assist a user in finding and communicating with the publisher")
    private List<ContactDt> myTelecom;
    @Child(name="description", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Human language description of the concept map", formalDefinition="A free text natural language description of the use of the concept map - reason for definition, conditions of use, etc.")
    private StringDt myDescription;
    @Child(name="copyright", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="About the concept map or its content", formalDefinition="A copyright statement relating to the concept map and/or its contents")
    private StringDt myCopyright;
    @Child(name="status", type={CodeDt.class}, order=7, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the concept map")
    private BoundCodeDt<ValueSetStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This ConceptMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="date", type={DateTimeDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Date for given status", formalDefinition="The date that the concept map status was last changed")
    private DateTimeDt myDate;
    @Child(name="source", order=10, min=1, max=1, summary=true, modifier=false, type={ValueSet.class})
    @Description(shortDefinition="Identifies the source value set which is being mapped", formalDefinition="The source value set that specifies the concepts that are being mapped")
    private ResourceReferenceDt mySource;
    @Child(name="target", order=11, min=1, max=1, summary=true, modifier=false, type={ValueSet.class})
    @Description(shortDefinition="Provides context to the mappings", formalDefinition="The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made")
    private ResourceReferenceDt myTarget;
    @Child(name="concept", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Mappings for a concept from the source valueset", formalDefinition="")
    private List<Concept> myConcept;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myCopyright, this.myStatus, this.myExperimental, this.myDate, this.mySource, this.myTarget, this.myConcept});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myCopyright, this.myStatus, this.myExperimental, this.myDate, this.mySource, this.myTarget, this.myConcept});
    }

    public StringDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public StringDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public ConceptMap setIdentifier(StringDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public ConceptMap setIdentifier(String theString) {
        this.myIdentifier = new StringDt(theString);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public ConceptMap setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public ConceptMap setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public ConceptMap setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public ConceptMap setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getPublisher() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public ConceptMap setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public ConceptMap setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public ConceptMap setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public ConceptMap addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public ConceptMap addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public ConceptMap setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ConceptMap setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public StringDt getCopyright() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public ConceptMap setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public ConceptMap setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ValueSetStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ValueSetStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<ValueSetStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ValueSetStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public ConceptMap setStatus(BoundCodeDt<ValueSetStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ConceptMap setStatus(ValueSetStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getExperimental() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public ConceptMap setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public ConceptMap setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public ConceptMap setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ConceptMap setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ConceptMap setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ResourceReferenceDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ConceptMap setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public ResourceReferenceDt getTargetElement() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public ConceptMap setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public List<Concept> getConcept() {
        if (this.myConcept == null) {
            this.myConcept = new ArrayList<Concept>();
        }
        return this.myConcept;
    }

    public List<Concept> getConceptElement() {
        if (this.myConcept == null) {
            this.myConcept = new ArrayList<Concept>();
        }
        return this.myConcept;
    }

    public ConceptMap setConcept(List<Concept> theValue) {
        this.myConcept = theValue;
        return this;
    }

    public Concept addConcept() {
        Concept newType = new Concept();
        this.getConcept().add(newType);
        return newType;
    }

    public Concept getConceptFirstRep() {
        if (this.getConcept().isEmpty()) {
            return this.addConcept();
        }
        return this.getConcept().get(0);
    }

    public String getResourceName() {
        return "ConceptMap";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class ConceptMap2
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="System of the target", formalDefinition="")
        private UriDt mySystem;
        @Child(name="code", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Code that identifies the target concept", formalDefinition="")
        private CodeDt myCode;
        @Child(name="equivalence", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="equal | equivalent | wider | subsumes | narrower | specialises | inexact | unmatched | disjoint", formalDefinition="")
        private BoundCodeDt<ConceptMapEquivalenceEnum> myEquivalence;
        @Child(name="comments", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Description of status/issues in mapping", formalDefinition="")
        private StringDt myComments;
        @Child(name="product", type={ConceptDependsOn.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Other concepts that this mapping also produces", formalDefinition="A set of additional outcomes from this mapping to other value sets. To properly execute this mapping, the specified value set must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on")
        private List<ConceptDependsOn> myProduct;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myCode, this.myEquivalence, this.myComments, this.myProduct});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myCode, this.myEquivalence, this.myComments, this.myProduct});
        }

        public UriDt getSystem() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public ConceptMap2 setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public ConceptMap2 setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public CodeDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public ConceptMap2 setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ConceptMap2 setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public BoundCodeDt<ConceptMapEquivalenceEnum> getEquivalence() {
            if (this.myEquivalence == null) {
                this.myEquivalence = new BoundCodeDt(ConceptMapEquivalenceEnum.VALUESET_BINDER);
            }
            return this.myEquivalence;
        }

        public BoundCodeDt<ConceptMapEquivalenceEnum> getEquivalenceElement() {
            if (this.myEquivalence == null) {
                this.myEquivalence = new BoundCodeDt(ConceptMapEquivalenceEnum.VALUESET_BINDER);
            }
            return this.myEquivalence;
        }

        public ConceptMap2 setEquivalence(BoundCodeDt<ConceptMapEquivalenceEnum> theValue) {
            this.myEquivalence = theValue;
            return this;
        }

        public ConceptMap2 setEquivalence(ConceptMapEquivalenceEnum theValue) {
            this.getEquivalence().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getComments() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public StringDt getCommentsElement() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public ConceptMap2 setComments(StringDt theValue) {
            this.myComments = theValue;
            return this;
        }

        public ConceptMap2 setComments(String theString) {
            this.myComments = new StringDt(theString);
            return this;
        }

        public List<ConceptDependsOn> getProduct() {
            if (this.myProduct == null) {
                this.myProduct = new ArrayList<ConceptDependsOn>();
            }
            return this.myProduct;
        }

        public List<ConceptDependsOn> getProductElement() {
            if (this.myProduct == null) {
                this.myProduct = new ArrayList<ConceptDependsOn>();
            }
            return this.myProduct;
        }

        public ConceptMap2 setProduct(List<ConceptDependsOn> theValue) {
            this.myProduct = theValue;
            return this;
        }

        public ConceptDependsOn addProduct() {
            ConceptDependsOn newType = new ConceptDependsOn();
            this.getProduct().add(newType);
            return newType;
        }

        public ConceptDependsOn getProductFirstRep() {
            if (this.getProduct().isEmpty()) {
                return this.addProduct();
            }
            return this.getProduct().get(0);
        }
    }

    @Block
    public static class ConceptDependsOn
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="concept", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Reference to element/field/valueset provides the context", formalDefinition="A reference to a specific concept that holds a coded value. This can be an element in a FHIR resource, or a specific reference to a data element in a different specification (e.g. v2) or a general reference to a kind of data field, or a reference to a value set with an appropriately narrow definition")
        private UriDt myConcept;
        @Child(name="system", type={UriDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="System for a concept in the referenced concept", formalDefinition="")
        private UriDt mySystem;
        @Child(name="code", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Code for a concept in the referenced concept", formalDefinition="")
        private CodeDt myCode;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myConcept, this.mySystem, this.myCode});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myConcept, this.mySystem, this.myCode});
        }

        public UriDt getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new UriDt();
            }
            return this.myConcept;
        }

        public UriDt getConceptElement() {
            if (this.myConcept == null) {
                this.myConcept = new UriDt();
            }
            return this.myConcept;
        }

        public ConceptDependsOn setConcept(UriDt theValue) {
            this.myConcept = theValue;
            return this;
        }

        public ConceptDependsOn setConcept(String theUri) {
            this.myConcept = new UriDt(theUri);
            return this;
        }

        public UriDt getSystem() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public ConceptDependsOn setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public ConceptDependsOn setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public CodeDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public ConceptDependsOn setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ConceptDependsOn setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }
    }

    @Block
    public static class Concept
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="System that defines the concept being mapped", formalDefinition="")
        private UriDt mySystem;
        @Child(name="code", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifies concept being mapped", formalDefinition="")
        private CodeDt myCode;
        @Child(name="dependsOn", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Other concepts required for this mapping (from context)", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified concept can be resolved, and it has the specified value")
        private List<ConceptDependsOn> myDependsOn;
        @Child(name="map", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="A concept from the target value set that this concept maps to", formalDefinition="")
        private List<ConceptMap2> myMap;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myCode, this.myDependsOn, this.myMap});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myCode, this.myDependsOn, this.myMap});
        }

        public UriDt getSystem() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public Concept setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public Concept setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public CodeDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public Concept setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public Concept setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public List<ConceptDependsOn> getDependsOn() {
            if (this.myDependsOn == null) {
                this.myDependsOn = new ArrayList<ConceptDependsOn>();
            }
            return this.myDependsOn;
        }

        public List<ConceptDependsOn> getDependsOnElement() {
            if (this.myDependsOn == null) {
                this.myDependsOn = new ArrayList<ConceptDependsOn>();
            }
            return this.myDependsOn;
        }

        public Concept setDependsOn(List<ConceptDependsOn> theValue) {
            this.myDependsOn = theValue;
            return this;
        }

        public ConceptDependsOn addDependsOn() {
            ConceptDependsOn newType = new ConceptDependsOn();
            this.getDependsOn().add(newType);
            return newType;
        }

        public ConceptDependsOn getDependsOnFirstRep() {
            if (this.getDependsOn().isEmpty()) {
                return this.addDependsOn();
            }
            return this.getDependsOn().get(0);
        }

        public List<ConceptMap2> getMap() {
            if (this.myMap == null) {
                this.myMap = new ArrayList<ConceptMap2>();
            }
            return this.myMap;
        }

        public List<ConceptMap2> getMapElement() {
            if (this.myMap == null) {
                this.myMap = new ArrayList<ConceptMap2>();
            }
            return this.myMap;
        }

        public Concept setMap(List<ConceptMap2> theValue) {
            this.myMap = theValue;
            return this;
        }

        public ConceptMap2 addMap() {
            ConceptMap2 newType = new ConceptMap2();
            this.getMap().add(newType);
            return newType;
        }

        public ConceptMap2 getMapFirstRep() {
            if (this.getMap().isEmpty()) {
                return this.addMap();
            }
            return this.getMap().get(0);
        }
    }
}

