/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.ContainedDt;
import ca.uhn.fhir.model.dstu.composite.NarrativeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseResource
extends BaseElement
implements IResource {
    public static final StringClientParam RES_ID = new StringClientParam("_id");
    @SearchParamDefinition(name="_id", path="", description="The ID of the resource", type="string")
    public static final String SP_RES_ID = "_id";
    @SearchParamDefinition(name="_language", path="", description="The language of the resource", type="string")
    public static final String SP_RES_LANGUAGE = "_language";
    @Child(name="contained", order=2, min=0, max=1)
    private ContainedDt myContained;
    private IdDt myId;
    @Child(name="language", order=0, min=0, max=1)
    private CodeDt myLanguage;
    private ResourceMetadataMap myResourceMetadata;
    @Child(name="text", order=1, min=0, max=1)
    private NarrativeDt myText;

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return Collections.emptyList();
    }

    public ContainedDt getContained() {
        if (this.myContained == null) {
            this.myContained = new ContainedDt();
        }
        return this.myContained;
    }

    public IdDt getId() {
        if (this.myId == null) {
            this.myId = new IdDt();
        }
        return this.myId;
    }

    public IIdType getIdElement() {
        return this.getId();
    }

    public CodeDt getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = new CodeDt();
        }
        return this.myLanguage;
    }

    public IBaseMetaType getMeta() {
        return new IBaseMetaType(){
            private static final long serialVersionUID = 1L;

            public IBaseMetaType addProfile(String theProfile) {
                ArrayList<IdDt> newTagList = new ArrayList<IdDt>();
                List existingTagList = (List)ResourceMetadataKeyEnum.PROFILES.get((IResource)BaseResource.this);
                if (existingTagList != null) {
                    newTagList.addAll(existingTagList);
                }
                ResourceMetadataKeyEnum.PROFILES.put((IResource)BaseResource.this, newTagList);
                IdDt tag = new IdDt(theProfile);
                newTagList.add(tag);
                return this;
            }

            public IBaseCoding addSecurity() {
                ArrayList<CodingDt> tagList = (ArrayList<CodingDt>)ResourceMetadataKeyEnum.SECURITY_LABELS.get((IResource)BaseResource.this);
                if (tagList == null) {
                    tagList = new ArrayList<CodingDt>();
                    ResourceMetadataKeyEnum.SECURITY_LABELS.put((IResource)BaseResource.this, tagList);
                }
                CodingDt tag = new CodingDt();
                tagList.add(tag);
                return this.asBaseCoding(tag);
            }

            public IBaseCoding addTag() {
                TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IResource)BaseResource.this);
                if (tagList == null) {
                    tagList = new TagList();
                    ResourceMetadataKeyEnum.TAG_LIST.put((IResource)BaseResource.this, (Object)tagList);
                }
                Tag tag = new Tag();
                tagList.add(tag);
                return tag;
            }

            private IBaseCoding asBaseCoding(final BaseCodingDt theCoding) {
                return new IBaseCoding(){
                    private static final long serialVersionUID = 1L;

                    public String getCode() {
                        return (String)theCoding.getCodeElement().getValue();
                    }

                    public String getDisplay() {
                        return (String)theCoding.getDisplayElement().getValue();
                    }

                    public List<String> getFormatCommentsPost() {
                        return Collections.emptyList();
                    }

                    public List<String> getFormatCommentsPre() {
                        return Collections.emptyList();
                    }

                    public String getSystem() {
                        return (String)theCoding.getSystemElement().getValue();
                    }

                    public boolean hasFormatComment() {
                        return false;
                    }

                    public boolean isEmpty() {
                        return ElementUtil.isEmpty((Object[])new Object[]{this.getSystem(), this.getCode(), this.getDisplay()});
                    }

                    public IBaseCoding setCode(String theTerm) {
                        theCoding.setCode(theTerm);
                        return this;
                    }

                    public IBaseCoding setDisplay(String theLabel) {
                        theCoding.setDisplay(theLabel);
                        return this;
                    }

                    public IBaseCoding setSystem(String theScheme) {
                        theCoding.setSystem(theScheme);
                        return this;
                    }
                };
            }

            public List<String> getFormatCommentsPost() {
                return Collections.emptyList();
            }

            public List<String> getFormatCommentsPre() {
                return Collections.emptyList();
            }

            public Date getLastUpdated() {
                InstantDt lu = (InstantDt)ResourceMetadataKeyEnum.UPDATED.get((IResource)BaseResource.this);
                if (lu != null) {
                    return (Date)lu.getValue();
                }
                return null;
            }

            public List<? extends IPrimitiveType<String>> getProfile() {
                ArrayList<IdDt> retVal = new ArrayList<IdDt>();
                List profilesList = (List)ResourceMetadataKeyEnum.PROFILES.get((IResource)BaseResource.this);
                if (profilesList == null) {
                    return Collections.emptyList();
                }
                for (IdDt next : profilesList) {
                    retVal.add(next);
                }
                return Collections.unmodifiableList(retVal);
            }

            public List<? extends IBaseCoding> getSecurity() {
                ArrayList<IBaseCoding> retVal = new ArrayList<IBaseCoding>();
                List labelsList = (List)ResourceMetadataKeyEnum.SECURITY_LABELS.get((IResource)BaseResource.this);
                if (labelsList == null) {
                    return Collections.emptyList();
                }
                for (BaseCodingDt next : labelsList) {
                    retVal.add(this.asBaseCoding(next));
                }
                return Collections.unmodifiableList(retVal);
            }

            public IBaseCoding getSecurity(String theSystem, String theCode) {
                for (BaseCodingDt next : (List)ResourceMetadataKeyEnum.SECURITY_LABELS.get((IResource)BaseResource.this)) {
                    if (!theSystem.equals(next.getSystemElement().getValue()) || !theCode.equals(next.getCodeElement().getValue())) continue;
                    return this.asBaseCoding(next);
                }
                return null;
            }

            public List<? extends IBaseCoding> getTag() {
                ArrayList<Tag> retVal = new ArrayList<Tag>();
                for (Tag next : (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IResource)BaseResource.this)) {
                    retVal.add(next);
                }
                return Collections.unmodifiableList(retVal);
            }

            public IBaseCoding getTag(String theSystem, String theCode) {
                for (Tag next : (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IResource)BaseResource.this)) {
                    if (!next.getScheme().equals(theSystem) || !next.getTerm().equals(theCode)) continue;
                    return next;
                }
                return null;
            }

            public String getVersionId() {
                return BaseResource.this.getId().getVersionIdPart();
            }

            public boolean hasFormatComment() {
                return false;
            }

            public boolean isEmpty() {
                return BaseResource.this.getResourceMetadata().isEmpty();
            }

            public IBaseMetaType setLastUpdated(Date theHeaderDateValue) {
                ResourceMetadataKeyEnum.UPDATED.put((IResource)BaseResource.this, (Object)new InstantDt(theHeaderDateValue));
                return this;
            }

            public IBaseMetaType setVersionId(String theVersionId) {
                BaseResource.this.setId(BaseResource.this.getId().withVersion(theVersionId));
                return this;
            }
        };
    }

    public ResourceMetadataMap getResourceMetadata() {
        if (this.myResourceMetadata == null) {
            this.myResourceMetadata = new ResourceMetadataMap();
        }
        return this.myResourceMetadata;
    }

    public NarrativeDt getText() {
        if (this.myText == null) {
            this.myText = new NarrativeDt();
        }
        return this.myText;
    }

    protected boolean isBaseEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLanguage, this.myText, this.myId});
    }

    public void setContained(ContainedDt theContained) {
        this.myContained = theContained;
    }

    public void setId(IdDt theId) {
        this.myId = theId;
    }

    public BaseResource setId(IIdType theId) {
        if (theId instanceof IdDt) {
            this.myId = (IdDt)theId;
        } else if (theId != null) {
            this.myId = new IdDt(theId.getValue());
        }
        return this;
    }

    public BaseResource setId(String theId) {
        this.myId = theId == null ? null : new IdDt(theId);
        return this;
    }

    public void setLanguage(CodeDt theLanguage) {
        this.myLanguage = theLanguage;
    }

    public void setResourceMetadata(ResourceMetadataMap theMap) {
        Validate.notNull((Object)theMap, (String)"The Map must not be null", (Object[])new Object[0]);
        this.myResourceMetadata = theMap;
    }

    public void setText(NarrativeDt theText) {
        this.myText = theText;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("id", (Object)this.getId().toUnqualified());
        return b.toString();
    }
}

