/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;

@DatatypeDef(name="SampledDataDt")
public class SampledDataDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="origin", type={QuantityDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Zero value and units", formalDefinition="The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series")
    private QuantityDt myOrigin;
    @Child(name="period", type={DecimalDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Number of milliseconds between samples", formalDefinition="The length of time between sampling times, measured in milliseconds")
    private DecimalDt myPeriod;
    @Child(name="factor", type={DecimalDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Multiply data by this before adding to origin", formalDefinition="A correction factor that is applied to the sampled data points before they are added to the origin")
    private DecimalDt myFactor;
    @Child(name="lowerLimit", type={DecimalDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Lower limit of detection", formalDefinition="The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit)")
    private DecimalDt myLowerLimit;
    @Child(name="upperLimit", type={DecimalDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Upper limit of detection", formalDefinition="The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit)")
    private DecimalDt myUpperLimit;
    @Child(name="dimensions", type={IntegerDt.class}, order=5, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Number of sample points at each time point", formalDefinition="The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once")
    private IntegerDt myDimensions;
    @Child(name="data", type={StringDt.class}, order=6, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Decimal values with spaces, or \"E\" | \"U\" | \"L\"", formalDefinition="A series of data points which are decimal values separated by a single space (character u20). The special values \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) can also be used in place of a decimal value")
    private StringDt myData;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOrigin, this.myPeriod, this.myFactor, this.myLowerLimit, this.myUpperLimit, this.myDimensions, this.myData});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOrigin, this.myPeriod, this.myFactor, this.myLowerLimit, this.myUpperLimit, this.myDimensions, this.myData});
    }

    public QuantityDt getOrigin() {
        if (this.myOrigin == null) {
            this.myOrigin = new QuantityDt();
        }
        return this.myOrigin;
    }

    public QuantityDt getOriginElement() {
        if (this.myOrigin == null) {
            this.myOrigin = new QuantityDt();
        }
        return this.myOrigin;
    }

    public SampledDataDt setOrigin(QuantityDt theValue) {
        this.myOrigin = theValue;
        return this;
    }

    public SampledDataDt setOrigin(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
        this.myOrigin = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public SampledDataDt setOrigin(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.myOrigin = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public SampledDataDt setOrigin(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.myOrigin = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public SampledDataDt setOrigin(double theValue) {
        this.myOrigin = new QuantityDt(theValue);
        return this;
    }

    public SampledDataDt setOrigin(long theValue) {
        this.myOrigin = new QuantityDt(theValue);
        return this;
    }

    public SampledDataDt setOrigin(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
        this.myOrigin = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public DecimalDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new DecimalDt();
        }
        return this.myPeriod;
    }

    public DecimalDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new DecimalDt();
        }
        return this.myPeriod;
    }

    public SampledDataDt setPeriod(DecimalDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public SampledDataDt setPeriod(long theValue) {
        this.myPeriod = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setPeriod(double theValue) {
        this.myPeriod = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setPeriod(BigDecimal theValue) {
        this.myPeriod = new DecimalDt(theValue);
        return this;
    }

    public DecimalDt getFactor() {
        if (this.myFactor == null) {
            this.myFactor = new DecimalDt();
        }
        return this.myFactor;
    }

    public DecimalDt getFactorElement() {
        if (this.myFactor == null) {
            this.myFactor = new DecimalDt();
        }
        return this.myFactor;
    }

    public SampledDataDt setFactor(DecimalDt theValue) {
        this.myFactor = theValue;
        return this;
    }

    public SampledDataDt setFactor(long theValue) {
        this.myFactor = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setFactor(double theValue) {
        this.myFactor = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setFactor(BigDecimal theValue) {
        this.myFactor = new DecimalDt(theValue);
        return this;
    }

    public DecimalDt getLowerLimit() {
        if (this.myLowerLimit == null) {
            this.myLowerLimit = new DecimalDt();
        }
        return this.myLowerLimit;
    }

    public DecimalDt getLowerLimitElement() {
        if (this.myLowerLimit == null) {
            this.myLowerLimit = new DecimalDt();
        }
        return this.myLowerLimit;
    }

    public SampledDataDt setLowerLimit(DecimalDt theValue) {
        this.myLowerLimit = theValue;
        return this;
    }

    public SampledDataDt setLowerLimit(long theValue) {
        this.myLowerLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setLowerLimit(double theValue) {
        this.myLowerLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setLowerLimit(BigDecimal theValue) {
        this.myLowerLimit = new DecimalDt(theValue);
        return this;
    }

    public DecimalDt getUpperLimit() {
        if (this.myUpperLimit == null) {
            this.myUpperLimit = new DecimalDt();
        }
        return this.myUpperLimit;
    }

    public DecimalDt getUpperLimitElement() {
        if (this.myUpperLimit == null) {
            this.myUpperLimit = new DecimalDt();
        }
        return this.myUpperLimit;
    }

    public SampledDataDt setUpperLimit(DecimalDt theValue) {
        this.myUpperLimit = theValue;
        return this;
    }

    public SampledDataDt setUpperLimit(long theValue) {
        this.myUpperLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setUpperLimit(double theValue) {
        this.myUpperLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setUpperLimit(BigDecimal theValue) {
        this.myUpperLimit = new DecimalDt(theValue);
        return this;
    }

    public IntegerDt getDimensions() {
        if (this.myDimensions == null) {
            this.myDimensions = new IntegerDt();
        }
        return this.myDimensions;
    }

    public IntegerDt getDimensionsElement() {
        if (this.myDimensions == null) {
            this.myDimensions = new IntegerDt();
        }
        return this.myDimensions;
    }

    public SampledDataDt setDimensions(IntegerDt theValue) {
        this.myDimensions = theValue;
        return this;
    }

    public SampledDataDt setDimensions(int theInteger) {
        this.myDimensions = new IntegerDt(theInteger);
        return this;
    }

    public StringDt getData() {
        if (this.myData == null) {
            this.myData = new StringDt();
        }
        return this.myData;
    }

    public StringDt getDataElement() {
        if (this.myData == null) {
            this.myData = new StringDt();
        }
        return this.myData;
    }

    public SampledDataDt setData(StringDt theValue) {
        this.myData = theValue;
        return this;
    }

    public SampledDataDt setData(String theString) {
        this.myData = new StringDt(theString);
        return this;
    }
}

