/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.ValueSet;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="CodingDt")
public class CodingDt
extends BaseCodingDt
implements ICompositeDatatype {
    @Child(name="system", type={UriDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Identity of the terminology system", formalDefinition="The identification of the code system that defines the meaning of the symbol in the code.")
    private UriDt mySystem;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Version of the system - if relevant", formalDefinition="The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured. and When the meaning is not guaranteed to be consistent, the version SHOULD be exchanged")
    private StringDt myVersion;
    @Child(name="code", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Symbol in syntax defined by the system", formalDefinition="A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination)")
    private CodeDt myCode;
    @Child(name="display", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Representation defined by the system", formalDefinition="A representation of the meaning of the code in the system, following the rules of the system.")
    private StringDt myDisplay;
    @Child(name="primary", type={BooleanDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="If this code was chosen directly by the user", formalDefinition="Indicates that this code was chosen by a user directly - i.e. off a pick list of available items (codes or displays)")
    private BooleanDt myPrimary;
    @Child(name="valueSet", order=5, min=0, max=1, summary=true, modifier=false, type={ValueSet.class})
    @Description(shortDefinition="Set this coding was chosen from", formalDefinition="The set of possible coded values this coding was chosen from or constrained by")
    private ResourceReferenceDt myValueSet;

    public CodingDt() {
    }

    public CodingDt(String theSystem, String theCode) {
        this.setSystem(theSystem);
        this.setCode(theCode);
    }

    public CodingDt(BaseCodingDt theCoding) {
        this(theCoding.getSystemElement().getValueAsString(), (String)theCoding.getCodeElement().getValue());
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySystem, this.myVersion, this.myCode, this.myDisplay, this.myPrimary, this.myValueSet});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myVersion, this.myCode, this.myDisplay, this.myPrimary, this.myValueSet});
    }

    public UriDt getSystem() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public CodingDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public CodingDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public CodingDt setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public CodingDt setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public CodeDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public CodingDt setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public CodingDt setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }

    public StringDt getDisplay() {
        if (this.myDisplay == null) {
            this.myDisplay = new StringDt();
        }
        return this.myDisplay;
    }

    public StringDt getDisplayElement() {
        if (this.myDisplay == null) {
            this.myDisplay = new StringDt();
        }
        return this.myDisplay;
    }

    public CodingDt setDisplay(StringDt theValue) {
        this.myDisplay = theValue;
        return this;
    }

    public CodingDt setDisplay(String theString) {
        this.myDisplay = new StringDt(theString);
        return this;
    }

    public BooleanDt getPrimary() {
        if (this.myPrimary == null) {
            this.myPrimary = new BooleanDt();
        }
        return this.myPrimary;
    }

    public BooleanDt getPrimaryElement() {
        if (this.myPrimary == null) {
            this.myPrimary = new BooleanDt();
        }
        return this.myPrimary;
    }

    public CodingDt setPrimary(BooleanDt theValue) {
        this.myPrimary = theValue;
        return this;
    }

    public CodingDt setPrimary(boolean theBoolean) {
        this.myPrimary = new BooleanDt(theBoolean);
        return this;
    }

    public ResourceReferenceDt getValueSet() {
        if (this.myValueSet == null) {
            this.myValueSet = new ResourceReferenceDt();
        }
        return this.myValueSet;
    }

    public ResourceReferenceDt getValueSetElement() {
        if (this.myValueSet == null) {
            this.myValueSet = new ResourceReferenceDt();
        }
        return this.myValueSet;
    }

    public CodingDt setValueSet(ResourceReferenceDt theValue) {
        this.myValueSet = theValue;
        return this;
    }
}

