/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.dstu.resource.Conformance;
import ca.uhn.fhir.model.dstu.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulConformanceModeEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.DynamicSearchMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.SearchMethodBinding;
import ca.uhn.fhir.rest.method.SearchParameter;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

public class ServerConformanceProvider
implements IServerConformanceProvider<Conformance> {
    private boolean myCache = true;
    private volatile Conformance myConformance;
    private String myPublisher = "Not provided";
    private final RestfulServer myRestfulServer;

    public ServerConformanceProvider(RestfulServer theRestfulServer) {
        this.myRestfulServer = theRestfulServer;
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    @Metadata
    public Conformance getServerConformance(HttpServletRequest theRequest) {
        if (this.myConformance != null && this.myCache) {
            return this.myConformance;
        }
        Conformance retVal = new Conformance();
        retVal.setPublisher(this.myPublisher);
        retVal.setDate(DateTimeDt.withCurrentTime());
        retVal.setFhirVersion("0.0.82-3059");
        retVal.setAcceptUnknown(false);
        retVal.getImplementation().setDescription(this.myRestfulServer.getImplementationDescription());
        retVal.getSoftware().setName(this.myRestfulServer.getServerName());
        retVal.getSoftware().setVersion(this.myRestfulServer.getServerVersion());
        retVal.addFormat("application/xml+fhir");
        retVal.addFormat("application/json+fhir");
        Conformance.Rest rest = retVal.addRest();
        rest.setMode(RestfulConformanceModeEnum.SERVER);
        HashSet<RestfulOperationSystemEnum> systemOps = new HashSet<RestfulOperationSystemEnum>();
        ArrayList bindings = new ArrayList(this.myRestfulServer.getResourceBindings());
        Collections.sort(bindings, new Comparator<ResourceBinding>(){

            @Override
            public int compare(ResourceBinding theArg0, ResourceBinding theArg1) {
                return theArg0.getResourceName().compareToIgnoreCase(theArg1.getResourceName());
            }
        });
        for (ResourceBinding next : bindings) {
            HashSet<RestfulOperationTypeEnum> resourceOps = new HashSet<RestfulOperationTypeEnum>();
            Conformance.RestResource resource = rest.addResource();
            String resourceName = next.getResourceName();
            RuntimeResourceDefinition def = this.myRestfulServer.getFhirContext().getResourceDefinition(resourceName);
            resource.getType().setValue((Object)def.getName());
            resource.getProfile().setReference(new IdDt(def.getResourceProfile(this.myRestfulServer.getServerBaseForRequest(theRequest))));
            TreeSet<String> includes = new TreeSet<String>();
            for (BaseMethodBinding nextMethodBinding : next.getMethodBindings()) {
                RestfulOperationSystemEnum sysOp;
                RestfulOperationTypeEnum resOp = nextMethodBinding.getResourceOperationType();
                if (resOp != null && !resourceOps.contains((Object)resOp)) {
                    resourceOps.add(resOp);
                    resource.addOperation().setCode(resOp);
                }
                if ((sysOp = nextMethodBinding.getSystemOperationType()) != null && !systemOps.contains((Object)sysOp)) {
                    systemOps.add(sysOp);
                    rest.addOperation().setCode(sysOp);
                }
                if (nextMethodBinding instanceof SearchMethodBinding) {
                    this.handleSearchMethodBinding(rest, resource, resourceName, def, includes, (SearchMethodBinding)nextMethodBinding);
                } else if (nextMethodBinding instanceof DynamicSearchMethodBinding) {
                    this.handleDynamicSearchMethodBinding(resource, def, includes, (DynamicSearchMethodBinding)nextMethodBinding);
                }
                Collections.sort(resource.getOperation(), new Comparator<Conformance.RestResourceOperation>(){

                    @Override
                    public int compare(Conformance.RestResourceOperation theO1, Conformance.RestResourceOperation theO2) {
                        RestfulOperationTypeEnum o1 = (RestfulOperationTypeEnum)theO1.getCode().getValueAsEnum();
                        RestfulOperationTypeEnum o2 = (RestfulOperationTypeEnum)theO2.getCode().getValueAsEnum();
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        return o1.ordinal() - o2.ordinal();
                    }
                });
            }
            for (String nextInclude : includes) {
                resource.addSearchInclude(nextInclude);
            }
        }
        this.myConformance = retVal;
        return retVal;
    }

    private void handleDynamicSearchMethodBinding(Conformance.RestResource resource, RuntimeResourceDefinition def, TreeSet<String> includes, DynamicSearchMethodBinding searchMethodBinding) {
        includes.addAll(searchMethodBinding.getIncludes());
        ArrayList<RuntimeSearchParam> searchParameters = new ArrayList<RuntimeSearchParam>();
        searchParameters.addAll(searchMethodBinding.getSearchParams());
        this.sortRuntimeSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            for (RuntimeSearchParam nextParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName;
                String nextParamUnchainedName = nextParamName = nextParameter.getName();
                if (nextParamName.contains(".")) {
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = nextParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                Conformance.RestResourceSearchParam param = resource.addSearchParam();
                param.setName(nextParamName);
                param.setDocumentation(nextParamDescription);
                param.getTypeElement().setValue((Object)nextParameter.getParamType().getCode());
            }
        }
    }

    private void handleSearchMethodBinding(Conformance.Rest rest, Conformance.RestResource resource, String resourceName, RuntimeResourceDefinition def, TreeSet<String> includes, SearchMethodBinding searchMethodBinding) {
        includes.addAll(searchMethodBinding.getIncludes());
        List params = searchMethodBinding.getParameters();
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (IParameter nextParameter : params) {
            if (!(nextParameter instanceof SearchParameter)) continue;
            searchParameters.add((SearchParameter)nextParameter);
        }
        this.sortSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            boolean allOptional = !((SearchParameter)searchParameters.get(0)).isRequired();
            Conformance.RestQuery query = null;
            if (!allOptional) {
                query = rest.addQuery();
                query.getDocumentation().setValue((Object)searchMethodBinding.getDescription());
                query.addUndeclaredExtension(false, "http://hl7api.sourceforge.net/hapi-fhir/extensions.xml#queryReturnType", (IBaseDatatype)new CodeDt(resourceName));
                for (String nextInclude : searchMethodBinding.getIncludes()) {
                    query.addUndeclaredExtension(false, "http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#allowedInclude", (IBaseDatatype)new StringDt(nextInclude));
                }
            }
            for (SearchParameter nextParameter : searchParameters) {
                Conformance.RestResourceSearchParam param;
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName;
                String nextParamUnchainedName = nextParamName = nextParameter.getName();
                if (nextParamName.contains(".")) {
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = nextParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                if (query == null) {
                    param = resource.addSearchParam();
                } else {
                    param = query.addParameter();
                    param.addUndeclaredExtension(false, "http://hl7api.sourceforge.net/hapi-fhir/extensions.xml#paramIsRequired", (IBaseDatatype)new BooleanDt(nextParameter.isRequired()));
                }
                param.setName(nextParamName);
                param.setDocumentation(nextParamDescription);
                param.getTypeElement().setValue((Object)nextParameter.getParamType().getCode());
                for (Class nextTarget : nextParameter.getDeclaredTypes()) {
                    ResourceTypeEnum code;
                    RuntimeResourceDefinition targetDef = this.myRestfulServer.getFhirContext().getResourceDefinition(nextTarget);
                    if (targetDef == null || (code = (ResourceTypeEnum)ResourceTypeEnum.VALUESET_BINDER.fromCodeString(targetDef.getName())) == null) continue;
                    param.addTarget(code);
                }
            }
        }
    }

    public void setCache(boolean theCache) {
        this.myCache = theCache;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    private void sortRuntimeSearchParameters(List<RuntimeSearchParam> searchParameters) {
        Collections.sort(searchParameters, new Comparator<RuntimeSearchParam>(){

            @Override
            public int compare(RuntimeSearchParam theO1, RuntimeSearchParam theO2) {
                return theO1.getName().compareTo(theO2.getName());
            }
        });
    }

    private void sortSearchParameters(List<SearchParameter> searchParameters) {
        Collections.sort(searchParameters, new Comparator<SearchParameter>(){

            @Override
            public int compare(SearchParameter theO1, SearchParameter theO2) {
                if (theO1.isRequired() == theO2.isRequired()) {
                    return theO1.getName().compareTo(theO2.getName());
                }
                if (theO1.isRequired()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

